/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.ISO9075;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

public class ResourceHelper {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHelper.class);
    @Autowired
    protected NodeService nodeService;
    @Autowired
    protected ContentService contentService;
    @Autowired
    protected NamespaceService namespaceService;
    @Autowired
    protected SearchService searchService;

    public boolean nodeDiffersFromResource(Resource resource, RepositoryLocation targetLocation) throws IOException {
        NodeRef nodeRef = this.findNodeForResource(resource, targetLocation);
        return nodeRef == null || this.nodeDiffersFromResource(resource, nodeRef);
    }

    public boolean nodeDiffersFromResource(Resource resource, NodeRef nodeRef) throws IOException {
        ContentReader reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        if (IOUtils.contentEquals((InputStream)reader.getContentInputStream(), (InputStream)resource.getInputStream())) {
            logger.debug("Existing repository node ({}) matches resource {}.", (Object)nodeRef, (Object)resource);
            return false;
        }
        return true;
    }

    public NodeRef findNodeForResource(Resource resource, RepositoryLocation repoLocation) {
        NodeRef rootNode = this.nodeService.getRootNode(repoLocation.getStoreRef());
        List nodeRefs = this.searchService.selectNodes(rootNode, String.format("%s/cm:%s", repoLocation.getPath(), ISO9075.encode((String)resource.getFilename())), null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.isEmpty()) {
            return null;
        }
        if (nodeRefs.size() == 1) {
            return (NodeRef)nodeRefs.get(0);
        }
        throw new IllegalStateException(String.format("Found more than 1 node for resource %s: %s.", resource, nodeRefs));
    }
}

