/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.schedule;

import com.github.dynamicextensionsalfresco.jobs.ScheduledQuartzJob;
import com.github.dynamicextensionsalfresco.schedule.ScheduledTask;
import com.github.dynamicextensionsalfresco.schedule.TaskConfiguration;
import com.github.dynamicextensionsalfresco.schedule.TaskRegistration;
import com.github.dynamicextensionsalfresco.schedule.TaskScheduler;
import com.github.dynamicextensionsalfresco.schedule.TaskSchedulerException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ScheduledTaskRegistrar
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private Logger logger = LoggerFactory.getLogger(ScheduledTaskRegistrar.class);
    @Autowired
    protected TaskScheduler scheduler;
    @Autowired
    @Qualifier(value="global-properties")
    protected Properties globalProperties = new Properties();
    private ArrayList<TaskRegistration> registeredTasks = new ArrayList();
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() {
        this.registerScheduledTaskAnnotatedBeans();
    }

    public void registerScheduledTaskAnnotatedBeans() {
        Map scheduledBeans = this.applicationContext.getBeansWithAnnotation(ScheduledTask.class);
        scheduledBeans.putAll(this.applicationContext.getBeansWithAnnotation(ScheduledQuartzJob.class));
        for (Map.Entry entry : scheduledBeans.entrySet()) {
            Object bean = entry.getValue();
            try {
                this.registerTask(bean);
            }
            catch (Exception e) {
                this.logger.error("Failed to register job: ", (Throwable)e);
            }
        }
    }

    TaskRegistration registerTask(Object bean) throws TaskSchedulerException {
        if (bean == null) {
            throw new IllegalArgumentException("argument 'bean' is null");
        }
        TaskConfiguration config = this.getTaskConfiguration(bean);
        TaskRegistration registration = this.scheduler.scheduleTask(config, bean);
        this.registeredTasks.add(registration);
        this.logger.debug("Scheduled task {} from group {} with cron {}", new Object[]{config.getName(), config.getGroup(), config.getCron()});
        return registration;
    }

    TaskConfiguration getTaskConfiguration(Object bean) {
        TaskConfiguration.Builder builder = TaskConfiguration.builder();
        ScheduledTask annotation = bean.getClass().getAnnotation(ScheduledTask.class);
        if (annotation != null) {
            builder.withAnnotation(annotation, this.globalProperties);
        } else {
            ScheduledQuartzJob quartzJobAnnotation = bean.getClass().getAnnotation(ScheduledQuartzJob.class);
            if (quartzJobAnnotation == null) {
                throw new IllegalArgumentException("Annotation @ScheduledTask missing on bean %s");
            }
            builder.withAnnotation(quartzJobAnnotation, this.globalProperties);
        }
        return builder.build();
    }

    public void destroy() {
        this.logger.info("Unscheduling {} tasks", (Object)this.registeredTasks.size());
        for (TaskRegistration task : this.registeredTasks) {
            try {
                task.unregister();
            }
            catch (TaskSchedulerException e) {
                this.logger.warn("Failed to unschedule task: {}", (Throwable)e);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setScheduler(TaskScheduler scheduler) {
        this.scheduler = scheduler;
    }
}

