/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.schedule;

import com.github.dynamicextensionsalfresco.jobs.ScheduledQuartzJob;
import com.github.dynamicextensionsalfresco.schedule.ScheduledTask;
import java.util.Properties;

public class TaskConfiguration {
    private final String cron;
    private final String name;
    private final String group;
    private final boolean cluster;

    public TaskConfiguration(String cron, String name, String group, boolean cluster) {
        this.cron = cron;
        this.name = name;
        this.group = group;
        this.cluster = cluster;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCron() {
        return this.cron;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public static class Builder {
        private String cron = "";
        private String name = "";
        private String group = "DEFAULT";
        private boolean cluster = false;

        private Builder() {
        }

        public TaskConfiguration build() {
            return new TaskConfiguration(this.cron, this.name, this.group, this.cluster);
        }

        public Builder withCron(String cron) {
            this.cron = cron;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder withCluster(boolean cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder withAnnotation(ScheduledQuartzJob annotation, Properties properties) {
            return this.withName(annotation.name()).withGroup(annotation.group()).withCron(properties.getProperty(annotation.cronProp(), annotation.cron())).withCluster(annotation.cluster());
        }

        public Builder withAnnotation(ScheduledTask annotation, Properties properties) {
            return this.withName(annotation.name()).withGroup(annotation.group()).withCron(properties.getProperty(annotation.cronProp(), annotation.cron())).withCluster(annotation.cluster());
        }
    }
}

