/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.web;

import com.github.dynamicextensionsalfresco.webscripts.DummyStore;
import com.github.dynamicextensionsalfresco.webscripts.support.AbstractBundleResourceHandler;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.springframework.extensions.webscripts.Container;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.DescriptionImpl;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.TransactionParameters;
import org.springframework.extensions.webscripts.URLModelFactory;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public final class ResourceWebscript
extends AbstractBundleResourceHandler
implements WebScript {
    @NotNull
    private final BundleContext bundleContext;
    private final String module;
    private Function<ResourceWebscript, Description> descriptionImpl = r -> {
        String[] uris = new String[]{"/" + r.module + "/web/{path}", "/" + r.module + "/web-cached/{version}/{path}"};
        String id = r.module + "-web";
        DescriptionImpl descriptionImpl = new DescriptionImpl(id, "staticWebResource" + r.module, "static web resources for extension " + r.module, uris[0]);
        descriptionImpl.setMethod("GET");
        descriptionImpl.setFormatStyle(Description.FormatStyle.argument);
        descriptionImpl.setDefaultFormat("html");
        descriptionImpl.setUris(uris);
        descriptionImpl.setFamilys(new HashSet<String>(Collections.singletonList("static-web")));
        descriptionImpl.setStore((Store)new DummyStore());
        descriptionImpl.setRequiredAuthentication(Description.RequiredAuthentication.none);
        TransactionParameters transactionParameters = new TransactionParameters();
        transactionParameters.setRequired(Description.RequiredTransaction.none);
        descriptionImpl.setRequiredTransactionParameters((Description.RequiredTransactionParameters)transactionParameters);
        return descriptionImpl;
    };

    public ResourceWebscript(@NotNull BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext is null");
        }
        this.bundleContext = bundleContext;
        this.module = bundleContext.getBundle().getSymbolicName().replace(".", "-").toLowerCase();
        this.initContentTypes();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setURLModelFactory(URLModelFactory urlModelFactory) {
    }

    public void init(Container container, Description description) {
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String path = (String)req.getServiceMatch().getTemplateVars().get("path");
        if (path != null) {
            if (req.getServiceMatch().getPath().startsWith("/" + this.module + "/web-cached/") && !this.shouldNotCache(path)) {
                this.setInfinateCache(res);
            }
            try {
                this.handleResource(path, req, res);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            res.setStatus(400);
        }
    }

    private boolean shouldNotCache(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        return path.endsWith(".map");
    }

    @Nullable
    public String getBundleEntryPath(@Nullable String path) {
        return "/META-INF/alfresco/web/" + path;
    }

    @Nullable
    public Description getDescription() {
        return this.descriptionImpl.apply(this);
    }

    @Nullable
    public ResourceBundle getResources() {
        return null;
    }
}

