/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts;

import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebScriptRequest;
import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebscriptResponse;
import com.github.dynamicextensionsalfresco.webscripts.HandlerMethods;
import com.github.dynamicextensionsalfresco.webscripts.MessageConverterRegistry;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Attribute;
import com.github.dynamicextensionsalfresco.webscripts.arguments.HandlerMethodArgumentsResolver;
import com.github.dynamicextensionsalfresco.webscripts.messages.AnnotationWebScriptOutputMessage;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.DefaultResolutionParameters;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.Resolution;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.ResolutionParameters;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.TemplateResolution;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.extensions.webscripts.Container;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.URLModelFactory;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;

public class AnnotationWebScript
implements WebScript {
    private HandlerMethodArgumentsResolver argumentsResolver;
    private MessageConverterRegistry messageConverterRegistry;
    private final Description description;
    private final Object handler;
    private final HandlerMethods handlerMethods;
    private final String id;

    public AnnotationWebScript(Description description, Object handler, HandlerMethods handlerMethods, HandlerMethodArgumentsResolver argumentsResolver, MessageConverterRegistry messageConverterRegistry) {
        Assert.notNull((Object)description, (String)"Description cannot be null.");
        Assert.hasText((String)description.getId(), (String)"No ID provided in Description.");
        Assert.notNull((Object)handler, (String)"Handler cannot be null.");
        Assert.notNull((Object)handlerMethods, (String)"Methods cannot be null.");
        this.description = description;
        this.handler = handler;
        this.handlerMethods = handlerMethods;
        this.argumentsResolver = argumentsResolver;
        this.messageConverterRegistry = messageConverterRegistry;
        this.id = description.getId();
    }

    public Object getHandler() {
        return this.handler;
    }

    public HandlerMethods getHandlerMethods() {
        return this.handlerMethods;
    }

    public final void execute(WebScriptRequest request, WebScriptResponse response) throws IOException {
        AnnotationWebScriptRequest annotationRequest = new AnnotationWebScriptRequest(request);
        AnnotationWebscriptResponse wrappedResponse = new AnnotationWebscriptResponse(response);
        try {
            this.invokeAttributeHandlerMethods(annotationRequest, (WebScriptResponse)wrappedResponse);
            this.invokeBeforeHandlerMethods(annotationRequest, (WebScriptResponse)wrappedResponse);
            Object returnValue = this.invokeUriHandlerMethod(annotationRequest, wrappedResponse);
            this.handleUriMethodReturnValue(this.handlerMethods, annotationRequest, wrappedResponse, returnValue);
        }
        catch (Throwable e) {
            this.invokeExceptionHandlerMethods(e, annotationRequest, (WebScriptResponse)wrappedResponse);
        }
    }

    public void init(Container container, Description description) {
    }

    public Description getDescription() {
        return this.description;
    }

    public ResourceBundle getResources() {
        return null;
    }

    public void setURLModelFactory(URLModelFactory arg0) {
    }

    protected boolean invokeBeforeHandlerMethods(AnnotationWebScriptRequest request, WebScriptResponse response) {
        for (Method method : this.handlerMethods.getBeforeMethods()) {
            method.setAccessible(true);
            Object[] arguments = this.getArgumentsResolver().resolveHandlerMethodArguments(method, this.handler, (WebScriptRequest)request, response);
            Object returnValue = ReflectionUtils.invokeMethod((Method)method, (Object)this.handler, (Object[])arguments);
            if (!Boolean.FALSE.equals(returnValue)) continue;
            return false;
        }
        return true;
    }

    protected void invokeAttributeHandlerMethods(AnnotationWebScriptRequest request, WebScriptResponse response) {
        for (Method method : this.handlerMethods.getAttributeMethods()) {
            method.setAccessible(true);
            Object[] arguments = this.getArgumentsResolver().resolveHandlerMethodArguments(method, this.handler, (WebScriptRequest)request, response);
            Object attribute = ReflectionUtils.invokeMethod((Method)method, (Object)this.handler, (Object[])arguments);
            if (attribute == null) continue;
            Attribute annotation = (Attribute)AnnotationUtils.findAnnotation((Method)method, Attribute.class);
            Map model = request.getModel();
            if (StringUtils.hasText((String)annotation.value())) {
                model.put(annotation.value(), attribute);
                continue;
            }
            String name = method.getName();
            if (name.startsWith("get") && name.length() > 3) {
                name = name.substring(3, 4).toLowerCase() + name.substring(4);
            }
            model.put(name, attribute);
        }
    }

    protected Object invokeUriHandlerMethod(AnnotationWebScriptRequest request, AnnotationWebscriptResponse response) {
        Method uriMethod = this.handlerMethods.getUriMethod();
        Object[] arguments = this.argumentsResolver.resolveHandlerMethodArguments(uriMethod, this.handler, (WebScriptRequest)request, (WebScriptResponse)response);
        uriMethod.setAccessible(true);
        return ReflectionUtils.invokeMethod((Method)uriMethod, (Object)this.handler, (Object[])arguments);
    }

    protected void handleUriMethodReturnValue(HandlerMethods handlerMethods, AnnotationWebScriptRequest request, AnnotationWebscriptResponse response, Object returnValue) throws Exception {
        String responseTemplateName;
        TemplateResolution resolution = null;
        if (returnValue instanceof Map) {
            resolution = new TemplateResolution((Map)returnValue);
        } else if (returnValue instanceof String) {
            resolution = new TemplateResolution((String)returnValue);
        } else if (returnValue instanceof Resolution) {
            resolution = (Resolution)returnValue;
        }
        if (returnValue instanceof HttpEntity) {
            this.handleHttpEntityResponse(request, response, (HttpEntity)returnValue);
        } else if (handlerMethods.useResponseBody()) {
            if (handlerMethods.getUriMethod().getReturnType() != Void.TYPE) {
                this.handleResponseBody(request, response, returnValue);
            }
        } else if (this.handlerMethods.useResponseTemplate() && (responseTemplateName = handlerMethods.getResponseTemplateName()) != null) {
            if (resolution instanceof TemplateResolution) {
                if (resolution.getTemplate() == null) {
                    resolution.setTemplate(responseTemplateName);
                }
            } else if (resolution == null) {
                resolution = new TemplateResolution(responseTemplateName);
            }
        }
        if (resolution != null) {
            if (resolution instanceof TemplateResolution) {
                TemplateResolution templateResolution = resolution;
                Map model = request.getModel();
                if (templateResolution.getModel() != null && templateResolution.getModel() != model) {
                    model.putAll(templateResolution.getModel());
                }
                templateResolution.setModel(model);
            }
            resolution.resolve(request, response, (ResolutionParameters)new DefaultResolutionParameters(handlerMethods.getUriMethod(), this.description, this.handler));
        }
    }

    private void handleHttpEntityResponse(AnnotationWebScriptRequest request, AnnotationWebscriptResponse response, HttpEntity<?> returnValue) throws IOException, HttpMediaTypeNotAcceptableException, HttpMediaTypeNotSupportedException {
        Object body;
        HttpHeaders entityHeaders;
        if (returnValue == null) {
            return;
        }
        AnnotationWebScriptOutputMessage outputMessage = new AnnotationWebScriptOutputMessage(response);
        if (returnValue instanceof ResponseEntity) {
            outputMessage.setStatusCode(((ResponseEntity)returnValue).getStatusCode());
        }
        if (!(entityHeaders = returnValue.getHeaders()).isEmpty()) {
            outputMessage.getHeaders().putAll((Map)entityHeaders);
        }
        if ((body = returnValue.getBody()) != null) {
            this.handleResponseBody(request, response, returnValue.getBody());
        } else {
            outputMessage.getBody();
        }
    }

    private void handleResponseBody(AnnotationWebScriptRequest request, AnnotationWebscriptResponse response, Object returnValue) throws HttpMediaTypeNotSupportedException, HttpMediaTypeNotAcceptableException, IOException {
        MediaType defaultResponseType = null;
        String defaultResponse = this.getDescription().getDefaultFormat();
        if (defaultResponse != null && !defaultResponse.isEmpty()) {
            defaultResponseType = MediaType.parseMediaType((String)defaultResponse);
        }
        String[] headerResponseTypes = request.getHeaderValues("Accept");
        HashSet<MediaType> acceptResponseTypes = new HashSet<MediaType>();
        if (headerResponseTypes != null) {
            for (String headerResponseType : headerResponseTypes) {
                String[] responses;
                for (String acceptResponse : responses = headerResponseType.split(",")) {
                    acceptResponseTypes.add(MediaType.parseMediaType((String)acceptResponse));
                }
            }
        }
        MediaType responseType = null;
        if (defaultResponse == null && acceptResponseTypes.isEmpty()) {
            throw new HttpMediaTypeNotSupportedException(null, this.messageConverterRegistry.getSupportedMediaTypes(), "Unable to convert, mediatype is null");
        }
        if (acceptResponseTypes.isEmpty()) {
            responseType = defaultResponseType;
        } else {
            for (MediaType mediaType : acceptResponseTypes) {
                if (defaultResponse != null && mediaType.isCompatibleWith(defaultResponseType)) {
                    responseType = defaultResponseType;
                    break;
                }
                if (this.messageConverterRegistry.carWrite(returnValue.getClass(), mediaType) == null) continue;
                responseType = mediaType;
                break;
            }
        }
        if (responseType == null) {
            throw new HttpMediaTypeNotAcceptableException(this.messageConverterRegistry.getSupportedMediaTypes());
        }
        HttpMessageConverter converter = this.messageConverterRegistry.carWrite(returnValue.getClass(), responseType);
        if (converter == null) {
            List<MediaType> supported = this.messageConverterRegistry.getSupportedMediaTypes();
            throw new HttpMediaTypeNotSupportedException(responseType, supported);
        }
        AnnotationWebScriptOutputMessage outputMessage = new AnnotationWebScriptOutputMessage(response);
        converter.write(returnValue, responseType, (HttpOutputMessage)outputMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeExceptionHandlerMethods(Throwable exception, AnnotationWebScriptRequest request, WebScriptResponse response) throws IOException {
        List<Method> exceptionHandlerMethods = this.handlerMethods.findExceptionHandlers(exception);
        if (exceptionHandlerMethods.isEmpty()) {
            this.translateException(exception);
        }
        try {
            request.setThrownException(exception);
            for (Method exceptionHandler : exceptionHandlerMethods) {
                Object[] arguments = this.getArgumentsResolver().resolveHandlerMethodArguments(exceptionHandler, this.handler, (WebScriptRequest)request, response);
                exceptionHandler.setAccessible(true);
                ReflectionUtils.invokeMethod((Method)exceptionHandler, (Object)this.handler, (Object[])arguments);
            }
        }
        catch (Throwable e) {
            this.translateException(e);
        }
        finally {
            request.setThrownException(null);
        }
    }

    protected void translateException(Throwable e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public void setArgumentsResolver(HandlerMethodArgumentsResolver handlerMethodArgumentsResolver) {
        Assert.notNull((Object)handlerMethodArgumentsResolver);
        this.argumentsResolver = handlerMethodArgumentsResolver;
    }

    protected HandlerMethodArgumentsResolver getArgumentsResolver() {
        return this.argumentsResolver;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationWebScript other = (AnnotationWebScript)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

