/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts;

import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebScript;
import com.github.dynamicextensionsalfresco.webscripts.DummyStore;
import com.github.dynamicextensionsalfresco.webscripts.ExceptionHandlerMethod;
import com.github.dynamicextensionsalfresco.webscripts.HandlerMethods;
import com.github.dynamicextensionsalfresco.webscripts.MessageConverterRegistry;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Attribute;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Authentication;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Before;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Cache;
import com.github.dynamicextensionsalfresco.webscripts.annotations.ExceptionHandler;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Transaction;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Uri;
import com.github.dynamicextensionsalfresco.webscripts.annotations.WebScript;
import com.github.dynamicextensionsalfresco.webscripts.arguments.HandlerMethodArgumentsResolver;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.DescriptionImpl;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.TransactionParameters;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class AnnotationWebScriptBuilder
implements BeanFactoryAware {
    @Autowired
    private HandlerMethodArgumentsResolver handlerMethodArgumentsResolver;
    @Autowired
    private MessageConverterRegistry messageConverterRegistry;
    @Nullable
    private ConfigurableListableBeanFactory beanFactory;
    private final String trailingSlashExpression = "/$";
    private final String leadingSlashExpression = "^/";

    public final void setHandlerMethodArgumentsResolver(@NotNull HandlerMethodArgumentsResolver value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.handlerMethodArgumentsResolver = value;
    }

    public final void setMessageConverterRegistry(@NotNull MessageConverterRegistry value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.messageConverterRegistry = value;
    }

    @Nullable
    protected final ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @NotNull
    public final List<org.springframework.extensions.webscripts.WebScript> createWebScripts(@NotNull String beanName) {
        Assert.hasText((String)beanName, (String)"Bean name cannot be empty.");
        if (this.beanFactory == null) {
            throw new IllegalStateException("beanFactory");
        }
        Class beanType = this.beanFactory.getType(beanName);
        if (beanType == null) {
            return Collections.emptyList();
        }
        WebScript webScriptAnnotation = this.beanFactory.findAnnotationOnBean(beanName, WebScript.class) != null ? (WebScript)this.beanFactory.findAnnotationOnBean(beanName, WebScript.class) : this.getDefaultWebScriptAnnotation();
        String baseUri = webScriptAnnotation.baseUri();
        if (StringUtils.hasText((String)baseUri) && !baseUri.startsWith("/")) {
            throw new RuntimeException("@WebScript baseUri for class '" + beanType + "' does not start with a slash: '" + baseUri + "'");
        }
        HandlerMethods handlerMethods = new HandlerMethods();
        ArrayList<org.springframework.extensions.webscripts.WebScript> webScripts = new ArrayList<org.springframework.extensions.webscripts.WebScript>();
        MethodHandler methodHandler = new MethodHandler(beanName, handlerMethods, webScriptAnnotation, webScripts);
        ReflectionUtils.doWithMethods((Class)beanType, x$0 -> methodHandler.registerBeforeHandlerMethod(x$0));
        ReflectionUtils.doWithMethods((Class)beanType, x$0 -> methodHandler.registerAttributeHandlerMethod(x$0));
        ReflectionUtils.doWithMethods((Class)beanType, x$0 -> methodHandler.registerExceptionHandlerMethod(x$0));
        ReflectionUtils.doWithMethods((Class)beanType, x$0 -> methodHandler.registerWebscriptHandlerMethod(x$0));
        HashSet<String> ids = new HashSet<String>();
        for (org.springframework.extensions.webscripts.WebScript webScript : webScripts) {
            String webscriptId = webScript.getDescription().getId();
            boolean notContained = ids.add(webscriptId);
            if (notContained) continue;
            throw new IllegalStateException("Duplicate Web Script ID \"" + webscriptId + "\" Make sure handler methods of annotation-based Web Scripts have unique names.");
        }
        return webScripts;
    }

    @NotNull
    protected final AnnotationWebScript createWebScript(@NotNull String beanName, @NotNull WebScript webScript, @NotNull Uri uri, @NotNull HandlerMethods handlerMethods) {
        if (beanName == null) {
            throw new IllegalArgumentException("beanName is null");
        }
        if (webScript == null) {
            throw new IllegalArgumentException("webScript is null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if (handlerMethods == null) {
            throw new IllegalArgumentException("handlerMethods is null");
        }
        DescriptionImpl description = new DescriptionImpl();
        if (StringUtils.hasText((String)webScript.defaultFormat())) {
            description.setDefaultFormat(webScript.defaultFormat());
        }
        String baseUri = webScript.baseUri();
        this.handleHandlerMethodAnnotation(uri, handlerMethods.getUriMethod(), description, baseUri);
        this.handleTypeAnnotations(beanName, webScript, description);
        String id = String.format("%s.%s.%s", this.generateId(beanName), handlerMethods.getUriMethod().getName(), description.getMethod().toLowerCase());
        description.setId(id);
        if (this.beanFactory == null) {
            throw new IllegalStateException("beanFactory");
        }
        Object handler = this.beanFactory.getBean(beanName);
        description.setStore((Store)new DummyStore());
        return this.createWebScript((Description)description, handler, handlerMethods);
    }

    @NotNull
    protected final AnnotationWebScript createWebScript(@NotNull Description description, @NotNull Object handler, @NotNull HandlerMethods handlerMethods) {
        if (description == null) {
            throw new IllegalArgumentException("description is null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler is null");
        }
        if (handlerMethods == null) {
            throw new IllegalArgumentException("handlerMethods is null");
        }
        return new AnnotationWebScript(description, handler, handlerMethods, this.handlerMethodArgumentsResolver, this.messageConverterRegistry);
    }

    protected final void handleHandlerMethodAnnotation(@NotNull Uri uri, @NotNull Method method, @NotNull DescriptionImpl description, @NotNull String baseUri) {
        Transaction methodTransaction;
        Description.FormatStyle springFormatStyle;
        String[] uris;
        Assert.notNull((Object)uri, (String)"Uri cannot be null.");
        Assert.notNull((Object)method, (String)"HttpMethod cannot be null.");
        Assert.notNull((Object)description, (String)"Description cannot be null.");
        if (baseUri == null) {
            throw new IllegalArgumentException("baseUri is null");
        }
        if (uri.value().length > 0) {
            uris = (String[])Arrays.stream(uri.value()).map(it -> baseUri.replaceAll("/$", "") + "/" + it.replaceAll("^/", "")).toArray(String[]::new);
        } else if (StringUtils.hasText((String)baseUri)) {
            uris = new String[]{baseUri.replaceAll("/$", "")};
        } else {
            throw new RuntimeException(String.format("No value specified for @Uri on method '%s' and no base URI found for @WebScript on class.", ClassUtils.getQualifiedMethodName((Method)method)));
        }
        description.setUris(uris);
        description.setMethod(uri.method().name());
        switch (uri.formatStyle()) {
            case ANY: {
                springFormatStyle = Description.FormatStyle.any;
                break;
            }
            case ARGUMENT: {
                springFormatStyle = Description.FormatStyle.argument;
                break;
            }
            case EXTENSION: {
                springFormatStyle = Description.FormatStyle.extension;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format style: " + uri.formatStyle());
            }
        }
        description.setFormatStyle(springFormatStyle);
        if (StringUtils.hasText((String)uri.defaultFormat())) {
            description.setDefaultFormat(uri.defaultFormat());
        }
        description.setMultipartProcessing(uri.multipartProcessing());
        Authentication methodAuthentication = method.getAnnotation(Authentication.class);
        if (methodAuthentication != null) {
            this.handleAuthenticationAnnotation(methodAuthentication, description);
        }
        if ((methodTransaction = method.getAnnotation(Transaction.class)) != null) {
            this.handleTransactionAnnotation(methodTransaction, description);
        }
    }

    protected final void handleTypeAnnotations(@NotNull String beanName, @NotNull WebScript webScript, @NotNull DescriptionImpl description) {
        Cache cache;
        if (beanName == null) {
            throw new IllegalArgumentException("beanName is null");
        }
        if (webScript == null) {
            throw new IllegalArgumentException("webScript is null");
        }
        if (description == null) {
            throw new IllegalArgumentException("description is null");
        }
        this.handleWebScriptAnnotation(webScript, beanName, description);
        if (this.beanFactory == null) {
            throw new IllegalStateException("beanFactory");
        }
        if (description.getRequiredAuthentication() == null) {
            Authentication authentication = (Authentication)this.beanFactory.findAnnotationOnBean(beanName, Authentication.class);
            if (authentication == null) {
                authentication = this.getDefaultAuthenticationAnnotation();
            }
            this.handleAuthenticationAnnotation(authentication, description);
        }
        if (description.getRequiredTransactionParameters() == null) {
            Transaction transaction = (Transaction)this.beanFactory.findAnnotationOnBean(beanName, Transaction.class);
            if (transaction == null) {
                transaction = description.getMethod().equals("GET") ? this.getDefaultReadonlyTransactionAnnotation() : this.getDefaultReadWriteTransactionAnnotation();
            }
            this.handleTransactionAnnotation(transaction, description);
        }
        if ((cache = (Cache)this.beanFactory.findAnnotationOnBean(beanName, Cache.class)) == null) {
            cache = this.getDefaultCacheAnnotation();
        }
        this.handleCacheAnnotation(cache, beanName, description);
        description.setDescPath("");
    }

    protected final void handleWebScriptAnnotation(@NotNull WebScript webScript, @NotNull String beanName, @NotNull DescriptionImpl description) {
        Description.Lifecycle springLifeCycle;
        Assert.notNull((Object)webScript, (String)"Annotation cannot be null.");
        Assert.hasText((String)beanName, (String)"Bean name cannot be empty.");
        Assert.notNull((Object)description, (String)"Description cannot be null.");
        Assert.hasText((String)description.getMethod(), (String)"Description method is not specified.");
        if (StringUtils.hasText((String)webScript.value())) {
            description.setShortName(webScript.value());
        } else {
            description.setShortName(this.generateShortName(beanName));
        }
        if (StringUtils.hasText((String)webScript.description())) {
            description.setDescription(webScript.description());
        } else {
            if (this.beanFactory == null) {
                throw new IllegalStateException("beanFactory");
            }
            description.setDescription(String.format("Annotation-based WebScript for class %s", this.beanFactory.getType(beanName).getName()));
        }
        if (webScript.families().length > 0) {
            description.setFamilys(new LinkedHashSet<String>(Arrays.asList(webScript.families())));
        }
        switch (webScript.lifecycle()) {
            case NONE: {
                springLifeCycle = Description.Lifecycle.none;
                break;
            }
            case DRAFT: {
                springLifeCycle = Description.Lifecycle.draft;
                break;
            }
            case DRAFT_PUBLIC_API: {
                springLifeCycle = Description.Lifecycle.draft_public_api;
                break;
            }
            case DEPRECATED: {
                springLifeCycle = Description.Lifecycle.deprecated;
                break;
            }
            case INTERNAL: {
                springLifeCycle = Description.Lifecycle.internal;
                break;
            }
            case PUBLIC_API: {
                springLifeCycle = Description.Lifecycle.public_api;
                break;
            }
            case SAMPLE: {
                springLifeCycle = Description.Lifecycle.sample;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown lifeCycle '" + webScript.lifecycle() + "'");
            }
        }
        description.setLifecycle(springLifeCycle);
    }

    protected final void handleAuthenticationAnnotation(@NotNull Authentication authentication, @NotNull DescriptionImpl description) {
        Description.RequiredAuthentication requiredAuthentication;
        Assert.notNull((Object)authentication, (String)"Annotation cannot be null.");
        Assert.notNull((Object)description, (String)"Description cannot be null.");
        if (StringUtils.hasText((String)authentication.runAs())) {
            description.setRunAs(authentication.runAs());
        }
        switch (authentication.value()) {
            case NONE: {
                requiredAuthentication = Description.RequiredAuthentication.none;
                break;
            }
            case GUEST: {
                requiredAuthentication = Description.RequiredAuthentication.guest;
                break;
            }
            case USER: {
                requiredAuthentication = Description.RequiredAuthentication.user;
                break;
            }
            case ADMIN: {
                requiredAuthentication = Description.RequiredAuthentication.admin;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown authentication value '" + authentication.value() + "'");
            }
        }
        description.setRequiredAuthentication(requiredAuthentication);
    }

    protected final void handleTransactionAnnotation(@NotNull Transaction transaction, @NotNull DescriptionImpl description) {
        Description.RequiredTransaction requiredTransaction;
        Assert.notNull((Object)transaction, (String)"Annotation cannot be null.");
        Assert.notNull((Object)description, (String)"Description cannot be null.");
        TransactionParameters transactionParameters = new TransactionParameters();
        switch (transaction.value()) {
            case NONE: {
                requiredTransaction = Description.RequiredTransaction.none;
                break;
            }
            case REQUIRED: {
                requiredTransaction = Description.RequiredTransaction.required;
                break;
            }
            case REQUIRES_NEW: {
                requiredTransaction = Description.RequiredTransaction.requiresnew;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown transaction value '" + transaction.value() + "'");
            }
        }
        transactionParameters.setRequired(requiredTransaction);
        if (transaction.readOnly()) {
            transactionParameters.setCapability(Description.TransactionCapability.readonly);
        } else {
            transactionParameters.setCapability(Description.TransactionCapability.readwrite);
        }
        transactionParameters.setBufferSize(transaction.bufferSize());
        description.setRequiredTransactionParameters((Description.RequiredTransactionParameters)transactionParameters);
    }

    protected final void handleCacheAnnotation(@NotNull Cache cache, @NotNull String beanName, @NotNull DescriptionImpl description) {
        Assert.notNull((Object)cache, (String)"Annotation cannot be null.");
        Assert.hasText((String)beanName, (String)"Bean name cannot be empty.");
        Assert.notNull((Object)description, (String)"Description cannot be null.");
        org.springframework.extensions.webscripts.Cache requiredCache = new org.springframework.extensions.webscripts.Cache();
        requiredCache.setNeverCache(cache.neverCache());
        requiredCache.setIsPublic(cache.isPublic());
        requiredCache.setMustRevalidate(cache.mustRevalidate());
        description.setRequiredCache((Description.RequiredCache)requiredCache);
    }

    @NotNull
    protected final String generateId(@NotNull String beanName) {
        Assert.hasText((String)beanName, (String)"Bean name cannot be empty");
        if (this.beanFactory == null) {
            throw new IllegalStateException("beanFactory");
        }
        Class clazz = this.beanFactory.getType(beanName);
        if (clazz == null) {
            throw new IllegalStateException("clazz is null");
        }
        String id = clazz.getName();
        if (id == null) {
            throw new IllegalStateException("clazz.name is null");
        }
        return id;
    }

    @NotNull
    protected final String generateShortName(@NotNull String beanName) {
        Assert.hasText((String)beanName, (String)"Bean name cannot be empty");
        if (this.beanFactory == null) {
            throw new IllegalStateException("beanFactory");
        }
        Class clazz = this.beanFactory.getType(beanName);
        if (clazz == null) {
            throw new IllegalStateException("clazz is null");
        }
        String shortName = ClassUtils.getShortName((Class)clazz);
        if (shortName == null) {
            throw new IllegalStateException("ClassUtils.getShortName(clazz) is null");
        }
        return shortName;
    }

    private Authentication getDefaultAuthenticationAnnotation() {
        @Authentication
        final class Default {
            Default() {
            }
        }
        return Default.class.getAnnotation(Authentication.class);
    }

    private final Transaction getDefaultReadWriteTransactionAnnotation() {
        @Transaction
        final class Default {
            Default() {
            }
        }
        return Default.class.getAnnotation(Transaction.class);
    }

    private Transaction getDefaultReadonlyTransactionAnnotation() {
        @Transaction(readOnly=true)
        final class Default {
            Default() {
            }
        }
        return Default.class.getAnnotation(Transaction.class);
    }

    private Cache getDefaultCacheAnnotation() {
        @Cache
        final class Default {
            Default() {
            }
        }
        return Default.class.getAnnotation(Cache.class);
    }

    private WebScript getDefaultWebScriptAnnotation() {
        @WebScript
        final class Default {
            Default() {
            }
        }
        return Default.class.getAnnotation(WebScript.class);
    }

    public void setBeanFactory(@NotNull BeanFactory beanFactory) {
        if (beanFactory == null) {
            throw new IllegalArgumentException("beanFactory is null");
        }
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"BeanFactory is not of type ConfigurableListableBeanFactory.");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    private class MethodHandler {
        private final String beanName;
        private final HandlerMethods handlerMethods;
        private final WebScript webScriptAnnotation;
        private final List<org.springframework.extensions.webscripts.WebScript> webScripts;

        public MethodHandler(String beanName, HandlerMethods handlerMethods, WebScript webScriptAnnotation, List<org.springframework.extensions.webscripts.WebScript> webScripts) {
            this.beanName = beanName;
            this.handlerMethods = handlerMethods;
            this.webScriptAnnotation = webScriptAnnotation;
            this.webScripts = webScripts;
        }

        private void registerBeforeHandlerMethod(Method method) {
            if (method == null) {
                throw new IllegalArgumentException("method is null");
            }
            Before before = (Before)AnnotationUtils.findAnnotation((Method)method, Before.class);
            if (before != null) {
                if (AnnotationUtils.findAnnotation((Method)method, Attribute.class) != null || AnnotationUtils.findAnnotation((Method)method, Uri.class) != null) {
                    throw new RuntimeException("Cannot combine @Before, @Attribute and @Uri on a single method. Method: " + ClassUtils.getQualifiedMethodName((Method)method));
                }
                this.handlerMethods.getBeforeMethods().add(method);
            }
        }

        private void registerAttributeHandlerMethod(Method method) {
            if (method == null) {
                throw new IllegalArgumentException("method is null");
            }
            Attribute attribute = (Attribute)AnnotationUtils.findAnnotation((Method)method, Attribute.class);
            if (attribute != null) {
                if (AnnotationUtils.findAnnotation((Method)method, Before.class) != null || AnnotationUtils.findAnnotation((Method)method, Uri.class) != null) {
                    throw new RuntimeException("Cannot combine @Before, @Attribute and @Uri on a single method. Method: " + ClassUtils.getQualifiedMethodName((Method)method));
                }
                if (Void.TYPE.equals(method.getReturnType())) {
                    throw new RuntimeException("@Attribute methods cannot have a void return type.");
                }
                this.handlerMethods.getAttributeMethods().add(method);
            }
        }

        private void registerExceptionHandlerMethod(Method method) {
            if (method == null) {
                throw new IllegalArgumentException("method is null");
            }
            ExceptionHandler exceptionHandler = (ExceptionHandler)AnnotationUtils.findAnnotation((Method)method, ExceptionHandler.class);
            if (exceptionHandler != null) {
                if (AnnotationUtils.findAnnotation((Method)method, Attribute.class) != null || AnnotationUtils.findAnnotation((Method)method, Before.class) != null || AnnotationUtils.findAnnotation((Method)method, Uri.class) != null) {
                    throw new RuntimeException("Cannot combine @Before, @Attribute @ExceptionHandler or @Uri on a single method. Method: " + ClassUtils.getQualifiedMethodName((Method)method));
                }
                this.handlerMethods.getExceptionHandlerMethods().add(new ExceptionHandlerMethod(exceptionHandler, method));
            }
        }

        private void registerWebscriptHandlerMethod(Method method) {
            if (method == null) {
                throw new IllegalArgumentException("method is null");
            }
            Uri uri = (Uri)AnnotationUtils.findAnnotation((Method)method, Uri.class);
            if (uri != null) {
                AnnotationWebScript webScript = AnnotationWebScriptBuilder.this.createWebScript(this.beanName, this.webScriptAnnotation, uri, this.handlerMethods.createForUriMethod(method));
                this.webScripts.add(webScript);
            }
        }
    }
}

