/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts;

import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebScriptBuilder;
import com.github.dynamicextensionsalfresco.webscripts.WebScriptUriRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.webscripts.WebScript;

public class AnnotationWebScriptRegistrar
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private AnnotationWebScriptBuilder annotationBasedWebScriptBuilder;
    private WebScriptUriRegistry webScriptUriRegistry;
    private final List<WebScript> webScripts = new ArrayList<WebScript>();

    public void registerWebScripts() {
        for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
            for (WebScript webScript : this.annotationBasedWebScriptBuilder.createWebScripts(beanName)) {
                this.webScriptUriRegistry.registerWebScript(webScript);
                this.webScripts.add(webScript);
            }
        }
    }

    public void unregisterWebScripts() {
        Iterator<WebScript> it = this.webScripts.iterator();
        while (it.hasNext()) {
            WebScript webScript = it.next();
            this.webScriptUriRegistry.unregisterWebScript(webScript);
            it.remove();
        }
    }

    public List<WebScript> getWebScripts() {
        return this.webScripts;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setAnnotationBasedWebScriptBuilder(AnnotationWebScriptBuilder annotationBasedWebScriptBuilder) {
        this.annotationBasedWebScriptBuilder = annotationBasedWebScriptBuilder;
    }

    public void setWebScriptUriRegistry(WebScriptUriRegistry webScriptUriRegistry) {
        this.webScriptUriRegistry = webScriptUriRegistry;
    }
}

