/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts;

import com.github.dynamicextensionsalfresco.webscripts.annotations.ExceptionHandler;
import java.lang.reflect.Method;

class ExceptionHandlerMethod {
    private final Class<? extends Throwable>[] exceptionTypes;
    private final Method method;

    ExceptionHandlerMethod(ExceptionHandler exceptionHandlerAnnotation, Method method) {
        this.exceptionTypes = exceptionHandlerAnnotation.value();
        this.method = method;
    }

    public boolean canHandle(Throwable exception) {
        if (this.exceptionTypes.length == 0) {
            return true;
        }
        for (Class<? extends Throwable> type : this.exceptionTypes) {
            if (!type.isInstance(exception)) continue;
            return true;
        }
        return false;
    }

    public Method getMethod() {
        return this.method;
    }
}

