/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts;

import com.github.dynamicextensionsalfresco.webscripts.ExceptionHandlerMethod;
import com.github.dynamicextensionsalfresco.webscripts.annotations.ResponseTemplate;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.ResponseBody;

public class HandlerMethods {
    private final List<Method> beforeMethods = new ArrayList<Method>();
    private final List<Method> attributeMethods = new ArrayList<Method>();
    private Method uriMethod;
    private final List<ExceptionHandlerMethod> exceptionHandlerMethods = new ArrayList<ExceptionHandlerMethod>();

    public List<Method> getBeforeMethods() {
        return this.beforeMethods;
    }

    public List<Method> getAttributeMethods() {
        return this.attributeMethods;
    }

    public Method getUriMethod() {
        return this.uriMethod;
    }

    public List<ExceptionHandlerMethod> getExceptionHandlerMethods() {
        return this.exceptionHandlerMethods;
    }

    public List<Method> findExceptionHandlers(Throwable exception) {
        ArrayList<Method> handlerMethods = new ArrayList<Method>(1);
        for (ExceptionHandlerMethod exceptionHandlerMethod : this.getExceptionHandlerMethods()) {
            if (!exceptionHandlerMethod.canHandle(exception)) continue;
            handlerMethods.add(exceptionHandlerMethod.getMethod());
        }
        return handlerMethods;
    }

    public boolean useResponseTemplate() {
        return AnnotationUtils.findAnnotation((Method)this.uriMethod, ResponseTemplate.class) != null;
    }

    public String getResponseTemplateName() {
        ResponseTemplate responseTemplate = (ResponseTemplate)AnnotationUtils.findAnnotation((Method)this.uriMethod, ResponseTemplate.class);
        return responseTemplate != null ? responseTemplate.value() : null;
    }

    public boolean useResponseBody() {
        return AnnotationUtils.findAnnotation((Method)this.uriMethod, ResponseBody.class) != null;
    }

    public HandlerMethods createForUriMethod(Method uriMethod) {
        HandlerMethods handlerMethods = new HandlerMethods();
        handlerMethods.beforeMethods.addAll(this.getBeforeMethods());
        handlerMethods.attributeMethods.addAll(this.getAttributeMethods());
        handlerMethods.uriMethod = uriMethod;
        handlerMethods.exceptionHandlerMethods.addAll(this.getExceptionHandlerMethods());
        return handlerMethods;
    }
}

