/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MessageConverterRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageConverterRegistry.class);
    private final List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)MessageConverterRegistry.class.getClassLoader());
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)MessageConverterRegistry.class.getClassLoader()) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)MessageConverterRegistry.class.getClassLoader());

    public MessageConverterRegistry() {
        if (jackson2Present) {
            if (ClassUtils.isPresent((String)"org.springframework.http.converter.json.MappingJackson2HttpMessageConverter", (ClassLoader)MessageConverterRegistry.class.getClassLoader())) {
                LOGGER.debug("Adding default converter " + MappingJackson2HttpMessageConverter.class.getName());
                this.messageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
            } else {
                LOGGER.warn("MappingJackson2HttpMessageConverter not found on the classpath");
            }
        }
        if (jaxb2Present) {
            LOGGER.debug("Adding default converter " + Jaxb2RootElementHttpMessageConverter.class.getName());
            this.messageConverters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
        }
    }

    public void RegisterMessageConvertor(HttpMessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"Cannot register 'null' as a messageConverter");
        this.messageConverters.add(messageConverter);
    }

    public List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    public HttpMessageConverter canRead(Class<?> clazz, MediaType mediaType) {
        for (HttpMessageConverter<?> converter : this.getMessageConverters()) {
            if (!converter.canRead(clazz, mediaType)) continue;
            return converter;
        }
        return null;
    }

    public HttpMessageConverter carWrite(Class<?> clazz, MediaType mediaType) {
        for (HttpMessageConverter<?> converter : this.getMessageConverters()) {
            if (!converter.canWrite(clazz, mediaType)) continue;
            return converter;
        }
        return null;
    }

    public List<MediaType> getSupportedMediaTypes() {
        ArrayList<MediaType> supported = new ArrayList<MediaType>();
        for (HttpMessageConverter<?> messageConverter : this.messageConverters) {
            supported.addAll(messageConverter.getSupportedMediaTypes());
        }
        return supported;
    }
}

