/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.extensions.webscripts.Container;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.URLModelFactory;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.Assert;

class WebScriptProxy
implements WebScript {
    private WebScript webScript;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Description description;

    WebScriptProxy(WebScript webScript) {
        this.setWebScript(webScript);
    }

    public void init(Container container, Description description) {
    }

    public void setURLModelFactory(URLModelFactory urlModelFactory) {
    }

    public Description getDescription() {
        this.lock.readLock().lock();
        try {
            Description description = this.description;
            return description;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public ResourceBundle getResources() {
        this.lock.readLock().lock();
        try {
            ResourceBundle resourceBundle = this.webScript.getResources();
            return resourceBundle;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        this.lock.readLock().lock();
        try {
            this.webScript.execute(req, res);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setWebScript(WebScript webScript) {
        Assert.notNull((Object)webScript);
        this.lock.writeLock().lock();
        try {
            this.webScript = webScript;
            if (webScript.getDescription() != null) {
                this.description = webScript.getDescription();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public WebScript getWrappedWebScript() {
        return this.webScript;
    }
}

