/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts;

import com.github.dynamicextensionsalfresco.webscripts.UnavailableWebScript;
import com.github.dynamicextensionsalfresco.webscripts.UriMethod;
import com.github.dynamicextensionsalfresco.webscripts.WebScriptProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.UriIndex;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class WebScriptUriRegistry
implements UriIndex,
BeanPostProcessor,
InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private UriIndex uriIndex;
    private WebScript unavailableWebScript = new UnavailableWebScript();
    private String uriIndexBeanName;
    private final List<WebScript> webScripts = new ArrayList<WebScript>();
    private final Map<UriMethod, WebScriptProxy> webScriptProxiesByUriMethod = new HashMap<UriMethod, WebScriptProxy>();
    private final Lock lock = new ReentrantLock();

    public void registerWebScript(WebScript webScript) {
        this.lock.lock();
        try {
            if (this.uriIndex != null) {
                this.doRegisterWebScript(webScript);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Delaying registration of Web Script '{}' until UriIndex is available.", (Object)webScript.getDescription().getId());
            }
            this.webScripts.add(webScript);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void unregisterWebScript(WebScript webScript) {
        this.lock.lock();
        try {
            this.doUnregisterWebScript(webScript);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        Assert.state((this.uriIndex != null ? 1 : 0) != 0);
        this.lock.lock();
        try {
            this.uriIndex.clear();
            this.webScriptProxiesByUriMethod.clear();
            this.registerPendingWebScripts();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((boolean)StringUtils.hasText((String)this.uriIndexBeanName), (String)"Name of UriIndex bean not configured.");
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.uriIndexBeanName.equals(beanName) && bean instanceof UriIndex) {
            this.setUriIndex((UriIndex)bean);
            return this;
        }
        return bean;
    }

    public List<WebScript> getWebScripts() {
        return this.webScripts;
    }

    public int getSize() {
        return this.uriIndex.getSize();
    }

    public void registerUri(WebScript script, String uri) {
        this.uriIndex.registerUri(script, uri);
    }

    public Match findWebScript(String method, String uri) {
        return this.uriIndex.findWebScript(method, uri);
    }

    private void doRegisterWebScript(WebScript webScript) {
        Assert.state((this.uriIndex != null ? 1 : 0) != 0);
        for (String uri : webScript.getDescription().getURIs()) {
            WebScriptProxy webScriptProxy;
            UriMethod key;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Registering Web Script '{}' for URI '{}'", (Object)webScript.getDescription().getId(), (Object)uri);
            }
            if (!this.webScriptProxiesByUriMethod.containsKey(key = UriMethod.forUriAndMethod(uri, webScript.getDescription().getMethod()))) {
                webScriptProxy = new WebScriptProxy(webScript);
                this.webScriptProxiesByUriMethod.put(key, webScriptProxy);
            } else {
                webScriptProxy = this.webScriptProxiesByUriMethod.get(key);
                webScriptProxy.setWebScript(webScript);
            }
            this.uriIndex.registerUri((WebScript)webScriptProxy, uri);
        }
    }

    private void doUnregisterWebScript(WebScript webScript) {
        this.webScripts.remove(webScript);
        for (String uri : webScript.getDescription().getURIs()) {
            UriMethod key = UriMethod.forUriAndMethod(uri, webScript.getDescription().getMethod());
            if (!this.webScriptProxiesByUriMethod.containsKey(key)) continue;
            WebScriptProxy webScriptProxy = this.webScriptProxiesByUriMethod.get(key);
            webScriptProxy.setWebScript(this.unavailableWebScript);
        }
    }

    private void registerPendingWebScripts() {
        for (WebScript webScript : this.webScripts) {
            this.doRegisterWebScript(webScript);
        }
    }

    public void setUriIndex(UriIndex uriIndex) {
        Assert.notNull((Object)uriIndex);
        this.uriIndex = uriIndex;
    }

    public void setUnavailableWebScript(WebScript unavailableWebScript) {
        Assert.notNull((Object)unavailableWebScript);
        this.unavailableWebScript = unavailableWebScript;
    }

    public void setUriIndexBeanName(String uriIndexBeanName) {
        Assert.hasText((String)uriIndexBeanName);
        this.uriIndexBeanName = uriIndexBeanName;
    }
}

