/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WrappingWebScriptRequest;
import org.springframework.extensions.webscripts.WrappingWebScriptResponse;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;

public class WebScriptUtil {
    public static WebScriptServletRequest extractWebScriptServletRequest(WebScriptRequest request) {
        WebScriptServletRequest webScriptServletRequest = null;
        if (request instanceof WrappingWebScriptRequest) {
            WebScriptRequest nextRequest = ((WrappingWebScriptRequest)request).getNext();
            if (nextRequest instanceof WebScriptServletRequest) {
                webScriptServletRequest = (WebScriptServletRequest)nextRequest;
            } else if (nextRequest != null) {
                webScriptServletRequest = WebScriptUtil.extractWebScriptServletRequest(nextRequest);
            }
        }
        return webScriptServletRequest;
    }

    public static HttpServletRequest extractHttpServletRequest(WebScriptRequest request) {
        HttpServletRequest servletRequest = null;
        if (request instanceof WrappingWebScriptRequest) {
            WebScriptRequest nextRequest = ((WrappingWebScriptRequest)request).getNext();
            if (nextRequest instanceof WebScriptServletRequest) {
                servletRequest = ((WebScriptServletRequest)nextRequest).getHttpServletRequest();
            } else if (nextRequest != null) {
                servletRequest = WebScriptUtil.extractHttpServletRequest(nextRequest);
            }
        }
        return servletRequest;
    }

    public static HttpServletResponse extractHttpServletResponse(WebScriptResponse request) {
        HttpServletResponse servletResponse = null;
        if (request instanceof WrappingWebScriptResponse) {
            WebScriptResponse nextResponse = ((WrappingWebScriptResponse)request).getNext();
            if (nextResponse instanceof WebScriptServletResponse) {
                servletResponse = ((WebScriptServletResponse)nextResponse).getHttpServletResponse();
            } else if (nextResponse != null) {
                servletResponse = WebScriptUtil.extractHttpServletResponse(nextResponse);
            }
        }
        return servletResponse;
    }

    private WebScriptUtil() {
    }
}

