/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts.arguments;

import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebScriptRequest;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Attribute;
import com.github.dynamicextensionsalfresco.webscripts.arguments.ArgumentResolver;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.StringUtils;

public class AttributeArgumentResolver
implements ArgumentResolver<Object, Attribute> {
    public boolean supports(Class<?> parameterType, Class<? extends Annotation> annotationType) {
        return Attribute.class.equals(annotationType);
    }

    public Object resolveArgument(Class<?> argumentType, Attribute attribute, String name, WebScriptRequest request, WebScriptResponse response) {
        Object value;
        Map attributesByName = ((AnnotationWebScriptRequest)request).getModel();
        if (StringUtils.hasText((String)attribute.value())) {
            name = attribute.value();
        }
        if ((value = attributesByName.containsKey(name) ? attributesByName.get(name) : this.resolveByType(argumentType, attributesByName)) == null && attribute.required()) {
            throw new RuntimeException(String.format("Cannot find attribute for argument '%s'", name));
        }
        return value;
    }

    protected Object resolveByType(Class<?> argumentType, Map<String, Object> attributesByName) {
        Object value = null;
        for (Object attributeValue : attributesByName.values()) {
            if (!argumentType.isInstance(attributeValue)) continue;
            value = attributeValue;
            break;
        }
        return value;
    }
}

