/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts.arguments;

import com.github.dynamicextensionsalfresco.webscripts.MessageConverterRegistry;
import com.github.dynamicextensionsalfresco.webscripts.arguments.ArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.AttributeArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.CommandArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.ContentArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.ExceptionArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.FileFieldArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.HeaderArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.HttpServletRequestArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.HttpServletResponseArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.JsonObjectArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.ModelArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.RequestBodyArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.RequestParamArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.StringValueConverter;
import com.github.dynamicextensionsalfresco.webscripts.arguments.UriVariableArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.WebScriptRequestArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.WebScriptResponseArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.WebScriptSessionArgumentResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.Assert;

public class HandlerMethodArgumentsResolver
implements ApplicationContextAware {
    private StringValueConverter stringValueConverter;
    private MessageConverterRegistry messageConverterRegistry;
    private BundleContext bundleContext;
    private List<ArgumentResolver<Object, Annotation>> argumentResolvers;
    private final Map<ArgumentResolverKey, ArgumentResolver<Object, Annotation>> argumentResolverCache = new ConcurrentHashMap<ArgumentResolverKey, ArgumentResolver<Object, Annotation>>();
    private final ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private ServiceTracker resolverTracker;
    private ApplicationContext applicationContext;

    protected void initializeArgumentResolvers() {
        this.argumentResolvers = new ArrayList<ArgumentResolver<Object, Annotation>>();
        this.argumentResolvers.add(new RequestBodyArgumentResolver(this.messageConverterRegistry));
        this.argumentResolvers.add(new RequestParamArgumentResolver(this.getStringValueConverter()));
        this.argumentResolvers.add(new UriVariableArgumentResolver(this.getStringValueConverter()));
        this.argumentResolvers.add(new AttributeArgumentResolver());
        this.argumentResolvers.add(new ModelArgumentResolver());
        this.argumentResolvers.add(new ExceptionArgumentResolver());
        this.argumentResolvers.add(new HeaderArgumentResolver());
        this.argumentResolvers.add(new ContentArgumentResolver());
        this.argumentResolvers.add(new CommandArgumentResolver());
        this.argumentResolvers.add(new FileFieldArgumentResolver());
        this.argumentResolvers.add(new WebScriptRequestArgumentResolver());
        this.argumentResolvers.add(new WebScriptResponseArgumentResolver());
        this.argumentResolvers.add(new WebScriptSessionArgumentResolver());
        this.argumentResolvers.add(new HttpServletRequestArgumentResolver());
        this.argumentResolvers.add(new HttpServletResponseArgumentResolver());
        this.argumentResolvers.add(new JsonObjectArgumentResolver());
        if (this.bundleContext != null) {
            this.resolverTracker = new ServiceTracker(this.bundleContext, ArgumentResolver.class, null);
            this.resolverTracker.open(true);
        }
    }

    public Object[] resolveHandlerMethodArguments(Method method, Object handler, WebScriptRequest request, WebScriptResponse response) {
        Assert.notNull((Object)method, (String)"Method cannot be null.");
        Assert.notNull((Object)request, (String)"Request cannot be null.");
        Assert.notNull((Object)response, (String)"Response cannot be null.");
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] arguments = new Object[parameterTypes.length];
        if (AopUtils.isAopProxy((Object)handler)) {
            method = AopUtils.getMostSpecificMethod((Method)method, (Class)AopUtils.getTargetClass((Object)handler));
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String[] methodParameterNames = this.parameterNameDiscoverer.getParameterNames(method);
        for (int index = 0; index < parameterTypes.length; ++index) {
            Annotation mappingAnnotation = null;
            ArgumentResolver<Object, Annotation> argumentResolver = null;
            if (parameterAnnotations[index].length == 0) {
                argumentResolver = this.getArgumentResolver(parameterTypes[index], null);
            } else {
                for (Annotation parameterAnnotation : parameterAnnotations[index]) {
                    argumentResolver = this.getArgumentResolver(parameterTypes[index], parameterAnnotation.annotationType());
                    if (argumentResolver == null) continue;
                    mappingAnnotation = parameterAnnotation;
                    break;
                }
            }
            if (argumentResolver == null) {
                throw new IllegalStateException(String.format("Cannot map parameter at index %d of method %s.%s.", index, handler.getClass().getSimpleName(), method.getName()));
            }
            String name = null;
            if (methodParameterNames != null) {
                name = methodParameterNames[index];
            }
            arguments[index] = argumentResolver.resolveArgument(parameterTypes[index], mappingAnnotation, name, request, response);
        }
        return arguments;
    }

    protected ArgumentResolver<Object, Annotation> getArgumentResolver(Class<?> parameterType, Class<? extends Annotation> annotationType) {
        Object[] services;
        Assert.notNull(parameterType, (String)"ParameterType cannot be null.");
        ArgumentResolverKey cacheKey = new ArgumentResolverKey(parameterType, annotationType);
        ArgumentResolver<Object, Annotation> match = this.argumentResolverCache.get(cacheKey);
        if (match != null) {
            return match;
        }
        Map localArgumentResolvers = this.applicationContext.getBeansOfType(ArgumentResolver.class);
        for (ArgumentResolver argumentResolver : localArgumentResolvers.values()) {
            if (!argumentResolver.supports(parameterType, annotationType)) continue;
            this.argumentResolverCache.put(cacheKey, (ArgumentResolver<Object, Annotation>)argumentResolver);
            return argumentResolver;
        }
        if (this.resolverTracker != null && (services = this.resolverTracker.getServices()) != null) {
            for (Object service : services) {
                ArgumentResolver argumentResolver = (ArgumentResolver)service;
                if (!argumentResolver.supports(parameterType, annotationType)) continue;
                return argumentResolver;
            }
        }
        for (ArgumentResolver argumentResolver : this.argumentResolvers) {
            if (!argumentResolver.supports(parameterType, annotationType)) continue;
            this.argumentResolverCache.put(cacheKey, (ArgumentResolver<Object, Annotation>)argumentResolver);
            return argumentResolver;
        }
        return null;
    }

    public void setStringValueConverter(StringValueConverter stringValueConverter) {
        this.stringValueConverter = stringValueConverter;
    }

    protected StringValueConverter getStringValueConverter() {
        return this.stringValueConverter;
    }

    public MessageConverterRegistry getMessageConverterRegistry() {
        return this.messageConverterRegistry;
    }

    public void setMessageConverterRegistry(MessageConverterRegistry messageConverterRegistry) {
        this.messageConverterRegistry = messageConverterRegistry;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static class ArgumentResolverKey {
        public final Class parameterType;
        public final Class annotationType;

        private ArgumentResolverKey(Class parameterType, Class annotationType) {
            this.parameterType = parameterType;
            this.annotationType = annotationType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArgumentResolverKey that = (ArgumentResolverKey)o;
            return !(this.annotationType == null ? that.annotationType != null : !this.annotationType.equals(that.annotationType)) && this.parameterType.equals(that.parameterType);
        }

        public int hashCode() {
            int result = this.parameterType.hashCode();
            result = 31 * result + (this.annotationType != null ? this.annotationType.hashCode() : 0);
            return result;
        }
    }
}

