/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts.arguments;

import com.github.dynamicextensionsalfresco.webscripts.arguments.AbstractTypeBasedArgumentResolver;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class JsonObjectArgumentResolver
extends AbstractTypeBasedArgumentResolver<JSONObject> {
    @Override
    protected Class<?> getExpectedArgumentType() {
        return JSONObject.class;
    }

    @Override
    protected JSONObject resolveArgument(WebScriptRequest request, WebScriptResponse response) {
        if (request.getContentType().startsWith("application/json")) {
            try {
                String contentText = request.getContent().getContent();
                if (contentText != null) {
                    try {
                        return new JSONObject(contentText);
                    }
                    catch (JSONException e) {
                        throw new WebScriptException(400, "Failed to parse JSON body: " + contentText, (Throwable)e);
                    }
                }
            }
            catch (IOException ex) {
                throw new WebScriptException(400, "Failed to read body content", (Throwable)ex);
            }
        }
        return null;
    }
}

