/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts.arguments;

import com.github.dynamicextensionsalfresco.webscripts.MessageConverterRegistry;
import com.github.dynamicextensionsalfresco.webscripts.arguments.ArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.messages.AnnotationWebScriptInputMessage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.RequestBody;

public class RequestBodyArgumentResolver
implements ArgumentResolver<Object, RequestBody> {
    private MessageConverterRegistry messageConverterRegistry;

    public RequestBodyArgumentResolver(MessageConverterRegistry messageConverterRegistry) {
        this.messageConverterRegistry = messageConverterRegistry;
    }

    public boolean supports(Class<?> argumentType, Class<? extends Annotation> annotationType) {
        return RequestBody.class.equals(annotationType);
    }

    public Object resolveArgument(Class<?> argumentType, RequestBody parameterAnnotation, String name, WebScriptRequest request, WebScriptResponse response) {
        String[] headerResponseTypes = request.getHeaderValues("Content-Type");
        if (headerResponseTypes == null) {
            throw new RuntimeException("Missing 'Content-Type' header from request. Unable to resolve parameters.");
        }
        if (headerResponseTypes.length != 1) {
            if (headerResponseTypes.length == 0) {
                throw new RuntimeException("Missing 'Content-Type' value from request. Unable to resolve parameters.");
            }
            throw new RuntimeException("Multiple 'Content-Type' values found in request. Unable to resolve parameters.");
        }
        MediaType contentType = MediaType.parseMediaType((String)headerResponseTypes[0]);
        HttpMessageConverter messageConverter = this.messageConverterRegistry.canRead(argumentType, contentType);
        if (messageConverter == null) {
            throw new RuntimeException("Unable to find Convertor for " + contentType.toString());
        }
        if (request.getContent() == null) {
            throw new RuntimeException("The content of the request is empty while it is required.");
        }
        boolean isEmpty = this.isBodyEmpty(request.getContent().getInputStream());
        if (isEmpty) {
            throw new RuntimeException("The body of the request is empty while it is required.");
        }
        AnnotationWebScriptInputMessage inputMessage = new AnnotationWebScriptInputMessage(request);
        try {
            Object result = messageConverter.read(argumentType, (HttpInputMessage)inputMessage);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isBodyEmpty(InputStream inputStream) {
        try {
            return inputStream.available() == 0;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while checking of body is empty", e);
        }
    }
}

