/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts.arguments;

import com.github.dynamicextensionsalfresco.webscripts.annotations.RequestParam;
import com.github.dynamicextensionsalfresco.webscripts.arguments.ArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.StringValueConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RequestParamArgumentResolver
implements ArgumentResolver<Object, RequestParam> {
    private final StringValueConverter stringValueConverter;

    RequestParamArgumentResolver(StringValueConverter stringValueConverter) {
        Assert.notNull((Object)stringValueConverter);
        this.stringValueConverter = stringValueConverter;
    }

    public boolean supports(Class<?> parameterType, Class<? extends Annotation> annotationType) {
        if (parameterType.isArray()) {
            parameterType = parameterType.getComponentType();
        }
        return this.getStringValueConverter().isSupportedType(parameterType) && RequestParam.class.equals(annotationType);
    }

    public Object resolveArgument(Class<?> parameterType, RequestParam requestParam, String name, WebScriptRequest request, WebScriptResponse response) {
        Assert.notNull((Object)requestParam, (String)"RequestParam annotation cannot be null.");
        String parameterName = requestParam.value();
        if (!StringUtils.hasText((String)parameterName)) {
            parameterName = name;
        }
        if (!StringUtils.hasText((String)parameterName)) {
            throw new RuntimeException("Cannot determine name of request parameter. Specify the name using the @RequestParam annotation.");
        }
        Object parameter = !parameterType.isArray() ? this.handleSingleParameter(parameterType, requestParam, request, parameterName) : (StringUtils.hasText((String)requestParam.delimiter()) ? this.handleDelimitedParameter(parameterType, requestParam, request, parameterName) : this.handleMultipleParameters(parameterType, requestParam, request, parameterName));
        return parameter;
    }

    private Object handleSingleParameter(Class<?> parameterType, RequestParam requestParam, WebScriptRequest request, String parameterName) {
        String parameterValue = request.getParameter(parameterName);
        Object value = null;
        if (parameterValue != null) {
            value = this.getStringValueConverter().convertStringValue(parameterType, parameterValue);
        } else {
            if (StringUtils.hasText((String)requestParam.defaultValue())) {
                value = this.getStringValueConverter().convertStringValue(parameterType, requestParam.defaultValue());
            }
            if (value == null) {
                this.throwMissingParameterIfMandatory(requestParam, parameterName);
            }
        }
        return value;
    }

    private Object handleDelimitedParameter(Class<?> parameterType, RequestParam requestParam, WebScriptRequest request, String parameterName) {
        String parameterValue = request.getParameter(parameterName);
        if (parameterValue == null) {
            if (StringUtils.hasText((String)requestParam.defaultValue())) {
                parameterValue = requestParam.defaultValue();
            } else {
                this.throwMissingParameterIfMandatory(requestParam, parameterName);
            }
        }
        if (parameterValue != null) {
            String[] parameterValues = parameterValue.split(requestParam.delimiter());
            return this.convertToArray(parameterType.getComponentType(), parameterValues);
        }
        return null;
    }

    private Object handleMultipleParameters(Class<?> parameterType, RequestParam requestParam, WebScriptRequest request, String parameterName) {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (parameterValues == null) {
            this.throwMissingParameterIfMandatory(requestParam, parameterName);
            parameterValues = new String[]{requestParam.defaultValue()};
        }
        return this.convertToArray(parameterType.getComponentType(), parameterValues);
    }

    private void throwMissingParameterIfMandatory(RequestParam requestParam, String parameterName) {
        if (requestParam.required()) {
            throw new WebScriptException(requestParam.missingParameterHttpStatusCode(), String.format("Request parameter not available: %s", parameterName));
        }
    }

    private Object[] convertToArray(Class<?> arrayComponentType, String[] parameterValues) {
        Object[] values = (Object[])Array.newInstance(arrayComponentType, parameterValues.length);
        for (int i = 0; i < parameterValues.length; ++i) {
            values[i] = this.getStringValueConverter().convertStringValue(arrayComponentType, parameterValues[i]);
        }
        return values;
    }

    protected StringValueConverter getStringValueConverter() {
        return this.stringValueConverter;
    }
}

