/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts.arguments;

import java.util.HashSet;
import java.util.Set;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class StringValueConverter {
    private static final Set<Class<?>> SUPPORTED_TYPES = new HashSet();
    private NamespacePrefixResolver namespacePrefixResolver;

    public boolean isSupportedType(Class<?> type) {
        return SUPPORTED_TYPES.contains(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T convertStringValue(Class<T> type, String stringValue) {
        Object value;
        if (String.class.equals(type)) {
            value = stringValue;
            return (T)value;
        } else if (Integer.TYPE.equals(type)) {
            value = Integer.parseInt(stringValue);
            return (T)value;
        } else if (Integer.class.equals(type)) {
            value = Integer.valueOf(stringValue);
            return (T)value;
        } else if (Long.TYPE.equals(type)) {
            value = Long.parseLong(stringValue);
            return (T)value;
        } else if (Long.class.equals(type)) {
            value = Long.valueOf(stringValue);
            return (T)value;
        } else if (Boolean.TYPE.equals(type)) {
            value = Boolean.parseBoolean(stringValue);
            return (T)value;
        } else if (Boolean.class.equals(type)) {
            value = Boolean.valueOf(stringValue);
            return (T)value;
        } else if (QName.class.equals(type)) {
            if (stringValue.matches("\\{.+?\\}.+?")) {
                value = QName.createQName((String)stringValue);
                return (T)value;
            } else {
                if (!stringValue.matches("\\w+?:\\w+?")) throw new IllegalArgumentException("Invalid QName format: " + stringValue);
                value = QName.createQName((String)stringValue, (NamespacePrefixResolver)this.getNamespacePrefixResolver());
            }
            return (T)value;
        } else {
            if (!NodeRef.class.equals(type)) throw new IllegalArgumentException(String.format("Unhandled parameter type %s", type));
            value = new NodeRef(stringValue);
        }
        return (T)value;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    protected NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.namespacePrefixResolver;
    }

    static {
        SUPPORTED_TYPES.add(String.class);
        SUPPORTED_TYPES.add(String[].class);
        SUPPORTED_TYPES.add(Integer.TYPE);
        SUPPORTED_TYPES.add(int[].class);
        SUPPORTED_TYPES.add(Integer.class);
        SUPPORTED_TYPES.add(Integer[].class);
        SUPPORTED_TYPES.add(Long.TYPE);
        SUPPORTED_TYPES.add(long[].class);
        SUPPORTED_TYPES.add(Long.class);
        SUPPORTED_TYPES.add(Long[].class);
        SUPPORTED_TYPES.add(Boolean.TYPE);
        SUPPORTED_TYPES.add(boolean[].class);
        SUPPORTED_TYPES.add(Boolean.class);
        SUPPORTED_TYPES.add(Boolean[].class);
        SUPPORTED_TYPES.add(QName.class);
        SUPPORTED_TYPES.add(NodeRef.class);
    }
}

