/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts.arguments;

import com.github.dynamicextensionsalfresco.webscripts.annotations.UriVariable;
import com.github.dynamicextensionsalfresco.webscripts.arguments.ArgumentResolver;
import com.github.dynamicextensionsalfresco.webscripts.arguments.StringValueConverter;
import java.lang.annotation.Annotation;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class UriVariableArgumentResolver
implements ArgumentResolver<Object, UriVariable> {
    private final StringValueConverter stringValueConverter;

    UriVariableArgumentResolver(StringValueConverter stringValueConverter) {
        Assert.notNull((Object)stringValueConverter);
        this.stringValueConverter = stringValueConverter;
    }

    public boolean supports(Class<?> parameterType, Class<? extends Annotation> annotationType) {
        return this.getStringValueConverter().isSupportedType(parameterType) && UriVariable.class.equals(annotationType);
    }

    public Object resolveArgument(Class<?> parameterType, UriVariable uriVariable, String name, WebScriptRequest request, WebScriptResponse response) {
        String variableName = uriVariable.value();
        if (!StringUtils.hasText((String)variableName)) {
            variableName = name;
        }
        if (!StringUtils.hasText((String)variableName)) {
            throw new RuntimeException("Cannot determine name of URI variable. Specify the name using the @UriVariable annotation.");
        }
        String variable = (String)request.getServiceMatch().getTemplateVars().get(variableName);
        Object value = null;
        if (variable != null) {
            value = this.getStringValueConverter().convertStringValue(parameterType, variable);
        } else if (uriVariable.required()) {
            throw new IllegalStateException(String.format("URI variable not available: %s", variableName));
        }
        return value;
    }

    public StringValueConverter getStringValueConverter() {
        return this.stringValueConverter;
    }
}

