/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.workflow.activiti;

import com.github.dynamicextensionsalfresco.workflow.activiti.WorkflowTaskRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.JavaDelegate;
import org.activiti.engine.delegate.TaskListener;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class WorkflowTaskRegistrar
implements InitializingBean,
ApplicationContextAware,
DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(WorkflowTaskRegistrar.class);
    private ApplicationContext applicationContext;
    @NotNull
    private final Map<String, Object> activitiBeanRegistry;
    @NotNull
    private final WorkflowTaskRegistry workflowTaskRegistry;

    public WorkflowTaskRegistrar(@NotNull Map<String, Object> activitiBeanRegistry, @NotNull WorkflowTaskRegistry workflowTaskRegistry) {
        if (activitiBeanRegistry == null) {
            throw new IllegalArgumentException("activitiBeanRegistry is null");
        }
        if (workflowTaskRegistry == null) {
            throw new IllegalArgumentException("workflowTaskRegistry is null");
        }
        this.activitiBeanRegistry = activitiBeanRegistry;
        this.workflowTaskRegistry = workflowTaskRegistry;
    }

    public void afterPropertiesSet() {
        for (Class<?> type : this.workflowDelegateTypes()) {
            Map delegates = this.applicationContext.getBeansOfType(type);
            delegates.forEach((name, bean) -> {
                Object existing = this.activitiBeanRegistry.put((String)name, bean);
                if (existing != null) {
                    this.logger.warn("replaced existing {} with name {}", existing.getClass(), name);
                }
                this.logger.debug("registered Bundle component {} (type: {}) -> {}", new Object[]{name, type, bean});
                if (JavaDelegate.class.equals((Object)type)) {
                    this.workflowTaskRegistry.registerDelegate((String)name, (JavaDelegate)bean);
                } else if (TaskListener.class.equals((Object)type)) {
                    this.workflowTaskRegistry.registerTaskListener((String)name, (TaskListener)bean);
                } else if (ExecutionListener.class.equals((Object)type)) {
                    this.workflowTaskRegistry.registerExecutionListener((String)name, (ExecutionListener)bean);
                }
            });
        }
    }

    public void destroy() {
        for (Class<?> type : this.workflowDelegateTypes()) {
            Map delegates = this.applicationContext.getBeansOfType(type);
            delegates.forEach((name, bean) -> {
                this.activitiBeanRegistry.remove(name);
                this.logger.debug("unregistered Bundle component {} (type: {}) -> {}", new Object[]{name, type, bean});
                if (JavaDelegate.class.equals((Object)type)) {
                    this.workflowTaskRegistry.unregisterDelegate((String)name);
                } else if (TaskListener.class.equals((Object)type)) {
                    this.workflowTaskRegistry.unregisterTaskListener((String)name);
                } else if (ExecutionListener.class.equals((Object)type)) {
                    this.workflowTaskRegistry.unregisterExecutionListener((String)name);
                }
            });
        }
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new IllegalArgumentException("applicationContext is null");
        }
        this.applicationContext = applicationContext;
    }

    @NotNull
    public final Map getActivitiBeanRegistry() {
        return this.activitiBeanRegistry;
    }

    @NotNull
    public final WorkflowTaskRegistry getWorkflowTaskRegistry() {
        return this.workflowTaskRegistry;
    }

    private List<Class<?>> workflowDelegateTypes() {
        return Arrays.asList(JavaDelegate.class, TaskListener.class, ExecutionListener.class);
    }
}

