/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.workflow.activiti;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class WorkflowTaskRegistryFactory
implements FactoryBean<Object> {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowTaskRegistryFactory.class);
    private Object implementation;

    public WorkflowTaskRegistryFactory() {
        try {
            Class.forName("org.activiti.engine.delegate.JavaDelegate");
            Class<?> implementationClass = Class.forName("com.github.dynamicextensionsalfresco.workflow.activiti.DefaultWorkflowTaskRegistry");
            this.implementation = implementationClass.newInstance();
        }
        catch (Throwable e) {
            logger.info("Activiti support disabled");
        }
    }

    public Object getObject() throws Exception {
        if (this.implementation != null) {
            return this.implementation;
        }
        return new Object();
    }

    public Class<?> getObjectType() {
        if (this.implementation == null) {
            return Object.class;
        }
        try {
            return Class.forName("com.github.dynamicextensionsalfresco.workflow.activiti.WorkflowTaskRegistry");
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isSingleton() {
        return true;
    }
}

