/*
 * Decompiled with CFR 0.152.
 */
package fi.testee.psql;

import fi.testee.exceptions.TestEEfiException;
import fi.testee.psql.PostgresConfiguration;
import fi.testee.spi.ConnectionFactory;
import fi.testee.utils.AnnotationUtils;
import fi.testee.utils.ExpressionUtils;
import fi.testee.utils.JdbcUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresConnectionFactory
implements ConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresConnectionFactory.class);
    private final ConcurrentHashMap<String, String> databases = new ConcurrentHashMap();
    @Resource(mappedName="testeefi/setup/class")
    private Class<?> testSetupClass;
    private PostgresConfiguration config;

    @PostConstruct
    private void readConfigFromTestClass() {
        this.config = (PostgresConfiguration)AnnotationUtils.firstByTypeHierarchy(this.testSetupClass, PostgresConfiguration.class);
        if (this.config == null) {
            throw new TestEEfiException("No @PostgresConfiguration found on " + this.testSetupClass + " which uses PostgresConnectionFactory");
        }
    }

    public Connection createConnection(String dbName) {
        this.databases.computeIfAbsent(dbName, s -> this.newDatabase());
        return (Connection)JdbcUtils.execute(() -> this.connect(this.databases.get(dbName)), e -> "Failed to open connection to PostgreSQL database");
    }

    private Connection connect(String dbName) throws SQLException {
        return DriverManager.getConnection(this.urlFor(dbName), this.username(), this.password());
    }

    private String username() {
        return ExpressionUtils.evalExpression((String)this.config.username());
    }

    private String hostname() {
        return ExpressionUtils.evalExpression((String)this.config.hostname());
    }

    private String password() {
        return ExpressionUtils.evalExpression((String)this.config.password());
    }

    private String port() {
        return ExpressionUtils.evalExpression((String)this.config.port());
    }

    private String urlFor(String dbName) {
        return "jdbc:postgresql://" + this.hostname() + ":" + this.port() + "/" + dbName;
    }

    private String newDatabase() {
        String dbName = "testeefi_" + UUID.randomUUID().toString().replace("-", "");
        this.createDB(dbName);
        return dbName;
    }

    private void createDB(String dbName) {
        JdbcUtils.execute(() -> {
            try (Connection c = this.connect("postgres");){
                JdbcUtils.update((Connection)c, (String)("CREATE DATABASE " + dbName), (Object[])new Object[0]);
                JdbcUtils.update((Connection)c, (String)("GRANT ALL PRIVILEGES ON DATABASE " + dbName + " TO " + this.username()), (Object[])new Object[0]);
                Object var4_4 = null;
                return var4_4;
            }
        }, e -> "Failed to create PostgreSQL database " + dbName);
    }

    private void dropDB(String dbName) {
        JdbcUtils.execute(() -> {
            try (Connection c = this.connect("postgres");){
                JdbcUtils.update((Connection)c, (String)("UPDATE pg_database SET datallowconn = 'false' WHERE datname = '" + dbName + "'"), (Object[])new Object[0]);
                JdbcUtils.query((Connection)c, (String)("SELECT pg_terminate_backend(pid) FROM pg_stat_activity WHERE datname = '" + dbName + "'"), row -> null, (Object[])new Object[0]);
                JdbcUtils.update((Connection)c, (String)("DROP DATABASE " + dbName), (Object[])new Object[0]);
            }
            return null;
        }, e -> "Failed to drop PostgreSQL database " + dbName);
    }

    @PreDestroy
    public void release() {
        this.databases.values().forEach(dbName -> {
            try {
                this.dropDB((String)dbName);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to cleanup PostgreSQL database {}", dbName, (Object)e);
            }
        });
    }
}

