/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.annotation_processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class ProcessorUtil {
    public static TypeMirror getComponentType(TypeMirror fieldType) {
        if (fieldType.getKind() == TypeKind.ARRAY) {
            TypeMirror componentType = ((ArrayType)fieldType).getComponentType();
            if (componentType.getKind() == TypeKind.ARRAY) {
                return ProcessorUtil.getComponentType(componentType);
            }
            return componentType;
        }
        if (fieldType.getKind() == TypeKind.DECLARED) {
            return ((DeclaredType)fieldType).getTypeArguments().get(0);
        }
        return null;
    }

    public static int getComponentTypeDepth(TypeMirror fieldType) {
        if (fieldType.getKind() == TypeKind.ARRAY) {
            TypeMirror componentType = ((ArrayType)fieldType).getComponentType();
            if (componentType.getKind() == TypeKind.ARRAY) {
                return ProcessorUtil.getComponentTypeDepth(componentType) + 1;
            }
            return 1;
        }
        if (fieldType.getKind() == TypeKind.DECLARED) {
            return 1;
        }
        return 0;
    }

    public static boolean hasModifier(Element element, Modifier ... modifiers) {
        for (Modifier modifier : modifiers) {
            if (element.getModifiers().contains((Object)modifier)) continue;
            return false;
        }
        return true;
    }

    public static <A extends Annotation> boolean hasMethodAnnotation(TypeElement element, Class<A> annotationType) {
        for (Element element2 : element.getEnclosedElements()) {
            A annotation;
            if (!element2.getKind().equals((Object)ElementKind.METHOD) || ProcessorUtil.hasModifier(element2, Modifier.STATIC) || (annotation = element.getAnnotation(annotationType)) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInterface(TypeElement element, Class<?> clazz) {
        if (!clazz.isInterface()) {
            throw new RuntimeException(String.format("%s is not interface class", clazz.getName()));
        }
        List<? extends TypeMirror> interfaces = element.getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            if (!clazz.getName().equals(typeMirror.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInterface(TypeElement element, TypeMirror infType) {
        List<? extends TypeMirror> interfaces = element.getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            if (!typeMirror.toString().equals(infType.toString())) continue;
            return true;
        }
        return false;
    }

    public static MethodSpec getConflictMethod(Iterable<MethodSpec> methodSpecs, MethodSpec target) {
        for (MethodSpec methodSpec : methodSpecs) {
            if (!methodSpec.name.equals(target.name) || !ProcessorUtil.compareParameterSpecs(methodSpec.parameters, target.parameters)) continue;
            return methodSpec;
        }
        return null;
    }

    public static boolean compareParameterSpecs(List<ParameterSpec> o1, List<ParameterSpec> o2) {
        if (o1.size() == o2.size()) {
            for (int i = 0; i < o1.size(); ++i) {
                ParameterSpec p1 = o1.get(i);
                ParameterSpec p2 = o2.get(i);
                if (p1.type.toString().equals(p2.type.toString())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String parameterSpecToString(List<ParameterSpec> parameterSpecs) {
        StringJoiner joiner = new StringJoiner(", ");
        for (ParameterSpec parameterSpec : parameterSpecs) {
            joiner.add(parameterSpec.type.toString());
        }
        return joiner.toString();
    }

    public static String getDefaultValueAsString(TypeMirror type) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return "false";
            }
            case FLOAT: {
                return "0.0f";
            }
            case DOUBLE: {
                return "0.0d";
            }
            case LONG: {
                return "0L";
            }
            case INT: {
                return "0";
            }
            case SHORT: {
                return "(short)0";
            }
            case BYTE: {
                return "(byte)0";
            }
            case CHAR: {
                return "'\u0000'";
            }
        }
        return "null";
    }

    public static Modifier[] getModifiers(Element element, Modifier ... excludes) {
        Set<Modifier> modifierSet = element.getModifiers();
        if (modifierSet == null) {
            return new Modifier[0];
        }
        if (excludes != null && excludes.length > 0) {
            ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
            List<Modifier> excludeList = Arrays.asList(excludes);
            for (Modifier modifier : modifierSet) {
                if (excludeList.contains((Object)modifier)) continue;
                modifiers.add(modifier);
            }
            return modifiers.toArray(new Modifier[0]);
        }
        return modifierSet.toArray(new Modifier[0]);
    }

    public static List<AnnotationSpec> getAnnotationSpecs(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        ArrayList<AnnotationSpec> annotationSpecs = new ArrayList<AnnotationSpec>();
        if (annotationMirrors != null) {
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                annotationSpecs.add(AnnotationSpec.get((AnnotationMirror)annotationMirror));
            }
        }
        return annotationSpecs;
    }

    public static List<ParameterSpec> getParameterSpecs(ExecutableElement element) {
        List<? extends VariableElement> parameters = element.getParameters();
        ArrayList<ParameterSpec> parameterSpecs = new ArrayList<ParameterSpec>();
        if (parameters != null) {
            for (VariableElement variableElement : parameters) {
                parameterSpecs.add(ParameterSpec.get((VariableElement)variableElement));
            }
        }
        return parameterSpecs;
    }

    public static List<TypeName> getSuperinterfaces(TypeElement element) {
        List<? extends TypeMirror> interfaces = element.getInterfaces();
        ArrayList<TypeName> typeNames = new ArrayList<TypeName>();
        if (interfaces != null) {
            for (TypeMirror typeMirror : interfaces) {
                typeNames.add(TypeName.get((TypeMirror)typeMirror));
            }
        }
        return typeNames;
    }
}

