/*
 * Decompiled with CFR 0.152.
 */
package fun.imcoder.cloud.base;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import fun.imcoder.cloud.annotation.ModelParam;
import fun.imcoder.cloud.base.BaseModel;
import fun.imcoder.cloud.base.BaseService;
import fun.imcoder.cloud.common.PageRequest;
import fun.imcoder.cloud.common.ResponseData;
import fun.imcoder.cloud.enums.ModelParamType;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class BaseController<M extends BaseModel, S extends BaseService> {
    @Autowired
    public S service;

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u4fe1\u606f")
    public ResponseData<List<M>> list(@ModelParam M m) {
        QueryWrapper queryWrapper = new QueryWrapper(m);
        this.setOrder(m, queryWrapper);
        return ResponseData.success(this.service.list((Wrapper)queryWrapper));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u67e5\u8be2\u4fe1\u606f")
    public ResponseData<List<M>> customList(@ModelParam M m) {
        return ResponseData.success(this.service.customList(m));
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u4fe1\u606f")
    public ResponseData<M> getById(@PathVariable Integer id) {
        return ResponseData.success((BaseModel)this.service.getById((Serializable)id));
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f")
    public ResponseData<IPage<M>> page(@ModelParam(value=ModelParamType.PAGE) PageRequest<M> pageRequest) {
        Page page = new Page((long)pageRequest.getPageNum().intValue(), (long)pageRequest.getPageSize().intValue());
        BaseModel m = (BaseModel)pageRequest.getParams();
        QueryWrapper queryWrapper = new QueryWrapper((Object)m);
        this.setOrder(m, queryWrapper);
        IPage rtn = this.service.page((IPage)page, (Wrapper)queryWrapper);
        return ResponseData.success(rtn);
    }

    @GetMapping(value={"/page-plus"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u5206\u9875\u67e5\u8be2\u4fe1\u606f")
    public ResponseData<IPage<M>> pagePlus(@ModelParam(value=ModelParamType.PAGE) PageRequest<M> pageRequest) {
        IPage<M> rtn = this.service.customPage(pageRequest);
        return ResponseData.success(rtn);
    }

    @PostMapping
    @ApiOperation(value="\u65b0\u589e")
    public ResponseData<M> add(@RequestBody M m) {
        this.service.save(m);
        return ResponseData.success(m);
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539")
    public ResponseData<M> update(@RequestBody M m) {
        this.service.updateById(m);
        return ResponseData.success(m);
    }

    @PostMapping(value={"/batch"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e")
    public ResponseData<List<M>> addBatch(@RequestBody List<M> list) {
        this.service.saveBatch(list);
        return ResponseData.success(list);
    }

    @PutMapping(value={"/batch"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539")
    public ResponseData<List<M>> updateBatch(@RequestBody List<M> list) {
        this.service.updateBatchById(list);
        return ResponseData.success(list);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u4fe1\u606f")
    public ResponseData<Boolean> deleteById(@PathVariable Serializable id) {
        return ResponseData.success(this.service.removeById(id));
    }

    @DeleteMapping
    @ApiOperation(value="\u591a\u6761\u4ef6\u5220\u9664\u4fe1\u606f")
    public ResponseData<Boolean> deleteByModel(@ModelParam M m) {
        QueryWrapper queryWrapper = new QueryWrapper(m);
        return ResponseData.success(this.service.remove((Wrapper)queryWrapper));
    }

    @PostMapping(value={"/batch-plus"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u6279\u91cf\u65b0\u589e")
    public ResponseData<List<M>> insertBatch(@RequestBody List<M> list) {
        this.service.insertBatch(list);
        return ResponseData.success(list);
    }

    @DeleteMapping(value={"/batch"})
    @ApiOperation(value="\u6839\u636e\u591a\u4e2aid\u6279\u91cf\u5220\u9664")
    public ResponseData<Boolean> deleteByIds(@RequestParam String ids) {
        List list = Arrays.stream(ids.split(",")).mapToInt(s -> Integer.parseInt(s)).boxed().collect(Collectors.toList());
        return ResponseData.success(this.service.removeByIds(list));
    }

    private void setOrder(M m, QueryWrapper queryWrapper) {
        if (((BaseModel)m).getOrder() != null) {
            if ("asc".equals(((BaseModel)m).getOrderType())) {
                queryWrapper.orderByAsc((Object)((BaseModel)m).getOrder());
            } else {
                queryWrapper.orderByDesc((Object)((BaseModel)m).getOrder());
            }
        }
        queryWrapper.orderByDesc((Object)"create_time");
    }
}

