/*
 * Decompiled with CFR 0.152.
 */
package fun.imcoder.cloud.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import fun.imcoder.cloud.enums.ResponseEnum;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResponseData<T>
implements Serializable {
    private Integer code;
    private String message;
    private T data;

    public ResponseData() {
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public ResponseData(Integer code, String msg) {
        this.code = code;
        this.message = msg;
    }

    public ResponseData(Integer code, String msg, T data) {
        this.code = code;
        this.message = msg;
        this.data = data;
    }

    public ResponseData(ResponseEnum responseEnum) {
        this.code = responseEnum.getCode();
        this.message = responseEnum.getMessage();
    }

    public ResponseData(ResponseEnum responseEnum, T data) {
        this.code = responseEnum.getCode();
        this.message = responseEnum.getMessage();
        this.data = data;
    }

    public static ResponseData success() {
        return new ResponseData(ResponseEnum.SUCCESS);
    }

    public static <T> ResponseData<T> success(T data) {
        return new ResponseData<T>(ResponseEnum.SUCCESS, data);
    }

    public static <T> ResponseData<T> success(int code, String msg) {
        return new ResponseData<T>(code, msg);
    }

    public static ResponseData error(int code, String msg) {
        return new ResponseData(code, msg);
    }

    public static ResponseData error(ResponseEnum responseEnum, String msg) {
        return new ResponseData(responseEnum.getCode(), msg);
    }

    public static ResponseData error(ResponseEnum responseEnum) {
        return new ResponseData(responseEnum);
    }

    public static ResponseData error(ResponseEnum responseEnum, Object data) {
        return new ResponseData<Object>(responseEnum, data);
    }

    public static ResponseData error(BindingResult result, MessageSource messageSource) {
        StringBuffer msg = new StringBuffer();
        List fieldErrors = result.getFieldErrors();
        Locale currentLocale = LocaleContextHolder.getLocale();
        for (FieldError fieldError : fieldErrors) {
            String errorMessage = messageSource.getMessage((MessageSourceResolvable)fieldError, currentLocale);
            msg.append(fieldError.getField() + "\uff1a" + errorMessage + " , ");
        }
        return ResponseData.error(ResponseEnum.INCORRECT_PARAMS, msg.toString());
    }
}

