/*
 * Decompiled with CFR 0.152.
 */
package fun.imcoder.cloud.controller;

import fun.imcoder.cloud.common.ResponseData;
import fun.imcoder.cloud.model.ImcoderFile;
import fun.imcoder.cloud.utils.FileUtils;
import java.io.IOException;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/file"})
public class FileController {
    @GetMapping(value={"/directory"})
    private ResponseData<List<ImcoderFile>> directory(@RequestParam String path) throws IOException {
        return ResponseData.success(FileUtils.getFiles(path));
    }

    @GetMapping(value={"/content"})
    private ResponseData<String> content(@RequestParam String path) throws Exception {
        return ResponseData.success(FileUtils.getFileContent(path));
    }

    @PostMapping(value={"/directory/create"})
    private ResponseData createDirectory(@RequestBody ImcoderFile file) {
        return ResponseData.success(FileUtils.mkdir(file.getPath()));
    }

    @PostMapping(value={"/create"})
    private ResponseData createFile(@RequestBody ImcoderFile file) {
        return ResponseData.success(FileUtils.newFile(file.getPath()));
    }

    @PutMapping(value={"/write"})
    private ResponseData writeFile(@RequestBody ImcoderFile file) {
        return ResponseData.success(FileUtils.writeFile(file.getPath(), file.getContent()));
    }

    @DeleteMapping(value={"/delete"})
    private ResponseData delete(@RequestBody ImcoderFile file) {
        return ResponseData.success(FileUtils.deleteFile(file.getPath()));
    }
}

