/*
 * Decompiled with CFR 0.152.
 */
package fun.imcoder.cloud.utils;

import fun.imcoder.cloud.model.ImcoderFile;
import fun.imcoder.cloud.utils.PathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtils {
    public static final String[] IMG_FILE = new String[]{"bmp", "jpg", "png", "tif", "gif", "jpeg"};
    public static final String[] DOC_FILE = new String[]{"doc", "docx", "txt", "hlp", "wps", "rtf", "html", "pdf"};
    public static final String[] VIDEO_FILE = new String[]{"avi", "mp4", "mpg", "mov", "swf"};
    public static final String[] MUSIC_FILE = new String[]{"wav", "aif", "au", "mp3", "ram", "wma", "mmf", "amr", "aac", "flac"};
    public static final int IMAGE_TYPE = 1;
    public static final int DOC_TYPE = 2;
    public static final int VIDEO_TYPE = 3;
    public static final int MUSIC_TYPE = 4;

    public static List<String> getFileExtendsByType(int fileType) {
        List<String> fileExtends;
        switch (fileType) {
            case 1: {
                fileExtends = Arrays.asList(IMG_FILE);
                break;
            }
            case 2: {
                fileExtends = Arrays.asList(DOC_FILE);
                break;
            }
            case 3: {
                fileExtends = Arrays.asList(VIDEO_FILE);
                break;
            }
            case 4: {
                fileExtends = Arrays.asList(MUSIC_FILE);
                break;
            }
            default: {
                fileExtends = new ArrayList<String>();
            }
        }
        return fileExtends;
    }

    public static boolean isImageFile(String extendName) {
        for (int i = 0; i < IMG_FILE.length; ++i) {
            if (!extendName.equalsIgnoreCase(IMG_FILE[i])) continue;
            return true;
        }
        return false;
    }

    public static String pathSplitFormat(String filePath) {
        String path = filePath.replace("///", "/").replace("//", "/").replace("\\\\\\", "\\").replace("\\\\", "\\");
        return path;
    }

    public static String getFileType(String fileName) {
        if (fileName.lastIndexOf(".") == -1) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static String getFileNameNotExtend(String fileName) {
        String fileType = FileUtils.getFileType(fileName);
        return fileName.replace("." + fileType, "");
    }

    public static String getFileContent(String path) throws Exception {
        return FileUtils.getFileContent(Paths.get(path, new String[0]));
    }

    public static String getFileContent(Path path) throws Exception {
        byte[] data = Files.readAllBytes(path);
        String content = new String(data, StandardCharsets.UTF_8);
        return content;
    }

    public static boolean writeFile(String path, String content) {
        try {
            Files.write(Paths.get(path, new String[0]), content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static List<ImcoderFile> getFiles(String path) throws IOException {
        return FileUtils.getFiles(Paths.get(path, new String[0]));
    }

    public static List<ImcoderFile> getFiles(Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return null;
        }
        Stream<Path> pathStream = Files.list(path);
        LinkedList<ImcoderFile> files = new LinkedList<ImcoderFile>();
        pathStream.forEach(p -> {
            ImcoderFile file = new ImcoderFile();
            file.setName(p.getFileName().toString());
            file.setPath(p.toString());
            file.setIsFile(Files.isRegularFile(p, new LinkOption[0]));
            if (Files.isDirectory(p, new LinkOption[0])) {
                try {
                    file.setNode(FileUtils.getFiles(p));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            files.add(file);
        });
        files.sort(new ImcoderFile());
        return files;
    }

    public static File newFile(String fileUrl) {
        File file = new File(fileUrl);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static boolean deleteFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        for (File newFile : file.listFiles()) {
            FileUtils.deleteFile(newFile);
        }
        return file.delete();
    }

    public static boolean deleteFile(String fileUrl) {
        File file = FileUtils.newFile(fileUrl);
        return FileUtils.deleteFile(file);
    }

    public static boolean remove(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        Arrays.asList(file.listFiles()).forEach(FileUtils::remove);
        return file.delete();
    }

    public static long getFileSize(String fileUrl) {
        File file = FileUtils.newFile(fileUrl);
        if (file.exists()) {
            return file.length();
        }
        return 0L;
    }

    public static long getFileSize(File file) {
        if (file == null) {
            return 0L;
        }
        return file.length();
    }

    public static boolean mkdir(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    public static boolean mkdir(String fileUrl) {
        if (fileUrl == null) {
            return false;
        }
        File file = FileUtils.newFile(fileUrl);
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(FileInputStream fileInputStream, FileOutputStream fileOutputStream) throws IOException {
        try {
            byte[] buf = new byte[4096];
            int len = fileInputStream.read(buf);
            while (len != -1) {
                fileOutputStream.write(buf, 0, len);
                len = fileInputStream.read(buf);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        FileUtils.copyFile(in, out);
    }

    public static void copyFile(String srcUrl, String destUrl) throws IOException {
        if (srcUrl == null || destUrl == null) {
            return;
        }
        File srcFile = FileUtils.newFile(srcUrl);
        File descFile = FileUtils.newFile(destUrl);
        FileUtils.copyFile(srcFile, descFile);
    }

    public static List<String> unzip(File file, String destDirPath) {
        ZipFile zipFile = null;
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> fileEntryNameList = new ArrayList<String>();
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                String[] nameStrArr = entry.getName().split("/");
                String nameStr = "/";
                for (int i = 0; i < nameStrArr.length; ++i) {
                    if ("".equals(nameStrArr[i])) continue;
                    nameStr = nameStr + "/" + nameStrArr[i];
                    set.add(nameStr);
                }
                String zipPath = "/" + entry.getName();
                fileEntryNameList.add(zipPath);
                if (entry.isDirectory()) {
                    String dirPath = destDirPath + File.separator + entry.getName();
                    File dir = FileUtils.newFile(dirPath);
                    dir.mkdir();
                    continue;
                }
                File targetFile = new File(destDirPath + "/" + entry.getName());
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                targetFile.createNewFile();
                InputStream is = zipFile.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(targetFile);
                byte[] buf = new byte[2048];
                while ((len = is.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
                fos.close();
                is.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("unzip error from ZipUtils", e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<String> res = new ArrayList<String>(set);
        return res;
    }

    public static long deleteFileFromDisk(String fileurl) {
        String fileUrl = PathUtils.getStaticPath() + fileurl;
        String extendName = FileUtils.getFileType(fileUrl);
        String minFileUrl = fileUrl.replace("." + extendName, "_min." + extendName);
        long fileSize = FileUtils.getFileSize(fileUrl);
        FileUtils.deleteFile(fileUrl);
        FileUtils.deleteFile(minFileUrl);
        return fileSize;
    }
}

