/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.gui;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import guru.nidi.codeassert.model.CodeClass;
import guru.nidi.codeassert.model.CodePackage;
import java.io.IOException;
import java.util.Map;

public class CodeClassSerializer
extends StdSerializer<CodeClass> {
    protected CodeClassSerializer(Class<CodeClass> t) {
        super(t);
    }

    public void serialize(CodeClass value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("name", value.getName());
        gen.writeStringField("package", value.getPackage().getName());
        gen.writeNumberField("size", value.getTotalSize());
        gen.writeArrayFieldStart("usePackages");
        for (CodePackage codePackage : value.usedPackages()) {
            gen.writeString(codePackage.getName());
        }
        gen.writeEndArray();
        gen.writeObjectFieldStart("useClasses");
        for (Map.Entry entry : value.usedClassCounts().entrySet()) {
            gen.writeNumberField(((CodeClass)entry.getKey()).getName(), ((Integer)entry.getValue()).intValue());
        }
        gen.writeEndObject();
        gen.writeEndObject();
    }
}

