/**
 * WebSocket的客户端插件
 *
 * @author wangliang181230
 */
(function(wsc){if(wsc)return;if(typeof String.prototype.startsWith!=="function"){String.prototype.startsWith=function(prefix){return this.slice(0,prefix.length)===prefix}}window.wscUtils={printArgs:function(funName,args){console.debug("%s————————————————————————————————————————",funName);console.debug(args)},toJson:function(jsonStr,callback){if(typeof callback!=="function"){callback=function(json){return json}}if(!jsonStr){return callback("")}else if(typeof jsonStr==="object"){if(jsonStr.toString()==="[object Blob]"){let reader=new FileReader();reader.onload=function(event){jsonStr=reader.result;wscUtils.toJson(jsonStr,callback)};reader.readAsText(jsonStr,'UTF-8');return jsonStr}else{return callback(jsonStr)}}if(typeof jsonStr!=="string"){return callback(jsonStr)}if(window["jQuery"]&&jQuery.parseJSON){try{return callback(jQuery.parseJSON(jsonStr))}catch(e){}}if(window["JSON"]&&JSON.parse){try{return callback(JSON.parse(jsonStr))}catch(e){}}try{let json=null;eval('json = '+jsonStr);return callback(json)}catch(e){console.error("json字符串转换为json对象失败，该json串为：%s\r\n错误信息：",jsonStr);console.error(e);throw e;}},intRandom:function(i){return Math.floor(i*Math.random())},uuidRandom:function(){return'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g,function(c){let r=Math.random()*16|0,v=c==='x'?r:(r&0x3|0x8);return v.toString(16)})},extend:function(target,source){for(let key in source){if(source[key]!=null){target[key]=source[key]}}return target},isWSRouterUrl:function(url){if(!url)return false;return url.startsWith("http://")||url.startsWith("https://")},isWSUrl:function(url){if(!url)return false;return url.startsWith("ws://")||url.startsWith("wss://")},send:function(routerUrl,requestType,onSuccess,onError){if(!window["$"]&&!window["jQuery"]){wscUtils.alert("WebSocketClient：通过WebSocket路由服务获取闲置服务地址，需使用jQuery.ajax()方法，请先引用jQuery.js");return this}(window["jQuery"]||window["$"]).ajax({url:routerUrl,type:requestType,crossDomain:true,xhrFields:{withCredentials:true},success:function(json){onSuccess(json)},error:function(){onError(arguments)}})},getWSUrlFromJson:function(json){let url;if(typeof json==="string"){if(wscUtils.isWSUrl(json))url=json}else{if(wscUtils.isWSUrl(json["url"]))url=json.url}return url},alert:function(msg){alert(msg)}};function WebSocketClient(options){if(!('WebSocket'in window)){wscUtils.alert('当前浏览器不支持WebSocket');return this}if(!options){wscUtils.alert("创建WebSocketClient对象时，参数不能为空");return}if(typeof options=="string"){options={url:options}}if(!options.url){wscUtils.alert("创建WebSocketClient对象时，url不能为空");return}this.url=options.url;if(options.routerMethodType)this.routerMethodType=options.routerMethodType;if(options.spareWSUrl){this.spareWSUrl=options.spareWSUrl;if(!this.url){this.url=this.getSpareWSUrl()}}if(typeof options.onopen==="function")this.onopen=options.onopen;if(typeof options.onmessage==="function")this.onmessage=options.onmessage;if(typeof options.onclose==="function")this.onclose=options.onclose;if(typeof options.onerror==="function")this.onerror=options.onerror;if(wscUtils.isWSUrl(this.url)){this.urlType="WS"}else if(wscUtils.isWSRouterUrl(this.url)){this.urlType="WSR"}else{wscUtils.alert("WebSocket服务地址格式有误："+this.url);return}if(options.autoConnect===true){this.connect()}}wscUtils.extend(WebSocketClient.prototype,{url:"",urlType:"",routerMethodType:"GET",spareWSUrl:"",getSpareWSUrl:function(){if(this.spareWSUrl){if(typeof this.spareWSUrl==="string"){return this.spareWSUrl}else if(typeof this.spareWSUrl==="object"&&this.spareWSUrl.length>0){if(this.spareWSUrl.length===1){return this.spareWSUrl[0]}else{this.spareWSUrl[wscUtils.intRandom(this.spareWSUrl.length)]}}}return null},onopen:null,onmessage:null,onclose:null,onerror:null,ws:null,status:"none",lastError:null,connectTime:null,connectSuccessTime:null,subscribeMap:{},delayFuns:[],connect:function(){if(this.status==="connected"||this.status==="connecting"){return this}else{this.clear("connecting")}console.info("开始创建WebSocket连接");this.connectTime=new Date();if(this.urlType==="WS"){this.buildWebSocketConnect(this.url)}else{this.getIdleWebSocketThenConnect()}return this},getIdleWebSocketThenConnect:function(){let self=this;wscUtils.send(this.url,this.routerMethodType,function(json){let url=wscUtils.getWSUrlFromJson(json);if(!url){console.error("未获取到WebSocket服务地址，请求路由服务的响应内容如下：");console.error(json);url=this.getSpareWSUrl();if(!url){console.error("通过路由服务未获取到WebSocket服务地址，也未配置备用服务地址，无法进行WebSocket连接");return}else{console.warn("通过备用的WebSocket服务地址连接")}}self.buildWebSocketConnect(url)},function(){let spareWSUrl=self.getSpareWSUrl();if(spareWSUrl){self.buildWebSocketConnect(spareWSUrl)}else{console.error("调用路由服务获取WebSocket服务地址失败，也未配置备用服务地址，无法进行WebSocket连接，错误信息如下：");console.error(arguments)}})},buildWebSocketConnect:function(wsUrl){let websocket=new WebSocket(wsUrl);this.ws=websocket;let self=this;websocket.onopen=function(open){wscUtils.printArgs("onopen",arguments);self.onOpen(open)};websocket.onmessage=function(event){wscUtils.printArgs("onmessage",arguments);self.onMessage(event)};websocket.onclose=function(close){wscUtils.printArgs("onclose",arguments);self.onClose(close)};websocket.onerror=function(error){wscUtils.printArgs("onerror",arguments);self.onError(error)};return this},changeStatus:function(status){this.status=status;return this},addDelayFuns:function(delayFun,autoConnect){if(typeof delayFun==="function"){if(this.status==="connected"){delayFun()}else{this.delayFuns[this.delayFuns.length]=delayFun;if(this.status!=="connecting"&&autoConnect===true){this.connect()}}}return this},runDelayFuns:function(){for(let i=0;i<this.delayFuns.length;i++){try{this.delayFuns[i]()}catch(e){console.error("执行第%d个延迟方法失败",i);console.error(e)}}this.delayFuns=[]},close:function(){this.clear("closed")},clear:function(status){if(this.ws!=null){try{this.ws.close()}catch(e){}}this.ws=null;if(status){this.changeStatus(status)}this.subscribeMap={};if(status!=="connecting"){this.delayFuns=[]}},subscribe:function(channel,id,listener){if(!channel){wscUtils.alert("channel参数不能为空");return this}if(typeof channel!=="string"){wscUtils.alert("channel参数必须是字符串");return this}if(typeof id==="function"){listener=id;id=null}else if(!listener){wscUtils.alert("receiveMsgFun参数不能为空");return this}if(this.status!=="connected"){let self=this;this.addDelayFuns(function(){self.subscribe(channel,id,listener)},true);return this}if(id){if(typeof id!=="string")id=id+""}else{id="*"}let subscribeInfo=this.getSubscribeByChannelAndId(channel,id);if(subscribeInfo){console.debug("已经订阅，不可重复订阅");return}subscribeInfo=this.addSubscribe(channel,id,listener);this.send({type:"subscribe",key:subscribeInfo.key,channel:channel,id:id});console.debug("发送订阅请求：key=%s, channel=%s, id=%s, listener=%s",subscribeInfo.key,channel,id,listener);return this},unsubscribe:function(channel,id){if(!channel){wscUtils.alert("channel参数不能为空");return this}if(typeof channel!=="string"){wscUtils.alert("channel参数必须是字符串");return this}if(this.status!=="connected"){if(this.status==="connecting"){let self=this;this.addDelayFuns(function(){self.unsubscribe(channel,id)})}return this}if(id){if(typeof id!=="string")id=id+""}else{id="*"}let subscribeInfo=this.getSubscribeByChannelAndId(channel,id);if(!subscribeInfo){console.debug("订阅信息不存在，无法发起取消请求");return this}this.send({type:"unsubscribe",key:subscribeInfo.key,channel:channel,id:id});this.removeSubscribe(subscribeInfo.key);console.debug("发送取消订阅请求：key=%s, channel=%s, id=%s",subscribeInfo.key,channel,id);return this},getListenerByChannelAndId:function(channel,id){let subscribeInfo=this.getSubscribeByChannelAndId(channel,id);return subscribeInfo?subscribeInfo.listener:null},getListener:function(key){let subscribeInfo=this.getSubscribe(key);return subscribeInfo?subscribeInfo.listener:null},runListener:function(json,event){let listener=this.getListener(json.key);if(listener){this.runOneListener(listener,json,event)}else{console.warn("监听方法不存在，接收到的数据为：%s",JSON.stringify(json))}return this},runOneListener:function(listenerFun,json,event){try{listenerFun(json,event)}catch(e){console.error("执行监听方法失败，接收到的数据为：%s\r\n错误信息：",JSON.stringify(json));console.error(e)}return this},addSubscribe:function(channel,id,listener){let subscribeInfo={key:wscUtils.uuidRandom(),channel:channel,id:id,listener:listener};while(this.subscribeMap[subscribeInfo.key]){console.debug("出现了重复的uuid："+subscribeInfo.key);subscribeInfo.key=wscUtils.uuidRandom()}this.subscribeMap[subscribeInfo.key]=subscribeInfo;return subscribeInfo},getSubscribeByChannelAndId:function(channel,id){if(id){if(typeof id!=="string")id=id+""}else{id="*"}let subscribeInfo;for(let key in this.subscribeMap){subscribeInfo=this.subscribeMap[key];if(subscribeInfo.channel===channel&&subscribeInfo.id===id){return subscribeInfo}}return null},getSubscribe:function(key){return this.subscribeMap[key]},removeSubscribeByChannelAndId:function(channel,id){let subscribeInfo=this.getSubscribeByChannelAndId(channel,id);if(subscribeInfo){this.removeSubscribe(subscribeInfo.key)}return subscribeInfo},removeSubscribe:function(key){try{delete this.subscribeMap[key]}catch(e){this.subscribeMap[key]=null}},onOpen:function(open){this.connectSuccessTime=new Date();console.info("创建WebSocket连接成功，耗时：%dms",(this.connectSuccessTime.getTime()-this.connectTime.getTime()));this.changeStatus("connected");if(typeof this.onopen=="function"){try{this.onopen(open)}catch(e){console.error("执行自定义的this.onopen()方法失败");console.error(e)}}this.runDelayFuns();return this},onMessage:function(event){if(typeof this.onmessage=="function"){try{this.onmessage(event)}catch(e){console.error("执行自定义的this.onmessage()方法失败");console.error(e)}}if(event&&event.data){let self=this;wscUtils.toJson(event.data,function(json){if(typeof json==="object"&&json.key){self.runListener(json,event)}})}return this},onClose:function(close){if(typeof this.onclose=="function"){try{this.onclose(close)}catch(e){console.error(e)}}let status=this.status==="error"?"":"closed";if(this.ws){this.clear(status)}else{if(this.status!=="error"){this.changeStatus(status)}}console.info("WebSocket连接已关闭");console.info(close);return this},onError:function(error){if(typeof this.onerror=="function"){try{this.onerror(error)}catch(e){console.error(e)}}this.changeStatus("error");this.clear();this.lastError=error;console.error("WebSocket连接出错了");console.error(error);return this},send:function(msg){if(!msg){wscUtils.alert("消息不能为空");return this}if(!msg.key){wscUtils.alert("消息的key不能为空");return this}if(!msg.type){wscUtils.alert("消息的类型不能为空");return this}if(this.ws==null){wscUtils.alert("WebSocket还未连接，无法发送消息");return this}if(typeof msg!="string"){msg=JSON.stringify(msg)}this.ws.send(msg);return this}});window.WebSocketClient=WebSocketClient})(window['WebSocketClient']);