/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.data;

import im.dart.boot.common.utils.Checker;
import im.dart.boot.common.utils.JsonUtil;
import im.dart.boot.common.utils.ReflectUtil;
import im.dart.boot.common.utils.Runner;
import im.dart.boot.common.utils.SerializeUtil;
import im.dart.boot.common.utils.XmlUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;

public class Base
implements Serializable {
    private static final long serialVersionUID = 1L;

    public String toJson() {
        return JsonUtil.safeToJson(this);
    }

    public String toXml() {
        return XmlUtil.toXml(this);
    }

    public byte[] toBytes() {
        return SerializeUtil.obj2Bit(this);
    }

    public Base clone() {
        return (Base)JsonUtil.safeToObj(this.toJson(), this.getClass());
    }

    public <T> T cloneSelf() {
        return (T)JsonUtil.safeToObj(this.toJson(), this.getClass());
    }

    public String toString() {
        return this.toJson();
    }

    public static <T extends Base> T from(byte[] bytes, Class<T> clazz) {
        return (T)((Base)SerializeUtil.bit2Obj(bytes, clazz));
    }

    public static <T extends Base> T from(String json, Class<T> clazz) {
        return (T)((Base)JsonUtil.safeToObj(json, clazz));
    }

    public static <T extends Base> T from(Class<T> clazz, String xml) {
        return (T)((Base)XmlUtil.toObj(xml, clazz));
    }

    public void fuse(Base target) {
        if (target == null) {
            return;
        }
        if (this.getClass() != target.getClass()) {
            return;
        }
        List<Field> fields = ReflectUtil.fetchFields(this.getClass());
        for (Field field : fields) {
            Runner.safeRun(() -> {
                Object value = ReflectUtil.fetchValue(target, field);
                if (Checker.isEmptyString(value)) {
                    return;
                }
                ReflectUtil.setFieldValue(this, field, value);
            });
        }
    }
}

