/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.data;

import im.dart.boot.common.data.Base;
import im.dart.boot.common.utils.Checker;
import java.util.Calendar;

public class IdCardData
extends Base {
    private int year;
    private int month;
    private int day;
    private String birthday;
    private int age;
    private String area;
    private String gender;

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public static IdCardData of(String idCard) {
        int day;
        int month;
        boolean valid = Checker.validIdCard(idCard);
        if (!valid) {
            return null;
        }
        int year = Integer.parseInt(idCard.substring(6, 10));
        int age = IdCardData.calcAge(year, month = Integer.parseInt(idCard.substring(10, 12)), day = Integer.parseInt(idCard.substring(12, 14)));
        if (age < 0) {
            return null;
        }
        String birthday = idCard.substring(6, 14);
        String gender = idCard.substring(16, 17);
        gender = Integer.parseInt(gender) % 2 != 0 ? "M" : "F";
        String area = idCard.substring(0, 6);
        IdCardData data = new IdCardData();
        data.setBirthday(birthday);
        data.setYear(year);
        data.setMonth(month);
        data.setDay(day);
        data.setGender(gender);
        data.setArea(area);
        data.setAge(age);
        return data;
    }

    private static int calcAge(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        int cYear = c.get(1);
        int cMonth = c.get(2) + 1;
        int cDay = c.get(5);
        if (year > cYear) {
            return -1;
        }
        int age = cYear - year;
        if (cMonth < month) {
            return age - 1;
        }
        if (cMonth == month && cDay < day) {
            return age - 1;
        }
        return age;
    }
}

