/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.data;

import im.dart.boot.common.data.Base;
import im.dart.boot.common.utils.Checker;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;

public class Page
extends Base {

    public static class Result<T extends Base>
    extends PageData {
        private Long total = 0L;
        private List<T> contents;

        public static <T extends Base> Result<T> of(List<T> contents, long total, Request<T> request) {
            return Result.of(contents, total, request.getPage(), request.getSize(), request.getSorts());
        }

        public static <T extends Base> Result<T> of(List<T> contents, long total, int page, int size, LinkedHashSet<Sort> sorts) {
            Result<T> result = new Result<T>();
            result.setPage(page);
            result.setSize(size);
            result.setTotal(total);
            result.setSorts(sorts);
            result.setContents(contents);
            return result;
        }

        public Long getTotal() {
            return this.total;
        }

        public void setTotal(Long total) {
            this.total = total;
        }

        public List<T> getContents() {
            return this.contents;
        }

        public void setContents(List<T> contents) {
            this.contents = contents;
        }
    }

    public static class Request<T extends Base>
    extends PageData {
        private T param;
        private Long start;
        private Long end;

        public T getParam() {
            return this.param;
        }

        public void setParam(T param) {
            this.param = param;
        }

        public Long getStart() {
            return this.start;
        }

        public void setStart(Long start) {
            this.start = start;
        }

        public Long getEnd() {
            return this.end;
        }

        public void setEnd(Long end) {
            this.end = end;
        }
    }

    public static class PageData
    extends Base {
        private Integer size = 10;
        private Integer page = 0;
        private LinkedHashSet<Sort> sorts;

        public Integer getSize() {
            if (Checker.isEmpty(this.size)) {
                return 10;
            }
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getPage() {
            if (Checker.isEmpty(this.page)) {
                return 0;
            }
            return this.page;
        }

        public void setPage(Integer page) {
            this.page = page;
        }

        public LinkedHashSet<Sort> getSorts() {
            return this.sorts;
        }

        public void setSorts(LinkedHashSet<Sort> sorts) {
            this.sorts = sorts;
        }

        public void forEachSort(Consumer<Sort> consumer) {
            if (Checker.isEmpty(this.sorts)) {
                return;
            }
            for (Sort sort : this.sorts) {
                if (Checker.isEmpty(sort.getFiled())) continue;
                consumer.accept(sort);
            }
        }
    }

    public static class Sort
    extends Base {
        private boolean asc;
        private String filed;

        private Sort(String filed, boolean asc) {
            this.asc = asc;
            this.filed = filed;
        }

        public boolean isAsc() {
            return this.asc;
        }

        public String getFiled() {
            return this.filed;
        }

        public static Sort of(String filed, boolean asc) {
            return new Sort(filed, asc);
        }
    }
}

