/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.data;

import im.dart.boot.common.constant.DartCode;
import im.dart.boot.common.data.Base;
import im.dart.boot.common.data.Code;

public class Result<T>
extends Base {
    private Code code;
    private T data;

    public Result() {
    }

    public Result(T data) {
        this.data = data;
    }

    public Result(Code code, T data) {
        this.code = code;
        this.data = data;
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static Result of(Code code) {
        return new Result<Object>(code, null);
    }

    public static <T> Result<T> of(T data) {
        return new Result<T>(DartCode.SUCCESS, data);
    }

    public static <T> Result<T> of(Code code, T data) {
        return new Result<T>(code, data);
    }

    public static Result SUCCESS() {
        return Result.of(DartCode.SUCCESS);
    }

    public static Result ERROR() {
        return Result.of(DartCode.SERVER_ERROR);
    }
}

