/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.match.constant;

public class GaussianConstants {
    public static final double[][] Gauss25 = new double[][]{{0.02546481, 0.02350698, 0.01849125, 0.01239505, 0.00708017, 0.00344629, 0.00142946}, {0.02350698, 0.02169968, 0.01706957, 0.01144208, 0.00653582, 0.00318132, 0.00131956}, {0.01849125, 0.01706957, 0.0134274, 0.00900066, 0.00514126, 0.00250252, 0.001038}, {0.01239505, 0.01144208, 0.00900066, 0.00603332, 0.00344629, 0.00167749, 6.9579E-4}, {0.00708017, 0.00653582, 0.00514126, 0.00344629, 0.00196855, 9.582E-4, 3.9744E-4}, {0.00344629, 0.00318132, 0.00250252, 0.00167749, 9.582E-4, 4.664E-4, 1.9346E-4}, {0.00142946, 0.00131956, 0.001038, 6.9579E-4, 3.9744E-4, 1.9346E-4, 8.024E-5}};

    public static double[][] getGaussianDistribution(int sampleCount, float range, float sigma) {
        double[][] distribution = new double[sampleCount][sampleCount];
        double sigmaSquared = Math.pow(sigma, 2.0);
        double inverseTwoPiSigmaSquared = 1.0 / (Math.PI * 2 * sigmaSquared);
        for (int i = 0; i < sampleCount; ++i) {
            for (int j = 0; j < sampleCount; ++j) {
                double x = range / (float)(sampleCount - 1) * (float)i;
                double y = range / (float)(sampleCount - 1) * (float)j;
                double power = Math.pow(x, 2.0) / (2.0 * sigmaSquared) + Math.pow(y, 2.0) / (2.0 * sigmaSquared);
                distribution[i][j] = inverseTwoPiSigmaSquared * Math.pow(Math.E, -1.0 * power);
            }
        }
        return distribution;
    }

    public static void main(String[] args) {
        double[][] dist;
        double[][] dArray = dist = GaussianConstants.getGaussianDistribution(7, 5.5f, 2.5f);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] row;
            for (double value : row = dArray[i]) {
                System.out.format("%.14f,", value);
            }
            System.out.println("");
        }
    }
}

