/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.match.sift;

import im.dart.boot.common.match.sift.ImagePixelArray;
import im.dart.boot.common.match.sift.scale.FeaturePoint;
import im.dart.boot.common.match.sift.scale.GaussianArray;
import im.dart.boot.common.match.sift.scale.KDFeaturePoint;
import im.dart.boot.common.match.sift.scale.OctaveSpace;
import im.dart.boot.common.match.sift.scale.Pyramid;
import im.dart.boot.common.match.sift.scale.ScalePeak;
import java.util.ArrayList;
import java.util.List;

public class SIFT {
    float preprocSigma = 1.5f;
    float octaveSigma = 1.6f;
    int minimumRequiredPixelsize = 32;
    int scaleSpaceLevels = 3;
    float dogThresh = 0.0075f;
    float dValueLowThresh = 0.008f;
    float maximumEdgeRatio = 20.0f;
    float scaleAdjustThresh = 0.5f;
    float peakRelThresh = 0.8f;
    int relocationMaximum = 4;
    private List<FeaturePoint> globalFeaturePoints;
    private List<KDFeaturePoint> globalKDFeaturePoints;

    public int detectFeatures(ImagePixelArray img) {
        return this.detectFeaturesDownscaled(img, -1, 1.0f);
    }

    public int detectFeaturesDownscaled(ImagePixelArray img, int preProcessMark, float startScale) {
        if (preProcessMark < 0) {
            img = img.doubled();
            startScale = (float)((double)startScale * 0.5);
        } else if (preProcessMark > 0) {
            while (img.width > preProcessMark || img.height > preProcessMark) {
                img = img.halved();
                startScale = (float)((double)startScale * 2.0);
            }
        }
        if ((double)this.preprocSigma > 0.0) {
            GaussianArray gaussianPre = new GaussianArray(this.preprocSigma);
            img = gaussianPre.convolve(img);
        }
        Pyramid pyr = new Pyramid();
        pyr.buildOctaves(img, startScale, this.scaleSpaceLevels, this.octaveSigma, this.minimumRequiredPixelsize);
        this.globalFeaturePoints = new ArrayList<FeaturePoint>();
        for (int on = 0; on < pyr.octaves.size(); ++on) {
            OctaveSpace osp = pyr.octaves.get(on);
            ArrayList<ScalePeak> peaks = osp.findPeaks(this.dogThresh);
            ArrayList<ScalePeak> peaksFilted = osp.filterAndLocalizePeaks(peaks, this.maximumEdgeRatio, this.dValueLowThresh, this.scaleAdjustThresh, this.relocationMaximum);
            osp.pretreatMagnitudeAndDirectionImgs();
            ArrayList<FeaturePoint> faturePoints = osp.makeFeaturePoints(peaksFilted, this.peakRelThresh, this.scaleSpaceLevels, this.octaveSigma);
            osp.clear();
            this.globalFeaturePoints.addAll(faturePoints);
        }
        return this.globalFeaturePoints.size();
    }

    public List<KDFeaturePoint> getGlobalKDFeaturePoints() {
        if (this.globalKDFeaturePoints != null) {
            return this.globalKDFeaturePoints;
        }
        if (this.globalFeaturePoints == null) {
            throw new IllegalArgumentException("No featurePoints generated yet.");
        }
        this.globalKDFeaturePoints = new ArrayList<KDFeaturePoint>();
        for (FeaturePoint fp : this.globalFeaturePoints) {
            this.globalKDFeaturePoints.add(new KDFeaturePoint(fp));
        }
        return this.globalKDFeaturePoints;
    }
}

