/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.match.sift.render;

import im.dart.boot.common.match.sift.IPixelConverter;
import im.dart.boot.common.match.sift.ImagePixelArray;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class RenderImage {
    private BufferedImage srcImage;

    public RenderImage(BufferedImage srcImage) {
        this.srcImage = srcImage;
    }

    public int getWidth() {
        return this.srcImage.getWidth();
    }

    public int getHeight() {
        return this.srcImage.getHeight();
    }

    public float scaleWithin(int dim) {
        float yScala;
        if (this.srcImage.getWidth() <= dim && this.srcImage.getHeight() <= dim) {
            return 1.0f;
        }
        float xScala = (float)dim / (float)this.srcImage.getWidth();
        float smallestScala = xScala <= (yScala = (float)dim / (float)this.srcImage.getHeight()) ? xScala : yScala;
        BufferedImage bmScalaed = new BufferedImage((int)((double)((float)this.srcImage.getWidth() * smallestScala) + 0.5), (int)((double)((float)this.srcImage.getHeight() * smallestScala) + 0.5), 2);
        Graphics2D g = bmScalaed.createGraphics();
        g.drawImage(this.srcImage, 0, 0, (int)((float)this.srcImage.getWidth() * smallestScala), (int)((float)this.srcImage.getHeight() * smallestScala), null);
        this.srcImage = bmScalaed;
        return smallestScala;
    }

    public ImagePixelArray toPixelFloatArray(IPixelConverter converter) {
        int h = this.srcImage.getHeight();
        int w = this.srcImage.getWidth();
        ImagePixelArray res = new ImagePixelArray(w, h);
        int[] pix = this.srcImage.getRGB(0, 0, w, h, null, 0, w);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int c = pix[x + y * w];
                int R = c >> 16 & 0xFF;
                int G = c >> 8 & 0xFF;
                int B = c >> 0 & 0xFF;
                res.data[x + y * w] = converter == null ? (float)(R + G + B) / 765.0f : converter.convert(R, G, B);
            }
        }
        return res;
    }
}

