/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.match.stereo;

import im.dart.boot.common.match.stereo.SSD;
import java.awt.image.BufferedImage;

public class ASW
extends SSD {
    private int[] LabTable = new int[1024];

    public ASW(BufferedImage leftImg, BufferedImage rightImg) {
        super(leftImg, rightImg);
        for (int i = 0; i < 1024; ++i) {
            this.LabTable[i] = i > 9 ? (int)(Math.pow((float)i / 1020.0f, 0.3333333432674408) * 1024.0 + 0.5) : (int)((841.0 * (double)i / 110160.0 + 0.13793103448275862) * 1024.0 + 0.5);
        }
    }

    @Override
    protected double getDist(int[] left, int[] right) {
        int len = left.length;
        double topSum = 0.0;
        double downSum = 0.0;
        for (int i = 0; i < len; ++i) {
            double swl = this.getAdaptiveSupportWeight(left, i);
            double swr = this.getAdaptiveSupportWeight(right, i);
            topSum += swl * swr * (double)this.getIntensityDistance(left[i], right[i]);
            downSum += swl * swr;
        }
        return topSum / downSum;
    }

    private double getAdaptiveSupportWeight(int[] window, int n) {
        int k = 100;
        double colorCost = this.getColorDistance(window, n);
        double disCost = this.getSpatialDistance(window, n);
        return 100.0 * Math.exp(-(colorCost + disCost));
    }

    private double getColorDistance(int[] window, int n) {
        int len = window.length;
        int yc = 45;
        int[] center = this.RGBToLab(window[len / 2]);
        int[] neighbor = this.RGBToLab(window[n]);
        double c = Math.sqrt((center[0] - neighbor[0]) * (center[0] - neighbor[0]) + (center[1] - neighbor[1]) * (center[1] - neighbor[1]) + (center[2] - neighbor[2]) * (center[2] - neighbor[2]));
        return c / 45.0;
    }

    private double getSpatialDistance(int[] window, int n) {
        int len = (int)Math.sqrt(window.length);
        int yp = 5;
        double dis = Math.sqrt((n / len - len / 2) * (n / len - len / 2) + (n % len - len / 2) * (n % len - len / 2));
        return dis / 5.0;
    }

    private int getIntensityDistance(int left, int right) {
        int r = ((left & 0xFF0000) >> 16) - ((right & 0xFF0000) >> 16);
        int g = ((left & 0xFF00) >> 8) - ((right & 0xFF00) >> 8);
        int b = (left & 0xFF) - (right & 0xFF);
        return (r > 0 ? r : -r) + (g > 0 ? g : -g) + (b > 0 ? b : -b);
    }

    private int[] RGBToLab(int pixel) {
        int big_shift = 18;
        int HalfShiftValue = 512;
        int shift = 10;
        int offset = 131072;
        int ScaleLC = 16384;
        int ScaleLT = 116;
        int ScaleY = 903;
        int para1 = 500;
        int para2 = 200;
        int ThPara = 9;
        int[] rgbImg = new int[]{(pixel & 0xFF0000) >> 16, (pixel & 0xFF00) >> 8, pixel & 0xFF};
        int[] labImg = new int[3];
        int X = rgbImg[0] * 199049 + rgbImg[1] * 394494 + rgbImg[2] * 455033 + 524288 >> 18;
        int Y = rgbImg[0] * 75675 + rgbImg[1] * 749900 + rgbImg[2] * 223002 + 524288 >> 18;
        int Z = rgbImg[0] * 915161 + rgbImg[1] * 114795 + rgbImg[2] * 18621 + 524288 >> 18;
        labImg[0] = Y > 9 ? 116 * this.LabTable[Y] - 16384 + 512 >> 10 : 903 * Y >> 10;
        labImg[1] = 500 * (this.LabTable[X] - this.LabTable[Y]) + 512 + 131072 >> 10;
        labImg[2] = 200 * (this.LabTable[Y] - this.LabTable[Z]) + 512 + 131072 >> 10;
        return labImg;
    }
}

