/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.match.stereo;

import im.dart.boot.common.match.stereo.SSD;
import java.awt.image.BufferedImage;

public class NCC
extends SSD {
    public NCC(BufferedImage leftImg, BufferedImage rightImg) {
        super(leftImg, rightImg);
    }

    @Override
    protected double getDist(int[] left, int[] right) {
        int len = left.length;
        double topSum = 0.0;
        double downLeftSum = 0.0;
        double downRightSum = 0.0;
        for (int i = 0; i < len; ++i) {
            double lefttemp = (double)((left[i] & 0xFF0000) >> 16) * 0.299 + (double)((left[i] & 0xFF00) >> 8) * 0.587 + (double)(left[i] & 0xFF) * 0.114;
            double righttemp = (double)((right[i] & 0xFF0000) >> 16) * 0.299 + (double)((right[i] & 0xFF00) >> 8) * 0.587 + (double)(right[i] & 0xFF) * 0.114;
            topSum += lefttemp * righttemp;
            downLeftSum += lefttemp * lefttemp;
            downRightSum += righttemp * righttemp;
        }
        double nc = topSum / Math.sqrt(downLeftSum * downRightSum);
        return 1.0 - nc;
    }
}

