/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.match.stereo;

import java.awt.image.BufferedImage;

public class SSD {
    private int[][] leftMatrix = null;
    private int[][] rightMatrix = null;
    private int width = 0;
    private int height = 0;
    private int MAX_DISPARITY = 79;
    private int VECTOR_SIZE = 5;

    public SSD(BufferedImage leftImg, BufferedImage rightImg) {
        this.width = leftImg.getWidth();
        this.height = leftImg.getHeight();
        int[] pixels = new int[this.width * this.height];
        leftImg.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        this.leftMatrix = SSD.changeDimension2(pixels, this.width);
        rightImg.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        this.rightMatrix = SSD.changeDimension2(pixels, this.width);
    }

    public BufferedImage getLeftDisparityMap() {
        return this.getDisparityMap(0);
    }

    public BufferedImage getRightDisparityMap() {
        return this.getDisparityMap(1);
    }

    private BufferedImage getDisparityMap(int flag) {
        int j;
        int i;
        int[][] disparityMatrix = new int[this.height][this.width];
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                disparityMatrix[j][i] = this.getMinDisparityValue(i, j, this.MAX_DISPARITY, flag, this.VECTOR_SIZE);
            }
        }
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                int singleChannel = disparityMatrix[j][i] * 3;
                disparityMatrix[j][i] = singleChannel << 16 | singleChannel << 8 | singleChannel | 0xFF000000;
            }
        }
        BufferedImage disparityMap = new BufferedImage(this.width, this.height, 5);
        disparityMap.setRGB(0, 0, this.width, this.height, SSD.changeDimension1(disparityMatrix), 0, this.width);
        return disparityMap;
    }

    private int getMinDisparityValue(int x, int y, int dmax, int flag, int n) {
        double disparityValue = 1000000.0;
        int d = 0;
        for (int i = 0; i <= dmax; ++i) {
            int[] leftVector = null;
            int[] rightVector = null;
            if (flag == 0) {
                leftVector = this.getFeatureVector(x, y, 0, n);
                rightVector = x - i >= 0 ? this.getFeatureVector(x - i, y, 1, n) : this.getFeatureVector(x, y, 1, n);
            } else {
                leftVector = x + i < this.width ? this.getFeatureVector(x + i, y, 0, n) : this.getFeatureVector(x, y, 0, n);
                rightVector = this.getFeatureVector(x, y, 1, n);
            }
            double disTemp = this.getDist(leftVector, rightVector);
            if (!(disTemp < disparityValue)) continue;
            disparityValue = disTemp;
            d = i;
        }
        return d;
    }

    private int[] getFeatureVector(int x, int y, int flag, int n) {
        int[] vector = new int[n * n];
        if (flag == 0) {
            int count = 0;
            for (int i = -(n / 2); i <= n / 2; ++i) {
                for (int j = -(n / 2); j <= n / 2; ++j) {
                    vector[count++] = x + i < this.width && x + i >= 0 && y + j < this.height && y + j >= 0 ? this.leftMatrix[y + j][x + i] : this.leftMatrix[y][x];
                }
            }
        } else {
            int count = 0;
            for (int i = -(n / 2); i <= n / 2; ++i) {
                for (int j = -(n / 2); j <= n / 2; ++j) {
                    vector[count++] = x + i < this.width && x + i >= 0 && y + j < this.height && y + j >= 0 ? this.rightMatrix[y + j][x + i] : this.rightMatrix[y][x];
                }
            }
        }
        return vector;
    }

    protected double getDist(int[] left, int[] right) {
        int len = left.length;
        int sum = 0;
        for (int i = 0; i < len; ++i) {
            double lefttemp = (double)((left[i] & 0xFF0000) >> 16) * 0.299 + (double)((left[i] & 0xFF00) >> 8) * 0.587 + (double)(left[i] & 0xFF) * 0.114;
            double righttemp = (double)((right[i] & 0xFF0000) >> 16) * 0.299 + (double)((right[i] & 0xFF00) >> 8) * 0.587 + (double)(right[i] & 0xFF) * 0.114;
            sum += (int)lefttemp - (int)righttemp > 0 ? (int)lefttemp - (int)righttemp : (int)righttemp - (int)lefttemp;
        }
        return sum;
    }

    public void setWindowSize(int n) {
        this.VECTOR_SIZE = n % 2 == 0 ? n + 1 : n;
    }

    public int getWindowSize() {
        return this.VECTOR_SIZE;
    }

    protected int[][] getLeftMatrix() {
        return this.leftMatrix;
    }

    protected int[][] getRightMatrix() {
        return this.rightMatrix;
    }

    protected int getWidth() {
        return this.width;
    }

    protected int getHeight() {
        return this.height;
    }

    private static int[][] changeDimension2(int[] oldArr, int width) {
        int[][] newArr = new int[oldArr.length / width][width];
        for (int i = 0; i < oldArr.length / width; ++i) {
            for (int y = 0; y < width; ++y) {
                newArr[i][y] = oldArr[i * width + y];
            }
        }
        return newArr;
    }

    private static int[] changeDimension1(int[][] oldArr) {
        int[] newArr = new int[oldArr.length * oldArr[0].length];
        for (int i = 0; i < oldArr.length; ++i) {
            for (int y = 0; y < oldArr[0].length; ++y) {
                newArr[i * oldArr[0].length + y] = oldArr[i][y];
            }
        }
        return newArr;
    }
}

