/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.queue;

import im.dart.boot.common.constant.DartCode;
import im.dart.boot.common.utils.Checker;
import im.dart.boot.common.utils.DateUtil;
import im.dart.boot.common.utils.Runner;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class DelayQueueExecutor {
    static Logger logger = Logger.getLogger(DelayQueueExecutor.class.getName());
    private static ConcurrentHashMap<Serializable, Consumer<Serializable>> queues = new ConcurrentHashMap();
    private static DelayQueue delayQueueKeys = new DelayQueue();

    public static void run(Serializable key, Consumer<Serializable> consumer, long millis) {
        if (Checker.isEmpty(key) || Checker.isEmpty(consumer)) {
            throw DartCode.PARAMETER_IS_EMPTY.exception();
        }
        if (millis <= 0L) {
            throw DartCode.PARAMETER_VALUE_RANGE_ERROR.exception();
        }
        delayQueueKeys.add(new DelayQueueKey(key, millis));
        queues.put(key, consumer);
    }

    public static void cancel(Serializable key) {
        queues.remove(key);
        logger.log(Level.INFO, "Cancel Delay Task : {0}", key);
    }

    private static void run() {
        Thread thread = new Thread(() -> {
            while (true) {
                Runner.safeRun(() -> {
                    DelayQueueKey delayQueueKey = (DelayQueueKey)delayQueueKeys.take();
                    if (Checker.isNotEmpty(delayQueueKey)) {
                        Serializable key = delayQueueKey.getKey();
                        Consumer<Serializable> consumer = queues.get(key);
                        if (Checker.isNotEmpty(consumer)) {
                            logger.log(Level.INFO, "Start Run Delay Task : {0}", key);
                            Runner.safeRun(consumer, key);
                        }
                    } else {
                        Thread.sleep(100L);
                    }
                });
            }
        });
        thread.setDaemon(true);
        thread.setName("DelayQueueExecutor-Thread");
        thread.start();
    }

    static {
        DelayQueueExecutor.run();
    }

    private static class DelayQueueKey
    implements Delayed {
        private final Serializable key;
        private final long start;
        private final long millis;

        DelayQueueKey(Serializable key, long millis) {
            this.key = key;
            this.start = DateUtil.currentTimeMillis();
            this.millis = millis;
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            return unit.convert(this.start + this.millis - DateUtil.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed delayed) {
            return (int)(this.getDelay(TimeUnit.MILLISECONDS) - delayed.getDelay(TimeUnit.MILLISECONDS));
        }

        public Serializable getKey() {
            return this.key;
        }
    }
}

