/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

public class ByteUtil {
    public static final byte BIT = 1;
    private static final int BIT_LEN_BYTE = 8;
    private static final int BYTE_LEN_SHORT = 2;
    private static final int BYTE_LEN_INT = 4;

    public static String toHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            Object hex = Integer.toHexString(bytes[i] & 0xFF);
            if (((String)hex).length() == 1) {
                hex = "0" + (String)hex;
            }
            sb.append((String)hex);
        }
        return sb.toString();
    }

    public static byte[] hexToBytes(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static byte setBitInfo(byte b, boolean value, int pos) {
        if (pos >= 8 || pos < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte tmp = (byte)(1 << pos);
        return (byte)(value ? b | tmp : b & ~tmp);
    }

    public static byte setTrue(byte b, int pos) {
        return ByteUtil.setBitInfo(b, true, pos);
    }

    public static byte setFalse(byte b, int pos) {
        return ByteUtil.setBitInfo(b, false, pos);
    }

    public static boolean check(byte b, int pos) {
        if (pos >= 8 || pos < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte tmp = (byte)(1 << pos);
        return (b & tmp) == tmp;
    }

    public static byte[] short2bytes(short num) {
        return new byte[]{(byte)(num >> 8), (byte)(num >> 0)};
    }

    public static short bytes2short(byte[] bytes) {
        if (bytes.length != 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (short)(bytes[0] << 8 | bytes[1] & 0xFF);
    }

    public static byte[] int2bytes(int num) {
        return new byte[]{(byte)(num >> 24 & 0xFF), (byte)(num >> 16 & 0xFF), (byte)(num >> 8 & 0xFF), (byte)(num & 0xFF)};
    }

    public static byte[] long2bytes(long num) {
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)(num & 0xFFL);
            num >>= 8;
        }
        return bytes;
    }

    public static int bytes2int(byte[] bytes) {
        if (bytes.length != 4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return bytes[3] & 0xFF | (bytes[2] & 0xFF) << 8 | (bytes[1] & 0xFF) << 16 | (bytes[0] & 0xFF) << 24;
    }

    public static byte[] xor(byte[] bytes, byte b) {
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = (byte)(bytes[i] ^ b);
        }
        return result;
    }

    public static byte[] fetch(byte[] source, int start, int length) {
        int end = start + length;
        if (end > source.length) {
            return null;
        }
        byte[] result = new byte[length];
        int idx = 0;
        for (int i = start; i < end; ++i) {
            result[idx] = source[i];
            ++idx;
        }
        return result;
    }

    public static byte[] merge(byte[] ... bytes) {
        if (bytes.length < 1) {
            return null;
        }
        if (bytes.length == 1) {
            return bytes[0];
        }
        int length = 0;
        for (byte[] bs : bytes) {
            length += bs.length;
        }
        int desPos = 0;
        byte[] result = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            byte[] source = bytes[i];
            System.arraycopy(source, 0, result, desPos += i == 0 ? 0 : bytes[i - 1].length, source.length);
        }
        return result;
    }
}

