/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import im.dart.boot.common.constant.DartCode;
import im.dart.boot.common.data.StateBase;
import im.dart.boot.common.utils.JsonUtil;
import im.dart.boot.common.utils.Runner;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Checker {
    private static final List<String> IMAGE_TYPES = Arrays.asList("bmp", "jpg", "png", "tif", "gif", "pcx", "tga", "exif", "fpx", "svg", "psd", "cdr", "pcd", "dxf", "ufo", "eps", "ai", "raw", "wmf", "webp");

    public static boolean isSuccess(StateBase obj) {
        return obj != null && obj.isSuccess();
    }

    public static void asserts(StateBase obj) {
        if (!Checker.isSuccess(obj)) {
            throw DartCode.PARAMETER_ERROR.exception(JsonUtil.safeToJson(obj));
        }
    }

    public static void asserts(boolean result) {
        if (!result) {
            throw DartCode.PARAMETER_ERROR.exception();
        }
    }

    public static void asserts(Runner.FunctionWithAssert func) {
        if (func == null) {
            throw DartCode.PARAMETER_ERROR.exception();
        }
        if (!func.check()) {
            throw DartCode.PARAMETER_ERROR.exception();
        }
    }

    public static boolean isImage(String type) {
        if (Checker.isEmpty(type)) {
            return false;
        }
        if (type.startsWith(".")) {
            type = type.substring(1);
        }
        type = type.trim().toLowerCase();
        return IMAGE_TYPES.contains(type);
    }

    public static boolean range(BigDecimal source, BigDecimal max, BigDecimal min) {
        if (source == null || max == null || min == null) {
            return false;
        }
        return max.compareTo(source) == 1 && source.compareTo(min) == 1;
    }

    public static boolean gt(BigDecimal one, BigDecimal two) {
        if (one == null) {
            return false;
        }
        if (two == null) {
            return true;
        }
        return one.compareTo(two) == 1;
    }

    public static boolean gte(BigDecimal one, BigDecimal two) {
        if (one == null) {
            return false;
        }
        if (two == null) {
            return true;
        }
        return one.compareTo(two) >= 0;
    }

    public static boolean validIdCard(String idCard) {
        if (idCard == null) {
            return false;
        }
        if (idCard.length() != 18) {
            return false;
        }
        char[] id = idCard.toCharArray();
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            sum += (1 << 17 - i) % 11 * (id[i] - 48);
        }
        int n = (12 - sum % 11) % 11;
        if (n < 10) {
            return n == id[17] - 48;
        }
        return id[17] == 'X';
    }

    public static boolean isEmptyString(Object obj) {
        if (Checker.isEmpty(obj)) {
            return true;
        }
        if (Checker.isBaseType(obj)) {
            return Checker.isEmpty(String.valueOf(obj));
        }
        return Checker.isEmpty(JsonUtil.safeToJson(obj));
    }

    public static boolean isAllEmpty(String ... strs) {
        if (strs == null || strs.length == 0) {
            return true;
        }
        for (String str : strs) {
            if (!Checker.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasEmpty(String ... strs) {
        if (strs == null || strs.length == 0) {
            return true;
        }
        for (String str : strs) {
            if (!Checker.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(Object ... objs) {
        if (objs == null || objs.length == 0) {
            return true;
        }
        for (Object obj : objs) {
            if (!Checker.isNotEmpty(obj)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasEmpty(Object ... objs) {
        if (objs == null || objs.length == 0) {
            return true;
        }
        for (Object obj : objs) {
            if (!Checker.isEmpty(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(String obj) {
        return obj == null || obj.trim().isEmpty() || obj.trim() == "";
    }

    public static boolean isNotEmpty(String obj) {
        return obj != null && !obj.isEmpty() && obj.trim() != "";
    }

    public static <T> boolean isEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    public static <T> boolean isNotEmpty(List<T> list) {
        return list != null && !list.isEmpty();
    }

    public static <T> boolean isEmpty(Collection<T> list) {
        return list == null || list.isEmpty();
    }

    public static <T> boolean isNotEmpty(Collection<T> list) {
        return list != null && !list.isEmpty();
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> boolean isNotEmpty(Map<K, V> map) {
        return map != null && !map.isEmpty();
    }

    public static boolean isEmpty(Object[] objs) {
        return objs == null || objs.length == 0;
    }

    public static boolean isNotEmpty(Object[] objs) {
        return objs != null && objs.length > 0;
    }

    public static boolean isNotEmpty(Object obj) {
        return obj != null;
    }

    public static boolean isEmpty(Object obj) {
        return obj == null;
    }

    public static boolean isBaseType(Object obj) {
        if (obj instanceof Byte) {
            return true;
        }
        if (obj instanceof Short) {
            return true;
        }
        if (obj instanceof Double) {
            return true;
        }
        if (obj instanceof Integer) {
            return true;
        }
        if (obj instanceof Long) {
            return true;
        }
        if (obj instanceof Character) {
            return true;
        }
        if (obj instanceof Boolean) {
            return true;
        }
        return obj instanceof String;
    }
}

