/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import im.dart.boot.common.constant.Charsets;
import im.dart.boot.common.constant.DartCode;
import im.dart.boot.common.utils.Checker;
import im.dart.boot.common.utils.ReflectUtil;
import im.dart.boot.common.utils.Runner;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Convert {
    public static Integer min(Integer ... nums) {
        if (nums == null) {
            throw DartCode.PARAMETER_IS_EMPTY.exception("nums");
        }
        Integer min = Integer.MAX_VALUE;
        for (Integer num : nums) {
            if (num == null || num >= min) continue;
            min = num;
        }
        return min;
    }

    public static Integer max(Integer ... nums) {
        if (nums == null) {
            throw DartCode.PARAMETER_IS_EMPTY.exception("nums");
        }
        Integer max = Integer.MIN_VALUE;
        for (Integer num : nums) {
            if (num == null || num <= max) continue;
            max = num;
        }
        return max;
    }

    public static Double min(Double ... nums) {
        if (nums == null) {
            throw DartCode.PARAMETER_IS_EMPTY.exception("nums");
        }
        Double min = Double.MAX_VALUE;
        for (Double num : nums) {
            if (num == null || !(num < min)) continue;
            min = num;
        }
        return min;
    }

    public static Double max(Double ... nums) {
        if (nums == null) {
            throw DartCode.PARAMETER_IS_EMPTY.exception("nums");
        }
        Double max = Double.MIN_VALUE;
        for (Double num : nums) {
            if (num == null || !(num > max)) continue;
            max = num;
        }
        return max;
    }

    public static Long min(Long ... nums) {
        if (nums == null) {
            throw DartCode.PARAMETER_IS_EMPTY.exception("nums");
        }
        Long min = Long.MAX_VALUE;
        for (Long num : nums) {
            if (num == null || num >= min) continue;
            min = num;
        }
        return min;
    }

    public static Long max(Long ... nums) {
        if (nums == null) {
            throw DartCode.PARAMETER_IS_EMPTY.exception("nums");
        }
        Long max = Long.MIN_VALUE;
        for (Long num : nums) {
            if (num == null || num <= max) continue;
            max = num;
        }
        return max;
    }

    public static String toStr(byte[] bytes) {
        if (Checker.isEmpty((Object)bytes)) {
            return null;
        }
        return new String(bytes, Charsets.UTF_8);
    }

    public static String toStr(Object obj) {
        if (Checker.isEmpty(obj)) {
            return null;
        }
        return String.valueOf(obj);
    }

    public static Boolean toBoolean(Object obj) {
        String value = Convert.toStr(obj);
        if (Checker.isEmpty(value)) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(value);
    }

    public static Integer toInt(Object obj) {
        String value = Convert.toStr(obj);
        if (Checker.isEmpty(value)) {
            return 0;
        }
        return Integer.valueOf(value);
    }

    public static Short toShort(Object obj) {
        String value = Convert.toStr(obj);
        if (Checker.isEmpty(value)) {
            return (short)0;
        }
        return Short.valueOf(value);
    }

    public static Byte toByte(Object obj) {
        String value = Convert.toStr(obj);
        if (Checker.isEmpty(value)) {
            return (byte)0;
        }
        return Byte.valueOf(value);
    }

    public static Long toLong(Object obj) {
        String value = Convert.toStr(obj);
        if (Checker.isEmpty(value)) {
            return 0L;
        }
        return Long.valueOf(value);
    }

    public static BigDecimal toBigDecimal(Object obj) {
        String value = Convert.toStr(obj);
        if (Checker.isEmpty(value)) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(value);
    }

    public static Double toDouble(Object obj) {
        String value = Convert.toStr(obj);
        if (Checker.isEmpty(value)) {
            return 0.0;
        }
        return Double.valueOf(value);
    }

    public static <K, V> List<V> fetchByKey(K[] keys, Map<K, V> values) {
        if (Checker.isEmpty(keys) || Checker.isEmpty(values)) {
            return null;
        }
        return Convert.fetchByKey(Arrays.asList(keys), values);
    }

    public static <K, V> List<V> fetchByKey(List<K> keys, Map<K, V> values) {
        if (Checker.isEmpty(keys) || Checker.isEmpty(values)) {
            return null;
        }
        ArrayList<V> list = new ArrayList<V>(keys.size());
        for (K k : keys) {
            V v = values.get(k);
            if (!Checker.isNotEmpty(v)) continue;
            list.add(v);
        }
        return list;
    }

    public static <E extends Serializable> E[] merge(E[] e1, E[] e2, Class<E> type) {
        if (Checker.isEmpty(e1)) {
            return e2;
        }
        if (Checker.isEmpty(e2)) {
            return e1;
        }
        Serializable[] res = (Serializable[])Array.newInstance(type, e1.length + e2.length);
        int idx = 0;
        for (E e : e1) {
            res[idx] = e;
            ++idx;
        }
        for (E e : e2) {
            res[idx] = e;
            ++idx;
        }
        return res;
    }

    public static <E extends Serializable> E[] mergeWithoutDuplication(E[] e1, E[] e2, Class<E> type) {
        if (Checker.isEmpty(e1)) {
            return e2;
        }
        if (Checker.isEmpty(e2)) {
            return e1;
        }
        HashSet<E> sets = new HashSet<E>();
        for (Object e : e1) {
            sets.add(e);
        }
        for (Object e : e2) {
            sets.add(e);
        }
        Serializable[] res = (Serializable[])Array.newInstance(type, sets.size());
        int idx = 0;
        for (Object e : sets) {
            res[idx] = e;
            ++idx;
        }
        return res;
    }

    public static <T> T fuse(T self, T target) {
        if (target == null) {
            return null;
        }
        if (self.getClass() != target.getClass()) {
            return null;
        }
        List<Field> fields = ReflectUtil.fetchFields(self.getClass());
        for (Field field : fields) {
            Runner.safeRun(() -> {
                Object value = ReflectUtil.fetchValue(target, field);
                if (Checker.isEmptyString(value)) {
                    return;
                }
                ReflectUtil.setFieldValue(self, field, value);
            });
        }
        return self;
    }
}

