/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import im.dart.boot.common.utils.Checker;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;

public class DateUtil {
    public static final String FMT_DEFAULT_STR = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter FMT_SIMPLE = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter FMT_DEFAULT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static String fmt(Long millisTime, String fmt) {
        if (millisTime == null || Checker.isEmpty(fmt)) {
            return null;
        }
        if (Checker.isEmpty(millisTime)) {
            return null;
        }
        long timeFmt = ("" + millisTime).length() == 10 ? millisTime * 1000L : millisTime;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(fmt);
        Instant instant = Instant.ofEpochMilli(timeFmt);
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime time = LocalDateTime.ofInstant(instant, zoneId);
        return time.format(formatter);
    }

    public static String fmt(Long millisTime) {
        return DateUtil.fmt(millisTime, FMT_DEFAULT_STR);
    }

    public static String fmt(String fmt) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(fmt));
    }

    public static Long fmtYYYYMMDD(Long millisTime) {
        String fmt = DateUtil.fmt(millisTime, "yyyyMMdd");
        if (fmt == null) {
            return null;
        }
        return Long.valueOf(fmt);
    }

    public static String current() {
        return LocalDateTime.now().format(FMT_DEFAULT);
    }

    public static String simpleCurrent() {
        return LocalDateTime.now().format(FMT_SIMPLE);
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long currentTimeSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long todayStart() {
        LocalDateTime time = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        return time.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static long monthStart() {
        LocalDate date = LocalDate.now();
        LocalDateTime time = LocalDateTime.of(LocalDate.of(date.getYear(), date.getMonth(), 1), LocalTime.MIN);
        return time.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static long yearStart() {
        LocalDateTime time = LocalDateTime.of(LocalDate.of(LocalDate.now().getYear(), 1, 1), LocalTime.MIN);
        return time.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static long todayEnd() {
        LocalDateTime time = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
        return time.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static int currentYear() {
        return Integer.valueOf(DateUtil.fmt(System.currentTimeMillis(), "yyyy"));
    }

    public static int currentDay() {
        return Integer.valueOf(DateUtil.fmt(System.currentTimeMillis(), "yyyyMMdd"));
    }

    public static String todayWeek() {
        int week = Calendar.getInstance().get(7);
        switch (week) {
            case 1: {
                return "\u661f\u671f\u5929";
            }
            case 2: {
                return "\u661f\u671f\u4e00";
            }
            case 3: {
                return "\u661f\u671f\u4e8c";
            }
            case 4: {
                return "\u661f\u671f\u4e09";
            }
            case 5: {
                return "\u661f\u671f\u56db";
            }
            case 6: {
                return "\u661f\u671f\u4e94";
            }
            case 7: {
                return "\u661f\u671f\u516d";
            }
        }
        return "UNKNOW";
    }
}

