/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import im.dart.boot.common.constant.Charsets;
import im.dart.boot.common.constant.DartCode;
import im.dart.boot.common.utils.ByteUtil;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Digest {
    public static String MD5(String code) {
        try {
            byte[] btInput = code.getBytes(Charsets.UTF_8);
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            return ByteUtil.toHex(md);
        }
        catch (Exception e) {
            throw DartCode.DIGEST_ERROR.exception(e);
        }
    }

    public static String SHA1(String str) {
        return Digest.sha(str, "SHA1");
    }

    public static String SHA256(String str) {
        return Digest.sha(str, "SHA-256");
    }

    public static String SHA512(String str) {
        return Digest.sha(str, "SHA-512");
    }

    private static String sha(String strText, String strType) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(strType);
            messageDigest.update(strText.getBytes(Charsets.UTF_8));
            byte[] bytes = messageDigest.digest();
            return ByteUtil.toHex(bytes);
        }
        catch (Exception e) {
            throw DartCode.DIGEST_ERROR.exception(e);
        }
    }

    public static byte[] HMAC_SHA1(String source, String key) {
        return Digest.hmacSha(source.getBytes(Charsets.UTF_8), key.getBytes(Charsets.UTF_8), "HmacSHA1");
    }

    public static byte[] HMAC_SHA1(byte[] source, byte[] key) {
        return Digest.hmacSha(source, key, "HmacSHA1");
    }

    public static byte[] HMAC_SHA256(byte[] source, byte[] key) {
        return Digest.hmacSha(source, key, "HmacSHA256");
    }

    public static byte[] HMAC_SHA512(byte[] source, byte[] key) {
        return Digest.hmacSha(source, key, "HmacSHA512");
    }

    private static byte[] hmacSha(byte[] source, byte[] key, String type) {
        try {
            Mac hmacSHA1 = Mac.getInstance("HmacSHA1");
            SecretKeySpec macKey = new SecretKeySpec(key, "AES");
            hmacSHA1.init(macKey);
            return hmacSHA1.doFinal(source);
        }
        catch (Exception e) {
            throw DartCode.DIGEST_ERROR.exception(e);
        }
    }
}

