/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import im.dart.boot.common.utils.DateUtil;
import im.dart.boot.common.utils.UUID;
import java.util.HashMap;
import java.util.Map;

public class IdCardUtil {
    private static final Map<String, Integer> AREA_CODES = new HashMap<String, Integer>();

    public static String generate() {
        StringBuilder generater = new StringBuilder();
        generater.append(IdCardUtil.randomAreaCode());
        generater.append(IdCardUtil.randomBirthday());
        generater.append(IdCardUtil.randomCode());
        generater.append(IdCardUtil.calcTrailingNumber(generater.toString().toCharArray()));
        return generater.toString();
    }

    private static int randomAreaCode() {
        Integer[] values = AREA_CODES.values().toArray(new Integer[AREA_CODES.size()]);
        return values[UUID.random(values.length)];
    }

    private static String randomBirthday() {
        int year = UUID.random(1950, DateUtil.currentYear());
        int month = UUID.random(12) + 1;
        int day = UUID.random(28) + 1;
        return String.format("%s%s%s", year, month < 10 ? "0" + month : Integer.valueOf(month), day < 10 ? "0" + day : Integer.valueOf(day));
    }

    private static char calcTrailingNumber(char[] chars) {
        int i;
        if (chars.length < 17) {
            return ' ';
        }
        int[] c = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        char[] r = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int[] n = new int[17];
        int result = 0;
        for (i = 0; i < n.length; ++i) {
            n[i] = Integer.parseInt("" + chars[i]);
        }
        for (i = 0; i < n.length; ++i) {
            result += c[i] * n[i];
        }
        return r[result % 11];
    }

    private static String randomCode() {
        int code = UUID.random(999);
        if (code < 10) {
            return "00" + code;
        }
        if (code < 100) {
            return "0" + code;
        }
        return "" + code;
    }

    /*
     * Opcode count of 21096 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        AREA_CODES.put("\u5317\u4eac\u5e02", 110000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 110100);
        AREA_CODES.put("\u4e1c\u57ce\u533a", 110101);
        AREA_CODES.put("\u897f\u57ce\u533a", 110102);
        AREA_CODES.put("\u5d07\u6587\u533a", 110103);
        AREA_CODES.put("\u5ba3\u6b66\u533a", 110104);
        AREA_CODES.put("\u671d\u9633\u533a", 110105);
        AREA_CODES.put("\u4e30\u53f0\u533a", 110106);
        AREA_CODES.put("\u77f3\u666f\u5c71\u533a", 110107);
        AREA_CODES.put("\u6d77\u6dc0\u533a", 110108);
        AREA_CODES.put("\u95e8\u5934\u6c9f\u533a", 110109);
        AREA_CODES.put("\u623f\u5c71\u533a", 110111);
        AREA_CODES.put("\u901a\u5dde\u533a", 110112);
        AREA_CODES.put("\u987a\u4e49\u533a", 110113);
        AREA_CODES.put("\u660c\u5e73\u533a", 110114);
        AREA_CODES.put("\u5927\u5174\u533a", 110115);
        AREA_CODES.put("\u6000\u67d4\u533a", 110116);
        AREA_CODES.put("\u5e73\u8c37\u533a", 110117);
        AREA_CODES.put("\u53bf", 110200);
        AREA_CODES.put("\u5bc6\u4e91\u53bf", 110228);
        AREA_CODES.put("\u5ef6\u5e86\u53bf", 110229);
        AREA_CODES.put("\u5929\u6d25\u5e02", 120000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 120100);
        AREA_CODES.put("\u548c\u5e73\u533a", 120101);
        AREA_CODES.put("\u6cb3\u4e1c\u533a", 120102);
        AREA_CODES.put("\u6cb3\u897f\u533a", 120103);
        AREA_CODES.put("\u5357\u5f00\u533a", 120104);
        AREA_CODES.put("\u6cb3\u5317\u533a", 120105);
        AREA_CODES.put("\u7ea2\u6865\u533a", 120106);
        AREA_CODES.put("\u4e1c\u4e3d\u533a", 120110);
        AREA_CODES.put("\u897f\u9752\u533a", 120111);
        AREA_CODES.put("\u6d25\u5357\u533a", 120112);
        AREA_CODES.put("\u5317\u8fb0\u533a", 120113);
        AREA_CODES.put("\u6b66\u6e05\u533a", 120114);
        AREA_CODES.put("\u5b9d\u577b\u533a", 120115);
        AREA_CODES.put("\u53bf", 120200);
        AREA_CODES.put("\u5b81\u6cb3\u53bf", 120221);
        AREA_CODES.put("\u9759\u6d77\u53bf", 120223);
        AREA_CODES.put("\u84df\u3000\u53bf", 120225);
        AREA_CODES.put("\u6cb3\u5317\u7701", 130000);
        AREA_CODES.put("\u77f3\u5bb6\u5e84\u5e02", 130100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 130101);
        AREA_CODES.put("\u957f\u5b89\u533a", 130102);
        AREA_CODES.put("\u6865\u4e1c\u533a", 130103);
        AREA_CODES.put("\u6865\u897f\u533a", 130104);
        AREA_CODES.put("\u65b0\u534e\u533a", 130105);
        AREA_CODES.put("\u4e95\u9649\u77ff\u533a", 130107);
        AREA_CODES.put("\u88d5\u534e\u533a", 130108);
        AREA_CODES.put("\u4e95\u9649\u53bf", 130121);
        AREA_CODES.put("\u6b63\u5b9a\u53bf", 130123);
        AREA_CODES.put("\u683e\u57ce\u53bf", 130124);
        AREA_CODES.put("\u884c\u5510\u53bf", 130125);
        AREA_CODES.put("\u7075\u5bff\u53bf", 130126);
        AREA_CODES.put("\u9ad8\u9091\u53bf", 130127);
        AREA_CODES.put("\u6df1\u6cfd\u53bf", 130128);
        AREA_CODES.put("\u8d5e\u7687\u53bf", 130129);
        AREA_CODES.put("\u65e0\u6781\u53bf", 130130);
        AREA_CODES.put("\u5e73\u5c71\u53bf", 130131);
        AREA_CODES.put("\u5143\u6c0f\u53bf", 130132);
        AREA_CODES.put("\u8d75\u3000\u53bf", 130133);
        AREA_CODES.put("\u8f9b\u96c6\u5e02", 130181);
        AREA_CODES.put("\u85c1\u57ce\u5e02", 130182);
        AREA_CODES.put("\u664b\u5dde\u5e02", 130183);
        AREA_CODES.put("\u65b0\u4e50\u5e02", 130184);
        AREA_CODES.put("\u9e7f\u6cc9\u5e02", 130185);
        AREA_CODES.put("\u5510\u5c71\u5e02", 130200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 130201);
        AREA_CODES.put("\u8def\u5357\u533a", 130202);
        AREA_CODES.put("\u8def\u5317\u533a", 130203);
        AREA_CODES.put("\u53e4\u51b6\u533a", 130204);
        AREA_CODES.put("\u5f00\u5e73\u533a", 130205);
        AREA_CODES.put("\u4e30\u5357\u533a", 130207);
        AREA_CODES.put("\u4e30\u6da6\u533a", 130208);
        AREA_CODES.put("\u6ee6\u3000\u53bf", 130223);
        AREA_CODES.put("\u6ee6\u5357\u53bf", 130224);
        AREA_CODES.put("\u4e50\u4ead\u53bf", 130225);
        AREA_CODES.put("\u8fc1\u897f\u53bf", 130227);
        AREA_CODES.put("\u7389\u7530\u53bf", 130229);
        AREA_CODES.put("\u5510\u6d77\u53bf", 130230);
        AREA_CODES.put("\u9075\u5316\u5e02", 130281);
        AREA_CODES.put("\u8fc1\u5b89\u5e02", 130283);
        AREA_CODES.put("\u79e6\u7687\u5c9b\u5e02", 130300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 130301);
        AREA_CODES.put("\u6d77\u6e2f\u533a", 130302);
        AREA_CODES.put("\u5c71\u6d77\u5173\u533a", 130303);
        AREA_CODES.put("\u5317\u6234\u6cb3\u533a", 130304);
        AREA_CODES.put("\u9752\u9f99\u6ee1\u65cf\u81ea\u6cbb\u53bf", 130321);
        AREA_CODES.put("\u660c\u9ece\u53bf", 130322);
        AREA_CODES.put("\u629a\u5b81\u53bf", 130323);
        AREA_CODES.put("\u5362\u9f99\u53bf", 130324);
        AREA_CODES.put("\u90af\u90f8\u5e02", 130400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 130401);
        AREA_CODES.put("\u90af\u5c71\u533a", 130402);
        AREA_CODES.put("\u4e1b\u53f0\u533a", 130403);
        AREA_CODES.put("\u590d\u5174\u533a", 130404);
        AREA_CODES.put("\u5cf0\u5cf0\u77ff\u533a", 130406);
        AREA_CODES.put("\u90af\u90f8\u53bf", 130421);
        AREA_CODES.put("\u4e34\u6f33\u53bf", 130423);
        AREA_CODES.put("\u6210\u5b89\u53bf", 130424);
        AREA_CODES.put("\u5927\u540d\u53bf", 130425);
        AREA_CODES.put("\u6d89\u3000\u53bf", 130426);
        AREA_CODES.put("\u78c1\u3000\u53bf", 130427);
        AREA_CODES.put("\u80a5\u4e61\u53bf", 130428);
        AREA_CODES.put("\u6c38\u5e74\u53bf", 130429);
        AREA_CODES.put("\u90b1\u3000\u53bf", 130430);
        AREA_CODES.put("\u9e21\u6cfd\u53bf", 130431);
        AREA_CODES.put("\u5e7f\u5e73\u53bf", 130432);
        AREA_CODES.put("\u9986\u9676\u53bf", 130433);
        AREA_CODES.put("\u9b4f\u3000\u53bf", 130434);
        AREA_CODES.put("\u66f2\u5468\u53bf", 130435);
        AREA_CODES.put("\u6b66\u5b89\u5e02", 130481);
        AREA_CODES.put("\u90a2\u53f0\u5e02", 130500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 130501);
        AREA_CODES.put("\u6865\u4e1c\u533a", 130502);
        AREA_CODES.put("\u6865\u897f\u533a", 130503);
        AREA_CODES.put("\u90a2\u53f0\u53bf", 130521);
        AREA_CODES.put("\u4e34\u57ce\u53bf", 130522);
        AREA_CODES.put("\u5185\u4e18\u53bf", 130523);
        AREA_CODES.put("\u67cf\u4e61\u53bf", 130524);
        AREA_CODES.put("\u9686\u5c27\u53bf", 130525);
        AREA_CODES.put("\u4efb\u3000\u53bf", 130526);
        AREA_CODES.put("\u5357\u548c\u53bf", 130527);
        AREA_CODES.put("\u5b81\u664b\u53bf", 130528);
        AREA_CODES.put("\u5de8\u9e7f\u53bf", 130529);
        AREA_CODES.put("\u65b0\u6cb3\u53bf", 130530);
        AREA_CODES.put("\u5e7f\u5b97\u53bf", 130531);
        AREA_CODES.put("\u5e73\u4e61\u53bf", 130532);
        AREA_CODES.put("\u5a01\u3000\u53bf", 130533);
        AREA_CODES.put("\u6e05\u6cb3\u53bf", 130534);
        AREA_CODES.put("\u4e34\u897f\u53bf", 130535);
        AREA_CODES.put("\u5357\u5bab\u5e02", 130581);
        AREA_CODES.put("\u6c99\u6cb3\u5e02", 130582);
        AREA_CODES.put("\u4fdd\u5b9a\u5e02", 130600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 130601);
        AREA_CODES.put("\u65b0\u5e02\u533a", 130602);
        AREA_CODES.put("\u5317\u5e02\u533a", 130603);
        AREA_CODES.put("\u5357\u5e02\u533a", 130604);
        AREA_CODES.put("\u6ee1\u57ce\u53bf", 130621);
        AREA_CODES.put("\u6e05\u82d1\u53bf", 130622);
        AREA_CODES.put("\u6d9e\u6c34\u53bf", 130623);
        AREA_CODES.put("\u961c\u5e73\u53bf", 130624);
        AREA_CODES.put("\u5f90\u6c34\u53bf", 130625);
        AREA_CODES.put("\u5b9a\u5174\u53bf", 130626);
        AREA_CODES.put("\u5510\u3000\u53bf", 130627);
        AREA_CODES.put("\u9ad8\u9633\u53bf", 130628);
        AREA_CODES.put("\u5bb9\u57ce\u53bf", 130629);
        AREA_CODES.put("\u6d9e\u6e90\u53bf", 130630);
        AREA_CODES.put("\u671b\u90fd\u53bf", 130631);
        AREA_CODES.put("\u5b89\u65b0\u53bf", 130632);
        AREA_CODES.put("\u6613\u3000\u53bf", 130633);
        AREA_CODES.put("\u66f2\u9633\u53bf", 130634);
        AREA_CODES.put("\u8821\u3000\u53bf", 130635);
        AREA_CODES.put("\u987a\u5e73\u53bf", 130636);
        AREA_CODES.put("\u535a\u91ce\u53bf", 130637);
        AREA_CODES.put("\u96c4\u3000\u53bf", 130638);
        AREA_CODES.put("\u6dbf\u5dde\u5e02", 130681);
        AREA_CODES.put("\u5b9a\u5dde\u5e02", 130682);
        AREA_CODES.put("\u5b89\u56fd\u5e02", 130683);
        AREA_CODES.put("\u9ad8\u7891\u5e97\u5e02", 130684);
        AREA_CODES.put("\u5f20\u5bb6\u53e3\u5e02", 130700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 130701);
        AREA_CODES.put("\u6865\u4e1c\u533a", 130702);
        AREA_CODES.put("\u6865\u897f\u533a", 130703);
        AREA_CODES.put("\u5ba3\u5316\u533a", 130705);
        AREA_CODES.put("\u4e0b\u82b1\u56ed\u533a", 130706);
        AREA_CODES.put("\u5ba3\u5316\u53bf", 130721);
        AREA_CODES.put("\u5f20\u5317\u53bf", 130722);
        AREA_CODES.put("\u5eb7\u4fdd\u53bf", 130723);
        AREA_CODES.put("\u6cbd\u6e90\u53bf", 130724);
        AREA_CODES.put("\u5c1a\u4e49\u53bf", 130725);
        AREA_CODES.put("\u851a\u3000\u53bf", 130726);
        AREA_CODES.put("\u9633\u539f\u53bf", 130727);
        AREA_CODES.put("\u6000\u5b89\u53bf", 130728);
        AREA_CODES.put("\u4e07\u5168\u53bf", 130729);
        AREA_CODES.put("\u6000\u6765\u53bf", 130730);
        AREA_CODES.put("\u6dbf\u9e7f\u53bf", 130731);
        AREA_CODES.put("\u8d64\u57ce\u53bf", 130732);
        AREA_CODES.put("\u5d07\u793c\u53bf", 130733);
        AREA_CODES.put("\u627f\u5fb7\u5e02", 130800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 130801);
        AREA_CODES.put("\u53cc\u6865\u533a", 130802);
        AREA_CODES.put("\u53cc\u6ee6\u533a", 130803);
        AREA_CODES.put("\u9e70\u624b\u8425\u5b50\u77ff\u533a", 130804);
        AREA_CODES.put("\u627f\u5fb7\u53bf", 130821);
        AREA_CODES.put("\u5174\u9686\u53bf", 130822);
        AREA_CODES.put("\u5e73\u6cc9\u53bf", 130823);
        AREA_CODES.put("\u6ee6\u5e73\u53bf", 130824);
        AREA_CODES.put("\u9686\u5316\u53bf", 130825);
        AREA_CODES.put("\u4e30\u5b81\u6ee1\u65cf\u81ea\u6cbb\u53bf", 130826);
        AREA_CODES.put("\u5bbd\u57ce\u6ee1\u65cf\u81ea\u6cbb\u53bf", 130827);
        AREA_CODES.put("\u56f4\u573a\u6ee1\u65cf\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 130828);
        AREA_CODES.put("\u6ca7\u5dde\u5e02", 130900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 130901);
        AREA_CODES.put("\u65b0\u534e\u533a", 130902);
        AREA_CODES.put("\u8fd0\u6cb3\u533a", 130903);
        AREA_CODES.put("\u6ca7\u3000\u53bf", 130921);
        AREA_CODES.put("\u9752\u3000\u53bf", 130922);
        AREA_CODES.put("\u4e1c\u5149\u53bf", 130923);
        AREA_CODES.put("\u6d77\u5174\u53bf", 130924);
        AREA_CODES.put("\u76d0\u5c71\u53bf", 130925);
        AREA_CODES.put("\u8083\u5b81\u53bf", 130926);
        AREA_CODES.put("\u5357\u76ae\u53bf", 130927);
        AREA_CODES.put("\u5434\u6865\u53bf", 130928);
        AREA_CODES.put("\u732e\u3000\u53bf", 130929);
        AREA_CODES.put("\u5b5f\u6751\u56de\u65cf\u81ea\u6cbb\u53bf", 130930);
        AREA_CODES.put("\u6cca\u5934\u5e02", 130981);
        AREA_CODES.put("\u4efb\u4e18\u5e02", 130982);
        AREA_CODES.put("\u9ec4\u9a85\u5e02", 130983);
        AREA_CODES.put("\u6cb3\u95f4\u5e02", 130984);
        AREA_CODES.put("\u5eca\u574a\u5e02", 131000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 131001);
        AREA_CODES.put("\u5b89\u6b21\u533a", 131002);
        AREA_CODES.put("\u5e7f\u9633\u533a", 131003);
        AREA_CODES.put("\u56fa\u5b89\u53bf", 131022);
        AREA_CODES.put("\u6c38\u6e05\u53bf", 131023);
        AREA_CODES.put("\u9999\u6cb3\u53bf", 131024);
        AREA_CODES.put("\u5927\u57ce\u53bf", 131025);
        AREA_CODES.put("\u6587\u5b89\u53bf", 131026);
        AREA_CODES.put("\u5927\u5382\u56de\u65cf\u81ea\u6cbb\u53bf", 131028);
        AREA_CODES.put("\u9738\u5dde\u5e02", 131081);
        AREA_CODES.put("\u4e09\u6cb3\u5e02", 131082);
        AREA_CODES.put("\u8861\u6c34\u5e02", 131100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 131101);
        AREA_CODES.put("\u6843\u57ce\u533a", 131102);
        AREA_CODES.put("\u67a3\u5f3a\u53bf", 131121);
        AREA_CODES.put("\u6b66\u9091\u53bf", 131122);
        AREA_CODES.put("\u6b66\u5f3a\u53bf", 131123);
        AREA_CODES.put("\u9976\u9633\u53bf", 131124);
        AREA_CODES.put("\u5b89\u5e73\u53bf", 131125);
        AREA_CODES.put("\u6545\u57ce\u53bf", 131126);
        AREA_CODES.put("\u666f\u3000\u53bf", 131127);
        AREA_CODES.put("\u961c\u57ce\u53bf", 131128);
        AREA_CODES.put("\u5180\u5dde\u5e02", 131181);
        AREA_CODES.put("\u6df1\u5dde\u5e02", 131182);
        AREA_CODES.put("\u5c71\u897f\u7701", 140000);
        AREA_CODES.put("\u592a\u539f\u5e02", 140100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 140101);
        AREA_CODES.put("\u5c0f\u5e97\u533a", 140105);
        AREA_CODES.put("\u8fce\u6cfd\u533a", 140106);
        AREA_CODES.put("\u674f\u82b1\u5cad\u533a", 140107);
        AREA_CODES.put("\u5c16\u8349\u576a\u533a", 140108);
        AREA_CODES.put("\u4e07\u67cf\u6797\u533a", 140109);
        AREA_CODES.put("\u664b\u6e90\u533a", 140110);
        AREA_CODES.put("\u6e05\u5f90\u53bf", 140121);
        AREA_CODES.put("\u9633\u66f2\u53bf", 140122);
        AREA_CODES.put("\u5a04\u70e6\u53bf", 140123);
        AREA_CODES.put("\u53e4\u4ea4\u5e02", 140181);
        AREA_CODES.put("\u5927\u540c\u5e02", 140200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 140201);
        AREA_CODES.put("\u57ce\u3000\u533a", 140202);
        AREA_CODES.put("\u77ff\u3000\u533a", 140203);
        AREA_CODES.put("\u5357\u90ca\u533a", 140211);
        AREA_CODES.put("\u65b0\u8363\u533a", 140212);
        AREA_CODES.put("\u9633\u9ad8\u53bf", 140221);
        AREA_CODES.put("\u5929\u9547\u53bf", 140222);
        AREA_CODES.put("\u5e7f\u7075\u53bf", 140223);
        AREA_CODES.put("\u7075\u4e18\u53bf", 140224);
        AREA_CODES.put("\u6d51\u6e90\u53bf", 140225);
        AREA_CODES.put("\u5de6\u4e91\u53bf", 140226);
        AREA_CODES.put("\u5927\u540c\u53bf", 140227);
        AREA_CODES.put("\u9633\u6cc9\u5e02", 140300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 140301);
        AREA_CODES.put("\u57ce\u3000\u533a", 140302);
        AREA_CODES.put("\u77ff\u3000\u533a", 140303);
        AREA_CODES.put("\u90ca\u3000\u533a", 140311);
        AREA_CODES.put("\u5e73\u5b9a\u53bf", 140321);
        AREA_CODES.put("\u76c2\u3000\u53bf", 140322);
        AREA_CODES.put("\u957f\u6cbb\u5e02", 140400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 140401);
        AREA_CODES.put("\u57ce\u3000\u533a", 140402);
        AREA_CODES.put("\u90ca\u3000\u533a", 140411);
        AREA_CODES.put("\u957f\u6cbb\u53bf", 140421);
        AREA_CODES.put("\u8944\u57a3\u53bf", 140423);
        AREA_CODES.put("\u5c6f\u7559\u53bf", 140424);
        AREA_CODES.put("\u5e73\u987a\u53bf", 140425);
        AREA_CODES.put("\u9ece\u57ce\u53bf", 140426);
        AREA_CODES.put("\u58f6\u5173\u53bf", 140427);
        AREA_CODES.put("\u957f\u5b50\u53bf", 140428);
        AREA_CODES.put("\u6b66\u4e61\u53bf", 140429);
        AREA_CODES.put("\u6c81\u3000\u53bf", 140430);
        AREA_CODES.put("\u6c81\u6e90\u53bf", 140431);
        AREA_CODES.put("\u6f5e\u57ce\u5e02", 140481);
        AREA_CODES.put("\u664b\u57ce\u5e02", 140500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 140501);
        AREA_CODES.put("\u57ce\u3000\u533a", 140502);
        AREA_CODES.put("\u6c81\u6c34\u53bf", 140521);
        AREA_CODES.put("\u9633\u57ce\u53bf", 140522);
        AREA_CODES.put("\u9675\u5ddd\u53bf", 140524);
        AREA_CODES.put("\u6cfd\u5dde\u53bf", 140525);
        AREA_CODES.put("\u9ad8\u5e73\u5e02", 140581);
        AREA_CODES.put("\u6714\u5dde\u5e02", 140600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 140601);
        AREA_CODES.put("\u6714\u57ce\u533a", 140602);
        AREA_CODES.put("\u5e73\u9c81\u533a", 140603);
        AREA_CODES.put("\u5c71\u9634\u53bf", 140621);
        AREA_CODES.put("\u5e94\u3000\u53bf", 140622);
        AREA_CODES.put("\u53f3\u7389\u53bf", 140623);
        AREA_CODES.put("\u6000\u4ec1\u53bf", 140624);
        AREA_CODES.put("\u664b\u4e2d\u5e02", 140700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 140701);
        AREA_CODES.put("\u6986\u6b21\u533a", 140702);
        AREA_CODES.put("\u6986\u793e\u53bf", 140721);
        AREA_CODES.put("\u5de6\u6743\u53bf", 140722);
        AREA_CODES.put("\u548c\u987a\u53bf", 140723);
        AREA_CODES.put("\u6614\u9633\u53bf", 140724);
        AREA_CODES.put("\u5bff\u9633\u53bf", 140725);
        AREA_CODES.put("\u592a\u8c37\u53bf", 140726);
        AREA_CODES.put("\u7941\u3000\u53bf", 140727);
        AREA_CODES.put("\u5e73\u9065\u53bf", 140728);
        AREA_CODES.put("\u7075\u77f3\u53bf", 140729);
        AREA_CODES.put("\u4ecb\u4f11\u5e02", 140781);
        AREA_CODES.put("\u8fd0\u57ce\u5e02", 140800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 140801);
        AREA_CODES.put("\u76d0\u6e56\u533a", 140802);
        AREA_CODES.put("\u4e34\u7317\u53bf", 140821);
        AREA_CODES.put("\u4e07\u8363\u53bf", 140822);
        AREA_CODES.put("\u95fb\u559c\u53bf", 140823);
        AREA_CODES.put("\u7a37\u5c71\u53bf", 140824);
        AREA_CODES.put("\u65b0\u7edb\u53bf", 140825);
        AREA_CODES.put("\u7edb\u3000\u53bf", 140826);
        AREA_CODES.put("\u57a3\u66f2\u53bf", 140827);
        AREA_CODES.put("\u590f\u3000\u53bf", 140828);
        AREA_CODES.put("\u5e73\u9646\u53bf", 140829);
        AREA_CODES.put("\u82ae\u57ce\u53bf", 140830);
        AREA_CODES.put("\u6c38\u6d4e\u5e02", 140881);
        AREA_CODES.put("\u6cb3\u6d25\u5e02", 140882);
        AREA_CODES.put("\u5ffb\u5dde\u5e02", 140900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 140901);
        AREA_CODES.put("\u5ffb\u5e9c\u533a", 140902);
        AREA_CODES.put("\u5b9a\u8944\u53bf", 140921);
        AREA_CODES.put("\u4e94\u53f0\u53bf", 140922);
        AREA_CODES.put("\u4ee3\u3000\u53bf", 140923);
        AREA_CODES.put("\u7e41\u5cd9\u53bf", 140924);
        AREA_CODES.put("\u5b81\u6b66\u53bf", 140925);
        AREA_CODES.put("\u9759\u4e50\u53bf", 140926);
        AREA_CODES.put("\u795e\u6c60\u53bf", 140927);
        AREA_CODES.put("\u4e94\u5be8\u53bf", 140928);
        AREA_CODES.put("\u5ca2\u5c9a\u53bf", 140929);
        AREA_CODES.put("\u6cb3\u66f2\u53bf", 140930);
        AREA_CODES.put("\u4fdd\u5fb7\u53bf", 140931);
        AREA_CODES.put("\u504f\u5173\u53bf", 140932);
        AREA_CODES.put("\u539f\u5e73\u5e02", 140981);
        AREA_CODES.put("\u4e34\u6c7e\u5e02", 141000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 141001);
        AREA_CODES.put("\u5c27\u90fd\u533a", 141002);
        AREA_CODES.put("\u66f2\u6c83\u53bf", 141021);
        AREA_CODES.put("\u7ffc\u57ce\u53bf", 141022);
        AREA_CODES.put("\u8944\u6c7e\u53bf", 141023);
        AREA_CODES.put("\u6d2a\u6d1e\u53bf", 141024);
        AREA_CODES.put("\u53e4\u3000\u53bf", 141025);
        AREA_CODES.put("\u5b89\u6cfd\u53bf", 141026);
        AREA_CODES.put("\u6d6e\u5c71\u53bf", 141027);
        AREA_CODES.put("\u5409\u3000\u53bf", 141028);
        AREA_CODES.put("\u4e61\u5b81\u53bf", 141029);
        AREA_CODES.put("\u5927\u5b81\u53bf", 141030);
        AREA_CODES.put("\u96b0\u3000\u53bf", 141031);
        AREA_CODES.put("\u6c38\u548c\u53bf", 141032);
        AREA_CODES.put("\u84b2\u3000\u53bf", 141033);
        AREA_CODES.put("\u6c7e\u897f\u53bf", 141034);
        AREA_CODES.put("\u4faf\u9a6c\u5e02", 141081);
        AREA_CODES.put("\u970d\u5dde\u5e02", 141082);
        AREA_CODES.put("\u5415\u6881\u5e02", 141100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 141101);
        AREA_CODES.put("\u79bb\u77f3\u533a", 141102);
        AREA_CODES.put("\u6587\u6c34\u53bf", 141121);
        AREA_CODES.put("\u4ea4\u57ce\u53bf", 141122);
        AREA_CODES.put("\u5174\u3000\u53bf", 141123);
        AREA_CODES.put("\u4e34\u3000\u53bf", 141124);
        AREA_CODES.put("\u67f3\u6797\u53bf", 141125);
        AREA_CODES.put("\u77f3\u697c\u53bf", 141126);
        AREA_CODES.put("\u5c9a\u3000\u53bf", 141127);
        AREA_CODES.put("\u65b9\u5c71\u53bf", 141128);
        AREA_CODES.put("\u4e2d\u9633\u53bf", 141129);
        AREA_CODES.put("\u4ea4\u53e3\u53bf", 141130);
        AREA_CODES.put("\u5b5d\u4e49\u5e02", 141181);
        AREA_CODES.put("\u6c7e\u9633\u5e02", 141182);
        AREA_CODES.put("\u5185\u8499\u53e4\u81ea\u6cbb\u533a", 150000);
        AREA_CODES.put("\u547c\u548c\u6d69\u7279\u5e02", 150100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 150101);
        AREA_CODES.put("\u65b0\u57ce\u533a", 150102);
        AREA_CODES.put("\u56de\u6c11\u533a", 150103);
        AREA_CODES.put("\u7389\u6cc9\u533a", 150104);
        AREA_CODES.put("\u8d5b\u7f55\u533a", 150105);
        AREA_CODES.put("\u571f\u9ed8\u7279\u5de6\u65d7", 150121);
        AREA_CODES.put("\u6258\u514b\u6258\u53bf", 150122);
        AREA_CODES.put("\u548c\u6797\u683c\u5c14\u53bf", 150123);
        AREA_CODES.put("\u6e05\u6c34\u6cb3\u53bf", 150124);
        AREA_CODES.put("\u6b66\u5ddd\u53bf", 150125);
        AREA_CODES.put("\u5305\u5934\u5e02", 150200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 150201);
        AREA_CODES.put("\u4e1c\u6cb3\u533a", 150202);
        AREA_CODES.put("\u6606\u90fd\u4ed1\u533a", 150203);
        AREA_CODES.put("\u9752\u5c71\u533a", 150204);
        AREA_CODES.put("\u77f3\u62d0\u533a", 150205);
        AREA_CODES.put("\u767d\u4e91\u9102\u535a\u77ff\u533a", 150206);
        AREA_CODES.put("\u4e5d\u539f\u533a", 150207);
        AREA_CODES.put("\u571f\u9ed8\u7279\u53f3\u65d7", 150221);
        AREA_CODES.put("\u56fa\u9633\u53bf", 150222);
        AREA_CODES.put("\u8fbe\u5c14\u7f55\u8302\u660e\u5b89\u8054\u5408\u65d7", 150223);
        AREA_CODES.put("\u4e4c\u6d77\u5e02", 150300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 150301);
        AREA_CODES.put("\u6d77\u52c3\u6e7e\u533a", 150302);
        AREA_CODES.put("\u6d77\u5357\u533a", 150303);
        AREA_CODES.put("\u4e4c\u8fbe\u533a", 150304);
        AREA_CODES.put("\u8d64\u5cf0\u5e02", 150400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 150401);
        AREA_CODES.put("\u7ea2\u5c71\u533a", 150402);
        AREA_CODES.put("\u5143\u5b9d\u5c71\u533a", 150403);
        AREA_CODES.put("\u677e\u5c71\u533a", 150404);
        AREA_CODES.put("\u963f\u9c81\u79d1\u5c14\u6c81\u65d7", 150421);
        AREA_CODES.put("\u5df4\u6797\u5de6\u65d7", 150422);
        AREA_CODES.put("\u5df4\u6797\u53f3\u65d7", 150423);
        AREA_CODES.put("\u6797\u897f\u53bf", 150424);
        AREA_CODES.put("\u514b\u4ec0\u514b\u817e\u65d7", 150425);
        AREA_CODES.put("\u7fc1\u725b\u7279\u65d7", 150426);
        AREA_CODES.put("\u5580\u5587\u6c81\u65d7", 150428);
        AREA_CODES.put("\u5b81\u57ce\u53bf", 150429);
        AREA_CODES.put("\u6556\u6c49\u65d7", 150430);
        AREA_CODES.put("\u901a\u8fbd\u5e02", 150500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 150501);
        AREA_CODES.put("\u79d1\u5c14\u6c81\u533a", 150502);
        AREA_CODES.put("\u79d1\u5c14\u6c81\u5de6\u7ffc\u4e2d\u65d7", 150521);
        AREA_CODES.put("\u79d1\u5c14\u6c81\u5de6\u7ffc\u540e\u65d7", 150522);
        AREA_CODES.put("\u5f00\u9c81\u53bf", 150523);
        AREA_CODES.put("\u5e93\u4f26\u65d7", 150524);
        AREA_CODES.put("\u5948\u66fc\u65d7", 150525);
        AREA_CODES.put("\u624e\u9c81\u7279\u65d7", 150526);
        AREA_CODES.put("\u970d\u6797\u90ed\u52d2\u5e02", 150581);
        AREA_CODES.put("\u9102\u5c14\u591a\u65af\u5e02", 150600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 150601);
        AREA_CODES.put("  \u4e1c\u80dc\u533a", 150602);
        AREA_CODES.put("\u8fbe\u62c9\u7279\u65d7", 150621);
        AREA_CODES.put("\u51c6\u683c\u5c14\u65d7", 150622);
        AREA_CODES.put("\u9102\u6258\u514b\u524d\u65d7", 150623);
        AREA_CODES.put("\u9102\u6258\u514b\u65d7", 150624);
        AREA_CODES.put("\u676d\u9526\u65d7", 150625);
        AREA_CODES.put("\u4e4c\u5ba1\u65d7", 150626);
        AREA_CODES.put("\u4f0a\u91d1\u970d\u6d1b\u65d7", 150627);
        AREA_CODES.put("\u547c\u4f26\u8d1d\u5c14\u5e02", 150700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 150701);
        AREA_CODES.put("\u6d77\u62c9\u5c14\u533a", 150702);
        AREA_CODES.put("\u963f\u8363\u65d7", 150721);
        AREA_CODES.put("\u83ab\u529b\u8fbe\u74e6\u8fbe\u65a1\u5c14\u65cf\u81ea\u6cbb\u65d7", 150722);
        AREA_CODES.put("\u9102\u4f26\u6625\u81ea\u6cbb\u65d7", 150723);
        AREA_CODES.put("\u9102\u6e29\u514b\u65cf\u81ea\u6cbb\u65d7", 150724);
        AREA_CODES.put("\u9648\u5df4\u5c14\u864e\u65d7", 150725);
        AREA_CODES.put("\u65b0\u5df4\u5c14\u864e\u5de6\u65d7", 150726);
        AREA_CODES.put("\u65b0\u5df4\u5c14\u864e\u53f3\u65d7", 150727);
        AREA_CODES.put("\u6ee1\u6d32\u91cc\u5e02", 150781);
        AREA_CODES.put("\u7259\u514b\u77f3\u5e02", 150782);
        AREA_CODES.put("\u624e\u5170\u5c6f\u5e02", 150783);
        AREA_CODES.put("\u989d\u5c14\u53e4\u7eb3\u5e02", 150784);
        AREA_CODES.put("\u6839\u6cb3\u5e02", 150785);
        AREA_CODES.put("\u5df4\u5f66\u6dd6\u5c14\u5e02", 150800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 150801);
        AREA_CODES.put("\u4e34\u6cb3\u533a", 150802);
        AREA_CODES.put("\u4e94\u539f\u53bf", 150821);
        AREA_CODES.put("\u78f4\u53e3\u53bf", 150822);
        AREA_CODES.put("\u4e4c\u62c9\u7279\u524d\u65d7", 150823);
        AREA_CODES.put("\u4e4c\u62c9\u7279\u4e2d\u65d7", 150824);
        AREA_CODES.put("\u4e4c\u62c9\u7279\u540e\u65d7", 150825);
        AREA_CODES.put("\u676d\u9526\u540e\u65d7", 150826);
        AREA_CODES.put("\u4e4c\u5170\u5bdf\u5e03\u5e02", 150900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 150901);
        AREA_CODES.put("\u96c6\u5b81\u533a", 150902);
        AREA_CODES.put("\u5353\u8d44\u53bf", 150921);
        AREA_CODES.put("\u5316\u5fb7\u53bf", 150922);
        AREA_CODES.put("\u5546\u90fd\u53bf", 150923);
        AREA_CODES.put("\u5174\u548c\u53bf", 150924);
        AREA_CODES.put("\u51c9\u57ce\u53bf", 150925);
        AREA_CODES.put("\u5bdf\u54c8\u5c14\u53f3\u7ffc\u524d\u65d7", 150926);
        AREA_CODES.put("\u5bdf\u54c8\u5c14\u53f3\u7ffc\u4e2d\u65d7", 150927);
        AREA_CODES.put("\u5bdf\u54c8\u5c14\u53f3\u7ffc\u540e\u65d7", 150928);
        AREA_CODES.put("\u56db\u5b50\u738b\u65d7", 150929);
        AREA_CODES.put("\u4e30\u9547\u5e02", 150981);
        AREA_CODES.put("\u5174\u5b89\u76df", 152200);
        AREA_CODES.put("\u4e4c\u5170\u6d69\u7279\u5e02", 152201);
        AREA_CODES.put("\u963f\u5c14\u5c71\u5e02", 152202);
        AREA_CODES.put("\u79d1\u5c14\u6c81\u53f3\u7ffc\u524d\u65d7", 152221);
        AREA_CODES.put("\u79d1\u5c14\u6c81\u53f3\u7ffc\u4e2d\u65d7", 152222);
        AREA_CODES.put("\u624e\u8d49\u7279\u65d7", 152223);
        AREA_CODES.put("\u7a81\u6cc9\u53bf", 152224);
        AREA_CODES.put("\u9521\u6797\u90ed\u52d2\u76df", 152500);
        AREA_CODES.put("\u4e8c\u8fde\u6d69\u7279\u5e02", 152501);
        AREA_CODES.put("\u9521\u6797\u6d69\u7279\u5e02", 152502);
        AREA_CODES.put("\u963f\u5df4\u560e\u65d7", 152522);
        AREA_CODES.put("\u82cf\u5c3c\u7279\u5de6\u65d7", 152523);
        AREA_CODES.put("\u82cf\u5c3c\u7279\u53f3\u65d7", 152524);
        AREA_CODES.put("\u4e1c\u4e4c\u73e0\u7a46\u6c81\u65d7", 152525);
        AREA_CODES.put("\u897f\u4e4c\u73e0\u7a46\u6c81\u65d7", 152526);
        AREA_CODES.put("\u592a\u4ec6\u5bfa\u65d7", 152527);
        AREA_CODES.put("\u9576\u9ec4\u65d7", 152528);
        AREA_CODES.put("\u6b63\u9576\u767d\u65d7", 152529);
        AREA_CODES.put("\u6b63\u84dd\u65d7", 152530);
        AREA_CODES.put("\u591a\u4f26\u53bf", 152531);
        AREA_CODES.put("\u963f\u62c9\u5584\u76df", 152900);
        AREA_CODES.put("\u963f\u62c9\u5584\u5de6\u65d7", 152921);
        AREA_CODES.put("\u963f\u62c9\u5584\u53f3\u65d7", 152922);
        AREA_CODES.put("\u989d\u6d4e\u7eb3\u65d7", 152923);
        AREA_CODES.put("\u8fbd\u5b81\u7701", 210000);
        AREA_CODES.put("\u6c88\u9633\u5e02", 210100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 210101);
        AREA_CODES.put("\u548c\u5e73\u533a", 210102);
        AREA_CODES.put("\u6c88\u6cb3\u533a", 210103);
        AREA_CODES.put("\u5927\u4e1c\u533a", 210104);
        AREA_CODES.put("\u7687\u59d1\u533a", 210105);
        AREA_CODES.put("\u94c1\u897f\u533a", 210106);
        AREA_CODES.put("\u82cf\u5bb6\u5c6f\u533a", 210111);
        AREA_CODES.put("\u4e1c\u9675\u533a", 210112);
        AREA_CODES.put("\u6c88\u5317\u65b0\u533a", 210113);
        AREA_CODES.put("\u4e8e\u6d2a\u533a", 210114);
        AREA_CODES.put("\u8fbd\u4e2d\u53bf", 210122);
        AREA_CODES.put("\u5eb7\u5e73\u53bf", 210123);
        AREA_CODES.put("\u6cd5\u5e93\u53bf", 210124);
        AREA_CODES.put("\u65b0\u6c11\u5e02", 210181);
        AREA_CODES.put("\u5927\u8fde\u5e02", 210200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 210201);
        AREA_CODES.put("\u4e2d\u5c71\u533a", 210202);
        AREA_CODES.put("\u897f\u5c97\u533a", 210203);
        AREA_CODES.put("\u6c99\u6cb3\u53e3\u533a", 210204);
        AREA_CODES.put("\u7518\u4e95\u5b50\u533a", 210211);
        AREA_CODES.put("\u65c5\u987a\u53e3\u533a", 210212);
        AREA_CODES.put("\u91d1\u5dde\u533a", 210213);
        AREA_CODES.put("\u957f\u6d77\u53bf", 210224);
        AREA_CODES.put("\u74e6\u623f\u5e97\u5e02", 210281);
        AREA_CODES.put("\u666e\u5170\u5e97\u5e02", 210282);
        AREA_CODES.put("\u5e84\u6cb3\u5e02", 210283);
        AREA_CODES.put("\u978d\u5c71\u5e02", 210300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 210301);
        AREA_CODES.put("\u94c1\u4e1c\u533a", 210302);
        AREA_CODES.put("\u94c1\u897f\u533a", 210303);
        AREA_CODES.put("\u7acb\u5c71\u533a", 210304);
        AREA_CODES.put("\u5343\u5c71\u533a", 210311);
        AREA_CODES.put("\u53f0\u5b89\u53bf", 210321);
        AREA_CODES.put("\u5cab\u5ca9\u6ee1\u65cf\u81ea\u6cbb\u53bf", 210323);
        AREA_CODES.put("\u6d77\u57ce\u5e02", 210381);
        AREA_CODES.put("\u629a\u987a\u5e02", 210400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 210401);
        AREA_CODES.put("\u65b0\u629a\u533a", 210402);
        AREA_CODES.put("\u4e1c\u6d32\u533a", 210403);
        AREA_CODES.put("\u671b\u82b1\u533a", 210404);
        AREA_CODES.put("\u987a\u57ce\u533a", 210411);
        AREA_CODES.put("\u629a\u987a\u53bf", 210421);
        AREA_CODES.put("\u65b0\u5bbe\u6ee1\u65cf\u81ea\u6cbb\u53bf", 210422);
        AREA_CODES.put("\u6e05\u539f\u6ee1\u65cf\u81ea\u6cbb\u53bf", 210423);
        AREA_CODES.put("\u672c\u6eaa\u5e02", 210500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 210501);
        AREA_CODES.put("\u5e73\u5c71\u533a", 210502);
        AREA_CODES.put("\u6eaa\u6e56\u533a", 210503);
        AREA_CODES.put("\u660e\u5c71\u533a", 210504);
        AREA_CODES.put("\u5357\u82ac\u533a", 210505);
        AREA_CODES.put("\u672c\u6eaa\u6ee1\u65cf\u81ea\u6cbb\u53bf", 210521);
        AREA_CODES.put("\u6853\u4ec1\u6ee1\u65cf\u81ea\u6cbb\u53bf", 210522);
        AREA_CODES.put("\u4e39\u4e1c\u5e02", 210600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 210601);
        AREA_CODES.put("\u5143\u5b9d\u533a", 210602);
        AREA_CODES.put("\u632f\u5174\u533a", 210603);
        AREA_CODES.put("\u632f\u5b89\u533a", 210604);
        AREA_CODES.put("\u5bbd\u7538\u6ee1\u65cf\u81ea\u6cbb\u53bf", 210624);
        AREA_CODES.put("\u4e1c\u6e2f\u5e02", 210681);
        AREA_CODES.put("\u51e4\u57ce\u5e02", 210682);
        AREA_CODES.put("\u9526\u5dde\u5e02", 210700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 210701);
        AREA_CODES.put("\u53e4\u5854\u533a", 210702);
        AREA_CODES.put("\u51cc\u6cb3\u533a", 210703);
        AREA_CODES.put("\u592a\u548c\u533a", 210711);
        AREA_CODES.put("\u9ed1\u5c71\u53bf", 210726);
        AREA_CODES.put("\u4e49\u3000\u53bf", 210727);
        AREA_CODES.put("\u51cc\u6d77\u5e02", 210781);
        AREA_CODES.put("\u5317\u9547\u5e02", 210782);
        AREA_CODES.put("\u8425\u53e3\u5e02", 210800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 210801);
        AREA_CODES.put("\u7ad9\u524d\u533a", 210802);
        AREA_CODES.put("\u897f\u5e02\u533a", 210803);
        AREA_CODES.put("\u9c85\u9c7c\u5708\u533a", 210804);
        AREA_CODES.put("\u8001\u8fb9\u533a", 210811);
        AREA_CODES.put("\u76d6\u5dde\u5e02", 210881);
        AREA_CODES.put("\u5927\u77f3\u6865\u5e02", 210882);
        AREA_CODES.put("\u961c\u65b0\u5e02", 210900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 210901);
        AREA_CODES.put("\u6d77\u5dde\u533a", 210902);
        AREA_CODES.put("\u65b0\u90b1\u533a", 210903);
        AREA_CODES.put("\u592a\u5e73\u533a", 210904);
        AREA_CODES.put("\u6e05\u6cb3\u95e8\u533a", 210905);
        AREA_CODES.put("\u7ec6\u6cb3\u533a", 210911);
        AREA_CODES.put("\u961c\u65b0\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 210921);
        AREA_CODES.put("\u5f70\u6b66\u53bf", 210922);
        AREA_CODES.put("\u8fbd\u9633\u5e02", 211000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 211001);
        AREA_CODES.put("\u767d\u5854\u533a", 211002);
        AREA_CODES.put("\u6587\u5723\u533a", 211003);
        AREA_CODES.put("\u5b8f\u4f1f\u533a", 211004);
        AREA_CODES.put("\u5f13\u957f\u5cad\u533a", 211005);
        AREA_CODES.put("\u592a\u5b50\u6cb3\u533a", 211011);
        AREA_CODES.put("\u8fbd\u9633\u53bf", 211021);
        AREA_CODES.put("\u706f\u5854\u5e02", 211081);
        AREA_CODES.put("\u76d8\u9526\u5e02", 211100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 211101);
        AREA_CODES.put("\u53cc\u53f0\u5b50\u533a", 211102);
        AREA_CODES.put("\u5174\u9686\u53f0\u533a", 211103);
        AREA_CODES.put("\u5927\u6d3c\u53bf", 211121);
        AREA_CODES.put("\u76d8\u5c71\u53bf", 211122);
        AREA_CODES.put("\u94c1\u5cad\u5e02", 211200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 211201);
        AREA_CODES.put("\u94f6\u5dde\u533a", 211202);
        AREA_CODES.put("\u6e05\u6cb3\u533a", 211204);
        AREA_CODES.put("\u94c1\u5cad\u53bf", 211221);
        AREA_CODES.put("\u897f\u4e30\u53bf", 211223);
        AREA_CODES.put("\u660c\u56fe\u53bf", 211224);
        AREA_CODES.put("\u8c03\u5175\u5c71\u5e02", 211281);
        AREA_CODES.put("\u5f00\u539f\u5e02", 211282);
        AREA_CODES.put("\u671d\u9633\u5e02", 211300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 211301);
        AREA_CODES.put("\u53cc\u5854\u533a", 211302);
        AREA_CODES.put("\u9f99\u57ce\u533a", 211303);
        AREA_CODES.put("\u671d\u9633\u53bf", 211321);
        AREA_CODES.put("\u5efa\u5e73\u53bf", 211322);
        AREA_CODES.put("\u5580\u5587\u6c81\u5de6\u7ffc\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 211324);
        AREA_CODES.put("\u5317\u7968\u5e02", 211381);
        AREA_CODES.put("\u51cc\u6e90\u5e02", 211382);
        AREA_CODES.put("\u846b\u82a6\u5c9b\u5e02", 211400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 211401);
        AREA_CODES.put("\u8fde\u5c71\u533a", 211402);
        AREA_CODES.put("\u9f99\u6e2f\u533a", 211403);
        AREA_CODES.put("\u5357\u7968\u533a", 211404);
        AREA_CODES.put("\u7ee5\u4e2d\u53bf", 211421);
        AREA_CODES.put("\u5efa\u660c\u53bf", 211422);
        AREA_CODES.put("\u5174\u57ce\u5e02", 211481);
        AREA_CODES.put("\u5409\u6797\u7701", 220000);
        AREA_CODES.put("\u957f\u6625\u5e02", 220100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 220101);
        AREA_CODES.put("\u5357\u5173\u533a", 220102);
        AREA_CODES.put("\u5bbd\u57ce\u533a", 220103);
        AREA_CODES.put("\u671d\u9633\u533a", 220104);
        AREA_CODES.put("\u4e8c\u9053\u533a", 220105);
        AREA_CODES.put("\u7eff\u56ed\u533a", 220106);
        AREA_CODES.put("\u53cc\u9633\u533a", 220112);
        AREA_CODES.put("\u519c\u5b89\u53bf", 220122);
        AREA_CODES.put("\u4e5d\u53f0\u5e02", 220181);
        AREA_CODES.put("\u6986\u6811\u5e02", 220182);
        AREA_CODES.put("\u5fb7\u60e0\u5e02", 220183);
        AREA_CODES.put("\u5409\u6797\u5e02", 220200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 220201);
        AREA_CODES.put("\u660c\u9091\u533a", 220202);
        AREA_CODES.put("\u9f99\u6f6d\u533a", 220203);
        AREA_CODES.put("\u8239\u8425\u533a", 220204);
        AREA_CODES.put("\u4e30\u6ee1\u533a", 220211);
        AREA_CODES.put("\u6c38\u5409\u53bf", 220221);
        AREA_CODES.put("\u86df\u6cb3\u5e02", 220281);
        AREA_CODES.put("\u6866\u7538\u5e02", 220282);
        AREA_CODES.put("\u8212\u5170\u5e02", 220283);
        AREA_CODES.put("\u78d0\u77f3\u5e02", 220284);
        AREA_CODES.put("\u56db\u5e73\u5e02", 220300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 220301);
        AREA_CODES.put("\u94c1\u897f\u533a", 220302);
        AREA_CODES.put("\u94c1\u4e1c\u533a", 220303);
        AREA_CODES.put("\u68a8\u6811\u53bf", 220322);
        AREA_CODES.put("\u4f0a\u901a\u6ee1\u65cf\u81ea\u6cbb\u53bf", 220323);
        AREA_CODES.put("\u516c\u4e3b\u5cad\u5e02", 220381);
        AREA_CODES.put("\u53cc\u8fbd\u5e02", 220382);
        AREA_CODES.put("\u8fbd\u6e90\u5e02", 220400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 220401);
        AREA_CODES.put("\u9f99\u5c71\u533a", 220402);
        AREA_CODES.put("\u897f\u5b89\u533a", 220403);
        AREA_CODES.put("\u4e1c\u4e30\u53bf", 220421);
        AREA_CODES.put("\u4e1c\u8fbd\u53bf", 220422);
        AREA_CODES.put("\u901a\u5316\u5e02", 220500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 220501);
        AREA_CODES.put("\u4e1c\u660c\u533a", 220502);
        AREA_CODES.put("\u4e8c\u9053\u6c5f\u533a", 220503);
        AREA_CODES.put("\u901a\u5316\u53bf", 220521);
        AREA_CODES.put("\u8f89\u5357\u53bf", 220523);
        AREA_CODES.put("\u67f3\u6cb3\u53bf", 220524);
        AREA_CODES.put("\u6885\u6cb3\u53e3\u5e02", 220581);
        AREA_CODES.put("\u96c6\u5b89\u5e02", 220582);
        AREA_CODES.put("\u767d\u5c71\u5e02", 220600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 220601);
        AREA_CODES.put("\u516b\u9053\u6c5f\u533a", 220602);
        AREA_CODES.put("  \u6c5f\u6e90\u533a", 220605);
        AREA_CODES.put("\u629a\u677e\u53bf", 220621);
        AREA_CODES.put("\u9756\u5b87\u53bf", 220622);
        AREA_CODES.put("\u957f\u767d\u671d\u9c9c\u65cf\u81ea\u6cbb\u53bf", 220623);
        AREA_CODES.put("\u4e34\u6c5f\u5e02", 220681);
        AREA_CODES.put("\u677e\u539f\u5e02", 220700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 220701);
        AREA_CODES.put("\u5b81\u6c5f\u533a", 220702);
        AREA_CODES.put("\u524d\u90ed\u5c14\u7f57\u65af\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 220721);
        AREA_CODES.put("\u957f\u5cad\u53bf", 220722);
        AREA_CODES.put("\u4e7e\u5b89\u53bf", 220723);
        AREA_CODES.put("\u6276\u4f59\u53bf", 220724);
        AREA_CODES.put("\u767d\u57ce\u5e02", 220800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 220801);
        AREA_CODES.put("\u6d2e\u5317\u533a", 220802);
        AREA_CODES.put("\u9547\u8d49\u53bf", 220821);
        AREA_CODES.put("\u901a\u6986\u53bf", 220822);
        AREA_CODES.put("\u6d2e\u5357\u5e02", 220881);
        AREA_CODES.put("\u5927\u5b89\u5e02", 220882);
        AREA_CODES.put("\u5ef6\u8fb9\u671d\u9c9c\u65cf\u81ea\u6cbb\u5dde", 222400);
        AREA_CODES.put("\u5ef6\u5409\u5e02", 222401);
        AREA_CODES.put("\u56fe\u4eec\u5e02", 222402);
        AREA_CODES.put("\u6566\u5316\u5e02", 222403);
        AREA_CODES.put("\u73f2\u6625\u5e02", 222404);
        AREA_CODES.put("\u9f99\u4e95\u5e02", 222405);
        AREA_CODES.put("\u548c\u9f99\u5e02", 222406);
        AREA_CODES.put("\u6c6a\u6e05\u53bf", 222424);
        AREA_CODES.put("\u5b89\u56fe\u53bf", 222426);
        AREA_CODES.put("\u9ed1\u9f99\u6c5f\u7701", 230000);
        AREA_CODES.put("\u54c8\u5c14\u6ee8\u5e02", 230100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 230101);
        AREA_CODES.put("\u9053\u91cc\u533a", 230102);
        AREA_CODES.put("\u5357\u5c97\u533a", 230103);
        AREA_CODES.put("\u9053\u5916\u533a", 230104);
        AREA_CODES.put("\u5e73\u623f\u533a", 230108);
        AREA_CODES.put("\u677e\u5317\u533a", 230109);
        AREA_CODES.put("\u9999\u574a\u533a", 230110);
        AREA_CODES.put("\u547c\u5170\u533a", 230111);
        AREA_CODES.put("\u4f9d\u5170\u53bf", 230123);
        AREA_CODES.put("\u65b9\u6b63\u53bf", 230124);
        AREA_CODES.put("\u5bbe\u3000\u53bf", 230125);
        AREA_CODES.put("\u5df4\u5f66\u53bf", 230126);
        AREA_CODES.put("\u6728\u5170\u53bf", 230127);
        AREA_CODES.put("\u901a\u6cb3\u53bf", 230128);
        AREA_CODES.put("\u5ef6\u5bff\u53bf", 230129);
        AREA_CODES.put("\u53cc\u57ce\u5e02", 230182);
        AREA_CODES.put("\u5c1a\u5fd7\u5e02", 230183);
        AREA_CODES.put("\u4e94\u5e38\u5e02", 230184);
        AREA_CODES.put("\u9f50\u9f50\u54c8\u5c14\u5e02", 230200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 230201);
        AREA_CODES.put("\u9f99\u6c99\u533a", 230202);
        AREA_CODES.put("\u5efa\u534e\u533a", 230203);
        AREA_CODES.put("\u94c1\u950b\u533a", 230204);
        AREA_CODES.put("\u6602\u6602\u6eaa\u533a", 230205);
        AREA_CODES.put("\u5bcc\u62c9\u5c14\u57fa\u533a", 230206);
        AREA_CODES.put("\u78be\u5b50\u5c71\u533a", 230207);
        AREA_CODES.put("\u6885\u91cc\u65af\u8fbe\u65a1\u5c14\u65cf\u533a", 230208);
        AREA_CODES.put("\u9f99\u6c5f\u53bf", 230221);
        AREA_CODES.put("\u4f9d\u5b89\u53bf", 230223);
        AREA_CODES.put("\u6cf0\u6765\u53bf", 230224);
        AREA_CODES.put("\u7518\u5357\u53bf", 230225);
        AREA_CODES.put("\u5bcc\u88d5\u53bf", 230227);
        AREA_CODES.put("\u514b\u5c71\u53bf", 230229);
        AREA_CODES.put("\u514b\u4e1c\u53bf", 230230);
        AREA_CODES.put("\u62dc\u6cc9\u53bf", 230231);
        AREA_CODES.put("\u8bb7\u6cb3\u5e02", 230281);
        AREA_CODES.put("\u9e21\u897f\u5e02", 230300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 230301);
        AREA_CODES.put("\u9e21\u51a0\u533a", 230302);
        AREA_CODES.put("\u6052\u5c71\u533a", 230303);
        AREA_CODES.put("\u6ef4\u9053\u533a", 230304);
        AREA_CODES.put("\u68a8\u6811\u533a", 230305);
        AREA_CODES.put("\u57ce\u5b50\u6cb3\u533a", 230306);
        AREA_CODES.put("\u9ebb\u5c71\u533a", 230307);
        AREA_CODES.put("\u9e21\u4e1c\u53bf", 230321);
        AREA_CODES.put("\u864e\u6797\u5e02", 230381);
        AREA_CODES.put("\u5bc6\u5c71\u5e02", 230382);
        AREA_CODES.put("\u9e64\u5c97\u5e02", 230400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 230401);
        AREA_CODES.put("\u5411\u9633\u533a", 230402);
        AREA_CODES.put("\u5de5\u519c\u533a", 230403);
        AREA_CODES.put("\u5357\u5c71\u533a", 230404);
        AREA_CODES.put("\u5174\u5b89\u533a", 230405);
        AREA_CODES.put("\u4e1c\u5c71\u533a", 230406);
        AREA_CODES.put("\u5174\u5c71\u533a", 230407);
        AREA_CODES.put("\u841d\u5317\u53bf", 230421);
        AREA_CODES.put("\u7ee5\u6ee8\u53bf", 230422);
        AREA_CODES.put("\u53cc\u9e2d\u5c71\u5e02", 230500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 230501);
        AREA_CODES.put("\u5c16\u5c71\u533a", 230502);
        AREA_CODES.put("\u5cad\u4e1c\u533a", 230503);
        AREA_CODES.put("\u56db\u65b9\u53f0\u533a", 230505);
        AREA_CODES.put("\u5b9d\u5c71\u533a", 230506);
        AREA_CODES.put("\u96c6\u8d24\u53bf", 230521);
        AREA_CODES.put("\u53cb\u8c0a\u53bf", 230522);
        AREA_CODES.put("\u5b9d\u6e05\u53bf", 230523);
        AREA_CODES.put("\u9976\u6cb3\u53bf", 230524);
        AREA_CODES.put("\u5927\u5e86\u5e02", 230600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 230601);
        AREA_CODES.put("\u8428\u5c14\u56fe\u533a", 230602);
        AREA_CODES.put("\u9f99\u51e4\u533a", 230603);
        AREA_CODES.put("\u8ba9\u80e1\u8def\u533a", 230604);
        AREA_CODES.put("\u7ea2\u5c97\u533a", 230605);
        AREA_CODES.put("\u5927\u540c\u533a", 230606);
        AREA_CODES.put("\u8087\u5dde\u53bf", 230621);
        AREA_CODES.put("\u8087\u6e90\u53bf", 230622);
        AREA_CODES.put("\u6797\u7538\u53bf", 230623);
        AREA_CODES.put("\u675c\u5c14\u4f2f\u7279\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 230624);
        AREA_CODES.put("\u4f0a\u6625\u5e02", 230700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 230701);
        AREA_CODES.put("\u4f0a\u6625\u533a", 230702);
        AREA_CODES.put("\u5357\u5c94\u533a", 230703);
        AREA_CODES.put("\u53cb\u597d\u533a", 230704);
        AREA_CODES.put("\u897f\u6797\u533a", 230705);
        AREA_CODES.put("\u7fe0\u5ce6\u533a", 230706);
        AREA_CODES.put("\u65b0\u9752\u533a", 230707);
        AREA_CODES.put("\u7f8e\u6eaa\u533a", 230708);
        AREA_CODES.put("\u91d1\u5c71\u5c6f\u533a", 230709);
        AREA_CODES.put("\u4e94\u8425\u533a", 230710);
        AREA_CODES.put("\u4e4c\u9a6c\u6cb3\u533a", 230711);
        AREA_CODES.put("\u6c64\u65fa\u6cb3\u533a", 230712);
        AREA_CODES.put("\u5e26\u5cad\u533a", 230713);
        AREA_CODES.put("\u4e4c\u4f0a\u5cad\u533a", 230714);
        AREA_CODES.put("\u7ea2\u661f\u533a", 230715);
        AREA_CODES.put("\u4e0a\u7518\u5cad\u533a", 230716);
        AREA_CODES.put("\u5609\u836b\u53bf", 230722);
        AREA_CODES.put("\u94c1\u529b\u5e02", 230781);
        AREA_CODES.put("\u4f73\u6728\u65af\u5e02", 230800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 230801);
        AREA_CODES.put("\u5411\u9633\u533a", 230803);
        AREA_CODES.put("\u524d\u8fdb\u533a", 230804);
        AREA_CODES.put("\u4e1c\u98ce\u533a", 230805);
        AREA_CODES.put("\u90ca\u3000\u533a", 230811);
        AREA_CODES.put("\u6866\u5357\u53bf", 230822);
        AREA_CODES.put("\u6866\u5ddd\u53bf", 230826);
        AREA_CODES.put("\u6c64\u539f\u53bf", 230828);
        AREA_CODES.put("\u629a\u8fdc\u53bf", 230833);
        AREA_CODES.put("\u540c\u6c5f\u5e02", 230881);
        AREA_CODES.put("\u5bcc\u9526\u5e02", 230882);
        AREA_CODES.put("\u4e03\u53f0\u6cb3\u5e02", 230900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 230901);
        AREA_CODES.put("\u65b0\u5174\u533a", 230902);
        AREA_CODES.put("\u6843\u5c71\u533a", 230903);
        AREA_CODES.put("\u8304\u5b50\u6cb3\u533a", 230904);
        AREA_CODES.put("\u52c3\u5229\u53bf", 230921);
        AREA_CODES.put("\u7261\u4e39\u6c5f\u5e02", 231000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 231001);
        AREA_CODES.put("\u4e1c\u5b89\u533a", 231002);
        AREA_CODES.put("\u9633\u660e\u533a", 231003);
        AREA_CODES.put("\u7231\u6c11\u533a", 231004);
        AREA_CODES.put("\u897f\u5b89\u533a", 231005);
        AREA_CODES.put("\u4e1c\u5b81\u53bf", 231024);
        AREA_CODES.put("\u6797\u53e3\u53bf", 231025);
        AREA_CODES.put("\u7ee5\u82ac\u6cb3\u5e02", 231081);
        AREA_CODES.put("\u6d77\u6797\u5e02", 231083);
        AREA_CODES.put("\u5b81\u5b89\u5e02", 231084);
        AREA_CODES.put("\u7a46\u68f1\u5e02", 231085);
        AREA_CODES.put("\u9ed1\u6cb3\u5e02", 231100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 231101);
        AREA_CODES.put("\u7231\u8f89\u533a", 231102);
        AREA_CODES.put("\u5ae9\u6c5f\u53bf", 231121);
        AREA_CODES.put("\u900a\u514b\u53bf", 231123);
        AREA_CODES.put("\u5b59\u5434\u53bf", 231124);
        AREA_CODES.put("\u5317\u5b89\u5e02", 231181);
        AREA_CODES.put("\u4e94\u5927\u8fde\u6c60\u5e02", 231182);
        AREA_CODES.put("\u7ee5\u5316\u5e02", 231200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 231201);
        AREA_CODES.put("\u5317\u6797\u533a", 231202);
        AREA_CODES.put("\u671b\u594e\u53bf", 231221);
        AREA_CODES.put("\u5170\u897f\u53bf", 231222);
        AREA_CODES.put("\u9752\u5188\u53bf", 231223);
        AREA_CODES.put("\u5e86\u5b89\u53bf", 231224);
        AREA_CODES.put("\u660e\u6c34\u53bf", 231225);
        AREA_CODES.put("\u7ee5\u68f1\u53bf", 231226);
        AREA_CODES.put("\u5b89\u8fbe\u5e02", 231281);
        AREA_CODES.put("\u8087\u4e1c\u5e02", 231282);
        AREA_CODES.put("\u6d77\u4f26\u5e02", 231283);
        AREA_CODES.put("\u5927\u5174\u5b89\u5cad\u5730\u533a", 232700);
        AREA_CODES.put("\u547c\u739b\u53bf", 232721);
        AREA_CODES.put("\u5854\u6cb3\u53bf", 232722);
        AREA_CODES.put("\u6f20\u6cb3\u53bf", 232723);
        AREA_CODES.put("\u4e0a\u6d77\u5e02", 310000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 310100);
        AREA_CODES.put("\u9ec4\u6d66\u533a", 310101);
        AREA_CODES.put("\u5362\u6e7e\u533a", 310103);
        AREA_CODES.put("\u5f90\u6c47\u533a", 310104);
        AREA_CODES.put("\u957f\u5b81\u533a", 310105);
        AREA_CODES.put("\u9759\u5b89\u533a", 310106);
        AREA_CODES.put("\u666e\u9640\u533a", 310107);
        AREA_CODES.put("\u95f8\u5317\u533a", 310108);
        AREA_CODES.put("\u8679\u53e3\u533a", 310109);
        AREA_CODES.put("\u6768\u6d66\u533a", 310110);
        AREA_CODES.put("\u95f5\u884c\u533a", 310112);
        AREA_CODES.put("\u5b9d\u5c71\u533a", 310113);
        AREA_CODES.put("\u5609\u5b9a\u533a", 310114);
        AREA_CODES.put("\u6d66\u4e1c\u65b0\u533a (*)", 310115);
        AREA_CODES.put("\u91d1\u5c71\u533a", 310116);
        AREA_CODES.put("\u677e\u6c5f\u533a", 310117);
        AREA_CODES.put("\u9752\u6d66\u533a", 310118);
        AREA_CODES.put("\u5949\u8d24\u533a", 310120);
        AREA_CODES.put("\u53bf", 310200);
        AREA_CODES.put("\u5d07\u660e\u53bf", 310230);
        AREA_CODES.put("\u6c5f\u82cf\u7701", 320000);
        AREA_CODES.put("\u5357\u4eac\u5e02", 320100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 320101);
        AREA_CODES.put("\u7384\u6b66\u533a", 320102);
        AREA_CODES.put("\u767d\u4e0b\u533a", 320103);
        AREA_CODES.put("\u79e6\u6dee\u533a", 320104);
        AREA_CODES.put("\u5efa\u90ba\u533a", 320105);
        AREA_CODES.put("\u9f13\u697c\u533a", 320106);
        AREA_CODES.put("\u4e0b\u5173\u533a", 320107);
        AREA_CODES.put("\u6d66\u53e3\u533a", 320111);
        AREA_CODES.put("\u6816\u971e\u533a", 320113);
        AREA_CODES.put("\u96e8\u82b1\u53f0\u533a", 320114);
        AREA_CODES.put("\u6c5f\u5b81\u533a", 320115);
        AREA_CODES.put("\u516d\u5408\u533a", 320116);
        AREA_CODES.put("\u6ea7\u6c34\u53bf", 320124);
        AREA_CODES.put("\u9ad8\u6df3\u53bf", 320125);
        AREA_CODES.put("\u65e0\u9521\u5e02", 320200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 320201);
        AREA_CODES.put("\u5d07\u5b89\u533a", 320202);
        AREA_CODES.put("\u5357\u957f\u533a", 320203);
        AREA_CODES.put("\u5317\u5858\u533a", 320204);
        AREA_CODES.put("\u9521\u5c71\u533a", 320205);
        AREA_CODES.put("\u60e0\u5c71\u533a", 320206);
        AREA_CODES.put("\u6ee8\u6e56\u533a", 320211);
        AREA_CODES.put("\u6c5f\u9634\u5e02", 320281);
        AREA_CODES.put("\u5b9c\u5174\u5e02", 320282);
        AREA_CODES.put("\u5f90\u5dde\u5e02", 320300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 320301);
        AREA_CODES.put("\u9f13\u697c\u533a", 320302);
        AREA_CODES.put("\u4e91\u9f99\u533a", 320303);
        AREA_CODES.put("\u4e5d\u91cc\u533a", 320304);
        AREA_CODES.put("\u8d3e\u6c6a\u533a", 320305);
        AREA_CODES.put("\u6cc9\u5c71\u533a", 320311);
        AREA_CODES.put("\u4e30\u3000\u53bf", 320321);
        AREA_CODES.put("\u6c9b\u3000\u53bf", 320322);
        AREA_CODES.put("\u94dc\u5c71\u53bf", 320323);
        AREA_CODES.put("\u7762\u5b81\u53bf", 320324);
        AREA_CODES.put("\u65b0\u6c82\u5e02", 320381);
        AREA_CODES.put("\u90b3\u5dde\u5e02", 320382);
        AREA_CODES.put("\u5e38\u5dde\u5e02", 320400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 320401);
        AREA_CODES.put("\u5929\u5b81\u533a", 320402);
        AREA_CODES.put("\u949f\u697c\u533a", 320404);
        AREA_CODES.put("\u621a\u5885\u5830\u533a", 320405);
        AREA_CODES.put("\u65b0\u5317\u533a", 320411);
        AREA_CODES.put("\u6b66\u8fdb\u533a", 320412);
        AREA_CODES.put("\u6ea7\u9633\u5e02", 320481);
        AREA_CODES.put("\u91d1\u575b\u5e02", 320482);
        AREA_CODES.put("\u82cf\u5dde\u5e02", 320500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 320501);
        AREA_CODES.put("\u6ca7\u6d6a\u533a", 320502);
        AREA_CODES.put("\u5e73\u6c5f\u533a", 320503);
        AREA_CODES.put("\u91d1\u960a\u533a", 320504);
        AREA_CODES.put("\u864e\u4e18\u533a", 320505);
        AREA_CODES.put("\u5434\u4e2d\u533a", 320506);
        AREA_CODES.put("\u76f8\u57ce\u533a", 320507);
        AREA_CODES.put("\u5e38\u719f\u5e02", 320581);
        AREA_CODES.put("\u5f20\u5bb6\u6e2f\u5e02", 320582);
        AREA_CODES.put("\u6606\u5c71\u5e02", 320583);
        AREA_CODES.put("\u5434\u6c5f\u5e02", 320584);
        AREA_CODES.put("\u592a\u4ed3\u5e02", 320585);
        AREA_CODES.put("\u5357\u901a\u5e02", 320600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 320601);
        AREA_CODES.put("\u5d07\u5ddd\u533a", 320602);
        AREA_CODES.put("\u6e2f\u95f8\u533a", 320611);
        AREA_CODES.put("\u6d77\u5b89\u53bf", 320621);
        AREA_CODES.put("\u5982\u4e1c\u53bf", 320623);
        AREA_CODES.put("\u542f\u4e1c\u5e02", 320681);
        AREA_CODES.put("\u5982\u768b\u5e02", 320682);
        AREA_CODES.put("\u6d77\u95e8\u5e02", 320684);
        AREA_CODES.put("\u8fde\u4e91\u6e2f\u5e02", 320700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 320701);
        AREA_CODES.put("\u8fde\u4e91\u533a", 320703);
        AREA_CODES.put("\u65b0\u6d66\u533a", 320705);
        AREA_CODES.put("\u6d77\u5dde\u533a", 320706);
        AREA_CODES.put("\u8d63\u6986\u53bf", 320721);
        AREA_CODES.put("\u4e1c\u6d77\u53bf", 320722);
        AREA_CODES.put("\u704c\u4e91\u53bf", 320723);
        AREA_CODES.put("\u704c\u5357\u53bf", 320724);
        AREA_CODES.put("\u6dee\u5b89\u5e02", 320800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 320801);
        AREA_CODES.put("\u6e05\u6cb3\u533a", 320802);
        AREA_CODES.put("\u695a\u5dde\u533a", 320803);
        AREA_CODES.put("\u6dee\u9634\u533a", 320804);
        AREA_CODES.put("\u6e05\u6d66\u533a", 320811);
        AREA_CODES.put("\u6d9f\u6c34\u53bf", 320826);
        AREA_CODES.put("\u6d2a\u6cfd\u53bf", 320829);
        AREA_CODES.put("\u76f1\u7719\u53bf", 320830);
        AREA_CODES.put("\u91d1\u6e56\u53bf", 320831);
        AREA_CODES.put("\u76d0\u57ce\u5e02", 320900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 320901);
        AREA_CODES.put("\u4ead\u6e56\u533a", 320902);
        AREA_CODES.put("\u76d0\u90fd\u533a", 320903);
        AREA_CODES.put("\u54cd\u6c34\u53bf", 320921);
        AREA_CODES.put("\u6ee8\u6d77\u53bf", 320922);
        AREA_CODES.put("\u961c\u5b81\u53bf", 320923);
        AREA_CODES.put("\u5c04\u9633\u53bf", 320924);
        AREA_CODES.put("\u5efa\u6e56\u53bf", 320925);
        AREA_CODES.put("\u4e1c\u53f0\u5e02", 320981);
        AREA_CODES.put("\u5927\u4e30\u5e02", 320982);
        AREA_CODES.put("\u626c\u5dde\u5e02", 321000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 321001);
        AREA_CODES.put("\u5e7f\u9675\u533a", 321002);
        AREA_CODES.put("\u9097\u6c5f\u533a", 321003);
        AREA_CODES.put("\u7ef4\u626c\u533a", 321011);
        AREA_CODES.put("\u5b9d\u5e94\u53bf", 321023);
        AREA_CODES.put("\u4eea\u5f81\u5e02", 321081);
        AREA_CODES.put("\u9ad8\u90ae\u5e02", 321084);
        AREA_CODES.put("\u6c5f\u90fd\u5e02", 321088);
        AREA_CODES.put("\u9547\u6c5f\u5e02", 321100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 321101);
        AREA_CODES.put("\u4eac\u53e3\u533a", 321102);
        AREA_CODES.put("\u6da6\u5dde\u533a", 321111);
        AREA_CODES.put("\u4e39\u5f92\u533a", 321112);
        AREA_CODES.put("\u4e39\u9633\u5e02", 321181);
        AREA_CODES.put("\u626c\u4e2d\u5e02", 321182);
        AREA_CODES.put("\u53e5\u5bb9\u5e02", 321183);
        AREA_CODES.put("\u6cf0\u5dde\u5e02", 321200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 321201);
        AREA_CODES.put("\u6d77\u9675\u533a", 321202);
        AREA_CODES.put("\u9ad8\u6e2f\u533a", 321203);
        AREA_CODES.put("\u5174\u5316\u5e02", 321281);
        AREA_CODES.put("\u9756\u6c5f\u5e02", 321282);
        AREA_CODES.put("\u6cf0\u5174\u5e02", 321283);
        AREA_CODES.put("\u59dc\u5830\u5e02", 321284);
        AREA_CODES.put("\u5bbf\u8fc1\u5e02", 321300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 321301);
        AREA_CODES.put("\u5bbf\u57ce\u533a", 321302);
        AREA_CODES.put("\u5bbf\u8c6b\u533a", 321311);
        AREA_CODES.put("\u6cad\u9633\u53bf", 321322);
        AREA_CODES.put("\u6cd7\u9633\u53bf", 321323);
        AREA_CODES.put("\u6cd7\u6d2a\u53bf", 321324);
        AREA_CODES.put("\u6d59\u6c5f\u7701", 330000);
        AREA_CODES.put("\u676d\u5dde\u5e02", 330100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 330101);
        AREA_CODES.put("\u4e0a\u57ce\u533a", 330102);
        AREA_CODES.put("\u4e0b\u57ce\u533a", 330103);
        AREA_CODES.put("\u6c5f\u5e72\u533a", 330104);
        AREA_CODES.put("\u62f1\u5885\u533a", 330105);
        AREA_CODES.put("\u897f\u6e56\u533a", 330106);
        AREA_CODES.put("\u6ee8\u6c5f\u533a", 330108);
        AREA_CODES.put("\u8427\u5c71\u533a", 330109);
        AREA_CODES.put("\u4f59\u676d\u533a", 330110);
        AREA_CODES.put("\u6850\u5e90\u53bf", 330122);
        AREA_CODES.put("\u6df3\u5b89\u53bf", 330127);
        AREA_CODES.put("\u5efa\u5fb7\u5e02", 330182);
        AREA_CODES.put("\u5bcc\u9633\u5e02", 330183);
        AREA_CODES.put("\u4e34\u5b89\u5e02", 330185);
        AREA_CODES.put("\u5b81\u6ce2\u5e02", 330200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 330201);
        AREA_CODES.put("\u6d77\u66d9\u533a", 330203);
        AREA_CODES.put("\u6c5f\u4e1c\u533a", 330204);
        AREA_CODES.put("\u6c5f\u5317\u533a", 330205);
        AREA_CODES.put("\u5317\u4ed1\u533a", 330206);
        AREA_CODES.put("\u9547\u6d77\u533a", 330211);
        AREA_CODES.put("\u911e\u5dde\u533a", 330212);
        AREA_CODES.put("\u8c61\u5c71\u53bf", 330225);
        AREA_CODES.put("\u5b81\u6d77\u53bf", 330226);
        AREA_CODES.put("\u4f59\u59da\u5e02", 330281);
        AREA_CODES.put("\u6148\u6eaa\u5e02", 330282);
        AREA_CODES.put("\u5949\u5316\u5e02", 330283);
        AREA_CODES.put("\u6e29\u5dde\u5e02", 330300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 330301);
        AREA_CODES.put("\u9e7f\u57ce\u533a", 330302);
        AREA_CODES.put("\u9f99\u6e7e\u533a", 330303);
        AREA_CODES.put("\u74ef\u6d77\u533a", 330304);
        AREA_CODES.put("\u6d1e\u5934\u53bf", 330322);
        AREA_CODES.put("\u6c38\u5609\u53bf", 330324);
        AREA_CODES.put("\u5e73\u9633\u53bf", 330326);
        AREA_CODES.put("\u82cd\u5357\u53bf", 330327);
        AREA_CODES.put("\u6587\u6210\u53bf", 330328);
        AREA_CODES.put("\u6cf0\u987a\u53bf", 330329);
        AREA_CODES.put("\u745e\u5b89\u5e02", 330381);
        AREA_CODES.put("\u4e50\u6e05\u5e02", 330382);
        AREA_CODES.put("\u5609\u5174\u5e02", 330400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 330401);
        AREA_CODES.put("\u5357\u6e56\u533a", 330402);
        AREA_CODES.put("\u79c0\u6d32\u533a", 330411);
        AREA_CODES.put("\u5609\u5584\u53bf", 330421);
        AREA_CODES.put("\u6d77\u76d0\u53bf", 330424);
        AREA_CODES.put("\u6d77\u5b81\u5e02", 330481);
        AREA_CODES.put("\u5e73\u6e56\u5e02", 330482);
        AREA_CODES.put("\u6850\u4e61\u5e02", 330483);
        AREA_CODES.put("\u6e56\u5dde\u5e02", 330500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 330501);
        AREA_CODES.put("\u5434\u5174\u533a", 330502);
        AREA_CODES.put("\u5357\u6d54\u533a", 330503);
        AREA_CODES.put("\u5fb7\u6e05\u53bf", 330521);
        AREA_CODES.put("\u957f\u5174\u53bf", 330522);
        AREA_CODES.put("\u5b89\u5409\u53bf", 330523);
        AREA_CODES.put("\u7ecd\u5174\u5e02", 330600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 330601);
        AREA_CODES.put("\u8d8a\u57ce\u533a", 330602);
        AREA_CODES.put("\u7ecd\u5174\u53bf", 330621);
        AREA_CODES.put("\u65b0\u660c\u53bf", 330624);
        AREA_CODES.put("\u8bf8\u66a8\u5e02", 330681);
        AREA_CODES.put("\u4e0a\u865e\u5e02", 330682);
        AREA_CODES.put("\u5d4a\u5dde\u5e02", 330683);
        AREA_CODES.put("\u91d1\u534e\u5e02", 330700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 330701);
        AREA_CODES.put("\u5a7a\u57ce\u533a", 330702);
        AREA_CODES.put("\u91d1\u4e1c\u533a", 330703);
        AREA_CODES.put("\u6b66\u4e49\u53bf", 330723);
        AREA_CODES.put("\u6d66\u6c5f\u53bf", 330726);
        AREA_CODES.put("\u78d0\u5b89\u53bf", 330727);
        AREA_CODES.put("\u5170\u6eaa\u5e02", 330781);
        AREA_CODES.put("\u4e49\u4e4c\u5e02", 330782);
        AREA_CODES.put("\u4e1c\u9633\u5e02", 330783);
        AREA_CODES.put("\u6c38\u5eb7\u5e02", 330784);
        AREA_CODES.put("\u8862\u5dde\u5e02", 330800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 330801);
        AREA_CODES.put("\u67ef\u57ce\u533a", 330802);
        AREA_CODES.put("\u8862\u6c5f\u533a", 330803);
        AREA_CODES.put("\u5e38\u5c71\u53bf", 330822);
        AREA_CODES.put("\u5f00\u5316\u53bf", 330824);
        AREA_CODES.put("\u9f99\u6e38\u53bf", 330825);
        AREA_CODES.put("\u6c5f\u5c71\u5e02", 330881);
        AREA_CODES.put("\u821f\u5c71\u5e02", 330900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 330901);
        AREA_CODES.put("\u5b9a\u6d77\u533a", 330902);
        AREA_CODES.put("\u666e\u9640\u533a", 330903);
        AREA_CODES.put("\u5cb1\u5c71\u53bf", 330921);
        AREA_CODES.put("\u5d4a\u6cd7\u53bf", 330922);
        AREA_CODES.put("\u53f0\u5dde\u5e02", 331000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 331001);
        AREA_CODES.put("\u6912\u6c5f\u533a", 331002);
        AREA_CODES.put("\u9ec4\u5ca9\u533a", 331003);
        AREA_CODES.put("\u8def\u6865\u533a", 331004);
        AREA_CODES.put("\u7389\u73af\u53bf", 331021);
        AREA_CODES.put("\u4e09\u95e8\u53bf", 331022);
        AREA_CODES.put("\u5929\u53f0\u53bf", 331023);
        AREA_CODES.put("\u4ed9\u5c45\u53bf", 331024);
        AREA_CODES.put("\u6e29\u5cad\u5e02", 331081);
        AREA_CODES.put("\u4e34\u6d77\u5e02", 331082);
        AREA_CODES.put("\u4e3d\u6c34\u5e02", 331100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 331101);
        AREA_CODES.put("\u83b2\u90fd\u533a", 331102);
        AREA_CODES.put("\u9752\u7530\u53bf", 331121);
        AREA_CODES.put("\u7f19\u4e91\u53bf", 331122);
        AREA_CODES.put("\u9042\u660c\u53bf", 331123);
        AREA_CODES.put("\u677e\u9633\u53bf", 331124);
        AREA_CODES.put("\u4e91\u548c\u53bf", 331125);
        AREA_CODES.put("\u5e86\u5143\u53bf", 331126);
        AREA_CODES.put("\u666f\u5b81\u7572\u65cf\u81ea\u6cbb\u53bf", 331127);
        AREA_CODES.put("\u9f99\u6cc9\u5e02", 331181);
        AREA_CODES.put("\u5b89\u5fbd\u7701", 340000);
        AREA_CODES.put("\u5408\u80a5\u5e02", 340100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 340101);
        AREA_CODES.put("\u7476\u6d77\u533a", 340102);
        AREA_CODES.put("\u5e90\u9633\u533a", 340103);
        AREA_CODES.put("\u8700\u5c71\u533a", 340104);
        AREA_CODES.put("\u5305\u6cb3\u533a", 340111);
        AREA_CODES.put("\u957f\u4e30\u53bf", 340121);
        AREA_CODES.put("\u80a5\u4e1c\u53bf", 340122);
        AREA_CODES.put("\u80a5\u897f\u53bf", 340123);
        AREA_CODES.put("\u829c\u6e56\u5e02", 340200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 340201);
        AREA_CODES.put("\u955c\u6e56\u533a", 340202);
        AREA_CODES.put("\u5f0b\u6c5f\u533a", 340203);
        AREA_CODES.put("\u9e20\u6c5f\u533a", 340207);
        AREA_CODES.put("\u4e09\u5c71\u533a", 340208);
        AREA_CODES.put("\u829c\u6e56\u53bf", 340221);
        AREA_CODES.put("\u7e41\u660c\u53bf", 340222);
        AREA_CODES.put("\u5357\u9675\u53bf", 340223);
        AREA_CODES.put("\u868c\u57e0\u5e02", 340300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 340301);
        AREA_CODES.put("\u9f99\u5b50\u6e56\u533a", 340302);
        AREA_CODES.put("\u868c\u5c71\u533a", 340303);
        AREA_CODES.put("\u79b9\u4f1a\u533a", 340304);
        AREA_CODES.put("\u6dee\u4e0a\u533a", 340311);
        AREA_CODES.put("\u6000\u8fdc\u53bf", 340321);
        AREA_CODES.put("\u4e94\u6cb3\u53bf", 340322);
        AREA_CODES.put("\u56fa\u9547\u53bf", 340323);
        AREA_CODES.put("\u6dee\u5357\u5e02", 340400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 340401);
        AREA_CODES.put("\u5927\u901a\u533a", 340402);
        AREA_CODES.put("\u7530\u5bb6\u5eb5\u533a", 340403);
        AREA_CODES.put("\u8c22\u5bb6\u96c6\u533a", 340404);
        AREA_CODES.put("\u516b\u516c\u5c71\u533a", 340405);
        AREA_CODES.put("\u6f58\u96c6\u533a", 340406);
        AREA_CODES.put("\u51e4\u53f0\u53bf", 340421);
        AREA_CODES.put("\u9a6c\u978d\u5c71\u5e02", 340500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 340501);
        AREA_CODES.put("\u91d1\u5bb6\u5e84\u533a", 340502);
        AREA_CODES.put("\u82b1\u5c71\u533a", 340503);
        AREA_CODES.put("\u96e8\u5c71\u533a", 340504);
        AREA_CODES.put("\u5f53\u6d82\u53bf", 340521);
        AREA_CODES.put("\u6dee\u5317\u5e02", 340600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 340601);
        AREA_CODES.put("\u675c\u96c6\u533a", 340602);
        AREA_CODES.put("\u76f8\u5c71\u533a", 340603);
        AREA_CODES.put("\u70c8\u5c71\u533a", 340604);
        AREA_CODES.put("\u6fc9\u6eaa\u53bf", 340621);
        AREA_CODES.put("\u94dc\u9675\u5e02", 340700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 340701);
        AREA_CODES.put("\u94dc\u5b98\u5c71\u533a", 340702);
        AREA_CODES.put("\u72ee\u5b50\u5c71\u533a", 340703);
        AREA_CODES.put("\u90ca\u3000\u533a", 340711);
        AREA_CODES.put("\u94dc\u9675\u53bf", 340721);
        AREA_CODES.put("\u5b89\u5e86\u5e02", 340800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 340801);
        AREA_CODES.put("\u8fce\u6c5f\u533a", 340802);
        AREA_CODES.put("\u5927\u89c2\u533a", 340803);
        AREA_CODES.put("\u5b9c\u79c0\u533a", 340811);
        AREA_CODES.put("\u6000\u5b81\u53bf", 340822);
        AREA_CODES.put("\u679e\u9633\u53bf", 340823);
        AREA_CODES.put("\u6f5c\u5c71\u53bf", 340824);
        AREA_CODES.put("\u592a\u6e56\u53bf", 340825);
        AREA_CODES.put("\u5bbf\u677e\u53bf", 340826);
        AREA_CODES.put("\u671b\u6c5f\u53bf", 340827);
        AREA_CODES.put("\u5cb3\u897f\u53bf", 340828);
        AREA_CODES.put("\u6850\u57ce\u5e02", 340881);
        AREA_CODES.put("\u9ec4\u5c71\u5e02", 341000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 341001);
        AREA_CODES.put("\u5c6f\u6eaa\u533a", 341002);
        AREA_CODES.put("\u9ec4\u5c71\u533a", 341003);
        AREA_CODES.put("\u5fbd\u5dde\u533a", 341004);
        AREA_CODES.put("\u6b59\u3000\u53bf", 341021);
        AREA_CODES.put("\u4f11\u5b81\u53bf", 341022);
        AREA_CODES.put("\u9edf\u3000\u53bf", 341023);
        AREA_CODES.put("\u7941\u95e8\u53bf", 341024);
        AREA_CODES.put("\u6ec1\u5dde\u5e02", 341100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 341101);
        AREA_CODES.put("\u7405\u740a\u533a", 341102);
        AREA_CODES.put("\u5357\u8c2f\u533a", 341103);
        AREA_CODES.put("\u6765\u5b89\u53bf", 341122);
        AREA_CODES.put("\u5168\u6912\u53bf", 341124);
        AREA_CODES.put("\u5b9a\u8fdc\u53bf", 341125);
        AREA_CODES.put("\u51e4\u9633\u53bf", 341126);
        AREA_CODES.put("\u5929\u957f\u5e02", 341181);
        AREA_CODES.put("\u660e\u5149\u5e02", 341182);
        AREA_CODES.put("\u961c\u9633\u5e02", 341200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 341201);
        AREA_CODES.put("\u988d\u5dde\u533a", 341202);
        AREA_CODES.put("\u988d\u4e1c\u533a", 341203);
        AREA_CODES.put("\u988d\u6cc9\u533a", 341204);
        AREA_CODES.put("\u4e34\u6cc9\u53bf", 341221);
        AREA_CODES.put("\u592a\u548c\u53bf", 341222);
        AREA_CODES.put("\u961c\u5357\u53bf", 341225);
        AREA_CODES.put("\u988d\u4e0a\u53bf", 341226);
        AREA_CODES.put("\u754c\u9996\u5e02", 341282);
        AREA_CODES.put("\u5bbf\u5dde\u5e02", 341300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 341301);
        AREA_CODES.put("\u57c7\u6865\u533a", 341302);
        AREA_CODES.put("\u7800\u5c71\u53bf", 341321);
        AREA_CODES.put("\u8427\u3000\u53bf", 341322);
        AREA_CODES.put("\u7075\u74a7\u53bf", 341323);
        AREA_CODES.put("\u6cd7\u3000\u53bf", 341324);
        AREA_CODES.put("\u5de2\u6e56\u5e02", 341400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 341401);
        AREA_CODES.put("\u5c45\u5de2\u533a", 341402);
        AREA_CODES.put("\u5e90\u6c5f\u53bf", 341421);
        AREA_CODES.put("\u65e0\u4e3a\u53bf", 341422);
        AREA_CODES.put("\u542b\u5c71\u53bf", 341423);
        AREA_CODES.put("\u548c\u3000\u53bf", 341424);
        AREA_CODES.put("\u516d\u5b89\u5e02", 341500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 341501);
        AREA_CODES.put("\u91d1\u5b89\u533a", 341502);
        AREA_CODES.put("\u88d5\u5b89\u533a", 341503);
        AREA_CODES.put("\u5bff\u3000\u53bf", 341521);
        AREA_CODES.put("\u970d\u90b1\u53bf", 341522);
        AREA_CODES.put("\u8212\u57ce\u53bf", 341523);
        AREA_CODES.put("\u91d1\u5be8\u53bf", 341524);
        AREA_CODES.put("\u970d\u5c71\u53bf", 341525);
        AREA_CODES.put("\u4eb3\u5dde\u5e02", 341600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 341601);
        AREA_CODES.put("\u8c2f\u57ce\u533a", 341602);
        AREA_CODES.put("\u6da1\u9633\u53bf", 341621);
        AREA_CODES.put("\u8499\u57ce\u53bf", 341622);
        AREA_CODES.put("\u5229\u8f9b\u53bf", 341623);
        AREA_CODES.put("\u6c60\u5dde\u5e02", 341700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 341701);
        AREA_CODES.put("\u8d35\u6c60\u533a", 341702);
        AREA_CODES.put("\u4e1c\u81f3\u53bf", 341721);
        AREA_CODES.put("\u77f3\u53f0\u53bf", 341722);
        AREA_CODES.put("\u9752\u9633\u53bf", 341723);
        AREA_CODES.put("\u5ba3\u57ce\u5e02", 341800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 341801);
        AREA_CODES.put("\u5ba3\u5dde\u533a", 341802);
        AREA_CODES.put("\u90ce\u6eaa\u53bf", 341821);
        AREA_CODES.put("\u5e7f\u5fb7\u53bf", 341822);
        AREA_CODES.put("\u6cfe\u3000\u53bf", 341823);
        AREA_CODES.put("\u7ee9\u6eaa\u53bf", 341824);
        AREA_CODES.put("\u65cc\u5fb7\u53bf", 341825);
        AREA_CODES.put("\u5b81\u56fd\u5e02", 341881);
        AREA_CODES.put("\u798f\u5efa\u7701", 350000);
        AREA_CODES.put("\u798f\u5dde\u5e02", 350100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 350101);
        AREA_CODES.put("\u9f13\u697c\u533a", 350102);
        AREA_CODES.put("\u53f0\u6c5f\u533a", 350103);
        AREA_CODES.put("\u4ed3\u5c71\u533a", 350104);
        AREA_CODES.put("\u9a6c\u5c3e\u533a", 350105);
        AREA_CODES.put("\u664b\u5b89\u533a", 350111);
        AREA_CODES.put("\u95fd\u4faf\u53bf", 350121);
        AREA_CODES.put("\u8fde\u6c5f\u53bf", 350122);
        AREA_CODES.put("\u7f57\u6e90\u53bf", 350123);
        AREA_CODES.put("\u95fd\u6e05\u53bf", 350124);
        AREA_CODES.put("\u6c38\u6cf0\u53bf", 350125);
        AREA_CODES.put("\u5e73\u6f6d\u53bf", 350128);
        AREA_CODES.put("\u798f\u6e05\u5e02", 350181);
        AREA_CODES.put("\u957f\u4e50\u5e02", 350182);
        AREA_CODES.put("\u53a6\u95e8\u5e02", 350200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 350201);
        AREA_CODES.put("\u601d\u660e\u533a", 350203);
        AREA_CODES.put("\u6d77\u6ca7\u533a", 350205);
        AREA_CODES.put("\u6e56\u91cc\u533a", 350206);
        AREA_CODES.put("\u96c6\u7f8e\u533a", 350211);
        AREA_CODES.put("\u540c\u5b89\u533a", 350212);
        AREA_CODES.put("\u7fd4\u5b89\u533a", 350213);
        AREA_CODES.put("\u8386\u7530\u5e02", 350300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 350301);
        AREA_CODES.put("\u57ce\u53a2\u533a", 350302);
        AREA_CODES.put("\u6db5\u6c5f\u533a", 350303);
        AREA_CODES.put("\u8354\u57ce\u533a", 350304);
        AREA_CODES.put("\u79c0\u5c7f\u533a", 350305);
        AREA_CODES.put("\u4ed9\u6e38\u53bf", 350322);
        AREA_CODES.put("\u4e09\u660e\u5e02", 350400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 350401);
        AREA_CODES.put("\u6885\u5217\u533a", 350402);
        AREA_CODES.put("\u4e09\u5143\u533a", 350403);
        AREA_CODES.put("\u660e\u6eaa\u53bf", 350421);
        AREA_CODES.put("\u6e05\u6d41\u53bf", 350423);
        AREA_CODES.put("\u5b81\u5316\u53bf", 350424);
        AREA_CODES.put("\u5927\u7530\u53bf", 350425);
        AREA_CODES.put("\u5c24\u6eaa\u53bf", 350426);
        AREA_CODES.put("\u6c99\u3000\u53bf", 350427);
        AREA_CODES.put("\u5c06\u4e50\u53bf", 350428);
        AREA_CODES.put("\u6cf0\u5b81\u53bf", 350429);
        AREA_CODES.put("\u5efa\u5b81\u53bf", 350430);
        AREA_CODES.put("\u6c38\u5b89\u5e02", 350481);
        AREA_CODES.put("\u6cc9\u5dde\u5e02", 350500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 350501);
        AREA_CODES.put("\u9ca4\u57ce\u533a", 350502);
        AREA_CODES.put("\u4e30\u6cfd\u533a", 350503);
        AREA_CODES.put("\u6d1b\u6c5f\u533a", 350504);
        AREA_CODES.put("\u6cc9\u6e2f\u533a", 350505);
        AREA_CODES.put("\u60e0\u5b89\u53bf", 350521);
        AREA_CODES.put("\u5b89\u6eaa\u53bf", 350524);
        AREA_CODES.put("\u6c38\u6625\u53bf", 350525);
        AREA_CODES.put("\u5fb7\u5316\u53bf", 350526);
        AREA_CODES.put("\u91d1\u95e8\u53bf", 350527);
        AREA_CODES.put("\u77f3\u72ee\u5e02", 350581);
        AREA_CODES.put("\u664b\u6c5f\u5e02", 350582);
        AREA_CODES.put("\u5357\u5b89\u5e02", 350583);
        AREA_CODES.put("\u6f33\u5dde\u5e02", 350600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 350601);
        AREA_CODES.put("\u8297\u57ce\u533a", 350602);
        AREA_CODES.put("\u9f99\u6587\u533a", 350603);
        AREA_CODES.put("\u4e91\u9704\u53bf", 350622);
        AREA_CODES.put("\u6f33\u6d66\u53bf", 350623);
        AREA_CODES.put("\u8bcf\u5b89\u53bf", 350624);
        AREA_CODES.put("\u957f\u6cf0\u53bf", 350625);
        AREA_CODES.put("\u4e1c\u5c71\u53bf", 350626);
        AREA_CODES.put("\u5357\u9756\u53bf", 350627);
        AREA_CODES.put("\u5e73\u548c\u53bf", 350628);
        AREA_CODES.put("\u534e\u5b89\u53bf", 350629);
        AREA_CODES.put("\u9f99\u6d77\u5e02", 350681);
        AREA_CODES.put("\u5357\u5e73\u5e02", 350700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 350701);
        AREA_CODES.put("\u5ef6\u5e73\u533a", 350702);
        AREA_CODES.put("\u987a\u660c\u53bf", 350721);
        AREA_CODES.put("\u6d66\u57ce\u53bf", 350722);
        AREA_CODES.put("\u5149\u6cfd\u53bf", 350723);
        AREA_CODES.put("\u677e\u6eaa\u53bf", 350724);
        AREA_CODES.put("\u653f\u548c\u53bf", 350725);
        AREA_CODES.put("\u90b5\u6b66\u5e02", 350781);
        AREA_CODES.put("\u6b66\u5937\u5c71\u5e02", 350782);
        AREA_CODES.put("\u5efa\u74ef\u5e02", 350783);
        AREA_CODES.put("\u5efa\u9633\u5e02", 350784);
        AREA_CODES.put("\u9f99\u5ca9\u5e02", 350800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 350801);
        AREA_CODES.put("\u65b0\u7f57\u533a", 350802);
        AREA_CODES.put("\u957f\u6c40\u53bf", 350821);
        AREA_CODES.put("\u6c38\u5b9a\u53bf", 350822);
        AREA_CODES.put("\u4e0a\u676d\u53bf", 350823);
        AREA_CODES.put("\u6b66\u5e73\u53bf", 350824);
        AREA_CODES.put("\u8fde\u57ce\u53bf", 350825);
        AREA_CODES.put("\u6f33\u5e73\u5e02", 350881);
        AREA_CODES.put("\u5b81\u5fb7\u5e02", 350900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 350901);
        AREA_CODES.put("\u8549\u57ce\u533a", 350902);
        AREA_CODES.put("\u971e\u6d66\u53bf", 350921);
        AREA_CODES.put("\u53e4\u7530\u53bf", 350922);
        AREA_CODES.put("\u5c4f\u5357\u53bf", 350923);
        AREA_CODES.put("\u5bff\u5b81\u53bf", 350924);
        AREA_CODES.put("\u5468\u5b81\u53bf", 350925);
        AREA_CODES.put("\u67d8\u8363\u53bf", 350926);
        AREA_CODES.put("\u798f\u5b89\u5e02", 350981);
        AREA_CODES.put("\u798f\u9f0e\u5e02", 350982);
        AREA_CODES.put("\u6c5f\u897f\u7701", 360000);
        AREA_CODES.put("\u5357\u660c\u5e02", 360100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 360101);
        AREA_CODES.put("\u4e1c\u6e56\u533a", 360102);
        AREA_CODES.put("\u897f\u6e56\u533a", 360103);
        AREA_CODES.put("\u9752\u4e91\u8c31\u533a", 360104);
        AREA_CODES.put("\u6e7e\u91cc\u533a", 360105);
        AREA_CODES.put("\u9752\u5c71\u6e56\u533a", 360111);
        AREA_CODES.put("\u5357\u660c\u53bf", 360121);
        AREA_CODES.put("\u65b0\u5efa\u53bf", 360122);
        AREA_CODES.put("\u5b89\u4e49\u53bf", 360123);
        AREA_CODES.put("\u8fdb\u8d24\u53bf", 360124);
        AREA_CODES.put("\u666f\u5fb7\u9547\u5e02", 360200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 360201);
        AREA_CODES.put("\u660c\u6c5f\u533a", 360202);
        AREA_CODES.put("\u73e0\u5c71\u533a", 360203);
        AREA_CODES.put("\u6d6e\u6881\u53bf", 360222);
        AREA_CODES.put("\u4e50\u5e73\u5e02", 360281);
        AREA_CODES.put("\u840d\u4e61\u5e02", 360300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 360301);
        AREA_CODES.put("\u5b89\u6e90\u533a", 360302);
        AREA_CODES.put("\u6e58\u4e1c\u533a", 360313);
        AREA_CODES.put("\u83b2\u82b1\u53bf", 360321);
        AREA_CODES.put("\u4e0a\u6817\u53bf", 360322);
        AREA_CODES.put("\u82a6\u6eaa\u53bf", 360323);
        AREA_CODES.put("\u4e5d\u6c5f\u5e02", 360400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 360401);
        AREA_CODES.put("\u5e90\u5c71\u533a", 360402);
        AREA_CODES.put("\u6d54\u9633\u533a", 360403);
        AREA_CODES.put("\u4e5d\u6c5f\u53bf", 360421);
        AREA_CODES.put("\u6b66\u5b81\u53bf", 360423);
        AREA_CODES.put("\u4fee\u6c34\u53bf", 360424);
        AREA_CODES.put("\u6c38\u4fee\u53bf", 360425);
        AREA_CODES.put("\u5fb7\u5b89\u53bf", 360426);
        AREA_CODES.put("\u661f\u5b50\u53bf", 360427);
        AREA_CODES.put("\u90fd\u660c\u53bf", 360428);
        AREA_CODES.put("\u6e56\u53e3\u53bf", 360429);
        AREA_CODES.put("\u5f6d\u6cfd\u53bf", 360430);
        AREA_CODES.put("\u745e\u660c\u5e02", 360481);
        AREA_CODES.put("\u65b0\u4f59\u5e02", 360500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 360501);
        AREA_CODES.put("\u6e1d\u6c34\u533a", 360502);
        AREA_CODES.put("\u5206\u5b9c\u53bf", 360521);
        AREA_CODES.put("\u9e70\u6f6d\u5e02", 360600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 360601);
        AREA_CODES.put("\u6708\u6e56\u533a", 360602);
        AREA_CODES.put("\u4f59\u6c5f\u53bf", 360622);
        AREA_CODES.put("\u8d35\u6eaa\u5e02", 360681);
        AREA_CODES.put("\u8d63\u5dde\u5e02", 360700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 360701);
        AREA_CODES.put("\u7ae0\u8d21\u533a", 360702);
        AREA_CODES.put("\u8d63\u3000\u53bf", 360721);
        AREA_CODES.put("\u4fe1\u4e30\u53bf", 360722);
        AREA_CODES.put("\u5927\u4f59\u53bf", 360723);
        AREA_CODES.put("\u4e0a\u72b9\u53bf", 360724);
        AREA_CODES.put("\u5d07\u4e49\u53bf", 360725);
        AREA_CODES.put("\u5b89\u8fdc\u53bf", 360726);
        AREA_CODES.put("\u9f99\u5357\u53bf", 360727);
        AREA_CODES.put("\u5b9a\u5357\u53bf", 360728);
        AREA_CODES.put("\u5168\u5357\u53bf", 360729);
        AREA_CODES.put("\u5b81\u90fd\u53bf", 360730);
        AREA_CODES.put("\u4e8e\u90fd\u53bf", 360731);
        AREA_CODES.put("\u5174\u56fd\u53bf", 360732);
        AREA_CODES.put("\u4f1a\u660c\u53bf", 360733);
        AREA_CODES.put("\u5bfb\u4e4c\u53bf", 360734);
        AREA_CODES.put("\u77f3\u57ce\u53bf", 360735);
        AREA_CODES.put("\u745e\u91d1\u5e02", 360781);
        AREA_CODES.put("\u5357\u5eb7\u5e02", 360782);
        AREA_CODES.put("\u5409\u5b89\u5e02", 360800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 360801);
        AREA_CODES.put("\u5409\u5dde\u533a", 360802);
        AREA_CODES.put("\u9752\u539f\u533a", 360803);
        AREA_CODES.put("\u5409\u5b89\u53bf", 360821);
        AREA_CODES.put("\u5409\u6c34\u53bf", 360822);
        AREA_CODES.put("\u5ce1\u6c5f\u53bf", 360823);
        AREA_CODES.put("\u65b0\u5e72\u53bf", 360824);
        AREA_CODES.put("\u6c38\u4e30\u53bf", 360825);
        AREA_CODES.put("\u6cf0\u548c\u53bf", 360826);
        AREA_CODES.put("\u9042\u5ddd\u53bf", 360827);
        AREA_CODES.put("\u4e07\u5b89\u53bf", 360828);
        AREA_CODES.put("\u5b89\u798f\u53bf", 360829);
        AREA_CODES.put("\u6c38\u65b0\u53bf", 360830);
        AREA_CODES.put("\u4e95\u5188\u5c71\u5e02", 360881);
        AREA_CODES.put("\u5b9c\u6625\u5e02", 360900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 360901);
        AREA_CODES.put("\u8881\u5dde\u533a", 360902);
        AREA_CODES.put("\u5949\u65b0\u53bf", 360921);
        AREA_CODES.put("\u4e07\u8f7d\u53bf", 360922);
        AREA_CODES.put("\u4e0a\u9ad8\u53bf", 360923);
        AREA_CODES.put("\u5b9c\u4e30\u53bf", 360924);
        AREA_CODES.put("\u9756\u5b89\u53bf", 360925);
        AREA_CODES.put("\u94dc\u9f13\u53bf", 360926);
        AREA_CODES.put("\u4e30\u57ce\u5e02", 360981);
        AREA_CODES.put("\u6a1f\u6811\u5e02", 360982);
        AREA_CODES.put("\u9ad8\u5b89\u5e02", 360983);
        AREA_CODES.put("\u629a\u5dde\u5e02", 361000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 361001);
        AREA_CODES.put("\u4e34\u5ddd\u533a", 361002);
        AREA_CODES.put("\u5357\u57ce\u53bf", 361021);
        AREA_CODES.put("\u9ece\u5ddd\u53bf", 361022);
        AREA_CODES.put("\u5357\u4e30\u53bf", 361023);
        AREA_CODES.put("\u5d07\u4ec1\u53bf", 361024);
        AREA_CODES.put("\u4e50\u5b89\u53bf", 361025);
        AREA_CODES.put("\u5b9c\u9ec4\u53bf", 361026);
        AREA_CODES.put("\u91d1\u6eaa\u53bf", 361027);
        AREA_CODES.put("\u8d44\u6eaa\u53bf", 361028);
        AREA_CODES.put("\u4e1c\u4e61\u53bf", 361029);
        AREA_CODES.put("\u5e7f\u660c\u53bf", 361030);
        AREA_CODES.put("\u4e0a\u9976\u5e02", 361100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 361101);
        AREA_CODES.put("\u4fe1\u5dde\u533a", 361102);
        AREA_CODES.put("\u4e0a\u9976\u53bf", 361121);
        AREA_CODES.put("\u5e7f\u4e30\u53bf", 361122);
        AREA_CODES.put("\u7389\u5c71\u53bf", 361123);
        AREA_CODES.put("\u94c5\u5c71\u53bf", 361124);
        AREA_CODES.put("\u6a2a\u5cf0\u53bf", 361125);
        AREA_CODES.put("\u5f0b\u9633\u53bf", 361126);
        AREA_CODES.put("\u4f59\u5e72\u53bf", 361127);
        AREA_CODES.put("\u9131\u9633\u53bf", 361128);
        AREA_CODES.put("\u4e07\u5e74\u53bf", 361129);
        AREA_CODES.put("\u5a7a\u6e90\u53bf", 361130);
        AREA_CODES.put("\u5fb7\u5174\u5e02", 361181);
        AREA_CODES.put("\u5c71\u4e1c\u7701", 370000);
        AREA_CODES.put("\u6d4e\u5357\u5e02", 370100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 370101);
        AREA_CODES.put("\u5386\u4e0b\u533a", 370102);
        AREA_CODES.put("\u5e02\u4e2d\u533a", 370103);
        AREA_CODES.put("\u69d0\u836b\u533a", 370104);
        AREA_CODES.put("\u5929\u6865\u533a", 370105);
        AREA_CODES.put("\u5386\u57ce\u533a", 370112);
        AREA_CODES.put("\u957f\u6e05\u533a", 370113);
        AREA_CODES.put("\u5e73\u9634\u53bf", 370124);
        AREA_CODES.put("\u6d4e\u9633\u53bf", 370125);
        AREA_CODES.put("\u5546\u6cb3\u53bf", 370126);
        AREA_CODES.put("\u7ae0\u4e18\u5e02", 370181);
        AREA_CODES.put("\u9752\u5c9b\u5e02", 370200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 370201);
        AREA_CODES.put("\u5e02\u5357\u533a", 370202);
        AREA_CODES.put("\u5e02\u5317\u533a", 370203);
        AREA_CODES.put("\u56db\u65b9\u533a", 370205);
        AREA_CODES.put("\u9ec4\u5c9b\u533a", 370211);
        AREA_CODES.put("\u5d02\u5c71\u533a", 370212);
        AREA_CODES.put("\u674e\u6ca7\u533a", 370213);
        AREA_CODES.put("\u57ce\u9633\u533a", 370214);
        AREA_CODES.put("\u80f6\u5dde\u5e02", 370281);
        AREA_CODES.put("\u5373\u58a8\u5e02", 370282);
        AREA_CODES.put("\u5e73\u5ea6\u5e02", 370283);
        AREA_CODES.put("\u80f6\u5357\u5e02", 370284);
        AREA_CODES.put("\u83b1\u897f\u5e02", 370285);
        AREA_CODES.put("\u6dc4\u535a\u5e02", 370300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 370301);
        AREA_CODES.put("\u6dc4\u5ddd\u533a", 370302);
        AREA_CODES.put("\u5f20\u5e97\u533a", 370303);
        AREA_CODES.put("\u535a\u5c71\u533a", 370304);
        AREA_CODES.put("\u4e34\u6dc4\u533a", 370305);
        AREA_CODES.put("\u5468\u6751\u533a", 370306);
        AREA_CODES.put("\u6853\u53f0\u53bf", 370321);
        AREA_CODES.put("\u9ad8\u9752\u53bf", 370322);
        AREA_CODES.put("\u6c82\u6e90\u53bf", 370323);
        AREA_CODES.put("\u67a3\u5e84\u5e02", 370400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 370401);
        AREA_CODES.put("\u5e02\u4e2d\u533a", 370402);
        AREA_CODES.put("\u859b\u57ce\u533a", 370403);
        AREA_CODES.put("\u5cc4\u57ce\u533a", 370404);
        AREA_CODES.put("\u53f0\u513f\u5e84\u533a", 370405);
        AREA_CODES.put("\u5c71\u4ead\u533a", 370406);
        AREA_CODES.put("\u6ed5\u5dde\u5e02", 370481);
        AREA_CODES.put("\u4e1c\u8425\u5e02", 370500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 370501);
        AREA_CODES.put("\u4e1c\u8425\u533a", 370502);
        AREA_CODES.put("\u6cb3\u53e3\u533a", 370503);
        AREA_CODES.put("\u57a6\u5229\u53bf", 370521);
        AREA_CODES.put("\u5229\u6d25\u53bf", 370522);
        AREA_CODES.put("\u5e7f\u9976\u53bf", 370523);
        AREA_CODES.put("\u70df\u53f0\u5e02", 370600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 370601);
        AREA_CODES.put("\u829d\u7f58\u533a", 370602);
        AREA_CODES.put("\u798f\u5c71\u533a", 370611);
        AREA_CODES.put("\u725f\u5e73\u533a", 370612);
        AREA_CODES.put("\u83b1\u5c71\u533a", 370613);
        AREA_CODES.put("\u957f\u5c9b\u53bf", 370634);
        AREA_CODES.put("\u9f99\u53e3\u5e02", 370681);
        AREA_CODES.put("\u83b1\u9633\u5e02", 370682);
        AREA_CODES.put("\u83b1\u5dde\u5e02", 370683);
        AREA_CODES.put("\u84ec\u83b1\u5e02", 370684);
        AREA_CODES.put("\u62db\u8fdc\u5e02", 370685);
        AREA_CODES.put("\u6816\u971e\u5e02", 370686);
        AREA_CODES.put("\u6d77\u9633\u5e02", 370687);
        AREA_CODES.put("\u6f4d\u574a\u5e02", 370700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 370701);
        AREA_CODES.put("\u6f4d\u57ce\u533a", 370702);
        AREA_CODES.put("\u5bd2\u4ead\u533a", 370703);
        AREA_CODES.put("\u574a\u5b50\u533a", 370704);
        AREA_CODES.put("\u594e\u6587\u533a", 370705);
        AREA_CODES.put("\u4e34\u6710\u53bf", 370724);
        AREA_CODES.put("\u660c\u4e50\u53bf", 370725);
        AREA_CODES.put("\u9752\u5dde\u5e02", 370781);
        AREA_CODES.put("\u8bf8\u57ce\u5e02", 370782);
        AREA_CODES.put("\u5bff\u5149\u5e02", 370783);
        AREA_CODES.put("\u5b89\u4e18\u5e02", 370784);
        AREA_CODES.put("\u9ad8\u5bc6\u5e02", 370785);
        AREA_CODES.put("\u660c\u9091\u5e02", 370786);
        AREA_CODES.put("\u6d4e\u5b81\u5e02", 370800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 370801);
        AREA_CODES.put("\u5e02\u4e2d\u533a", 370802);
        AREA_CODES.put("\u4efb\u57ce\u533a", 370811);
        AREA_CODES.put("\u5fae\u5c71\u53bf", 370826);
        AREA_CODES.put("\u9c7c\u53f0\u53bf", 370827);
        AREA_CODES.put("\u91d1\u4e61\u53bf", 370828);
        AREA_CODES.put("\u5609\u7965\u53bf", 370829);
        AREA_CODES.put("\u6c76\u4e0a\u53bf", 370830);
        AREA_CODES.put("\u6cd7\u6c34\u53bf", 370831);
        AREA_CODES.put("\u6881\u5c71\u53bf", 370832);
        AREA_CODES.put("\u66f2\u961c\u5e02", 370881);
        AREA_CODES.put("\u5156\u5dde\u5e02", 370882);
        AREA_CODES.put("\u90b9\u57ce\u5e02", 370883);
        AREA_CODES.put("\u6cf0\u5b89\u5e02", 370900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 370901);
        AREA_CODES.put("\u6cf0\u5c71\u533a", 370902);
        AREA_CODES.put("\u5cb1\u5cb3\u533a", 370911);
        AREA_CODES.put("\u5b81\u9633\u53bf", 370921);
        AREA_CODES.put("\u4e1c\u5e73\u53bf", 370923);
        AREA_CODES.put("\u65b0\u6cf0\u5e02", 370982);
        AREA_CODES.put("\u80a5\u57ce\u5e02", 370983);
        AREA_CODES.put("\u5a01\u6d77\u5e02", 371000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 371001);
        AREA_CODES.put("\u73af\u7fe0\u533a", 371002);
        AREA_CODES.put("\u6587\u767b\u5e02", 371081);
        AREA_CODES.put("\u8363\u6210\u5e02", 371082);
        AREA_CODES.put("\u4e73\u5c71\u5e02", 371083);
        AREA_CODES.put("\u65e5\u7167\u5e02", 371100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 371101);
        AREA_CODES.put("\u4e1c\u6e2f\u533a", 371102);
        AREA_CODES.put("\u5c9a\u5c71\u533a", 371103);
        AREA_CODES.put("\u4e94\u83b2\u53bf", 371121);
        AREA_CODES.put("\u8392\u3000\u53bf", 371122);
        AREA_CODES.put("\u83b1\u829c\u5e02", 371200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 371201);
        AREA_CODES.put("\u83b1\u57ce\u533a", 371202);
        AREA_CODES.put("\u94a2\u57ce\u533a", 371203);
        AREA_CODES.put("\u4e34\u6c82\u5e02", 371300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 371301);
        AREA_CODES.put("\u5170\u5c71\u533a", 371302);
        AREA_CODES.put("\u7f57\u5e84\u533a", 371311);
        AREA_CODES.put("\u6cb3\u4e1c\u533a", 371312);
        AREA_CODES.put("\u6c82\u5357\u53bf", 371321);
        AREA_CODES.put("\u90ef\u57ce\u53bf", 371322);
        AREA_CODES.put("\u6c82\u6c34\u53bf", 371323);
        AREA_CODES.put("\u82cd\u5c71\u53bf", 371324);
        AREA_CODES.put("\u8d39\u3000\u53bf", 371325);
        AREA_CODES.put("\u5e73\u9091\u53bf", 371326);
        AREA_CODES.put("\u8392\u5357\u53bf", 371327);
        AREA_CODES.put("\u8499\u9634\u53bf", 371328);
        AREA_CODES.put("\u4e34\u6cad\u53bf", 371329);
        AREA_CODES.put("\u5fb7\u5dde\u5e02", 371400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 371401);
        AREA_CODES.put("\u5fb7\u57ce\u533a", 371402);
        AREA_CODES.put("\u9675\u3000\u53bf", 371421);
        AREA_CODES.put("\u5b81\u6d25\u53bf", 371422);
        AREA_CODES.put("\u5e86\u4e91\u53bf", 371423);
        AREA_CODES.put("\u4e34\u9091\u53bf", 371424);
        AREA_CODES.put("\u9f50\u6cb3\u53bf", 371425);
        AREA_CODES.put("\u5e73\u539f\u53bf", 371426);
        AREA_CODES.put("\u590f\u6d25\u53bf", 371427);
        AREA_CODES.put("\u6b66\u57ce\u53bf", 371428);
        AREA_CODES.put("\u4e50\u9675\u5e02", 371481);
        AREA_CODES.put("\u79b9\u57ce\u5e02", 371482);
        AREA_CODES.put("\u804a\u57ce\u5e02", 371500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 371501);
        AREA_CODES.put("\u4e1c\u660c\u5e9c\u533a", 371502);
        AREA_CODES.put("\u9633\u8c37\u53bf", 371521);
        AREA_CODES.put("\u8398\u3000\u53bf", 371522);
        AREA_CODES.put("\u830c\u5e73\u53bf", 371523);
        AREA_CODES.put("\u4e1c\u963f\u53bf", 371524);
        AREA_CODES.put("\u51a0\u3000\u53bf", 371525);
        AREA_CODES.put("\u9ad8\u5510\u53bf", 371526);
        AREA_CODES.put("\u4e34\u6e05\u5e02", 371581);
        AREA_CODES.put("\u6ee8\u5dde\u5e02", 371600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 371601);
        AREA_CODES.put("\u6ee8\u57ce\u533a", 371602);
        AREA_CODES.put("\u60e0\u6c11\u53bf", 371621);
        AREA_CODES.put("\u9633\u4fe1\u53bf", 371622);
        AREA_CODES.put("\u65e0\u68e3\u53bf", 371623);
        AREA_CODES.put("\u6cbe\u5316\u53bf", 371624);
        AREA_CODES.put("\u535a\u5174\u53bf", 371625);
        AREA_CODES.put("\u90b9\u5e73\u53bf", 371626);
        AREA_CODES.put("\u83cf\u6cfd\u5e02", 371700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 371701);
        AREA_CODES.put("\u7261\u4e39\u533a", 371702);
        AREA_CODES.put("\u66f9\u3000\u53bf", 371721);
        AREA_CODES.put("\u5355\u3000\u53bf", 371722);
        AREA_CODES.put("\u6210\u6b66\u53bf", 371723);
        AREA_CODES.put("\u5de8\u91ce\u53bf", 371724);
        AREA_CODES.put("\u90d3\u57ce\u53bf", 371725);
        AREA_CODES.put("\u9104\u57ce\u53bf", 371726);
        AREA_CODES.put("\u5b9a\u9676\u53bf", 371727);
        AREA_CODES.put("\u4e1c\u660e\u53bf", 371728);
        AREA_CODES.put("\u6cb3\u5357\u7701", 410000);
        AREA_CODES.put("\u90d1\u5dde\u5e02", 410100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 410101);
        AREA_CODES.put("\u4e2d\u539f\u533a", 410102);
        AREA_CODES.put("\u4e8c\u4e03\u533a", 410103);
        AREA_CODES.put("\u7ba1\u57ce\u56de\u65cf\u533a", 410104);
        AREA_CODES.put("\u91d1\u6c34\u533a", 410105);
        AREA_CODES.put("\u4e0a\u8857\u533a", 410106);
        AREA_CODES.put("\u60e0\u6d4e\u533a", 410108);
        AREA_CODES.put("\u4e2d\u725f\u53bf", 410122);
        AREA_CODES.put("\u5de9\u4e49\u5e02", 410181);
        AREA_CODES.put("\u8365\u9633\u5e02", 410182);
        AREA_CODES.put("\u65b0\u5bc6\u5e02", 410183);
        AREA_CODES.put("\u65b0\u90d1\u5e02", 410184);
        AREA_CODES.put("\u767b\u5c01\u5e02", 410185);
        AREA_CODES.put("\u5f00\u5c01\u5e02", 410200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 410201);
        AREA_CODES.put("\u9f99\u4ead\u533a", 410202);
        AREA_CODES.put("\u987a\u6cb3\u56de\u65cf\u533a", 410203);
        AREA_CODES.put("\u9f13\u697c\u533a", 410204);
        AREA_CODES.put("\u79b9\u738b\u53f0\u533a", 410205);
        AREA_CODES.put("\u91d1\u660e\u533a", 410211);
        AREA_CODES.put("\u675e\u3000\u53bf", 410221);
        AREA_CODES.put("\u901a\u8bb8\u53bf", 410222);
        AREA_CODES.put("\u5c09\u6c0f\u53bf", 410223);
        AREA_CODES.put("\u5f00\u5c01\u53bf", 410224);
        AREA_CODES.put("\u5170\u8003\u53bf", 410225);
        AREA_CODES.put("\u6d1b\u9633\u5e02", 410300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 410301);
        AREA_CODES.put("\u8001\u57ce\u533a", 410302);
        AREA_CODES.put("\u897f\u5de5\u533a", 410303);
        AREA_CODES.put("\u700d\u6cb3\u56de\u65cf\u533a", 410304);
        AREA_CODES.put("\u6da7\u897f\u533a", 410305);
        AREA_CODES.put("\u5409\u5229\u533a", 410306);
        AREA_CODES.put("\u6d1b\u9f99\u533a", 410311);
        AREA_CODES.put("\u5b5f\u6d25\u53bf", 410322);
        AREA_CODES.put("\u65b0\u5b89\u53bf", 410323);
        AREA_CODES.put("\u683e\u5ddd\u53bf", 410324);
        AREA_CODES.put("\u5d69\u3000\u53bf", 410325);
        AREA_CODES.put("\u6c5d\u9633\u53bf", 410326);
        AREA_CODES.put("\u5b9c\u9633\u53bf", 410327);
        AREA_CODES.put("\u6d1b\u5b81\u53bf", 410328);
        AREA_CODES.put("\u4f0a\u5ddd\u53bf", 410329);
        AREA_CODES.put("\u5043\u5e08\u5e02", 410381);
        AREA_CODES.put("\u5e73\u9876\u5c71\u5e02", 410400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 410401);
        AREA_CODES.put("\u65b0\u534e\u533a", 410402);
        AREA_CODES.put("\u536b\u4e1c\u533a", 410403);
        AREA_CODES.put("\u77f3\u9f99\u533a", 410404);
        AREA_CODES.put("\u6e5b\u6cb3\u533a", 410411);
        AREA_CODES.put("\u5b9d\u4e30\u53bf", 410421);
        AREA_CODES.put("\u53f6\u3000\u53bf", 410422);
        AREA_CODES.put("\u9c81\u5c71\u53bf", 410423);
        AREA_CODES.put("\u90cf\u3000\u53bf", 410425);
        AREA_CODES.put("\u821e\u94a2\u5e02", 410481);
        AREA_CODES.put("\u6c5d\u5dde\u5e02", 410482);
        AREA_CODES.put("\u5b89\u9633\u5e02", 410500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 410501);
        AREA_CODES.put("\u6587\u5cf0\u533a", 410502);
        AREA_CODES.put("\u5317\u5173\u533a", 410503);
        AREA_CODES.put("\u6bb7\u90fd\u533a", 410505);
        AREA_CODES.put("\u9f99\u5b89\u533a", 410506);
        AREA_CODES.put("\u5b89\u9633\u53bf", 410522);
        AREA_CODES.put("\u6c64\u9634\u53bf", 410523);
        AREA_CODES.put("\u6ed1\u3000\u53bf", 410526);
        AREA_CODES.put("\u5185\u9ec4\u53bf", 410527);
        AREA_CODES.put("\u6797\u5dde\u5e02", 410581);
        AREA_CODES.put("\u9e64\u58c1\u5e02", 410600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 410601);
        AREA_CODES.put("\u9e64\u5c71\u533a", 410602);
        AREA_CODES.put("\u5c71\u57ce\u533a", 410603);
        AREA_CODES.put("\u6dc7\u6ee8\u533a", 410611);
        AREA_CODES.put("\u6d5a\u3000\u53bf", 410621);
        AREA_CODES.put("\u6dc7\u3000\u53bf", 410622);
        AREA_CODES.put("\u65b0\u4e61\u5e02", 410700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 410701);
        AREA_CODES.put("\u7ea2\u65d7\u533a", 410702);
        AREA_CODES.put("\u536b\u6ee8\u533a", 410703);
        AREA_CODES.put("\u51e4\u6cc9\u533a", 410704);
        AREA_CODES.put("\u7267\u91ce\u533a", 410711);
        AREA_CODES.put("\u65b0\u4e61\u53bf", 410721);
        AREA_CODES.put("\u83b7\u5609\u53bf", 410724);
        AREA_CODES.put("\u539f\u9633\u53bf", 410725);
        AREA_CODES.put("\u5ef6\u6d25\u53bf", 410726);
        AREA_CODES.put("\u5c01\u4e18\u53bf", 410727);
        AREA_CODES.put("\u957f\u57a3\u53bf", 410728);
        AREA_CODES.put("\u536b\u8f89\u5e02", 410781);
        AREA_CODES.put("\u8f89\u53bf\u5e02", 410782);
        AREA_CODES.put("\u7126\u4f5c\u5e02", 410800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 410801);
        AREA_CODES.put("\u89e3\u653e\u533a", 410802);
        AREA_CODES.put("\u4e2d\u7ad9\u533a", 410803);
        AREA_CODES.put("\u9a6c\u6751\u533a", 410804);
        AREA_CODES.put("\u5c71\u9633\u533a", 410811);
        AREA_CODES.put("\u4fee\u6b66\u53bf", 410821);
        AREA_CODES.put("\u535a\u7231\u53bf", 410822);
        AREA_CODES.put("\u6b66\u965f\u53bf", 410823);
        AREA_CODES.put("\u6e29\u3000\u53bf", 410825);
        AREA_CODES.put("\u6c81\u9633\u5e02", 410882);
        AREA_CODES.put("\u5b5f\u5dde\u5e02", 410883);
        AREA_CODES.put("\u6fee\u9633\u5e02", 410900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 410901);
        AREA_CODES.put("\u534e\u9f99\u533a", 410902);
        AREA_CODES.put("\u6e05\u4e30\u53bf", 410922);
        AREA_CODES.put("\u5357\u4e50\u53bf", 410923);
        AREA_CODES.put("\u8303\u3000\u53bf", 410926);
        AREA_CODES.put("\u53f0\u524d\u53bf", 410927);
        AREA_CODES.put("\u6fee\u9633\u53bf", 410928);
        AREA_CODES.put("\u8bb8\u660c\u5e02", 411000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 411001);
        AREA_CODES.put("\u9b4f\u90fd\u533a", 411002);
        AREA_CODES.put("\u8bb8\u660c\u53bf", 411023);
        AREA_CODES.put("\u9122\u9675\u53bf", 411024);
        AREA_CODES.put("\u8944\u57ce\u53bf", 411025);
        AREA_CODES.put("\u79b9\u5dde\u5e02", 411081);
        AREA_CODES.put("\u957f\u845b\u5e02", 411082);
        AREA_CODES.put("\u6f2f\u6cb3\u5e02", 411100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 411101);
        AREA_CODES.put("\u6e90\u6c47\u533a", 411102);
        AREA_CODES.put("\u90fe\u57ce\u533a", 411103);
        AREA_CODES.put("\u53ec\u9675\u533a", 411104);
        AREA_CODES.put("\u821e\u9633\u53bf", 411121);
        AREA_CODES.put("\u4e34\u988d\u53bf", 411122);
        AREA_CODES.put("\u4e09\u95e8\u5ce1\u5e02", 411200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 411201);
        AREA_CODES.put("\u6e56\u6ee8\u533a", 411202);
        AREA_CODES.put("\u6e11\u6c60\u53bf", 411221);
        AREA_CODES.put("\u9655\u3000\u53bf", 411222);
        AREA_CODES.put("\u5362\u6c0f\u53bf", 411224);
        AREA_CODES.put("\u4e49\u9a6c\u5e02", 411281);
        AREA_CODES.put("\u7075\u5b9d\u5e02", 411282);
        AREA_CODES.put("\u5357\u9633\u5e02", 411300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 411301);
        AREA_CODES.put("\u5b9b\u57ce\u533a", 411302);
        AREA_CODES.put("\u5367\u9f99\u533a", 411303);
        AREA_CODES.put("\u5357\u53ec\u53bf", 411321);
        AREA_CODES.put("\u65b9\u57ce\u53bf", 411322);
        AREA_CODES.put("\u897f\u5ce1\u53bf", 411323);
        AREA_CODES.put("\u9547\u5e73\u53bf", 411324);
        AREA_CODES.put("\u5185\u4e61\u53bf", 411325);
        AREA_CODES.put("\u6dc5\u5ddd\u53bf", 411326);
        AREA_CODES.put("\u793e\u65d7\u53bf", 411327);
        AREA_CODES.put("\u5510\u6cb3\u53bf", 411328);
        AREA_CODES.put("\u65b0\u91ce\u53bf", 411329);
        AREA_CODES.put("\u6850\u67cf\u53bf", 411330);
        AREA_CODES.put("\u9093\u5dde\u5e02", 411381);
        AREA_CODES.put("\u5546\u4e18\u5e02", 411400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 411401);
        AREA_CODES.put("\u6881\u56ed\u533a", 411402);
        AREA_CODES.put("\u7762\u9633\u533a", 411403);
        AREA_CODES.put("\u6c11\u6743\u53bf", 411421);
        AREA_CODES.put("\u7762\u3000\u53bf", 411422);
        AREA_CODES.put("\u5b81\u9675\u53bf", 411423);
        AREA_CODES.put("\u67d8\u57ce\u53bf", 411424);
        AREA_CODES.put("\u865e\u57ce\u53bf", 411425);
        AREA_CODES.put("\u590f\u9091\u53bf", 411426);
        AREA_CODES.put("\u6c38\u57ce\u5e02", 411481);
        AREA_CODES.put("\u4fe1\u9633\u5e02", 411500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 411501);
        AREA_CODES.put("\u6d49\u6cb3\u533a", 411502);
        AREA_CODES.put("\u5e73\u6865\u533a", 411503);
        AREA_CODES.put("\u7f57\u5c71\u53bf", 411521);
        AREA_CODES.put("\u5149\u5c71\u53bf", 411522);
        AREA_CODES.put("\u65b0\u3000\u53bf", 411523);
        AREA_CODES.put("\u5546\u57ce\u53bf", 411524);
        AREA_CODES.put("\u56fa\u59cb\u53bf", 411525);
        AREA_CODES.put("\u6f62\u5ddd\u53bf", 411526);
        AREA_CODES.put("\u6dee\u6ee8\u53bf", 411527);
        AREA_CODES.put("\u606f\u3000\u53bf", 411528);
        AREA_CODES.put("\u5468\u53e3\u5e02", 411600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 411601);
        AREA_CODES.put("\u5ddd\u6c47\u533a", 411602);
        AREA_CODES.put("\u6276\u6c9f\u53bf", 411621);
        AREA_CODES.put("\u897f\u534e\u53bf", 411622);
        AREA_CODES.put("\u5546\u6c34\u53bf", 411623);
        AREA_CODES.put("\u6c88\u4e18\u53bf", 411624);
        AREA_CODES.put("\u90f8\u57ce\u53bf", 411625);
        AREA_CODES.put("\u6dee\u9633\u53bf", 411626);
        AREA_CODES.put("\u592a\u5eb7\u53bf", 411627);
        AREA_CODES.put("\u9e7f\u9091\u53bf", 411628);
        AREA_CODES.put("\u9879\u57ce\u5e02", 411681);
        AREA_CODES.put("\u9a7b\u9a6c\u5e97\u5e02", 411700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 411701);
        AREA_CODES.put("\u9a7f\u57ce\u533a", 411702);
        AREA_CODES.put("\u897f\u5e73\u53bf", 411721);
        AREA_CODES.put("\u4e0a\u8521\u53bf", 411722);
        AREA_CODES.put("\u5e73\u8206\u53bf", 411723);
        AREA_CODES.put("\u6b63\u9633\u53bf", 411724);
        AREA_CODES.put("\u786e\u5c71\u53bf", 411725);
        AREA_CODES.put("\u6ccc\u9633\u53bf", 411726);
        AREA_CODES.put("\u6c5d\u5357\u53bf", 411727);
        AREA_CODES.put("\u9042\u5e73\u53bf", 411728);
        AREA_CODES.put("\u65b0\u8521\u53bf", 411729);
        AREA_CODES.put("\u6d4e\u6e90\u5e02", 419001);
        AREA_CODES.put("\u6e56\u5317\u7701", 420000);
        AREA_CODES.put("\u6b66\u6c49\u5e02", 420100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 420101);
        AREA_CODES.put("\u6c5f\u5cb8\u533a", 420102);
        AREA_CODES.put("\u6c5f\u6c49\u533a", 420103);
        AREA_CODES.put("\u785a\u53e3\u533a", 420104);
        AREA_CODES.put("\u6c49\u9633\u533a", 420105);
        AREA_CODES.put("\u6b66\u660c\u533a", 420106);
        AREA_CODES.put("\u9752\u5c71\u533a", 420107);
        AREA_CODES.put("\u6d2a\u5c71\u533a", 420111);
        AREA_CODES.put("\u4e1c\u897f\u6e56\u533a", 420112);
        AREA_CODES.put("\u6c49\u5357\u533a", 420113);
        AREA_CODES.put("\u8521\u7538\u533a", 420114);
        AREA_CODES.put("\u6c5f\u590f\u533a", 420115);
        AREA_CODES.put("\u9ec4\u9642\u533a", 420116);
        AREA_CODES.put("\u65b0\u6d32\u533a", 420117);
        AREA_CODES.put("\u9ec4\u77f3\u5e02", 420200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 420201);
        AREA_CODES.put("\u9ec4\u77f3\u6e2f\u533a", 420202);
        AREA_CODES.put("\u897f\u585e\u5c71\u533a", 420203);
        AREA_CODES.put("\u4e0b\u9646\u533a", 420204);
        AREA_CODES.put("\u94c1\u5c71\u533a", 420205);
        AREA_CODES.put("\u9633\u65b0\u53bf", 420222);
        AREA_CODES.put("\u5927\u51b6\u5e02", 420281);
        AREA_CODES.put("\u5341\u5830\u5e02", 420300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 420301);
        AREA_CODES.put("\u8305\u7bad\u533a", 420302);
        AREA_CODES.put("\u5f20\u6e7e\u533a", 420303);
        AREA_CODES.put("\u90e7\u3000\u53bf", 420321);
        AREA_CODES.put("\u90e7\u897f\u53bf", 420322);
        AREA_CODES.put("\u7af9\u5c71\u53bf", 420323);
        AREA_CODES.put("\u7af9\u6eaa\u53bf", 420324);
        AREA_CODES.put("\u623f\u3000\u53bf", 420325);
        AREA_CODES.put("\u4e39\u6c5f\u53e3\u5e02", 420381);
        AREA_CODES.put("\u5b9c\u660c\u5e02", 420500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 420501);
        AREA_CODES.put("\u897f\u9675\u533a", 420502);
        AREA_CODES.put("\u4f0d\u5bb6\u5c97\u533a", 420503);
        AREA_CODES.put("\u70b9\u519b\u533a", 420504);
        AREA_CODES.put("\u7307\u4ead\u533a", 420505);
        AREA_CODES.put("\u5937\u9675\u533a", 420506);
        AREA_CODES.put("\u8fdc\u5b89\u53bf", 420525);
        AREA_CODES.put("\u5174\u5c71\u53bf", 420526);
        AREA_CODES.put("\u79ed\u5f52\u53bf", 420527);
        AREA_CODES.put("\u957f\u9633\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf", 420528);
        AREA_CODES.put("\u4e94\u5cf0\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf", 420529);
        AREA_CODES.put("\u5b9c\u90fd\u5e02", 420581);
        AREA_CODES.put("\u5f53\u9633\u5e02", 420582);
        AREA_CODES.put("\u679d\u6c5f\u5e02", 420583);
        AREA_CODES.put("\u8944\u6a0a\u5e02", 420600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 420601);
        AREA_CODES.put("\u8944\u57ce\u533a", 420602);
        AREA_CODES.put("\u6a0a\u57ce\u533a", 420606);
        AREA_CODES.put("\u8944\u9633\u533a", 420607);
        AREA_CODES.put("\u5357\u6f33\u53bf", 420624);
        AREA_CODES.put("\u8c37\u57ce\u53bf", 420625);
        AREA_CODES.put("\u4fdd\u5eb7\u53bf", 420626);
        AREA_CODES.put("\u8001\u6cb3\u53e3\u5e02", 420682);
        AREA_CODES.put("\u67a3\u9633\u5e02", 420683);
        AREA_CODES.put("\u5b9c\u57ce\u5e02", 420684);
        AREA_CODES.put("\u9102\u5dde\u5e02", 420700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 420701);
        AREA_CODES.put("\u6881\u5b50\u6e56\u533a", 420702);
        AREA_CODES.put("\u534e\u5bb9\u533a", 420703);
        AREA_CODES.put("\u9102\u57ce\u533a", 420704);
        AREA_CODES.put("\u8346\u95e8\u5e02", 420800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 420801);
        AREA_CODES.put("\u4e1c\u5b9d\u533a", 420802);
        AREA_CODES.put("\u6387\u5200\u533a", 420804);
        AREA_CODES.put("\u4eac\u5c71\u53bf", 420821);
        AREA_CODES.put("\u6c99\u6d0b\u53bf", 420822);
        AREA_CODES.put("\u949f\u7965\u5e02", 420881);
        AREA_CODES.put("\u5b5d\u611f\u5e02", 420900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 420901);
        AREA_CODES.put("\u5b5d\u5357\u533a", 420902);
        AREA_CODES.put("\u5b5d\u660c\u53bf", 420921);
        AREA_CODES.put("\u5927\u609f\u53bf", 420922);
        AREA_CODES.put("\u4e91\u68a6\u53bf", 420923);
        AREA_CODES.put("\u5e94\u57ce\u5e02", 420981);
        AREA_CODES.put("\u5b89\u9646\u5e02", 420982);
        AREA_CODES.put("\u6c49\u5ddd\u5e02", 420984);
        AREA_CODES.put("\u8346\u5dde\u5e02", 421000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 421001);
        AREA_CODES.put("\u6c99\u5e02\u533a", 421002);
        AREA_CODES.put("\u8346\u5dde\u533a", 421003);
        AREA_CODES.put("\u516c\u5b89\u53bf", 421022);
        AREA_CODES.put("\u76d1\u5229\u53bf", 421023);
        AREA_CODES.put("\u6c5f\u9675\u53bf", 421024);
        AREA_CODES.put("\u77f3\u9996\u5e02", 421081);
        AREA_CODES.put("\u6d2a\u6e56\u5e02", 421083);
        AREA_CODES.put("\u677e\u6ecb\u5e02", 421087);
        AREA_CODES.put("\u9ec4\u5188\u5e02", 421100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 421101);
        AREA_CODES.put("\u9ec4\u5dde\u533a", 421102);
        AREA_CODES.put("\u56e2\u98ce\u53bf", 421121);
        AREA_CODES.put("\u7ea2\u5b89\u53bf", 421122);
        AREA_CODES.put("\u7f57\u7530\u53bf", 421123);
        AREA_CODES.put("\u82f1\u5c71\u53bf", 421124);
        AREA_CODES.put("\u6d60\u6c34\u53bf", 421125);
        AREA_CODES.put("\u8572\u6625\u53bf", 421126);
        AREA_CODES.put("\u9ec4\u6885\u53bf", 421127);
        AREA_CODES.put("\u9ebb\u57ce\u5e02", 421181);
        AREA_CODES.put("\u6b66\u7a74\u5e02", 421182);
        AREA_CODES.put("\u54b8\u5b81\u5e02", 421200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 421201);
        AREA_CODES.put("\u54b8\u5b89\u533a", 421202);
        AREA_CODES.put("\u5609\u9c7c\u53bf", 421221);
        AREA_CODES.put("\u901a\u57ce\u53bf", 421222);
        AREA_CODES.put("\u5d07\u9633\u53bf", 421223);
        AREA_CODES.put("\u901a\u5c71\u53bf", 421224);
        AREA_CODES.put("\u8d64\u58c1\u5e02", 421281);
        AREA_CODES.put("\u968f\u5dde\u5e02", 421300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 421301);
        AREA_CODES.put("\u66fe\u90fd\u533a (*)", 421303);
        AREA_CODES.put("\u5e7f\u6c34\u5e02", 421381);
        AREA_CODES.put("\u6069\u65bd\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", 422800);
        AREA_CODES.put("\u6069\u65bd\u5e02", 422801);
        AREA_CODES.put("\u5229\u5ddd\u5e02", 422802);
        AREA_CODES.put("\u5efa\u59cb\u53bf", 422822);
        AREA_CODES.put("\u5df4\u4e1c\u53bf", 422823);
        AREA_CODES.put("\u5ba3\u6069\u53bf", 422825);
        AREA_CODES.put("\u54b8\u4e30\u53bf", 422826);
        AREA_CODES.put("\u6765\u51e4\u53bf", 422827);
        AREA_CODES.put("\u9e64\u5cf0\u53bf", 422828);
        AREA_CODES.put("\u7701\u76f4\u8f96\u53bf\u7ea7\u884c\u653f\u533a\u5212", 429000);
        AREA_CODES.put("\u4ed9\u6843\u5e02", 429004);
        AREA_CODES.put("\u6f5c\u6c5f\u5e02", 429005);
        AREA_CODES.put("\u5929\u95e8\u5e02", 429006);
        AREA_CODES.put("\u795e\u519c\u67b6\u6797\u533a", 429021);
        AREA_CODES.put("\u6e56\u5357\u7701", 430000);
        AREA_CODES.put("\u957f\u6c99\u5e02", 430100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 430101);
        AREA_CODES.put("\u8299\u84c9\u533a", 430102);
        AREA_CODES.put("\u5929\u5fc3\u533a", 430103);
        AREA_CODES.put("\u5cb3\u9e93\u533a", 430104);
        AREA_CODES.put("\u5f00\u798f\u533a", 430105);
        AREA_CODES.put("\u96e8\u82b1\u533a", 430111);
        AREA_CODES.put("\u957f\u6c99\u53bf", 430121);
        AREA_CODES.put("\u671b\u57ce\u53bf", 430122);
        AREA_CODES.put("\u5b81\u4e61\u53bf", 430124);
        AREA_CODES.put("\u6d4f\u9633\u5e02", 430181);
        AREA_CODES.put("\u682a\u6d32\u5e02", 430200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 430201);
        AREA_CODES.put("\u8377\u5858\u533a", 430202);
        AREA_CODES.put("\u82a6\u6dde\u533a", 430203);
        AREA_CODES.put("\u77f3\u5cf0\u533a", 430204);
        AREA_CODES.put("\u5929\u5143\u533a", 430211);
        AREA_CODES.put("\u682a\u6d32\u53bf", 430221);
        AREA_CODES.put("\u6538\u3000\u53bf", 430223);
        AREA_CODES.put("\u8336\u9675\u53bf", 430224);
        AREA_CODES.put("\u708e\u9675\u53bf", 430225);
        AREA_CODES.put("\u91b4\u9675\u5e02", 430281);
        AREA_CODES.put("\u6e58\u6f6d\u5e02", 430300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 430301);
        AREA_CODES.put("\u96e8\u6e56\u533a", 430302);
        AREA_CODES.put("\u5cb3\u5858\u533a", 430304);
        AREA_CODES.put("\u6e58\u6f6d\u53bf", 430321);
        AREA_CODES.put("\u6e58\u4e61\u5e02", 430381);
        AREA_CODES.put("\u97f6\u5c71\u5e02", 430382);
        AREA_CODES.put("\u8861\u9633\u5e02", 430400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 430401);
        AREA_CODES.put("\u73e0\u6656\u533a", 430405);
        AREA_CODES.put("\u96c1\u5cf0\u533a", 430406);
        AREA_CODES.put("\u77f3\u9f13\u533a", 430407);
        AREA_CODES.put("\u84b8\u6e58\u533a", 430408);
        AREA_CODES.put("\u5357\u5cb3\u533a", 430412);
        AREA_CODES.put("\u8861\u9633\u53bf", 430421);
        AREA_CODES.put("\u8861\u5357\u53bf", 430422);
        AREA_CODES.put("\u8861\u5c71\u53bf", 430423);
        AREA_CODES.put("\u8861\u4e1c\u53bf", 430424);
        AREA_CODES.put("\u7941\u4e1c\u53bf", 430426);
        AREA_CODES.put("\u8012\u9633\u5e02", 430481);
        AREA_CODES.put("\u5e38\u5b81\u5e02", 430482);
        AREA_CODES.put("\u90b5\u9633\u5e02", 430500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 430501);
        AREA_CODES.put("\u53cc\u6e05\u533a", 430502);
        AREA_CODES.put("\u5927\u7965\u533a", 430503);
        AREA_CODES.put("\u5317\u5854\u533a", 430511);
        AREA_CODES.put("\u90b5\u4e1c\u53bf", 430521);
        AREA_CODES.put("\u65b0\u90b5\u53bf", 430522);
        AREA_CODES.put("\u90b5\u9633\u53bf", 430523);
        AREA_CODES.put("\u9686\u56de\u53bf", 430524);
        AREA_CODES.put("\u6d1e\u53e3\u53bf", 430525);
        AREA_CODES.put("\u7ee5\u5b81\u53bf", 430527);
        AREA_CODES.put("\u65b0\u5b81\u53bf", 430528);
        AREA_CODES.put("\u57ce\u6b65\u82d7\u65cf\u81ea\u6cbb\u53bf", 430529);
        AREA_CODES.put("\u6b66\u5188\u5e02", 430581);
        AREA_CODES.put("\u5cb3\u9633\u5e02", 430600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 430601);
        AREA_CODES.put("\u5cb3\u9633\u697c\u533a", 430602);
        AREA_CODES.put("\u4e91\u6eaa\u533a", 430603);
        AREA_CODES.put("\u541b\u5c71\u533a", 430611);
        AREA_CODES.put("\u5cb3\u9633\u53bf", 430621);
        AREA_CODES.put("\u534e\u5bb9\u53bf", 430623);
        AREA_CODES.put("\u6e58\u9634\u53bf", 430624);
        AREA_CODES.put("\u5e73\u6c5f\u53bf", 430626);
        AREA_CODES.put("\u6c68\u7f57\u5e02", 430681);
        AREA_CODES.put("\u4e34\u6e58\u5e02", 430682);
        AREA_CODES.put("\u5e38\u5fb7\u5e02", 430700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 430701);
        AREA_CODES.put("\u6b66\u9675\u533a", 430702);
        AREA_CODES.put("\u9f0e\u57ce\u533a", 430703);
        AREA_CODES.put("\u5b89\u4e61\u53bf", 430721);
        AREA_CODES.put("\u6c49\u5bff\u53bf", 430722);
        AREA_CODES.put("\u6fa7\u3000\u53bf", 430723);
        AREA_CODES.put("\u4e34\u6fa7\u53bf", 430724);
        AREA_CODES.put("\u6843\u6e90\u53bf", 430725);
        AREA_CODES.put("\u77f3\u95e8\u53bf", 430726);
        AREA_CODES.put("\u6d25\u5e02\u5e02", 430781);
        AREA_CODES.put("\u5f20\u5bb6\u754c\u5e02", 430800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 430801);
        AREA_CODES.put("\u6c38\u5b9a\u533a", 430802);
        AREA_CODES.put("\u6b66\u9675\u6e90\u533a", 430811);
        AREA_CODES.put("\u6148\u5229\u53bf", 430821);
        AREA_CODES.put("\u6851\u690d\u53bf", 430822);
        AREA_CODES.put("\u76ca\u9633\u5e02", 430900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 430901);
        AREA_CODES.put("\u8d44\u9633\u533a", 430902);
        AREA_CODES.put("\u8d6b\u5c71\u533a", 430903);
        AREA_CODES.put("\u5357\u3000\u53bf", 430921);
        AREA_CODES.put("\u6843\u6c5f\u53bf", 430922);
        AREA_CODES.put("\u5b89\u5316\u53bf", 430923);
        AREA_CODES.put("\u6c85\u6c5f\u5e02", 430981);
        AREA_CODES.put("\u90f4\u5dde\u5e02", 431000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 431001);
        AREA_CODES.put("\u5317\u6e56\u533a", 431002);
        AREA_CODES.put("\u82cf\u4ed9\u533a", 431003);
        AREA_CODES.put("\u6842\u9633\u53bf", 431021);
        AREA_CODES.put("\u5b9c\u7ae0\u53bf", 431022);
        AREA_CODES.put("\u6c38\u5174\u53bf", 431023);
        AREA_CODES.put("\u5609\u79be\u53bf", 431024);
        AREA_CODES.put("\u4e34\u6b66\u53bf", 431025);
        AREA_CODES.put("\u6c5d\u57ce\u53bf", 431026);
        AREA_CODES.put("\u6842\u4e1c\u53bf", 431027);
        AREA_CODES.put("\u5b89\u4ec1\u53bf", 431028);
        AREA_CODES.put("\u8d44\u5174\u5e02", 431081);
        AREA_CODES.put("\u6c38\u5dde\u5e02", 431100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 431101);
        AREA_CODES.put("\u96f6\u9675\u533a", 431102);
        AREA_CODES.put("\u51b7\u6c34\u6ee9\u533a", 431103);
        AREA_CODES.put("\u7941\u9633\u53bf", 431121);
        AREA_CODES.put("\u4e1c\u5b89\u53bf", 431122);
        AREA_CODES.put("\u53cc\u724c\u53bf", 431123);
        AREA_CODES.put("\u9053\u3000\u53bf", 431124);
        AREA_CODES.put("\u6c5f\u6c38\u53bf", 431125);
        AREA_CODES.put("\u5b81\u8fdc\u53bf", 431126);
        AREA_CODES.put("\u84dd\u5c71\u53bf", 431127);
        AREA_CODES.put("\u65b0\u7530\u53bf", 431128);
        AREA_CODES.put("\u6c5f\u534e\u7476\u65cf\u81ea\u6cbb\u53bf", 431129);
        AREA_CODES.put("\u6000\u5316\u5e02", 431200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 431201);
        AREA_CODES.put("\u9e64\u57ce\u533a", 431202);
        AREA_CODES.put("\u4e2d\u65b9\u53bf", 431221);
        AREA_CODES.put("\u6c85\u9675\u53bf", 431222);
        AREA_CODES.put("\u8fb0\u6eaa\u53bf", 431223);
        AREA_CODES.put("\u6e86\u6d66\u53bf", 431224);
        AREA_CODES.put("\u4f1a\u540c\u53bf", 431225);
        AREA_CODES.put("\u9ebb\u9633\u82d7\u65cf\u81ea\u6cbb\u53bf", 431226);
        AREA_CODES.put("\u65b0\u6643\u4f97\u65cf\u81ea\u6cbb\u53bf", 431227);
        AREA_CODES.put("\u82b7\u6c5f\u4f97\u65cf\u81ea\u6cbb\u53bf", 431228);
        AREA_CODES.put("\u9756\u5dde\u82d7\u65cf\u4f97\u65cf\u81ea\u6cbb\u53bf", 431229);
        AREA_CODES.put("\u901a\u9053\u4f97\u65cf\u81ea\u6cbb\u53bf", 431230);
        AREA_CODES.put("\u6d2a\u6c5f\u5e02", 431281);
        AREA_CODES.put("\u5a04\u5e95\u5e02", 431300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 431301);
        AREA_CODES.put("\u5a04\u661f\u533a", 431302);
        AREA_CODES.put("\u53cc\u5cf0\u53bf", 431321);
        AREA_CODES.put("\u65b0\u5316\u53bf", 431322);
        AREA_CODES.put("\u51b7\u6c34\u6c5f\u5e02", 431381);
        AREA_CODES.put("\u6d9f\u6e90\u5e02", 431382);
        AREA_CODES.put("\u6e58\u897f\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", 433100);
        AREA_CODES.put("\u5409\u9996\u5e02", 433101);
        AREA_CODES.put("\u6cf8\u6eaa\u53bf", 433122);
        AREA_CODES.put("\u51e4\u51f0\u53bf", 433123);
        AREA_CODES.put("\u82b1\u57a3\u53bf", 433124);
        AREA_CODES.put("\u4fdd\u9756\u53bf", 433125);
        AREA_CODES.put("\u53e4\u4e08\u53bf", 433126);
        AREA_CODES.put("\u6c38\u987a\u53bf", 433127);
        AREA_CODES.put("\u9f99\u5c71\u53bf", 433130);
        AREA_CODES.put("\u5e7f\u4e1c\u7701", 440000);
        AREA_CODES.put("\u5e7f\u5dde\u5e02", 440100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 440101);
        AREA_CODES.put("\u8354\u6e7e\u533a", 440103);
        AREA_CODES.put("\u8d8a\u79c0\u533a", 440104);
        AREA_CODES.put("\u6d77\u73e0\u533a", 440105);
        AREA_CODES.put("\u5929\u6cb3\u533a", 440106);
        AREA_CODES.put("\u767d\u4e91\u533a", 440111);
        AREA_CODES.put("\u9ec4\u57d4\u533a", 440112);
        AREA_CODES.put("\u756a\u79ba\u533a", 440113);
        AREA_CODES.put("\u82b1\u90fd\u533a", 440114);
        AREA_CODES.put("\u5357\u6c99\u533a", 440115);
        AREA_CODES.put("\u841d\u5c97\u533a", 440116);
        AREA_CODES.put("\u589e\u57ce\u5e02", 440183);
        AREA_CODES.put("\u4ece\u5316\u5e02", 440184);
        AREA_CODES.put("\u97f6\u5173\u5e02", 440200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 440201);
        AREA_CODES.put("\u6b66\u6c5f\u533a", 440203);
        AREA_CODES.put("\u6d48\u6c5f\u533a", 440204);
        AREA_CODES.put("\u66f2\u6c5f\u533a", 440205);
        AREA_CODES.put("\u59cb\u5174\u53bf", 440222);
        AREA_CODES.put("\u4ec1\u5316\u53bf", 440224);
        AREA_CODES.put("\u7fc1\u6e90\u53bf", 440229);
        AREA_CODES.put("\u4e73\u6e90\u7476\u65cf\u81ea\u6cbb\u53bf", 440232);
        AREA_CODES.put("\u65b0\u4e30\u53bf", 440233);
        AREA_CODES.put("\u4e50\u660c\u5e02", 440281);
        AREA_CODES.put("\u5357\u96c4\u5e02", 440282);
        AREA_CODES.put("\u6df1\u5733\u5e02", 440300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 440301);
        AREA_CODES.put("\u7f57\u6e56\u533a", 440303);
        AREA_CODES.put("\u798f\u7530\u533a", 440304);
        AREA_CODES.put("\u5357\u5c71\u533a", 440305);
        AREA_CODES.put("\u5b9d\u5b89\u533a", 440306);
        AREA_CODES.put("\u9f99\u5c97\u533a", 440307);
        AREA_CODES.put("\u76d0\u7530\u533a", 440308);
        AREA_CODES.put("\u73e0\u6d77\u5e02", 440400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 440401);
        AREA_CODES.put("\u9999\u6d32\u533a", 440402);
        AREA_CODES.put("\u6597\u95e8\u533a", 440403);
        AREA_CODES.put("\u91d1\u6e7e\u533a", 440404);
        AREA_CODES.put("\u6c55\u5934\u5e02", 440500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 440501);
        AREA_CODES.put("\u9f99\u6e56\u533a", 440507);
        AREA_CODES.put("\u91d1\u5e73\u533a", 440511);
        AREA_CODES.put("\u6fe0\u6c5f\u533a", 440512);
        AREA_CODES.put("\u6f6e\u9633\u533a", 440513);
        AREA_CODES.put("\u6f6e\u5357\u533a", 440514);
        AREA_CODES.put("\u6f84\u6d77\u533a", 440515);
        AREA_CODES.put("\u5357\u6fb3\u53bf", 440523);
        AREA_CODES.put("\u4f5b\u5c71\u5e02", 440600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 440601);
        AREA_CODES.put("\u7985\u57ce\u533a", 440604);
        AREA_CODES.put("\u5357\u6d77\u533a", 440605);
        AREA_CODES.put("\u987a\u5fb7\u533a", 440606);
        AREA_CODES.put("\u4e09\u6c34\u533a", 440607);
        AREA_CODES.put("\u9ad8\u660e\u533a", 440608);
        AREA_CODES.put("\u6c5f\u95e8\u5e02", 440700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 440701);
        AREA_CODES.put("\u84ec\u6c5f\u533a", 440703);
        AREA_CODES.put("\u6c5f\u6d77\u533a", 440704);
        AREA_CODES.put("\u65b0\u4f1a\u533a", 440705);
        AREA_CODES.put("\u53f0\u5c71\u5e02", 440781);
        AREA_CODES.put("\u5f00\u5e73\u5e02", 440783);
        AREA_CODES.put("\u9e64\u5c71\u5e02", 440784);
        AREA_CODES.put("\u6069\u5e73\u5e02", 440785);
        AREA_CODES.put("\u6e5b\u6c5f\u5e02", 440800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 440801);
        AREA_CODES.put("\u8d64\u574e\u533a", 440802);
        AREA_CODES.put("\u971e\u5c71\u533a", 440803);
        AREA_CODES.put("\u5761\u5934\u533a", 440804);
        AREA_CODES.put("\u9ebb\u7ae0\u533a", 440811);
        AREA_CODES.put("\u9042\u6eaa\u53bf", 440823);
        AREA_CODES.put("\u5f90\u95fb\u53bf", 440825);
        AREA_CODES.put("\u5ec9\u6c5f\u5e02", 440881);
        AREA_CODES.put("\u96f7\u5dde\u5e02", 440882);
        AREA_CODES.put("\u5434\u5ddd\u5e02", 440883);
        AREA_CODES.put("\u8302\u540d\u5e02", 440900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 440901);
        AREA_CODES.put("\u8302\u5357\u533a", 440902);
        AREA_CODES.put("\u8302\u6e2f\u533a", 440903);
        AREA_CODES.put("\u7535\u767d\u53bf", 440923);
        AREA_CODES.put("\u9ad8\u5dde\u5e02", 440981);
        AREA_CODES.put("\u5316\u5dde\u5e02", 440982);
        AREA_CODES.put("\u4fe1\u5b9c\u5e02", 440983);
        AREA_CODES.put("\u8087\u5e86\u5e02", 441200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 441201);
        AREA_CODES.put("\u7aef\u5dde\u533a", 441202);
        AREA_CODES.put("\u9f0e\u6e56\u533a", 441203);
        AREA_CODES.put("\u5e7f\u5b81\u53bf", 441223);
        AREA_CODES.put("\u6000\u96c6\u53bf", 441224);
        AREA_CODES.put("\u5c01\u5f00\u53bf", 441225);
        AREA_CODES.put("\u5fb7\u5e86\u53bf", 441226);
        AREA_CODES.put("\u9ad8\u8981\u5e02", 441283);
        AREA_CODES.put("\u56db\u4f1a\u5e02", 441284);
        AREA_CODES.put("\u60e0\u5dde\u5e02", 441300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 441301);
        AREA_CODES.put("\u60e0\u57ce\u533a", 441302);
        AREA_CODES.put("\u60e0\u9633\u533a", 441303);
        AREA_CODES.put("\u535a\u7f57\u53bf", 441322);
        AREA_CODES.put("\u60e0\u4e1c\u53bf", 441323);
        AREA_CODES.put("\u9f99\u95e8\u53bf", 441324);
        AREA_CODES.put("\u6885\u5dde\u5e02", 441400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 441401);
        AREA_CODES.put("\u6885\u6c5f\u533a", 441402);
        AREA_CODES.put("\u6885\u3000\u53bf", 441421);
        AREA_CODES.put("\u5927\u57d4\u53bf", 441422);
        AREA_CODES.put("\u4e30\u987a\u53bf", 441423);
        AREA_CODES.put("\u4e94\u534e\u53bf", 441424);
        AREA_CODES.put("\u5e73\u8fdc\u53bf", 441426);
        AREA_CODES.put("\u8549\u5cad\u53bf", 441427);
        AREA_CODES.put("\u5174\u5b81\u5e02", 441481);
        AREA_CODES.put("\u6c55\u5c3e\u5e02", 441500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 441501);
        AREA_CODES.put("\u57ce\u3000\u533a", 441502);
        AREA_CODES.put("\u6d77\u4e30\u53bf", 441521);
        AREA_CODES.put("\u9646\u6cb3\u53bf", 441523);
        AREA_CODES.put("\u9646\u4e30\u5e02", 441581);
        AREA_CODES.put("\u6cb3\u6e90\u5e02", 441600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 441601);
        AREA_CODES.put("\u6e90\u57ce\u533a", 441602);
        AREA_CODES.put("\u7d2b\u91d1\u53bf", 441621);
        AREA_CODES.put("\u9f99\u5ddd\u53bf", 441622);
        AREA_CODES.put("\u8fde\u5e73\u53bf", 441623);
        AREA_CODES.put("\u548c\u5e73\u53bf", 441624);
        AREA_CODES.put("\u4e1c\u6e90\u53bf", 441625);
        AREA_CODES.put("\u9633\u6c5f\u5e02", 441700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 441701);
        AREA_CODES.put("\u6c5f\u57ce\u533a", 441702);
        AREA_CODES.put("\u9633\u897f\u53bf", 441721);
        AREA_CODES.put("\u9633\u4e1c\u53bf", 441723);
        AREA_CODES.put("\u9633\u6625\u5e02", 441781);
        AREA_CODES.put("\u6e05\u8fdc\u5e02", 441800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 441801);
        AREA_CODES.put("\u6e05\u57ce\u533a", 441802);
        AREA_CODES.put("\u4f5b\u5188\u53bf", 441821);
        AREA_CODES.put("\u9633\u5c71\u53bf", 441823);
        AREA_CODES.put("\u8fde\u5c71\u58ee\u65cf\u7476\u65cf\u81ea\u6cbb\u53bf", 441825);
        AREA_CODES.put("\u8fde\u5357\u7476\u65cf\u81ea\u6cbb\u53bf", 441826);
        AREA_CODES.put("\u6e05\u65b0\u53bf", 441827);
        AREA_CODES.put("\u82f1\u5fb7\u5e02", 441881);
        AREA_CODES.put("\u8fde\u5dde\u5e02", 441882);
        AREA_CODES.put("\u4e1c\u839e\u5e02", 441900);
        AREA_CODES.put("\u4e2d\u5c71\u5e02", 442000);
        AREA_CODES.put("\u6f6e\u5dde\u5e02", 445100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 445101);
        AREA_CODES.put("\u6e58\u6865\u533a", 445102);
        AREA_CODES.put("\u6f6e\u5b89\u53bf", 445121);
        AREA_CODES.put("\u9976\u5e73\u53bf", 445122);
        AREA_CODES.put("\u63ed\u9633\u5e02", 445200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 445201);
        AREA_CODES.put("\u6995\u57ce\u533a", 445202);
        AREA_CODES.put("\u63ed\u4e1c\u53bf", 445221);
        AREA_CODES.put("\u63ed\u897f\u53bf", 445222);
        AREA_CODES.put("\u60e0\u6765\u53bf", 445224);
        AREA_CODES.put("\u666e\u5b81\u5e02", 445281);
        AREA_CODES.put("\u4e91\u6d6e\u5e02", 445300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 445301);
        AREA_CODES.put("\u4e91\u57ce\u533a", 445302);
        AREA_CODES.put("\u65b0\u5174\u53bf", 445321);
        AREA_CODES.put("\u90c1\u5357\u53bf", 445322);
        AREA_CODES.put("\u4e91\u5b89\u53bf", 445323);
        AREA_CODES.put("\u7f57\u5b9a\u5e02", 445381);
        AREA_CODES.put("\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a", 450000);
        AREA_CODES.put("\u5357\u5b81\u5e02", 450100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 450101);
        AREA_CODES.put("\u5174\u5b81\u533a", 450102);
        AREA_CODES.put("\u9752\u79c0\u533a", 450103);
        AREA_CODES.put("\u6c5f\u5357\u533a", 450105);
        AREA_CODES.put("\u897f\u4e61\u5858\u533a", 450107);
        AREA_CODES.put("\u826f\u5e86\u533a", 450108);
        AREA_CODES.put("\u9095\u5b81\u533a", 450109);
        AREA_CODES.put("\u6b66\u9e23\u53bf", 450122);
        AREA_CODES.put("\u9686\u5b89\u53bf", 450123);
        AREA_CODES.put("\u9a6c\u5c71\u53bf", 450124);
        AREA_CODES.put("\u4e0a\u6797\u53bf", 450125);
        AREA_CODES.put("\u5bbe\u9633\u53bf", 450126);
        AREA_CODES.put("\u6a2a\u3000\u53bf", 450127);
        AREA_CODES.put("\u67f3\u5dde\u5e02", 450200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 450201);
        AREA_CODES.put("\u57ce\u4e2d\u533a", 450202);
        AREA_CODES.put("\u9c7c\u5cf0\u533a", 450203);
        AREA_CODES.put("\u67f3\u5357\u533a", 450204);
        AREA_CODES.put("\u67f3\u5317\u533a", 450205);
        AREA_CODES.put("\u67f3\u6c5f\u53bf", 450221);
        AREA_CODES.put("\u67f3\u57ce\u53bf", 450222);
        AREA_CODES.put("\u9e7f\u5be8\u53bf", 450223);
        AREA_CODES.put("\u878d\u5b89\u53bf", 450224);
        AREA_CODES.put("\u878d\u6c34\u82d7\u65cf\u81ea\u6cbb\u53bf", 450225);
        AREA_CODES.put("\u4e09\u6c5f\u4f97\u65cf\u81ea\u6cbb\u53bf", 450226);
        AREA_CODES.put("\u6842\u6797\u5e02", 450300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 450301);
        AREA_CODES.put("\u79c0\u5cf0\u533a", 450302);
        AREA_CODES.put("\u53e0\u5f69\u533a", 450303);
        AREA_CODES.put("\u8c61\u5c71\u533a", 450304);
        AREA_CODES.put("\u4e03\u661f\u533a", 450305);
        AREA_CODES.put("\u96c1\u5c71\u533a", 450311);
        AREA_CODES.put("\u9633\u6714\u53bf", 450321);
        AREA_CODES.put("\u4e34\u6842\u53bf", 450322);
        AREA_CODES.put("\u7075\u5ddd\u53bf", 450323);
        AREA_CODES.put("\u5168\u5dde\u53bf", 450324);
        AREA_CODES.put("\u5174\u5b89\u53bf", 450325);
        AREA_CODES.put("\u6c38\u798f\u53bf", 450326);
        AREA_CODES.put("\u704c\u9633\u53bf", 450327);
        AREA_CODES.put("\u9f99\u80dc\u5404\u65cf\u81ea\u6cbb\u53bf", 450328);
        AREA_CODES.put("\u8d44\u6e90\u53bf", 450329);
        AREA_CODES.put("\u5e73\u4e50\u53bf", 450330);
        AREA_CODES.put("\u8354\u84b2\u53bf", 450331);
        AREA_CODES.put("\u606d\u57ce\u7476\u65cf\u81ea\u6cbb\u53bf", 450332);
        AREA_CODES.put("\u68a7\u5dde\u5e02", 450400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 450401);
        AREA_CODES.put("\u4e07\u79c0\u533a", 450403);
        AREA_CODES.put("\u8776\u5c71\u533a", 450404);
        AREA_CODES.put("\u957f\u6d32\u533a", 450405);
        AREA_CODES.put("\u82cd\u68a7\u53bf", 450421);
        AREA_CODES.put("\u85e4\u3000\u53bf", 450422);
        AREA_CODES.put("\u8499\u5c71\u53bf", 450423);
        AREA_CODES.put("\u5c91\u6eaa\u5e02", 450481);
        AREA_CODES.put("\u5317\u6d77\u5e02", 450500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 450501);
        AREA_CODES.put("\u6d77\u57ce\u533a", 450502);
        AREA_CODES.put("\u94f6\u6d77\u533a", 450503);
        AREA_CODES.put("\u94c1\u5c71\u6e2f\u533a", 450512);
        AREA_CODES.put("\u5408\u6d66\u53bf", 450521);
        AREA_CODES.put("\u9632\u57ce\u6e2f\u5e02", 450600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 450601);
        AREA_CODES.put("\u6e2f\u53e3\u533a", 450602);
        AREA_CODES.put("\u9632\u57ce\u533a", 450603);
        AREA_CODES.put("\u4e0a\u601d\u53bf", 450621);
        AREA_CODES.put("\u4e1c\u5174\u5e02", 450681);
        AREA_CODES.put("\u94a6\u5dde\u5e02", 450700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 450701);
        AREA_CODES.put("\u94a6\u5357\u533a", 450702);
        AREA_CODES.put("\u94a6\u5317\u533a", 450703);
        AREA_CODES.put("\u7075\u5c71\u53bf", 450721);
        AREA_CODES.put("\u6d66\u5317\u53bf", 450722);
        AREA_CODES.put("\u8d35\u6e2f\u5e02", 450800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 450801);
        AREA_CODES.put("\u6e2f\u5317\u533a", 450802);
        AREA_CODES.put("\u6e2f\u5357\u533a", 450803);
        AREA_CODES.put("\u8983\u5858\u533a", 450804);
        AREA_CODES.put("\u5e73\u5357\u53bf", 450821);
        AREA_CODES.put("\u6842\u5e73\u5e02", 450881);
        AREA_CODES.put("\u7389\u6797\u5e02", 450900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 450901);
        AREA_CODES.put("\u7389\u5dde\u533a", 450902);
        AREA_CODES.put("\u5bb9\u3000\u53bf", 450921);
        AREA_CODES.put("\u9646\u5ddd\u53bf", 450922);
        AREA_CODES.put("\u535a\u767d\u53bf", 450923);
        AREA_CODES.put("\u5174\u4e1a\u53bf", 450924);
        AREA_CODES.put("\u5317\u6d41\u5e02", 450981);
        AREA_CODES.put("\u767e\u8272\u5e02", 451000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 451001);
        AREA_CODES.put("\u53f3\u6c5f\u533a", 451002);
        AREA_CODES.put("\u7530\u9633\u53bf", 451021);
        AREA_CODES.put("\u7530\u4e1c\u53bf", 451022);
        AREA_CODES.put("\u5e73\u679c\u53bf", 451023);
        AREA_CODES.put("\u5fb7\u4fdd\u53bf", 451024);
        AREA_CODES.put("\u9756\u897f\u53bf", 451025);
        AREA_CODES.put("\u90a3\u5761\u53bf", 451026);
        AREA_CODES.put("\u51cc\u4e91\u53bf", 451027);
        AREA_CODES.put("\u4e50\u4e1a\u53bf", 451028);
        AREA_CODES.put("\u7530\u6797\u53bf", 451029);
        AREA_CODES.put("\u897f\u6797\u53bf", 451030);
        AREA_CODES.put("\u9686\u6797\u5404\u65cf\u81ea\u6cbb\u53bf", 451031);
        AREA_CODES.put("\u8d3a\u5dde\u5e02", 451100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 451101);
        AREA_CODES.put("\u516b\u6b65\u533a", 451102);
        AREA_CODES.put("\u662d\u5e73\u53bf", 451121);
        AREA_CODES.put("\u949f\u5c71\u53bf", 451122);
        AREA_CODES.put("\u5bcc\u5ddd\u7476\u65cf\u81ea\u6cbb\u53bf", 451123);
        AREA_CODES.put("\u6cb3\u6c60\u5e02", 451200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 451201);
        AREA_CODES.put("\u91d1\u57ce\u6c5f\u533a", 451202);
        AREA_CODES.put("\u5357\u4e39\u53bf", 451221);
        AREA_CODES.put("\u5929\u5ce8\u53bf", 451222);
        AREA_CODES.put("\u51e4\u5c71\u53bf", 451223);
        AREA_CODES.put("\u4e1c\u5170\u53bf", 451224);
        AREA_CODES.put("\u7f57\u57ce\u4eeb\u4f6c\u65cf\u81ea\u6cbb\u53bf", 451225);
        AREA_CODES.put("\u73af\u6c5f\u6bdb\u5357\u65cf\u81ea\u6cbb\u53bf", 451226);
        AREA_CODES.put("\u5df4\u9a6c\u7476\u65cf\u81ea\u6cbb\u53bf", 451227);
        AREA_CODES.put("\u90fd\u5b89\u7476\u65cf\u81ea\u6cbb\u53bf", 451228);
        AREA_CODES.put("\u5927\u5316\u7476\u65cf\u81ea\u6cbb\u53bf", 451229);
        AREA_CODES.put("\u5b9c\u5dde\u5e02", 451281);
        AREA_CODES.put("\u6765\u5bbe\u5e02", 451300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 451301);
        AREA_CODES.put("\u5174\u5bbe\u533a", 451302);
        AREA_CODES.put("\u5ffb\u57ce\u53bf", 451321);
        AREA_CODES.put("\u8c61\u5dde\u53bf", 451322);
        AREA_CODES.put("\u6b66\u5ba3\u53bf", 451323);
        AREA_CODES.put("\u91d1\u79c0\u7476\u65cf\u81ea\u6cbb\u53bf", 451324);
        AREA_CODES.put("\u5408\u5c71\u5e02", 451381);
        AREA_CODES.put("\u5d07\u5de6\u5e02", 451400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 451401);
        AREA_CODES.put("\u6c5f\u6d32\u533a", 451402);
        AREA_CODES.put("\u6276\u7ee5\u53bf", 451421);
        AREA_CODES.put("\u5b81\u660e\u53bf", 451422);
        AREA_CODES.put("\u9f99\u5dde\u53bf", 451423);
        AREA_CODES.put("\u5927\u65b0\u53bf", 451424);
        AREA_CODES.put("\u5929\u7b49\u53bf", 451425);
        AREA_CODES.put("\u51ed\u7965\u5e02", 451481);
        AREA_CODES.put("\u6d77\u5357\u7701", 460000);
        AREA_CODES.put("\u6d77\u53e3\u5e02", 460100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 460101);
        AREA_CODES.put("\u79c0\u82f1\u533a", 460105);
        AREA_CODES.put("\u9f99\u534e\u533a", 460106);
        AREA_CODES.put("\u743c\u5c71\u533a", 460107);
        AREA_CODES.put("\u7f8e\u5170\u533a", 460108);
        AREA_CODES.put("\u4e09\u4e9a\u5e02", 460200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 460201);
        AREA_CODES.put("\u7701\u76f4\u8f96\u53bf\u7ea7\u884c\u653f\u533a\u5212", 469000);
        AREA_CODES.put("\u4e94\u6307\u5c71\u5e02", 469001);
        AREA_CODES.put("\u743c\u6d77\u5e02", 469002);
        AREA_CODES.put("\u510b\u5dde\u5e02", 469003);
        AREA_CODES.put("\u6587\u660c\u5e02", 469005);
        AREA_CODES.put("\u4e07\u5b81\u5e02", 469006);
        AREA_CODES.put("\u4e1c\u65b9\u5e02", 469007);
        AREA_CODES.put("\u5b9a\u5b89\u53bf", 469021);
        AREA_CODES.put("\u5c6f\u660c\u53bf", 469022);
        AREA_CODES.put("\u6f84\u8fc8\u53bf", 469023);
        AREA_CODES.put("\u4e34\u9ad8\u53bf", 469024);
        AREA_CODES.put("\u767d\u6c99\u9ece\u65cf\u81ea\u6cbb\u53bf", 469025);
        AREA_CODES.put("\u660c\u6c5f\u9ece\u65cf\u81ea\u6cbb\u53bf", 469026);
        AREA_CODES.put("\u4e50\u4e1c\u9ece\u65cf\u81ea\u6cbb\u53bf", 469027);
        AREA_CODES.put("\u9675\u6c34\u9ece\u65cf\u81ea\u6cbb\u53bf", 469028);
        AREA_CODES.put("\u4fdd\u4ead\u9ece\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 469029);
        AREA_CODES.put("\u743c\u4e2d\u9ece\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 469030);
        AREA_CODES.put("\u897f\u6c99\u7fa4\u5c9b", 469031);
        AREA_CODES.put("\u5357\u6c99\u7fa4\u5c9b", 469032);
        AREA_CODES.put("\u4e2d\u6c99\u7fa4\u5c9b\u7684\u5c9b\u7901\u53ca\u5176\u6d77\u57df", 469033);
        AREA_CODES.put("\u91cd\u5e86\u5e02", 500000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 500100);
        AREA_CODES.put("\u4e07\u5dde\u533a", 500101);
        AREA_CODES.put("\u6daa\u9675\u533a", 500102);
        AREA_CODES.put("\u6e1d\u4e2d\u533a", 500103);
        AREA_CODES.put("\u5927\u6e21\u53e3\u533a", 500104);
        AREA_CODES.put("\u6c5f\u5317\u533a", 500105);
        AREA_CODES.put("\u6c99\u576a\u575d\u533a", 500106);
        AREA_CODES.put("\u4e5d\u9f99\u5761\u533a", 500107);
        AREA_CODES.put("\u5357\u5cb8\u533a", 500108);
        AREA_CODES.put("\u5317\u789a\u533a", 500109);
        AREA_CODES.put("\u4e07\u76db\u533a", 500110);
        AREA_CODES.put("\u53cc\u6865\u533a", 500111);
        AREA_CODES.put("\u6e1d\u5317\u533a", 500112);
        AREA_CODES.put("\u5df4\u5357\u533a", 500113);
        AREA_CODES.put("\u9ed4\u6c5f\u533a", 500114);
        AREA_CODES.put("\u957f\u5bff\u533a", 500115);
        AREA_CODES.put("\u6c5f\u6d25\u533a", 500116);
        AREA_CODES.put("\u5408\u5ddd\u533a", 500117);
        AREA_CODES.put("\u6c38\u5ddd\u533a", 500118);
        AREA_CODES.put("\u5357\u5ddd\u533a", 500119);
        AREA_CODES.put("\u53bf", 500200);
        AREA_CODES.put("\u7da6\u6c5f\u53bf", 500222);
        AREA_CODES.put("\u6f7c\u5357\u53bf", 500223);
        AREA_CODES.put("\u94dc\u6881\u53bf", 500224);
        AREA_CODES.put("\u5927\u8db3\u53bf", 500225);
        AREA_CODES.put("\u8363\u660c\u53bf", 500226);
        AREA_CODES.put("\u74a7\u5c71\u53bf", 500227);
        AREA_CODES.put("\u6881\u5e73\u53bf", 500228);
        AREA_CODES.put("\u57ce\u53e3\u53bf", 500229);
        AREA_CODES.put("\u4e30\u90fd\u53bf", 500230);
        AREA_CODES.put("\u57ab\u6c5f\u53bf", 500231);
        AREA_CODES.put("\u6b66\u9686\u53bf", 500232);
        AREA_CODES.put("\u5fe0\u3000\u53bf", 500233);
        AREA_CODES.put("\u5f00\u3000\u53bf", 500234);
        AREA_CODES.put("\u4e91\u9633\u53bf", 500235);
        AREA_CODES.put("\u5949\u8282\u53bf", 500236);
        AREA_CODES.put("\u5deb\u5c71\u53bf", 500237);
        AREA_CODES.put("\u5deb\u6eaa\u53bf", 500238);
        AREA_CODES.put("\u77f3\u67f1\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf", 500240);
        AREA_CODES.put("\u79c0\u5c71\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 500241);
        AREA_CODES.put("\u9149\u9633\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 500242);
        AREA_CODES.put("\u5f6d\u6c34\u82d7\u65cf\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf", 500243);
        AREA_CODES.put("\u56db\u5ddd\u7701", 510000);
        AREA_CODES.put("\u6210\u90fd\u5e02", 510100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 510101);
        AREA_CODES.put("\u9526\u6c5f\u533a", 510104);
        AREA_CODES.put("\u9752\u7f8a\u533a", 510105);
        AREA_CODES.put("\u91d1\u725b\u533a", 510106);
        AREA_CODES.put("\u6b66\u4faf\u533a", 510107);
        AREA_CODES.put("\u6210\u534e\u533a", 510108);
        AREA_CODES.put("\u9f99\u6cc9\u9a7f\u533a", 510112);
        AREA_CODES.put("\u9752\u767d\u6c5f\u533a", 510113);
        AREA_CODES.put("\u65b0\u90fd\u533a", 510114);
        AREA_CODES.put("\u6e29\u6c5f\u533a", 510115);
        AREA_CODES.put("\u91d1\u5802\u53bf", 510121);
        AREA_CODES.put("\u53cc\u6d41\u53bf", 510122);
        AREA_CODES.put("\u90eb\u3000\u53bf", 510124);
        AREA_CODES.put("\u5927\u9091\u53bf", 510129);
        AREA_CODES.put("\u84b2\u6c5f\u53bf", 510131);
        AREA_CODES.put("\u65b0\u6d25\u53bf", 510132);
        AREA_CODES.put("\u90fd\u6c5f\u5830\u5e02", 510181);
        AREA_CODES.put("\u5f6d\u5dde\u5e02", 510182);
        AREA_CODES.put("\u909b\u5d03\u5e02", 510183);
        AREA_CODES.put("\u5d07\u5dde\u5e02", 510184);
        AREA_CODES.put("\u81ea\u8d21\u5e02", 510300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 510301);
        AREA_CODES.put("\u81ea\u6d41\u4e95\u533a", 510302);
        AREA_CODES.put("\u8d21\u4e95\u533a", 510303);
        AREA_CODES.put("\u5927\u5b89\u533a", 510304);
        AREA_CODES.put("\u6cbf\u6ee9\u533a", 510311);
        AREA_CODES.put("\u8363\u3000\u53bf", 510321);
        AREA_CODES.put("\u5bcc\u987a\u53bf", 510322);
        AREA_CODES.put("\u6500\u679d\u82b1\u5e02", 510400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 510401);
        AREA_CODES.put("\u4e1c\u3000\u533a", 510402);
        AREA_CODES.put("\u897f\u3000\u533a", 510403);
        AREA_CODES.put("\u4ec1\u548c\u533a", 510411);
        AREA_CODES.put("\u7c73\u6613\u53bf", 510421);
        AREA_CODES.put("\u76d0\u8fb9\u53bf", 510422);
        AREA_CODES.put("\u6cf8\u5dde\u5e02", 510500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 510501);
        AREA_CODES.put("\u6c5f\u9633\u533a", 510502);
        AREA_CODES.put("\u7eb3\u6eaa\u533a", 510503);
        AREA_CODES.put("\u9f99\u9a6c\u6f6d\u533a", 510504);
        AREA_CODES.put("\u6cf8\u3000\u53bf", 510521);
        AREA_CODES.put("\u5408\u6c5f\u53bf", 510522);
        AREA_CODES.put("\u53d9\u6c38\u53bf", 510524);
        AREA_CODES.put("\u53e4\u853a\u53bf", 510525);
        AREA_CODES.put("\u5fb7\u9633\u5e02", 510600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 510601);
        AREA_CODES.put("\u65cc\u9633\u533a", 510603);
        AREA_CODES.put("\u4e2d\u6c5f\u53bf", 510623);
        AREA_CODES.put("\u7f57\u6c5f\u53bf", 510626);
        AREA_CODES.put("\u5e7f\u6c49\u5e02", 510681);
        AREA_CODES.put("\u4ec0\u90a1\u5e02", 510682);
        AREA_CODES.put("\u7ef5\u7af9\u5e02", 510683);
        AREA_CODES.put("\u7ef5\u9633\u5e02", 510700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 510701);
        AREA_CODES.put("\u6daa\u57ce\u533a", 510703);
        AREA_CODES.put("\u6e38\u4ed9\u533a", 510704);
        AREA_CODES.put("\u4e09\u53f0\u53bf", 510722);
        AREA_CODES.put("\u76d0\u4ead\u53bf", 510723);
        AREA_CODES.put("\u5b89\u3000\u53bf", 510724);
        AREA_CODES.put("\u6893\u6f7c\u53bf", 510725);
        AREA_CODES.put("\u5317\u5ddd\u7f8c\u65cf\u81ea\u6cbb\u53bf", 510726);
        AREA_CODES.put("\u5e73\u6b66\u53bf", 510727);
        AREA_CODES.put("\u6c5f\u6cb9\u5e02", 510781);
        AREA_CODES.put("\u5e7f\u5143\u5e02", 510800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 510801);
        AREA_CODES.put("\u5229\u5dde\u533a", 510802);
        AREA_CODES.put("\u5143\u575d\u533a", 510811);
        AREA_CODES.put("\u671d\u5929\u533a", 510812);
        AREA_CODES.put("\u65fa\u82cd\u53bf", 510821);
        AREA_CODES.put("\u9752\u5ddd\u53bf", 510822);
        AREA_CODES.put("\u5251\u9601\u53bf", 510823);
        AREA_CODES.put("\u82cd\u6eaa\u53bf", 510824);
        AREA_CODES.put("\u9042\u5b81\u5e02", 510900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 510901);
        AREA_CODES.put("\u8239\u5c71\u533a", 510903);
        AREA_CODES.put("\u5b89\u5c45\u533a", 510904);
        AREA_CODES.put("\u84ec\u6eaa\u53bf", 510921);
        AREA_CODES.put("\u5c04\u6d2a\u53bf", 510922);
        AREA_CODES.put("\u5927\u82f1\u53bf", 510923);
        AREA_CODES.put("\u5185\u6c5f\u5e02", 511000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 511001);
        AREA_CODES.put("\u5e02\u4e2d\u533a", 511002);
        AREA_CODES.put("\u4e1c\u5174\u533a", 511011);
        AREA_CODES.put("\u5a01\u8fdc\u53bf", 511024);
        AREA_CODES.put("\u8d44\u4e2d\u53bf", 511025);
        AREA_CODES.put("\u9686\u660c\u53bf", 511028);
        AREA_CODES.put("\u4e50\u5c71\u5e02", 511100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 511101);
        AREA_CODES.put("\u5e02\u4e2d\u533a", 511102);
        AREA_CODES.put("\u6c99\u6e7e\u533a", 511111);
        AREA_CODES.put("\u4e94\u901a\u6865\u533a", 511112);
        AREA_CODES.put("\u91d1\u53e3\u6cb3\u533a", 511113);
        AREA_CODES.put("\u728d\u4e3a\u53bf", 511123);
        AREA_CODES.put("\u4e95\u7814\u53bf", 511124);
        AREA_CODES.put("\u5939\u6c5f\u53bf", 511126);
        AREA_CODES.put("\u6c90\u5ddd\u53bf", 511129);
        AREA_CODES.put("\u5ce8\u8fb9\u5f5d\u65cf\u81ea\u6cbb\u53bf", 511132);
        AREA_CODES.put("\u9a6c\u8fb9\u5f5d\u65cf\u81ea\u6cbb\u53bf", 511133);
        AREA_CODES.put("\u5ce8\u7709\u5c71\u5e02", 511181);
        AREA_CODES.put("\u5357\u5145\u5e02", 511300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 511301);
        AREA_CODES.put("\u987a\u5e86\u533a", 511302);
        AREA_CODES.put("\u9ad8\u576a\u533a", 511303);
        AREA_CODES.put("\u5609\u9675\u533a", 511304);
        AREA_CODES.put("\u5357\u90e8\u53bf", 511321);
        AREA_CODES.put("\u8425\u5c71\u53bf", 511322);
        AREA_CODES.put("\u84ec\u5b89\u53bf", 511323);
        AREA_CODES.put("\u4eea\u9647\u53bf", 511324);
        AREA_CODES.put("\u897f\u5145\u53bf", 511325);
        AREA_CODES.put("\u9606\u4e2d\u5e02", 511381);
        AREA_CODES.put("\u7709\u5c71\u5e02", 511400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 511401);
        AREA_CODES.put("\u4e1c\u5761\u533a", 511402);
        AREA_CODES.put("\u4ec1\u5bff\u53bf", 511421);
        AREA_CODES.put("\u5f6d\u5c71\u53bf", 511422);
        AREA_CODES.put("\u6d2a\u96c5\u53bf", 511423);
        AREA_CODES.put("\u4e39\u68f1\u53bf", 511424);
        AREA_CODES.put("\u9752\u795e\u53bf", 511425);
        AREA_CODES.put("\u5b9c\u5bbe\u5e02", 511500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 511501);
        AREA_CODES.put("\u7fe0\u5c4f\u533a", 511502);
        AREA_CODES.put("\u5b9c\u5bbe\u53bf", 511521);
        AREA_CODES.put("\u5357\u6eaa\u53bf", 511522);
        AREA_CODES.put("\u6c5f\u5b89\u53bf", 511523);
        AREA_CODES.put("\u957f\u5b81\u53bf", 511524);
        AREA_CODES.put("\u9ad8\u3000\u53bf", 511525);
        AREA_CODES.put("\u73d9\u3000\u53bf", 511526);
        AREA_CODES.put("\u7b60\u8fde\u53bf", 511527);
        AREA_CODES.put("\u5174\u6587\u53bf", 511528);
        AREA_CODES.put("\u5c4f\u5c71\u53bf", 511529);
        AREA_CODES.put("\u5e7f\u5b89\u5e02", 511600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 511601);
        AREA_CODES.put("\u5e7f\u5b89\u533a", 511602);
        AREA_CODES.put("\u5cb3\u6c60\u53bf", 511621);
        AREA_CODES.put("\u6b66\u80dc\u53bf", 511622);
        AREA_CODES.put("\u90bb\u6c34\u53bf", 511623);
        AREA_CODES.put("\u534e\u84e5\u5e02", 511681);
        AREA_CODES.put("\u8fbe\u5dde\u5e02", 511700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 511701);
        AREA_CODES.put("\u901a\u5ddd\u533a", 511702);
        AREA_CODES.put("\u8fbe\u3000\u53bf", 511721);
        AREA_CODES.put("\u5ba3\u6c49\u53bf", 511722);
        AREA_CODES.put("\u5f00\u6c5f\u53bf", 511723);
        AREA_CODES.put("\u5927\u7af9\u53bf", 511724);
        AREA_CODES.put("\u6e20\u3000\u53bf", 511725);
        AREA_CODES.put("\u4e07\u6e90\u5e02", 511781);
        AREA_CODES.put("\u96c5\u5b89\u5e02", 511800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 511801);
        AREA_CODES.put("\u96e8\u57ce\u533a", 511802);
        AREA_CODES.put("\u540d\u5c71\u53bf", 511821);
        AREA_CODES.put("\u8365\u7ecf\u53bf", 511822);
        AREA_CODES.put("\u6c49\u6e90\u53bf", 511823);
        AREA_CODES.put("\u77f3\u68c9\u53bf", 511824);
        AREA_CODES.put("\u5929\u5168\u53bf", 511825);
        AREA_CODES.put("\u82a6\u5c71\u53bf", 511826);
        AREA_CODES.put("\u5b9d\u5174\u53bf", 511827);
        AREA_CODES.put("\u5df4\u4e2d\u5e02", 511900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 511901);
        AREA_CODES.put("\u5df4\u5dde\u533a", 511902);
        AREA_CODES.put("\u901a\u6c5f\u53bf", 511921);
        AREA_CODES.put("\u5357\u6c5f\u53bf", 511922);
        AREA_CODES.put("\u5e73\u660c\u53bf", 511923);
        AREA_CODES.put("\u8d44\u9633\u5e02", 512000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 512001);
        AREA_CODES.put("\u96c1\u6c5f\u533a", 512002);
        AREA_CODES.put("\u5b89\u5cb3\u53bf", 512021);
        AREA_CODES.put("\u4e50\u81f3\u53bf", 512022);
        AREA_CODES.put("\u7b80\u9633\u5e02", 512081);
        AREA_CODES.put("\u963f\u575d\u85cf\u65cf\u7f8c\u65cf\u81ea\u6cbb\u5dde", 513200);
        AREA_CODES.put("\u6c76\u5ddd\u53bf", 513221);
        AREA_CODES.put("\u7406\u3000\u53bf", 513222);
        AREA_CODES.put("\u8302\u3000\u53bf", 513223);
        AREA_CODES.put("\u677e\u6f58\u53bf", 513224);
        AREA_CODES.put("\u4e5d\u5be8\u6c9f\u53bf", 513225);
        AREA_CODES.put("\u91d1\u5ddd\u53bf", 513226);
        AREA_CODES.put("\u5c0f\u91d1\u53bf", 513227);
        AREA_CODES.put("\u9ed1\u6c34\u53bf", 513228);
        AREA_CODES.put("\u9a6c\u5c14\u5eb7\u53bf", 513229);
        AREA_CODES.put("\u58e4\u5858\u53bf", 513230);
        AREA_CODES.put("\u963f\u575d\u53bf", 513231);
        AREA_CODES.put("\u82e5\u5c14\u76d6\u53bf", 513232);
        AREA_CODES.put("\u7ea2\u539f\u53bf", 513233);
        AREA_CODES.put("\u7518\u5b5c\u85cf\u65cf\u81ea\u6cbb\u5dde", 513300);
        AREA_CODES.put("\u5eb7\u5b9a\u53bf", 513321);
        AREA_CODES.put("\u6cf8\u5b9a\u53bf", 513322);
        AREA_CODES.put("\u4e39\u5df4\u53bf", 513323);
        AREA_CODES.put("\u4e5d\u9f99\u53bf", 513324);
        AREA_CODES.put("\u96c5\u6c5f\u53bf", 513325);
        AREA_CODES.put("\u9053\u5b5a\u53bf", 513326);
        AREA_CODES.put("\u7089\u970d\u53bf", 513327);
        AREA_CODES.put("\u7518\u5b5c\u53bf", 513328);
        AREA_CODES.put("\u65b0\u9f99\u53bf", 513329);
        AREA_CODES.put("\u5fb7\u683c\u53bf", 513330);
        AREA_CODES.put("\u767d\u7389\u53bf", 513331);
        AREA_CODES.put("\u77f3\u6e20\u53bf", 513332);
        AREA_CODES.put("\u8272\u8fbe\u53bf", 513333);
        AREA_CODES.put("\u7406\u5858\u53bf", 513334);
        AREA_CODES.put("\u5df4\u5858\u53bf", 513335);
        AREA_CODES.put("\u4e61\u57ce\u53bf", 513336);
        AREA_CODES.put("\u7a3b\u57ce\u53bf", 513337);
        AREA_CODES.put("\u5f97\u8363\u53bf", 513338);
        AREA_CODES.put("\u51c9\u5c71\u5f5d\u65cf\u81ea\u6cbb\u5dde", 513400);
        AREA_CODES.put("\u897f\u660c\u5e02", 513401);
        AREA_CODES.put("\u6728\u91cc\u85cf\u65cf\u81ea\u6cbb\u53bf", 513422);
        AREA_CODES.put("\u76d0\u6e90\u53bf", 513423);
        AREA_CODES.put("\u5fb7\u660c\u53bf", 513424);
        AREA_CODES.put("\u4f1a\u7406\u53bf", 513425);
        AREA_CODES.put("\u4f1a\u4e1c\u53bf", 513426);
        AREA_CODES.put("\u5b81\u5357\u53bf", 513427);
        AREA_CODES.put("\u666e\u683c\u53bf", 513428);
        AREA_CODES.put("\u5e03\u62d6\u53bf", 513429);
        AREA_CODES.put("\u91d1\u9633\u53bf", 513430);
        AREA_CODES.put("\u662d\u89c9\u53bf", 513431);
        AREA_CODES.put("\u559c\u5fb7\u53bf", 513432);
        AREA_CODES.put("\u5195\u5b81\u53bf", 513433);
        AREA_CODES.put("\u8d8a\u897f\u53bf", 513434);
        AREA_CODES.put("\u7518\u6d1b\u53bf", 513435);
        AREA_CODES.put("\u7f8e\u59d1\u53bf", 513436);
        AREA_CODES.put("\u96f7\u6ce2\u53bf", 513437);
        AREA_CODES.put("\u8d35\u5dde\u7701", 520000);
        AREA_CODES.put("\u8d35\u9633\u5e02", 520100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 520101);
        AREA_CODES.put("\u5357\u660e\u533a", 520102);
        AREA_CODES.put("\u4e91\u5ca9\u533a", 520103);
        AREA_CODES.put("\u82b1\u6eaa\u533a", 520111);
        AREA_CODES.put("\u4e4c\u5f53\u533a", 520112);
        AREA_CODES.put("\u767d\u4e91\u533a", 520113);
        AREA_CODES.put("\u5c0f\u6cb3\u533a", 520114);
        AREA_CODES.put("\u5f00\u9633\u53bf", 520121);
        AREA_CODES.put("\u606f\u70fd\u53bf", 520122);
        AREA_CODES.put("\u4fee\u6587\u53bf", 520123);
        AREA_CODES.put("\u6e05\u9547\u5e02", 520181);
        AREA_CODES.put("\u516d\u76d8\u6c34\u5e02", 520200);
        AREA_CODES.put("\u949f\u5c71\u533a", 520201);
        AREA_CODES.put("\u516d\u679d\u7279\u533a", 520203);
        AREA_CODES.put("\u6c34\u57ce\u53bf", 520221);
        AREA_CODES.put("\u76d8\u3000\u53bf", 520222);
        AREA_CODES.put("\u9075\u4e49\u5e02", 520300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 520301);
        AREA_CODES.put("\u7ea2\u82b1\u5c97\u533a", 520302);
        AREA_CODES.put("\u6c47\u5ddd\u533a", 520303);
        AREA_CODES.put("\u9075\u4e49\u53bf", 520321);
        AREA_CODES.put("\u6850\u6893\u53bf", 520322);
        AREA_CODES.put("\u7ee5\u9633\u53bf", 520323);
        AREA_CODES.put("\u6b63\u5b89\u53bf", 520324);
        AREA_CODES.put("\u9053\u771f\u4ee1\u4f6c\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 520325);
        AREA_CODES.put("\u52a1\u5ddd\u4ee1\u4f6c\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 520326);
        AREA_CODES.put("\u51e4\u5188\u53bf", 520327);
        AREA_CODES.put("\u6e44\u6f6d\u53bf", 520328);
        AREA_CODES.put("\u4f59\u5e86\u53bf", 520329);
        AREA_CODES.put("\u4e60\u6c34\u53bf", 520330);
        AREA_CODES.put("\u8d64\u6c34\u5e02", 520381);
        AREA_CODES.put("\u4ec1\u6000\u5e02", 520382);
        AREA_CODES.put("\u5b89\u987a\u5e02", 520400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 520401);
        AREA_CODES.put("\u897f\u79c0\u533a", 520402);
        AREA_CODES.put("\u5e73\u575d\u53bf", 520421);
        AREA_CODES.put("\u666e\u5b9a\u53bf", 520422);
        AREA_CODES.put("\u9547\u5b81\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 520423);
        AREA_CODES.put("\u5173\u5cad\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 520424);
        AREA_CODES.put("\u7d2b\u4e91\u82d7\u65cf\u5e03\u4f9d\u65cf\u81ea\u6cbb\u53bf", 520425);
        AREA_CODES.put("\u94dc\u4ec1\u5730\u533a", 522200);
        AREA_CODES.put("\u94dc\u4ec1\u5e02", 522201);
        AREA_CODES.put("\u6c5f\u53e3\u53bf", 522222);
        AREA_CODES.put("\u7389\u5c4f\u4f97\u65cf\u81ea\u6cbb\u53bf", 522223);
        AREA_CODES.put("\u77f3\u9621\u53bf", 522224);
        AREA_CODES.put("\u601d\u5357\u53bf", 522225);
        AREA_CODES.put("\u5370\u6c5f\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 522226);
        AREA_CODES.put("\u5fb7\u6c5f\u53bf", 522227);
        AREA_CODES.put("\u6cbf\u6cb3\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf", 522228);
        AREA_CODES.put("\u677e\u6843\u82d7\u65cf\u81ea\u6cbb\u53bf", 522229);
        AREA_CODES.put("\u4e07\u5c71\u7279\u533a", 522230);
        AREA_CODES.put("\u9ed4\u897f\u5357\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", 522300);
        AREA_CODES.put("\u5174\u4e49\u5e02", 522301);
        AREA_CODES.put("\u5174\u4ec1\u53bf", 522322);
        AREA_CODES.put("\u666e\u5b89\u53bf", 522323);
        AREA_CODES.put("\u6674\u9686\u53bf", 522324);
        AREA_CODES.put("\u8d1e\u4e30\u53bf", 522325);
        AREA_CODES.put("\u671b\u8c1f\u53bf", 522326);
        AREA_CODES.put("\u518c\u4ea8\u53bf", 522327);
        AREA_CODES.put("\u5b89\u9f99\u53bf", 522328);
        AREA_CODES.put("\u6bd5\u8282\u5730\u533a", 522400);
        AREA_CODES.put("\u6bd5\u8282\u5e02", 522401);
        AREA_CODES.put("\u5927\u65b9\u53bf", 522422);
        AREA_CODES.put("\u9ed4\u897f\u53bf", 522423);
        AREA_CODES.put("\u91d1\u6c99\u53bf", 522424);
        AREA_CODES.put("\u7ec7\u91d1\u53bf", 522425);
        AREA_CODES.put("\u7eb3\u96cd\u53bf", 522426);
        AREA_CODES.put("\u5a01\u5b81\u5f5d\u65cf\u56de\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 522427);
        AREA_CODES.put("\u8d6b\u7ae0\u53bf", 522428);
        AREA_CODES.put("\u9ed4\u4e1c\u5357\u82d7\u65cf\u4f97\u65cf\u81ea\u6cbb\u5dde", 522600);
        AREA_CODES.put("\u51ef\u91cc\u5e02", 522601);
        AREA_CODES.put("\u9ec4\u5e73\u53bf", 522622);
        AREA_CODES.put("\u65bd\u79c9\u53bf", 522623);
        AREA_CODES.put("\u4e09\u7a57\u53bf", 522624);
        AREA_CODES.put("\u9547\u8fdc\u53bf", 522625);
        AREA_CODES.put("\u5c91\u5de9\u53bf", 522626);
        AREA_CODES.put("\u5929\u67f1\u53bf", 522627);
        AREA_CODES.put("\u9526\u5c4f\u53bf", 522628);
        AREA_CODES.put("\u5251\u6cb3\u53bf", 522629);
        AREA_CODES.put("\u53f0\u6c5f\u53bf", 522630);
        AREA_CODES.put("\u9ece\u5e73\u53bf", 522631);
        AREA_CODES.put("\u6995\u6c5f\u53bf", 522632);
        AREA_CODES.put("\u4ece\u6c5f\u53bf", 522633);
        AREA_CODES.put("\u96f7\u5c71\u53bf", 522634);
        AREA_CODES.put("\u9ebb\u6c5f\u53bf", 522635);
        AREA_CODES.put("\u4e39\u5be8\u53bf", 522636);
        AREA_CODES.put("\u9ed4\u5357\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", 522700);
        AREA_CODES.put("\u90fd\u5300\u5e02", 522701);
        AREA_CODES.put("\u798f\u6cc9\u5e02", 522702);
        AREA_CODES.put("\u8354\u6ce2\u53bf", 522722);
        AREA_CODES.put("\u8d35\u5b9a\u53bf", 522723);
        AREA_CODES.put("\u74ee\u5b89\u53bf", 522725);
        AREA_CODES.put("\u72ec\u5c71\u53bf", 522726);
        AREA_CODES.put("\u5e73\u5858\u53bf", 522727);
        AREA_CODES.put("\u7f57\u7538\u53bf", 522728);
        AREA_CODES.put("\u957f\u987a\u53bf", 522729);
        AREA_CODES.put("\u9f99\u91cc\u53bf", 522730);
        AREA_CODES.put("\u60e0\u6c34\u53bf", 522731);
        AREA_CODES.put("\u4e09\u90fd\u6c34\u65cf\u81ea\u6cbb\u53bf", 522732);
        AREA_CODES.put("\u4e91\u5357\u7701", 530000);
        AREA_CODES.put("\u6606\u660e\u5e02", 530100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 530101);
        AREA_CODES.put("\u4e94\u534e\u533a", 530102);
        AREA_CODES.put("\u76d8\u9f99\u533a", 530103);
        AREA_CODES.put("\u5b98\u6e21\u533a", 530111);
        AREA_CODES.put("\u897f\u5c71\u533a", 530112);
        AREA_CODES.put("\u4e1c\u5ddd\u533a", 530113);
        AREA_CODES.put("\u5448\u8d21\u53bf", 530121);
        AREA_CODES.put("\u664b\u5b81\u53bf", 530122);
        AREA_CODES.put("\u5bcc\u6c11\u53bf", 530124);
        AREA_CODES.put("\u5b9c\u826f\u53bf", 530125);
        AREA_CODES.put("\u77f3\u6797\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530126);
        AREA_CODES.put("\u5d69\u660e\u53bf", 530127);
        AREA_CODES.put("\u7984\u529d\u5f5d\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 530128);
        AREA_CODES.put("\u5bfb\u7538\u56de\u65cf\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530129);
        AREA_CODES.put("\u5b89\u5b81\u5e02", 530181);
        AREA_CODES.put("\u66f2\u9756\u5e02", 530300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 530301);
        AREA_CODES.put("\u9e92\u9e9f\u533a", 530302);
        AREA_CODES.put("\u9a6c\u9f99\u53bf", 530321);
        AREA_CODES.put("\u9646\u826f\u53bf", 530322);
        AREA_CODES.put("\u5e08\u5b97\u53bf", 530323);
        AREA_CODES.put("\u7f57\u5e73\u53bf", 530324);
        AREA_CODES.put("\u5bcc\u6e90\u53bf", 530325);
        AREA_CODES.put("\u4f1a\u6cfd\u53bf", 530326);
        AREA_CODES.put("\u6cbe\u76ca\u53bf", 530328);
        AREA_CODES.put("\u5ba3\u5a01\u5e02", 530381);
        AREA_CODES.put("\u7389\u6eaa\u5e02", 530400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 530401);
        AREA_CODES.put("\u7ea2\u5854\u533a", 530402);
        AREA_CODES.put("\u6c5f\u5ddd\u53bf", 530421);
        AREA_CODES.put("\u6f84\u6c5f\u53bf", 530422);
        AREA_CODES.put("\u901a\u6d77\u53bf", 530423);
        AREA_CODES.put("\u534e\u5b81\u53bf", 530424);
        AREA_CODES.put("\u6613\u95e8\u53bf", 530425);
        AREA_CODES.put("\u5ce8\u5c71\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530426);
        AREA_CODES.put("\u65b0\u5e73\u5f5d\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf", 530427);
        AREA_CODES.put("\u5143\u6c5f\u54c8\u5c3c\u65cf\u5f5d\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf", 530428);
        AREA_CODES.put("\u4fdd\u5c71\u5e02", 530500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 530501);
        AREA_CODES.put("\u9686\u9633\u533a", 530502);
        AREA_CODES.put("\u65bd\u7538\u53bf", 530521);
        AREA_CODES.put("\u817e\u51b2\u53bf", 530522);
        AREA_CODES.put("\u9f99\u9675\u53bf", 530523);
        AREA_CODES.put("\u660c\u5b81\u53bf", 530524);
        AREA_CODES.put("\u662d\u901a\u5e02", 530600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 530601);
        AREA_CODES.put("\u662d\u9633\u533a", 530602);
        AREA_CODES.put("\u9c81\u7538\u53bf", 530621);
        AREA_CODES.put("\u5de7\u5bb6\u53bf", 530622);
        AREA_CODES.put("\u76d0\u6d25\u53bf", 530623);
        AREA_CODES.put("\u5927\u5173\u53bf", 530624);
        AREA_CODES.put("\u6c38\u5584\u53bf", 530625);
        AREA_CODES.put("\u7ee5\u6c5f\u53bf", 530626);
        AREA_CODES.put("\u9547\u96c4\u53bf", 530627);
        AREA_CODES.put("\u5f5d\u826f\u53bf", 530628);
        AREA_CODES.put("\u5a01\u4fe1\u53bf", 530629);
        AREA_CODES.put("\u6c34\u5bcc\u53bf", 530630);
        AREA_CODES.put("\u4e3d\u6c5f\u5e02", 530700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 530701);
        AREA_CODES.put("\u53e4\u57ce\u533a", 530702);
        AREA_CODES.put("\u7389\u9f99\u7eb3\u897f\u65cf\u81ea\u6cbb\u53bf", 530721);
        AREA_CODES.put("\u6c38\u80dc\u53bf", 530722);
        AREA_CODES.put("\u534e\u576a\u53bf", 530723);
        AREA_CODES.put("\u5b81\u8497\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530724);
        AREA_CODES.put("\u666e\u6d31\u5e02", 530800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 530801);
        AREA_CODES.put("\u601d\u8305\u533a", 530802);
        AREA_CODES.put("\u5b81\u6d31\u54c8\u5c3c\u65cf\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530821);
        AREA_CODES.put("\u58a8\u6c5f\u54c8\u5c3c\u65cf\u81ea\u6cbb\u53bf", 530822);
        AREA_CODES.put("\u666f\u4e1c\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530823);
        AREA_CODES.put("\u666f\u8c37\u50a3\u65cf\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530824);
        AREA_CODES.put("\u9547\u6c85\u5f5d\u65cf\u54c8\u5c3c\u65cf\u62c9\u795c\u65cf\u81ea\u6cbb\u53bf", 530825);
        AREA_CODES.put("\u6c5f\u57ce\u54c8\u5c3c\u65cf\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530826);
        AREA_CODES.put("\u5b5f\u8fde\u50a3\u65cf\u62c9\u795c\u65cf\u4f64\u65cf\u81ea\u6cbb\u53bf", 530827);
        AREA_CODES.put("\u6f9c\u6ca7\u62c9\u795c\u65cf\u81ea\u6cbb\u53bf", 530828);
        AREA_CODES.put("\u897f\u76df\u4f64\u65cf\u81ea\u6cbb\u53bf", 530829);
        AREA_CODES.put("\u4e34\u6ca7\u5e02", 530900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 530901);
        AREA_CODES.put("\u4e34\u7fd4\u533a", 530902);
        AREA_CODES.put("\u51e4\u5e86\u53bf", 530921);
        AREA_CODES.put("\u4e91\u3000\u53bf", 530922);
        AREA_CODES.put("\u6c38\u5fb7\u53bf", 530923);
        AREA_CODES.put("\u9547\u5eb7\u53bf", 530924);
        AREA_CODES.put("\u53cc\u6c5f\u62c9\u795c\u65cf\u4f64\u65cf\u5e03\u6717\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf", 530925);
        AREA_CODES.put("\u803f\u9a6c\u50a3\u65cf\u4f64\u65cf\u81ea\u6cbb\u53bf", 530926);
        AREA_CODES.put("\u6ca7\u6e90\u4f64\u65cf\u81ea\u6cbb\u53bf", 530927);
        AREA_CODES.put("\u695a\u96c4\u5f5d\u65cf\u81ea\u6cbb\u5dde", 532300);
        AREA_CODES.put("\u695a\u96c4\u5e02", 532301);
        AREA_CODES.put("\u53cc\u67cf\u53bf", 532322);
        AREA_CODES.put("\u725f\u5b9a\u53bf", 532323);
        AREA_CODES.put("\u5357\u534e\u53bf", 532324);
        AREA_CODES.put("\u59da\u5b89\u53bf", 532325);
        AREA_CODES.put("\u5927\u59da\u53bf", 532326);
        AREA_CODES.put("\u6c38\u4ec1\u53bf", 532327);
        AREA_CODES.put("\u5143\u8c0b\u53bf", 532328);
        AREA_CODES.put("\u6b66\u5b9a\u53bf", 532329);
        AREA_CODES.put("\u7984\u4e30\u53bf", 532331);
        AREA_CODES.put("\u7ea2\u6cb3\u54c8\u5c3c\u65cf\u5f5d\u65cf\u81ea\u6cbb\u5dde", 532500);
        AREA_CODES.put("\u4e2a\u65e7\u5e02", 532501);
        AREA_CODES.put("\u5f00\u8fdc\u5e02", 532502);
        AREA_CODES.put("\u8499\u81ea\u53bf", 532522);
        AREA_CODES.put("\u5c4f\u8fb9\u82d7\u65cf\u81ea\u6cbb\u53bf", 532523);
        AREA_CODES.put("\u5efa\u6c34\u53bf", 532524);
        AREA_CODES.put("\u77f3\u5c4f\u53bf", 532525);
        AREA_CODES.put("\u5f25\u52d2\u53bf", 532526);
        AREA_CODES.put("\u6cf8\u897f\u53bf", 532527);
        AREA_CODES.put("\u5143\u9633\u53bf", 532528);
        AREA_CODES.put("\u7ea2\u6cb3\u53bf", 532529);
        AREA_CODES.put("\u91d1\u5e73\u82d7\u65cf\u7476\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf", 532530);
        AREA_CODES.put("\u7eff\u6625\u53bf", 532531);
        AREA_CODES.put("\u6cb3\u53e3\u7476\u65cf\u81ea\u6cbb\u53bf", 532532);
        AREA_CODES.put("\u6587\u5c71\u58ee\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", 532600);
        AREA_CODES.put("\u6587\u5c71\u53bf", 532621);
        AREA_CODES.put("\u781a\u5c71\u53bf", 532622);
        AREA_CODES.put("\u897f\u7574\u53bf", 532623);
        AREA_CODES.put("\u9ebb\u6817\u5761\u53bf", 532624);
        AREA_CODES.put("\u9a6c\u5173\u53bf", 532625);
        AREA_CODES.put("\u4e18\u5317\u53bf", 532626);
        AREA_CODES.put("\u5e7f\u5357\u53bf", 532627);
        AREA_CODES.put("\u5bcc\u5b81\u53bf", 532628);
        AREA_CODES.put("\u897f\u53cc\u7248\u7eb3\u50a3\u65cf\u81ea\u6cbb\u5dde", 532800);
        AREA_CODES.put("\u666f\u6d2a\u5e02", 532801);
        AREA_CODES.put("\u52d0\u6d77\u53bf", 532822);
        AREA_CODES.put("\u52d0\u814a\u53bf", 532823);
        AREA_CODES.put("\u5927\u7406\u767d\u65cf\u81ea\u6cbb\u5dde", 532900);
        AREA_CODES.put("\u5927\u7406\u5e02", 532901);
        AREA_CODES.put("\u6f3e\u6fde\u5f5d\u65cf\u81ea\u6cbb\u53bf", 532922);
        AREA_CODES.put("\u7965\u4e91\u53bf", 532923);
        AREA_CODES.put("\u5bbe\u5ddd\u53bf", 532924);
        AREA_CODES.put("\u5f25\u6e21\u53bf", 532925);
        AREA_CODES.put("\u5357\u6da7\u5f5d\u65cf\u81ea\u6cbb\u53bf", 532926);
        AREA_CODES.put("\u5dcd\u5c71\u5f5d\u65cf\u56de\u65cf\u81ea\u6cbb\u53bf", 532927);
        AREA_CODES.put("\u6c38\u5e73\u53bf", 532928);
        AREA_CODES.put("\u4e91\u9f99\u53bf", 532929);
        AREA_CODES.put("\u6d31\u6e90\u53bf", 532930);
        AREA_CODES.put("\u5251\u5ddd\u53bf", 532931);
        AREA_CODES.put("\u9e64\u5e86\u53bf", 532932);
        AREA_CODES.put("\u5fb7\u5b8f\u50a3\u65cf\u666f\u9887\u65cf\u81ea\u6cbb\u5dde", 533100);
        AREA_CODES.put("\u745e\u4e3d\u5e02", 533102);
        AREA_CODES.put("\u6f5e\u897f\u5e02", 533103);
        AREA_CODES.put("\u6881\u6cb3\u53bf", 533122);
        AREA_CODES.put("\u76c8\u6c5f\u53bf", 533123);
        AREA_CODES.put("\u9647\u5ddd\u53bf", 533124);
        AREA_CODES.put("\u6012\u6c5f\u5088\u50f3\u65cf\u81ea\u6cbb\u5dde", 533300);
        AREA_CODES.put("\u6cf8\u6c34\u53bf", 533321);
        AREA_CODES.put("\u798f\u8d21\u53bf", 533323);
        AREA_CODES.put("\u8d21\u5c71\u72ec\u9f99\u65cf\u6012\u65cf\u81ea\u6cbb\u53bf", 533324);
        AREA_CODES.put("\u5170\u576a\u767d\u65cf\u666e\u7c73\u65cf\u81ea\u6cbb\u53bf", 533325);
        AREA_CODES.put("\u8fea\u5e86\u85cf\u65cf\u81ea\u6cbb\u5dde", 533400);
        AREA_CODES.put("\u9999\u683c\u91cc\u62c9\u53bf", 533421);
        AREA_CODES.put("\u5fb7\u94a6\u53bf", 533422);
        AREA_CODES.put("\u7ef4\u897f\u5088\u50f3\u65cf\u81ea\u6cbb\u53bf", 533423);
        AREA_CODES.put("\u897f\u85cf\u81ea\u6cbb\u533a", 540000);
        AREA_CODES.put("\u62c9\u8428\u5e02", 540100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 540101);
        AREA_CODES.put("\u57ce\u5173\u533a", 540102);
        AREA_CODES.put("\u6797\u5468\u53bf", 540121);
        AREA_CODES.put("\u5f53\u96c4\u53bf", 540122);
        AREA_CODES.put("\u5c3c\u6728\u53bf", 540123);
        AREA_CODES.put("\u66f2\u6c34\u53bf", 540124);
        AREA_CODES.put("\u5806\u9f99\u5fb7\u5e86\u53bf", 540125);
        AREA_CODES.put("\u8fbe\u5b5c\u53bf", 540126);
        AREA_CODES.put("\u58a8\u7af9\u5de5\u5361\u53bf", 540127);
        AREA_CODES.put("\u660c\u90fd\u5730\u533a", 542100);
        AREA_CODES.put("\u660c\u90fd\u53bf", 542121);
        AREA_CODES.put("\u6c5f\u8fbe\u53bf", 542122);
        AREA_CODES.put("\u8d21\u89c9\u53bf", 542123);
        AREA_CODES.put("\u7c7b\u4e4c\u9f50\u53bf", 542124);
        AREA_CODES.put("\u4e01\u9752\u53bf", 542125);
        AREA_CODES.put("\u5bdf\u96c5\u53bf", 542126);
        AREA_CODES.put("\u516b\u5bbf\u53bf", 542127);
        AREA_CODES.put("\u5de6\u8d21\u53bf", 542128);
        AREA_CODES.put("\u8292\u5eb7\u53bf", 542129);
        AREA_CODES.put("\u6d1b\u9686\u53bf", 542132);
        AREA_CODES.put("\u8fb9\u575d\u53bf", 542133);
        AREA_CODES.put("\u5c71\u5357\u5730\u533a", 542200);
        AREA_CODES.put("\u4e43\u4e1c\u53bf", 542221);
        AREA_CODES.put("\u624e\u56ca\u53bf", 542222);
        AREA_CODES.put("\u8d21\u560e\u53bf", 542223);
        AREA_CODES.put("\u6851\u65e5\u53bf", 542224);
        AREA_CODES.put("\u743c\u7ed3\u53bf", 542225);
        AREA_CODES.put("\u66f2\u677e\u53bf", 542226);
        AREA_CODES.put("\u63aa\u7f8e\u53bf", 542227);
        AREA_CODES.put("\u6d1b\u624e\u53bf", 542228);
        AREA_CODES.put("\u52a0\u67e5\u53bf", 542229);
        AREA_CODES.put("\u9686\u5b50\u53bf", 542231);
        AREA_CODES.put("\u9519\u90a3\u53bf", 542232);
        AREA_CODES.put("\u6d6a\u5361\u5b50\u53bf", 542233);
        AREA_CODES.put("\u65e5\u5580\u5219\u5730\u533a", 542300);
        AREA_CODES.put("\u65e5\u5580\u5219\u5e02", 542301);
        AREA_CODES.put("\u5357\u6728\u6797\u53bf", 542322);
        AREA_CODES.put("\u6c5f\u5b5c\u53bf", 542323);
        AREA_CODES.put("\u5b9a\u65e5\u53bf", 542324);
        AREA_CODES.put("\u8428\u8fe6\u53bf", 542325);
        AREA_CODES.put("\u62c9\u5b5c\u53bf", 542326);
        AREA_CODES.put("\u6602\u4ec1\u53bf", 542327);
        AREA_CODES.put("\u8c22\u901a\u95e8\u53bf", 542328);
        AREA_CODES.put("\u767d\u6717\u53bf", 542329);
        AREA_CODES.put("\u4ec1\u5e03\u53bf", 542330);
        AREA_CODES.put("\u5eb7\u9a6c\u53bf", 542331);
        AREA_CODES.put("\u5b9a\u7ed3\u53bf", 542332);
        AREA_CODES.put("\u4ef2\u5df4\u53bf", 542333);
        AREA_CODES.put("\u4e9a\u4e1c\u53bf", 542334);
        AREA_CODES.put("\u5409\u9686\u53bf", 542335);
        AREA_CODES.put("\u8042\u62c9\u6728\u53bf", 542336);
        AREA_CODES.put("\u8428\u560e\u53bf", 542337);
        AREA_CODES.put("\u5c97\u5df4\u53bf", 542338);
        AREA_CODES.put("\u90a3\u66f2\u5730\u533a", 542400);
        AREA_CODES.put("\u90a3\u66f2\u53bf", 542421);
        AREA_CODES.put("\u5609\u9ece\u53bf", 542422);
        AREA_CODES.put("\u6bd4\u5982\u53bf", 542423);
        AREA_CODES.put("\u8042\u8363\u53bf", 542424);
        AREA_CODES.put("\u5b89\u591a\u53bf", 542425);
        AREA_CODES.put("\u7533\u624e\u53bf", 542426);
        AREA_CODES.put("\u7d22\u3000\u53bf", 542427);
        AREA_CODES.put("\u73ed\u6208\u53bf", 542428);
        AREA_CODES.put("\u5df4\u9752\u53bf", 542429);
        AREA_CODES.put("\u5c3c\u739b\u53bf", 542430);
        AREA_CODES.put("\u963f\u91cc\u5730\u533a", 542500);
        AREA_CODES.put("\u666e\u5170\u53bf", 542521);
        AREA_CODES.put("\u672d\u8fbe\u53bf", 542522);
        AREA_CODES.put("\u5676\u5c14\u53bf", 542523);
        AREA_CODES.put("\u65e5\u571f\u53bf", 542524);
        AREA_CODES.put("\u9769\u5409\u53bf", 542525);
        AREA_CODES.put("\u6539\u5219\u53bf", 542526);
        AREA_CODES.put("\u63aa\u52e4\u53bf", 542527);
        AREA_CODES.put("\u6797\u829d\u5730\u533a", 542600);
        AREA_CODES.put("\u6797\u829d\u53bf", 542621);
        AREA_CODES.put("\u5de5\u5e03\u6c5f\u8fbe\u53bf", 542622);
        AREA_CODES.put("\u7c73\u6797\u53bf", 542623);
        AREA_CODES.put("\u58a8\u8131\u53bf", 542624);
        AREA_CODES.put("\u6ce2\u5bc6\u53bf", 542625);
        AREA_CODES.put("\u5bdf\u9685\u53bf", 542626);
        AREA_CODES.put("\u6717\u3000\u53bf", 542627);
        AREA_CODES.put("\u9655\u897f\u7701", 610000);
        AREA_CODES.put("\u897f\u5b89\u5e02", 610100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 610101);
        AREA_CODES.put("\u65b0\u57ce\u533a", 610102);
        AREA_CODES.put("\u7891\u6797\u533a", 610103);
        AREA_CODES.put("\u83b2\u6e56\u533a", 610104);
        AREA_CODES.put("\u705e\u6865\u533a", 610111);
        AREA_CODES.put("\u672a\u592e\u533a", 610112);
        AREA_CODES.put("\u96c1\u5854\u533a", 610113);
        AREA_CODES.put("\u960e\u826f\u533a", 610114);
        AREA_CODES.put("\u4e34\u6f7c\u533a", 610115);
        AREA_CODES.put("\u957f\u5b89\u533a", 610116);
        AREA_CODES.put("\u84dd\u7530\u53bf", 610122);
        AREA_CODES.put("\u5468\u81f3\u53bf", 610124);
        AREA_CODES.put("\u6237\u3000\u53bf", 610125);
        AREA_CODES.put("\u9ad8\u9675\u53bf", 610126);
        AREA_CODES.put("\u94dc\u5ddd\u5e02", 610200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 610201);
        AREA_CODES.put("\u738b\u76ca\u533a", 610202);
        AREA_CODES.put("\u5370\u53f0\u533a", 610203);
        AREA_CODES.put("\u8000\u5dde\u533a", 610204);
        AREA_CODES.put("\u5b9c\u541b\u53bf", 610222);
        AREA_CODES.put("\u5b9d\u9e21\u5e02", 610300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 610301);
        AREA_CODES.put("\u6e2d\u6ee8\u533a", 610302);
        AREA_CODES.put("\u91d1\u53f0\u533a", 610303);
        AREA_CODES.put("\u9648\u4ed3\u533a", 610304);
        AREA_CODES.put("\u51e4\u7fd4\u53bf", 610322);
        AREA_CODES.put("\u5c90\u5c71\u53bf", 610323);
        AREA_CODES.put("\u6276\u98ce\u53bf", 610324);
        AREA_CODES.put("\u7709\u3000\u53bf", 610326);
        AREA_CODES.put("\u9647\u3000\u53bf", 610327);
        AREA_CODES.put("\u5343\u9633\u53bf", 610328);
        AREA_CODES.put("\u9e9f\u6e38\u53bf", 610329);
        AREA_CODES.put("\u51e4\u3000\u53bf", 610330);
        AREA_CODES.put("\u592a\u767d\u53bf", 610331);
        AREA_CODES.put("\u54b8\u9633\u5e02", 610400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 610401);
        AREA_CODES.put("\u79e6\u90fd\u533a", 610402);
        AREA_CODES.put("\u6768\u9675\u533a", 610403);
        AREA_CODES.put("\u6e2d\u57ce\u533a", 610404);
        AREA_CODES.put("\u4e09\u539f\u53bf", 610422);
        AREA_CODES.put("\u6cfe\u9633\u53bf", 610423);
        AREA_CODES.put("\u4e7e\u3000\u53bf", 610424);
        AREA_CODES.put("\u793c\u6cc9\u53bf", 610425);
        AREA_CODES.put("\u6c38\u5bff\u53bf", 610426);
        AREA_CODES.put("\u5f6c\u3000\u53bf", 610427);
        AREA_CODES.put("\u957f\u6b66\u53bf", 610428);
        AREA_CODES.put("\u65ec\u9091\u53bf", 610429);
        AREA_CODES.put("\u6df3\u5316\u53bf", 610430);
        AREA_CODES.put("\u6b66\u529f\u53bf", 610431);
        AREA_CODES.put("\u5174\u5e73\u5e02", 610481);
        AREA_CODES.put("\u6e2d\u5357\u5e02", 610500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 610501);
        AREA_CODES.put("\u4e34\u6e2d\u533a", 610502);
        AREA_CODES.put("\u534e\u3000\u53bf", 610521);
        AREA_CODES.put("\u6f7c\u5173\u53bf", 610522);
        AREA_CODES.put("\u5927\u8354\u53bf", 610523);
        AREA_CODES.put("\u5408\u9633\u53bf", 610524);
        AREA_CODES.put("\u6f84\u57ce\u53bf", 610525);
        AREA_CODES.put("\u84b2\u57ce\u53bf", 610526);
        AREA_CODES.put("\u767d\u6c34\u53bf", 610527);
        AREA_CODES.put("\u5bcc\u5e73\u53bf", 610528);
        AREA_CODES.put("\u97e9\u57ce\u5e02", 610581);
        AREA_CODES.put("\u534e\u9634\u5e02", 610582);
        AREA_CODES.put("\u5ef6\u5b89\u5e02", 610600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 610601);
        AREA_CODES.put("\u5b9d\u5854\u533a", 610602);
        AREA_CODES.put("\u5ef6\u957f\u53bf", 610621);
        AREA_CODES.put("\u5ef6\u5ddd\u53bf", 610622);
        AREA_CODES.put("\u5b50\u957f\u53bf", 610623);
        AREA_CODES.put("\u5b89\u585e\u53bf", 610624);
        AREA_CODES.put("\u5fd7\u4e39\u53bf", 610625);
        AREA_CODES.put("\u5434\u8d77\u53bf", 610626);
        AREA_CODES.put("\u7518\u6cc9\u53bf", 610627);
        AREA_CODES.put("\u5bcc\u3000\u53bf", 610628);
        AREA_CODES.put("\u6d1b\u5ddd\u53bf", 610629);
        AREA_CODES.put("\u5b9c\u5ddd\u53bf", 610630);
        AREA_CODES.put("\u9ec4\u9f99\u53bf", 610631);
        AREA_CODES.put("\u9ec4\u9675\u53bf", 610632);
        AREA_CODES.put("\u6c49\u4e2d\u5e02", 610700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 610701);
        AREA_CODES.put("\u6c49\u53f0\u533a", 610702);
        AREA_CODES.put("\u5357\u90d1\u53bf", 610721);
        AREA_CODES.put("\u57ce\u56fa\u53bf", 610722);
        AREA_CODES.put("\u6d0b\u3000\u53bf", 610723);
        AREA_CODES.put("\u897f\u4e61\u53bf", 610724);
        AREA_CODES.put("\u52c9\u3000\u53bf", 610725);
        AREA_CODES.put("\u5b81\u5f3a\u53bf", 610726);
        AREA_CODES.put("\u7565\u9633\u53bf", 610727);
        AREA_CODES.put("\u9547\u5df4\u53bf", 610728);
        AREA_CODES.put("\u7559\u575d\u53bf", 610729);
        AREA_CODES.put("\u4f5b\u576a\u53bf", 610730);
        AREA_CODES.put("\u6986\u6797\u5e02", 610800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 610801);
        AREA_CODES.put("\u6986\u9633\u533a", 610802);
        AREA_CODES.put("\u795e\u6728\u53bf", 610821);
        AREA_CODES.put("\u5e9c\u8c37\u53bf", 610822);
        AREA_CODES.put("\u6a2a\u5c71\u53bf", 610823);
        AREA_CODES.put("\u9756\u8fb9\u53bf", 610824);
        AREA_CODES.put("\u5b9a\u8fb9\u53bf", 610825);
        AREA_CODES.put("\u7ee5\u5fb7\u53bf", 610826);
        AREA_CODES.put("\u7c73\u8102\u53bf", 610827);
        AREA_CODES.put("\u4f73\u3000\u53bf", 610828);
        AREA_CODES.put("\u5434\u5821\u53bf", 610829);
        AREA_CODES.put("\u6e05\u6da7\u53bf", 610830);
        AREA_CODES.put("\u5b50\u6d32\u53bf", 610831);
        AREA_CODES.put("\u5b89\u5eb7\u5e02", 610900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 610901);
        AREA_CODES.put("\u6c49\u6ee8\u533a", 610902);
        AREA_CODES.put("\u6c49\u9634\u53bf", 610921);
        AREA_CODES.put("\u77f3\u6cc9\u53bf", 610922);
        AREA_CODES.put("\u5b81\u9655\u53bf", 610923);
        AREA_CODES.put("\u7d2b\u9633\u53bf", 610924);
        AREA_CODES.put("\u5c9a\u768b\u53bf", 610925);
        AREA_CODES.put("\u5e73\u5229\u53bf", 610926);
        AREA_CODES.put("\u9547\u576a\u53bf", 610927);
        AREA_CODES.put("\u65ec\u9633\u53bf", 610928);
        AREA_CODES.put("\u767d\u6cb3\u53bf", 610929);
        AREA_CODES.put("\u5546\u6d1b\u5e02", 611000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 611001);
        AREA_CODES.put("\u5546\u5dde\u533a", 611002);
        AREA_CODES.put("\u6d1b\u5357\u53bf", 611021);
        AREA_CODES.put("\u4e39\u51e4\u53bf", 611022);
        AREA_CODES.put("\u5546\u5357\u53bf", 611023);
        AREA_CODES.put("\u5c71\u9633\u53bf", 611024);
        AREA_CODES.put("\u9547\u5b89\u53bf", 611025);
        AREA_CODES.put("\u67de\u6c34\u53bf", 611026);
        AREA_CODES.put("\u7518\u8083\u7701", 620000);
        AREA_CODES.put("\u5170\u5dde\u5e02", 620100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 620101);
        AREA_CODES.put("\u57ce\u5173\u533a", 620102);
        AREA_CODES.put("\u4e03\u91cc\u6cb3\u533a", 620103);
        AREA_CODES.put("\u897f\u56fa\u533a", 620104);
        AREA_CODES.put("\u5b89\u5b81\u533a", 620105);
        AREA_CODES.put("\u7ea2\u53e4\u533a", 620111);
        AREA_CODES.put("\u6c38\u767b\u53bf", 620121);
        AREA_CODES.put("\u768b\u5170\u53bf", 620122);
        AREA_CODES.put("\u6986\u4e2d\u53bf", 620123);
        AREA_CODES.put("\u5609\u5cea\u5173\u5e02", 620200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 620201);
        AREA_CODES.put("\u91d1\u660c\u5e02", 620300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 620301);
        AREA_CODES.put("\u91d1\u5ddd\u533a", 620302);
        AREA_CODES.put("\u6c38\u660c\u53bf", 620321);
        AREA_CODES.put("\u767d\u94f6\u5e02", 620400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 620401);
        AREA_CODES.put("\u767d\u94f6\u533a", 620402);
        AREA_CODES.put("\u5e73\u5ddd\u533a", 620403);
        AREA_CODES.put("\u9756\u8fdc\u53bf", 620421);
        AREA_CODES.put("\u4f1a\u5b81\u53bf", 620422);
        AREA_CODES.put("\u666f\u6cf0\u53bf", 620423);
        AREA_CODES.put("\u5929\u6c34\u5e02", 620500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 620501);
        AREA_CODES.put("\u79e6\u5dde\u533a", 620502);
        AREA_CODES.put("\u9ea6\u79ef\u533a", 620503);
        AREA_CODES.put("\u6e05\u6c34\u53bf", 620521);
        AREA_CODES.put("\u79e6\u5b89\u53bf", 620522);
        AREA_CODES.put("\u7518\u8c37\u53bf", 620523);
        AREA_CODES.put("\u6b66\u5c71\u53bf", 620524);
        AREA_CODES.put("\u5f20\u5bb6\u5ddd\u56de\u65cf\u81ea\u6cbb\u53bf", 620525);
        AREA_CODES.put("\u6b66\u5a01\u5e02", 620600);
        AREA_CODES.put("\u5e02\u8f96\u533a", 620601);
        AREA_CODES.put("\u51c9\u5dde\u533a", 620602);
        AREA_CODES.put("\u6c11\u52e4\u53bf", 620621);
        AREA_CODES.put("\u53e4\u6d6a\u53bf", 620622);
        AREA_CODES.put("\u5929\u795d\u85cf\u65cf\u81ea\u6cbb\u53bf", 620623);
        AREA_CODES.put("\u5f20\u6396\u5e02", 620700);
        AREA_CODES.put("\u5e02\u8f96\u533a", 620701);
        AREA_CODES.put("\u7518\u5dde\u533a", 620702);
        AREA_CODES.put("\u8083\u5357\u88d5\u56fa\u65cf\u81ea\u6cbb\u53bf", 620721);
        AREA_CODES.put("\u6c11\u4e50\u53bf", 620722);
        AREA_CODES.put("\u4e34\u6cfd\u53bf", 620723);
        AREA_CODES.put("\u9ad8\u53f0\u53bf", 620724);
        AREA_CODES.put("\u5c71\u4e39\u53bf", 620725);
        AREA_CODES.put("\u5e73\u51c9\u5e02", 620800);
        AREA_CODES.put("\u5e02\u8f96\u533a", 620801);
        AREA_CODES.put("\u5d06\u5cd2\u533a", 620802);
        AREA_CODES.put("\u6cfe\u5ddd\u53bf", 620821);
        AREA_CODES.put("\u7075\u53f0\u53bf", 620822);
        AREA_CODES.put("\u5d07\u4fe1\u53bf", 620823);
        AREA_CODES.put("\u534e\u4ead\u53bf", 620824);
        AREA_CODES.put("\u5e84\u6d6a\u53bf", 620825);
        AREA_CODES.put("\u9759\u5b81\u53bf", 620826);
        AREA_CODES.put("\u9152\u6cc9\u5e02", 620900);
        AREA_CODES.put("\u5e02\u8f96\u533a", 620901);
        AREA_CODES.put("\u8083\u5dde\u533a", 620902);
        AREA_CODES.put("\u91d1\u5854\u53bf", 620921);
        AREA_CODES.put("\u74dc\u5dde\u53bf", 620922);
        AREA_CODES.put("\u8083\u5317\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 620923);
        AREA_CODES.put("\u963f\u514b\u585e\u54c8\u8428\u514b\u65cf\u81ea\u6cbb\u53bf", 620924);
        AREA_CODES.put("\u7389\u95e8\u5e02", 620981);
        AREA_CODES.put("\u6566\u714c\u5e02", 620982);
        AREA_CODES.put("\u5e86\u9633\u5e02", 621000);
        AREA_CODES.put("\u5e02\u8f96\u533a", 621001);
        AREA_CODES.put("\u897f\u5cf0\u533a", 621002);
        AREA_CODES.put("\u5e86\u57ce\u53bf", 621021);
        AREA_CODES.put("\u73af\u3000\u53bf", 621022);
        AREA_CODES.put("\u534e\u6c60\u53bf", 621023);
        AREA_CODES.put("\u5408\u6c34\u53bf", 621024);
        AREA_CODES.put("\u6b63\u5b81\u53bf", 621025);
        AREA_CODES.put("\u5b81\u3000\u53bf", 621026);
        AREA_CODES.put("\u9547\u539f\u53bf", 621027);
        AREA_CODES.put("\u5b9a\u897f\u5e02", 621100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 621101);
        AREA_CODES.put("\u5b89\u5b9a\u533a", 621102);
        AREA_CODES.put("\u901a\u6e2d\u53bf", 621121);
        AREA_CODES.put("\u9647\u897f\u53bf", 621122);
        AREA_CODES.put("\u6e2d\u6e90\u53bf", 621123);
        AREA_CODES.put("\u4e34\u6d2e\u53bf", 621124);
        AREA_CODES.put("\u6f33\u3000\u53bf", 621125);
        AREA_CODES.put("\u5cb7\u3000\u53bf", 621126);
        AREA_CODES.put("\u9647\u5357\u5e02", 621200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 621201);
        AREA_CODES.put("\u6b66\u90fd\u533a", 621202);
        AREA_CODES.put("\u6210\u3000\u53bf", 621221);
        AREA_CODES.put("\u6587\u3000\u53bf", 621222);
        AREA_CODES.put("\u5b95\u660c\u53bf", 621223);
        AREA_CODES.put("\u5eb7\u3000\u53bf", 621224);
        AREA_CODES.put("\u897f\u548c\u53bf", 621225);
        AREA_CODES.put("\u793c\u3000\u53bf", 621226);
        AREA_CODES.put("\u5fbd\u3000\u53bf", 621227);
        AREA_CODES.put("\u4e24\u5f53\u53bf", 621228);
        AREA_CODES.put("\u4e34\u590f\u56de\u65cf\u81ea\u6cbb\u5dde", 622900);
        AREA_CODES.put("\u4e34\u590f\u5e02", 622901);
        AREA_CODES.put("\u4e34\u590f\u53bf", 622921);
        AREA_CODES.put("\u5eb7\u4e50\u53bf", 622922);
        AREA_CODES.put("\u6c38\u9756\u53bf", 622923);
        AREA_CODES.put("\u5e7f\u6cb3\u53bf", 622924);
        AREA_CODES.put("\u548c\u653f\u53bf", 622925);
        AREA_CODES.put("\u4e1c\u4e61\u65cf\u81ea\u6cbb\u53bf", 622926);
        AREA_CODES.put("\u79ef\u77f3\u5c71\u4fdd\u5b89\u65cf\u4e1c\u4e61\u65cf\u6492\u62c9\u65cf\u81ea\u6cbb\u53bf", 622927);
        AREA_CODES.put("\u7518\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde", 623000);
        AREA_CODES.put("\u5408\u4f5c\u5e02", 623001);
        AREA_CODES.put("\u4e34\u6f6d\u53bf", 623021);
        AREA_CODES.put("\u5353\u5c3c\u53bf", 623022);
        AREA_CODES.put("\u821f\u66f2\u53bf", 623023);
        AREA_CODES.put("\u8fed\u90e8\u53bf", 623024);
        AREA_CODES.put("\u739b\u66f2\u53bf", 623025);
        AREA_CODES.put("\u788c\u66f2\u53bf", 623026);
        AREA_CODES.put("\u590f\u6cb3\u53bf", 623027);
        AREA_CODES.put("\u9752\u6d77\u7701", 630000);
        AREA_CODES.put("\u897f\u5b81\u5e02", 630100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 630101);
        AREA_CODES.put("\u57ce\u4e1c\u533a", 630102);
        AREA_CODES.put("\u57ce\u4e2d\u533a", 630103);
        AREA_CODES.put("\u57ce\u897f\u533a", 630104);
        AREA_CODES.put("\u57ce\u5317\u533a", 630105);
        AREA_CODES.put("\u5927\u901a\u56de\u65cf\u571f\u65cf\u81ea\u6cbb\u53bf", 630121);
        AREA_CODES.put("\u6e5f\u4e2d\u53bf", 630122);
        AREA_CODES.put("\u6e5f\u6e90\u53bf", 630123);
        AREA_CODES.put("\u6d77\u4e1c\u5730\u533a", 632100);
        AREA_CODES.put("\u5e73\u5b89\u53bf", 632121);
        AREA_CODES.put("\u6c11\u548c\u56de\u65cf\u571f\u65cf\u81ea\u6cbb\u53bf", 632122);
        AREA_CODES.put("\u4e50\u90fd\u53bf", 632123);
        AREA_CODES.put("\u4e92\u52a9\u571f\u65cf\u81ea\u6cbb\u53bf", 632126);
        AREA_CODES.put("\u5316\u9686\u56de\u65cf\u81ea\u6cbb\u53bf", 632127);
        AREA_CODES.put("\u5faa\u5316\u6492\u62c9\u65cf\u81ea\u6cbb\u53bf", 632128);
        AREA_CODES.put("\u6d77\u5317\u85cf\u65cf\u81ea\u6cbb\u5dde", 632200);
        AREA_CODES.put("\u95e8\u6e90\u56de\u65cf\u81ea\u6cbb\u53bf", 632221);
        AREA_CODES.put("\u7941\u8fde\u53bf", 632222);
        AREA_CODES.put("\u6d77\u664f\u53bf", 632223);
        AREA_CODES.put("\u521a\u5bdf\u53bf", 632224);
        AREA_CODES.put("\u9ec4\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde", 632300);
        AREA_CODES.put("\u540c\u4ec1\u53bf", 632321);
        AREA_CODES.put("\u5c16\u624e\u53bf", 632322);
        AREA_CODES.put("\u6cfd\u5e93\u53bf", 632323);
        AREA_CODES.put("\u6cb3\u5357\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 632324);
        AREA_CODES.put("\u6d77\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde", 632500);
        AREA_CODES.put("\u5171\u548c\u53bf", 632521);
        AREA_CODES.put("\u540c\u5fb7\u53bf", 632522);
        AREA_CODES.put("\u8d35\u5fb7\u53bf", 632523);
        AREA_CODES.put("\u5174\u6d77\u53bf", 632524);
        AREA_CODES.put("\u8d35\u5357\u53bf", 632525);
        AREA_CODES.put("\u679c\u6d1b\u85cf\u65cf\u81ea\u6cbb\u5dde", 632600);
        AREA_CODES.put("\u739b\u6c81\u53bf", 632621);
        AREA_CODES.put("\u73ed\u739b\u53bf", 632622);
        AREA_CODES.put("\u7518\u5fb7\u53bf", 632623);
        AREA_CODES.put("\u8fbe\u65e5\u53bf", 632624);
        AREA_CODES.put("\u4e45\u6cbb\u53bf", 632625);
        AREA_CODES.put("\u739b\u591a\u53bf", 632626);
        AREA_CODES.put("\u7389\u6811\u85cf\u65cf\u81ea\u6cbb\u5dde", 632700);
        AREA_CODES.put("\u7389\u6811\u53bf", 632721);
        AREA_CODES.put("\u6742\u591a\u53bf", 632722);
        AREA_CODES.put("\u79f0\u591a\u53bf", 632723);
        AREA_CODES.put("\u6cbb\u591a\u53bf", 632724);
        AREA_CODES.put("\u56ca\u8c26\u53bf", 632725);
        AREA_CODES.put("\u66f2\u9ebb\u83b1\u53bf", 632726);
        AREA_CODES.put("\u6d77\u897f\u8499\u53e4\u65cf\u85cf\u65cf\u81ea\u6cbb\u5dde", 632800);
        AREA_CODES.put("\u683c\u5c14\u6728\u5e02", 632801);
        AREA_CODES.put("\u5fb7\u4ee4\u54c8\u5e02", 632802);
        AREA_CODES.put("\u4e4c\u5170\u53bf", 632821);
        AREA_CODES.put("\u90fd\u5170\u53bf", 632822);
        AREA_CODES.put("\u5929\u5cfb\u53bf", 632823);
        AREA_CODES.put("\u5b81\u590f\u56de\u65cf\u81ea\u6cbb\u533a", 640000);
        AREA_CODES.put("\u94f6\u5ddd\u5e02", 640100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 640101);
        AREA_CODES.put("\u5174\u5e86\u533a", 640104);
        AREA_CODES.put("\u897f\u590f\u533a", 640105);
        AREA_CODES.put("\u91d1\u51e4\u533a", 640106);
        AREA_CODES.put("\u6c38\u5b81\u53bf", 640121);
        AREA_CODES.put("\u8d3a\u5170\u53bf", 640122);
        AREA_CODES.put("\u7075\u6b66\u5e02", 640181);
        AREA_CODES.put("\u77f3\u5634\u5c71\u5e02", 640200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 640201);
        AREA_CODES.put("\u5927\u6b66\u53e3\u533a", 640202);
        AREA_CODES.put("\u60e0\u519c\u533a", 640205);
        AREA_CODES.put("\u5e73\u7f57\u53bf", 640221);
        AREA_CODES.put("\u5434\u5fe0\u5e02", 640300);
        AREA_CODES.put("\u5e02\u8f96\u533a", 640301);
        AREA_CODES.put("\u5229\u901a\u533a", 640302);
        AREA_CODES.put("\u7ea2\u5bfa\u5821\u533a (*)", 640303);
        AREA_CODES.put("\u76d0\u6c60\u53bf", 640323);
        AREA_CODES.put("\u540c\u5fc3\u53bf", 640324);
        AREA_CODES.put("\u9752\u94dc\u5ce1\u5e02", 640381);
        AREA_CODES.put("\u56fa\u539f\u5e02", 640400);
        AREA_CODES.put("\u5e02\u8f96\u533a", 640401);
        AREA_CODES.put("\u539f\u5dde\u533a", 640402);
        AREA_CODES.put("\u897f\u5409\u53bf", 640422);
        AREA_CODES.put("\u9686\u5fb7\u53bf", 640423);
        AREA_CODES.put("\u6cfe\u6e90\u53bf", 640424);
        AREA_CODES.put("\u5f6d\u9633\u53bf", 640425);
        AREA_CODES.put("\u4e2d\u536b\u5e02", 640500);
        AREA_CODES.put("\u5e02\u8f96\u533a", 640501);
        AREA_CODES.put("\u6c99\u5761\u5934\u533a", 640502);
        AREA_CODES.put("\u4e2d\u5b81\u53bf", 640521);
        AREA_CODES.put("\u6d77\u539f\u53bf", 640522);
        AREA_CODES.put("\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a", 650000);
        AREA_CODES.put("\u4e4c\u9c81\u6728\u9f50\u5e02", 650100);
        AREA_CODES.put("\u5e02\u8f96\u533a", 650101);
        AREA_CODES.put("\u5929\u5c71\u533a", 650102);
        AREA_CODES.put("\u6c99\u4f9d\u5df4\u514b\u533a", 650103);
        AREA_CODES.put("\u65b0\u5e02\u533a", 650104);
        AREA_CODES.put("\u6c34\u78e8\u6c9f\u533a", 650105);
        AREA_CODES.put("\u5934\u5c6f\u6cb3\u533a", 650106);
        AREA_CODES.put("\u8fbe\u5742\u57ce\u533a", 650107);
        AREA_CODES.put("\u7c73\u4e1c\u533a", 650109);
        AREA_CODES.put("\u4e4c\u9c81\u6728\u9f50\u53bf", 650121);
        AREA_CODES.put("\u514b\u62c9\u739b\u4f9d\u5e02", 650200);
        AREA_CODES.put("\u5e02\u8f96\u533a", 650201);
        AREA_CODES.put("\u72ec\u5c71\u5b50\u533a", 650202);
        AREA_CODES.put("\u514b\u62c9\u739b\u4f9d\u533a", 650203);
        AREA_CODES.put("\u767d\u78b1\u6ee9\u533a", 650204);
        AREA_CODES.put("\u4e4c\u5c14\u79be\u533a", 650205);
        AREA_CODES.put("\u5410\u9c81\u756a\u5730\u533a", 652100);
        AREA_CODES.put("\u5410\u9c81\u756a\u5e02", 652101);
        AREA_CODES.put("\u912f\u5584\u53bf", 652122);
        AREA_CODES.put("\u6258\u514b\u900a\u53bf", 652123);
        AREA_CODES.put("\u54c8\u5bc6\u5730\u533a", 652200);
        AREA_CODES.put("\u54c8\u5bc6\u5e02", 652201);
        AREA_CODES.put("\u5df4\u91cc\u5764\u54c8\u8428\u514b\u81ea\u6cbb\u53bf", 652222);
        AREA_CODES.put("\u4f0a\u543e\u53bf", 652223);
        AREA_CODES.put("\u660c\u5409\u56de\u65cf\u81ea\u6cbb\u5dde", 652300);
        AREA_CODES.put("\u660c\u5409\u5e02", 652301);
        AREA_CODES.put("\u961c\u5eb7\u5e02", 652302);
        AREA_CODES.put("\u547c\u56fe\u58c1\u53bf", 652323);
        AREA_CODES.put("\u739b\u7eb3\u65af\u53bf", 652324);
        AREA_CODES.put("\u5947\u53f0\u53bf", 652325);
        AREA_CODES.put("\u5409\u6728\u8428\u5c14\u53bf", 652327);
        AREA_CODES.put("\u6728\u5792\u54c8\u8428\u514b\u81ea\u6cbb\u53bf", 652328);
        AREA_CODES.put("\u535a\u5c14\u5854\u62c9\u8499\u53e4\u81ea\u6cbb\u5dde", 652700);
        AREA_CODES.put("\u535a\u4e50\u5e02", 652701);
        AREA_CODES.put("\u7cbe\u6cb3\u53bf", 652722);
        AREA_CODES.put("\u6e29\u6cc9\u53bf", 652723);
        AREA_CODES.put("\u5df4\u97f3\u90ed\u695e\u8499\u53e4\u81ea\u6cbb\u5dde", 652800);
        AREA_CODES.put("\u5e93\u5c14\u52d2\u5e02", 652801);
        AREA_CODES.put("\u8f6e\u53f0\u53bf", 652822);
        AREA_CODES.put("\u5c09\u7281\u53bf", 652823);
        AREA_CODES.put("\u82e5\u7f8c\u53bf", 652824);
        AREA_CODES.put("\u4e14\u672b\u53bf", 652825);
        AREA_CODES.put("\u7109\u8006\u56de\u65cf\u81ea\u6cbb\u53bf", 652826);
        AREA_CODES.put("\u548c\u9759\u53bf", 652827);
        AREA_CODES.put("\u548c\u7855\u53bf", 652828);
        AREA_CODES.put("\u535a\u6e56\u53bf", 652829);
        AREA_CODES.put("\u963f\u514b\u82cf\u5730\u533a", 652900);
        AREA_CODES.put("\u963f\u514b\u82cf\u5e02", 652901);
        AREA_CODES.put("\u6e29\u5bbf\u53bf", 652922);
        AREA_CODES.put("\u5e93\u8f66\u53bf", 652923);
        AREA_CODES.put("\u6c99\u96c5\u53bf", 652924);
        AREA_CODES.put("\u65b0\u548c\u53bf", 652925);
        AREA_CODES.put("\u62dc\u57ce\u53bf", 652926);
        AREA_CODES.put("\u4e4c\u4ec0\u53bf", 652927);
        AREA_CODES.put("\u963f\u74e6\u63d0\u53bf", 652928);
        AREA_CODES.put("\u67ef\u576a\u53bf", 652929);
        AREA_CODES.put("\u514b\u5b5c\u52d2\u82cf\u67ef\u5c14\u514b\u5b5c\u81ea\u6cbb\u5dde", 653000);
        AREA_CODES.put("\u963f\u56fe\u4ec0\u5e02", 653001);
        AREA_CODES.put("\u963f\u514b\u9676\u53bf", 653022);
        AREA_CODES.put("\u963f\u5408\u5947\u53bf", 653023);
        AREA_CODES.put("\u4e4c\u6070\u53bf", 653024);
        AREA_CODES.put("\u5580\u4ec0\u5730\u533a", 653100);
        AREA_CODES.put("\u5580\u4ec0\u5e02", 653101);
        AREA_CODES.put("\u758f\u9644\u53bf", 653121);
        AREA_CODES.put("\u758f\u52d2\u53bf", 653122);
        AREA_CODES.put("\u82f1\u5409\u6c99\u53bf", 653123);
        AREA_CODES.put("\u6cfd\u666e\u53bf", 653124);
        AREA_CODES.put("\u838e\u8f66\u53bf", 653125);
        AREA_CODES.put("\u53f6\u57ce\u53bf", 653126);
        AREA_CODES.put("\u9ea6\u76d6\u63d0\u53bf", 653127);
        AREA_CODES.put("\u5cb3\u666e\u6e56\u53bf", 653128);
        AREA_CODES.put("\u4f3d\u5e08\u53bf", 653129);
        AREA_CODES.put("\u5df4\u695a\u53bf", 653130);
        AREA_CODES.put("\u5854\u4ec0\u5e93\u5c14\u5e72\u5854\u5409\u514b\u81ea\u6cbb\u53bf", 653131);
        AREA_CODES.put("\u548c\u7530\u5730\u533a", 653200);
        AREA_CODES.put("\u548c\u7530\u5e02", 653201);
        AREA_CODES.put("\u548c\u7530\u53bf", 653221);
        AREA_CODES.put("\u58a8\u7389\u53bf", 653222);
        AREA_CODES.put("\u76ae\u5c71\u53bf", 653223);
        AREA_CODES.put("\u6d1b\u6d66\u53bf", 653224);
        AREA_CODES.put("\u7b56\u52d2\u53bf", 653225);
        AREA_CODES.put("\u4e8e\u7530\u53bf", 653226);
        AREA_CODES.put("\u6c11\u4e30\u53bf", 653227);
        AREA_CODES.put("\u4f0a\u7281\u54c8\u8428\u514b\u81ea\u6cbb\u5dde", 654000);
        AREA_CODES.put("\u4f0a\u5b81\u5e02", 654002);
        AREA_CODES.put("\u594e\u5c6f\u5e02", 654003);
        AREA_CODES.put("\u4f0a\u5b81\u53bf", 654021);
        AREA_CODES.put("\u5bdf\u5e03\u67e5\u5c14\u9521\u4f2f\u81ea\u6cbb\u53bf", 654022);
        AREA_CODES.put("\u970d\u57ce\u53bf", 654023);
        AREA_CODES.put("\u5de9\u7559\u53bf", 654024);
        AREA_CODES.put("\u65b0\u6e90\u53bf", 654025);
        AREA_CODES.put("\u662d\u82cf\u53bf", 654026);
        AREA_CODES.put("\u7279\u514b\u65af\u53bf", 654027);
        AREA_CODES.put("\u5c3c\u52d2\u514b\u53bf", 654028);
        AREA_CODES.put("\u5854\u57ce\u5730\u533a", 654200);
        AREA_CODES.put("\u5854\u57ce\u5e02", 654201);
        AREA_CODES.put("\u4e4c\u82cf\u5e02", 654202);
        AREA_CODES.put("\u989d\u654f\u53bf", 654221);
        AREA_CODES.put("\u6c99\u6e7e\u53bf", 654223);
        AREA_CODES.put("\u6258\u91cc\u53bf", 654224);
        AREA_CODES.put("\u88d5\u6c11\u53bf", 654225);
        AREA_CODES.put("\u548c\u5e03\u514b\u8d5b\u5c14\u8499\u53e4\u81ea\u6cbb\u53bf", 654226);
        AREA_CODES.put("\u963f\u52d2\u6cf0\u5730\u533a", 654300);
        AREA_CODES.put("\u963f\u52d2\u6cf0\u5e02", 654301);
        AREA_CODES.put("\u5e03\u5c14\u6d25\u53bf", 654321);
        AREA_CODES.put("\u5bcc\u8574\u53bf", 654322);
        AREA_CODES.put("\u798f\u6d77\u53bf", 654323);
        AREA_CODES.put("\u54c8\u5df4\u6cb3\u53bf", 654324);
        AREA_CODES.put("\u9752\u6cb3\u53bf", 654325);
        AREA_CODES.put("\u5409\u6728\u4e43\u53bf", 654326);
        AREA_CODES.put("\u81ea\u6cbb\u533a\u76f4\u8f96\u53bf\u7ea7\u884c\u653f\u533a\u5212", 659000);
        AREA_CODES.put("\u77f3\u6cb3\u5b50\u5e02", 659001);
        AREA_CODES.put("\u963f\u62c9\u5c14\u5e02", 659002);
        AREA_CODES.put("\u56fe\u6728\u8212\u514b\u5e02", 659003);
        AREA_CODES.put("\u4e94\u5bb6\u6e20\u5e02", 659004);
        AREA_CODES.put("\u53f0\u6e7e\u7701", 710000);
        AREA_CODES.put("\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a", 810000);
        AREA_CODES.put("\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a", 820000);
    }
}

