/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import im.dart.boot.common.utils.Checker;
import im.dart.boot.common.utils.Runner;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class JsonUtil {
    private static ObjectMapper MAPPER = new ObjectMapper();

    public static String toJson(Object obj) throws JsonProcessingException {
        if (Checker.isEmpty(obj)) {
            return null;
        }
        return MAPPER.writeValueAsString(obj);
    }

    public static String safeToJson(Object obj) {
        if (Checker.isEmpty(obj)) {
            return null;
        }
        return Runner.safeRun(() -> MAPPER.writeValueAsString(obj));
    }

    public static <T> T toObj(String json, Class<T> clazz) throws JsonProcessingException {
        if (Checker.isEmpty(json)) {
            return null;
        }
        return (T)MAPPER.readValue(json, clazz);
    }

    public static <T> T safeToObj(String json, Class<T> clazz) {
        if (Checker.isEmpty(json)) {
            return null;
        }
        return (T)Runner.safeRun(() -> MAPPER.readValue(json, clazz));
    }

    public static <T, S> T safeToObj(String json, Class<T> clazz, Class<S> type) {
        if (Checker.isEmpty(json)) {
            return null;
        }
        return (T)Runner.safeRun(() -> {
            JavaType javaType = MAPPER.getTypeFactory().constructParametricType(clazz, new Class[]{type});
            return MAPPER.readValue(json, javaType);
        });
    }

    public static <T> List<T> safeToList(String json, Class<T> clazz) {
        if (Checker.isEmpty(json)) {
            return null;
        }
        return Runner.safeRun(() -> {
            JavaType javaType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{clazz});
            return (List)MAPPER.readValue(json, javaType);
        });
    }

    public static <T> Set<T> safeToSet(String json, Class<T> clazz) {
        if (Checker.isEmpty(json)) {
            return null;
        }
        return Runner.safeRun(() -> {
            JavaType javaType = MAPPER.getTypeFactory().constructParametricType(Set.class, new Class[]{clazz});
            return (Set)MAPPER.readValue(json, javaType);
        });
    }

    public static <K, V> Map<K, V> safeToMap(String json, Class<K> classKey, Class<V> classValue) {
        if (Checker.isEmpty(json)) {
            return null;
        }
        return Runner.safeRun(() -> {
            JavaType javaType = MAPPER.getTypeFactory().constructParametricType(HashMap.class, new Class[]{classKey, classValue});
            return (Map)MAPPER.readValue(json, javaType);
        });
    }

    public static JsonNode toObj(String json) throws JsonProcessingException {
        if (Checker.isEmpty(json)) {
            return null;
        }
        return MAPPER.readTree(json);
    }

    public static JsonNode safeToObj(String json) {
        if (Checker.isEmpty(json)) {
            return null;
        }
        return Runner.safeRun(() -> MAPPER.readTree(json));
    }

    public static <T> T getValue(JsonNode node, String name) {
        if (Checker.isEmpty(node)) {
            return null;
        }
        JsonNode n = node.get(name);
        if (Checker.isEmpty(n)) {
            return null;
        }
        return (T)n.asText();
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(SerializationFeature.FAIL_ON_UNWRAPPED_TYPE_IDENTIFIERS, false);
        MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        MAPPER.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString("");
            }
        });
        MAPPER.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }
}

