/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import im.dart.boot.common.data.Base;
import im.dart.boot.common.data.Entry;
import im.dart.boot.common.utils.Checker;
import im.dart.boot.common.utils.Runner;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ReflectUtil {
    static Logger logger = Logger.getLogger(ReflectUtil.class.getName());
    private static final ConcurrentHashMap<Class, ArrayList<Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap();

    public static List<Field> fetchFields(Class clazz) {
        Field[] fieldList;
        if (clazz.equals(Object.class) || clazz.equals(Base.class)) {
            return new ArrayList<Field>();
        }
        ArrayList<Field> fields = CLASS_FIELD_CACHE.get(clazz);
        if (Checker.isNotEmpty(fields)) {
            return fields;
        }
        fields = new ArrayList();
        for (Field f : fieldList = clazz.getDeclaredFields()) {
            if (Objects.equals("serialVersionUID", f.getName())) continue;
            fields.add(f);
        }
        fields.addAll(ReflectUtil.fetchFields(clazz.getSuperclass()));
        CLASS_FIELD_CACHE.put(clazz, fields);
        return fields;
    }

    public static void setFieldValue(Object obj, Field field, Object value) {
        if (Checker.isEmpty(obj) || Checker.isEmpty(field) || Checker.isEmpty(value)) {
            return;
        }
        Runner.safeRun(() -> {
            field.setAccessible(true);
            field.set(obj, value);
        });
    }

    public static List<Entry<String, Object>> fields(Object obj) {
        if (obj == null) {
            return new ArrayList<Entry<String, Object>>();
        }
        List<Field> fields = ReflectUtil.fetchFields(obj.getClass());
        return fields.stream().map(tmp -> ReflectUtil.fetch(obj, tmp)).filter(tmp -> Objects.nonNull(tmp)).collect(Collectors.toList());
    }

    public static List<String> fetchNullField(Object obj) {
        if (obj == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> nullFields = new ArrayList<String>();
        List<Field> fields = ReflectUtil.fetchFields(obj.getClass());
        for (Field field : fields) {
            Entry<String, Object> data = ReflectUtil.fetch(obj, field);
            if (!Checker.isEmpty(data)) continue;
            nullFields.add(field.getName());
        }
        return nullFields;
    }

    public static <T> T newObj(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        return (T)Runner.safeRun(() -> {
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        });
    }

    public static Entry<String, Object> fetch(Object obj, Field field) {
        if (obj == null || field == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            Object value = field.get(obj);
            if (!Checker.isEmptyString(value)) {
                return new Entry<String, Object>(field.getName(), value);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public static Object fetchValue(Object obj, Field field) {
        if (obj == null || field == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    static {
        CLASS_FIELD_CACHE.clear();
    }
}

