/*
 * Decompiled with CFR 0.152.
 */
package im.dart.boot.common.utils;

import im.dart.boot.common.utils.Checker;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Runner {
    static Logger logger = Logger.getLogger(Runner.class.getName());

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static void newThread(Runnable runnable) {
        new Thread(runnable).start();
    }

    public static void safeThread(ConsumerWithException consumer) {
        Thread safeThread = new Thread(() -> {
            try {
                consumer.apply();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        });
        safeThread.setName("SafeThread");
        safeThread.setDaemon(true);
        safeThread.start();
    }

    public static void safeThreadWhile(ConsumerWithException consumer) {
        Thread safeThreadWhile = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        consumer.apply();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    continue;
                }
                break;
            }
        });
        safeThreadWhile.setName("SafeThreadWhile");
        safeThreadWhile.setDaemon(true);
        safeThreadWhile.start();
    }

    public static <T> void safeRun(Consumer<T> consumer, T data) {
        try {
            consumer.accept(data);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static void safeRun(ConsumerWithException consumer) {
        try {
            consumer.apply();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static <T> T safeRun(FunctionWithException<T> consumer) {
        try {
            return consumer.apply();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static <T> T safeRun(FunctionWithException<T> consumer, T defaultValue) {
        Object value = null;
        try {
            value = consumer.apply();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return (T)(Checker.isEmpty(value) ? defaultValue : value);
    }

    public static interface FunctionWithAssert {
        public boolean check();
    }

    public static interface FunctionWithException<T> {
        public T apply() throws Exception;
    }

    public static interface ConsumerWithException {
        public void apply() throws Exception;
    }
}

